/*
 * Decompiled with CFR 0.152.
 */
package com.trtc.tuikit.common.imageloader;

public class ImageOptions {
    private final int placeImage;
    private final int errorImage;
    private final int roundRadius;
    private final boolean isGif;
    private final boolean skipMemoryCache;
    private final boolean skipDiskCache;
    private final float blurEffect;

    private ImageOptions(Builder builder) {
        this.placeImage = builder.placeImage;
        this.errorImage = builder.errorImage;
        this.roundRadius = builder.roundRadius;
        this.isGif = builder.isGif;
        this.skipMemoryCache = false;
        this.skipDiskCache = false;
        this.blurEffect = builder.blurEffect;
    }

    public int getPlaceImage() {
        return this.placeImage;
    }

    public int getErrorImage() {
        return this.errorImage;
    }

    public int getRoundRadius() {
        return this.roundRadius;
    }

    public boolean isGif() {
        return this.isGif;
    }

    public boolean skipMemoryCache() {
        return this.skipMemoryCache;
    }

    public boolean skipDiskCache() {
        return this.skipDiskCache;
    }

    public float getBlurEffect() {
        return this.blurEffect;
    }

    public static class Builder {
        private final boolean skipMemoryCache = false;
        private final boolean skipDiskCache = false;
        private int placeImage = 0;
        private int errorImage = 0;
        private int roundRadius = 0;
        private boolean isGif = false;
        private float blurEffect = 0.0f;

        public Builder setPlaceImage(int placeImage) {
            this.placeImage = placeImage;
            return this;
        }

        public Builder setErrorImage(int errorImage) {
            this.errorImage = errorImage;
            return this;
        }

        public Builder setRoundRadius(int roundRadius) {
            this.roundRadius = roundRadius;
            return this;
        }

        public Builder asGif(boolean isGif) {
            this.isGif = isGif;
            return this;
        }

        public Builder setBlurEffect(float level) {
            this.blurEffect = level;
            return this;
        }

        public ImageOptions build() {
            return new ImageOptions(this);
        }
    }
}

