/*
 * Decompiled with CFR 0.152.
 */
package com.trtc.tuikit.common.imageloader;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.RenderEffect;
import android.graphics.Shader;
import android.os.Build;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.MultiTransformation;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.trtc.tuikit.common.imageloader.BlurUtils;
import com.trtc.tuikit.common.imageloader.ImageOptions;
import com.trtc.tuikit.common.system.ContextProvider;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;

public class ImageLoader {
    public static void load(Context context, ImageView target, Object source, int placeImage) {
        ImageOptions imageOptions = new ImageOptions.Builder().setPlaceImage(placeImage).build();
        ImageLoader.load(context, target, source, imageOptions);
    }

    public static void load(Context context, ImageView target, Object source, ImageOptions config) {
        if (target == null) {
            return;
        }
        if (source == null) {
            int image = config.getPlaceImage() != 0 ? config.getPlaceImage() : config.getErrorImage();
            target.setImageResource(image);
            return;
        }
        ImageLoader.loadImageView(context, target, source, config);
    }

    public static Bitmap transformBitmap(Context context, Object source, int width, int height, ImageOptions options) {
        if (source == null) {
            return null;
        }
        RequestBuilder builder = Glide.with((Context)context.getApplicationContext()).asBitmap().load(source);
        ImageLoader.setBuilderOptions(context.getApplicationContext(), builder, options);
        try {
            return (Bitmap)builder.submit(width, height).get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void clear(Context context, ImageView target) {
        if (target != null) {
            Glide.with((Context)context.getApplicationContext()).clear((View)target);
        }
    }

    private static void loadImageView(Context context, ImageView target, Object source, ImageOptions config) {
        if (Build.VERSION.SDK_INT >= 17 && context instanceof Activity && (((Activity)context).isFinishing() || ((Activity)context).isDestroyed())) {
            return;
        }
        RequestBuilder builder = config.isGif() ? Glide.with((Context)context.getApplicationContext()).asGif().load(source) : Glide.with((Context)context.getApplicationContext()).load(source);
        ImageLoader.setBuilderOptions(context.getApplicationContext(), builder, config);
        builder.into(target);
        ImageLoader.setRenderEffect(target, config);
    }

    private static void setRenderEffect(ImageView target, ImageOptions config) {
        float level = config.getBlurEffect();
        if (level > 0.0f && Build.VERSION.SDK_INT >= 31) {
            target.setRenderEffect(RenderEffect.createBlurEffect((float)level, (float)level, (Shader.TileMode)Shader.TileMode.MIRROR));
        }
    }

    @SuppressLint(value={"CheckResult"})
    private static void setBuilderOptions(Context context, RequestBuilder<?> builder, ImageOptions config) {
        RequestOptions options = new RequestOptions();
        ArrayList<Object> transformations = new ArrayList<Object>();
        transformations.add(new CenterCrop());
        if (config.getRoundRadius() > 0) {
            transformations.add(new RoundedCorners(ImageLoader.dip2px(config.getRoundRadius())));
        }
        if (config.getBlurEffect() > 0.0f && Build.VERSION.SDK_INT < 31) {
            transformations.add((Object)new BlurTransformation(context, config.getBlurEffect()));
        }
        options.transform((Transformation)new MultiTransformation(transformations));
        if (config.getPlaceImage() != 0) {
            options.placeholder(config.getPlaceImage());
        }
        if (config.getErrorImage() != 0) {
            options.error(config.getErrorImage());
        }
        options.diskCacheStrategy(config.skipDiskCache() ? DiskCacheStrategy.NONE : DiskCacheStrategy.ALL);
        options.skipMemoryCache(config.skipMemoryCache());
        builder.apply((BaseRequestOptions)options);
    }

    private static int dip2px(int dpValue) {
        float scale = ContextProvider.getApplicationContext().getResources().getDisplayMetrics().density;
        return (int)((float)dpValue * scale + 0.5f);
    }

    public static class BlurTransformation
    extends BitmapTransformation {
        private final float radius;
        private final WeakReference<Context> weakPreference;

        public BlurTransformation(Context context, float level) {
            this.radius = level * 0.25f;
            this.weakPreference = new WeakReference<Context>(context);
        }

        public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
            messageDigest.update(("blur:" + this.radius).getBytes());
        }

        @Nullable
        public Bitmap transform(@NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
            return BlurUtils.blur((Context)this.weakPreference.get(), pool, toTransform, (int)this.radius);
        }
    }
}

