/*
 * Decompiled with CFR 0.152.
 */
package com.trtc.tuikit.common.foregroundservice;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import com.trtc.tuikit.common.R;
import com.trtc.tuikit.common.foregroundservice.ServiceState;
import com.trtc.tuikit.common.system.ContextProvider;
import com.trtc.tuikit.common.util.TUIBuild;

public class MediaForegroundService
extends Service {
    private static final String TAG = "MediaForegroundService";
    private static final String TITLE = "title";
    private static final String ICON = "icon";
    private static final String DESCRIPTION = "description";
    private static final int NOTIFICATION_ID = 1001;
    private static ServiceState state = ServiceState.IDLE;

    public static void start(Context context, String title, String description, int icon) {
        if (state == ServiceState.STARTING || state == ServiceState.RUNNING) {
            Log.i((String)TAG, (String)"start foreground service\uff0cservice is running");
            return;
        }
        if (state == ServiceState.STOPPING) {
            state = ServiceState.STARTING;
            Log.i((String)TAG, (String)"start foreground service\uff0cservice is stopping");
            return;
        }
        state = ServiceState.STARTING;
        Log.d((String)TAG, (String)("start foreground service title=" + title + " description=" + description));
        Intent intent = new Intent(context, MediaForegroundService.class);
        intent.putExtra(TITLE, title);
        intent.putExtra(ICON, icon);
        intent.putExtra(DESCRIPTION, description);
        if (Build.VERSION.SDK_INT >= 26) {
            context.startForegroundService(intent);
        } else {
            context.startService(intent);
        }
    }

    public static void stop(Context context) {
        Log.d((String)TAG, (String)"stop foreground service");
        if (ServiceState.RUNNING == state) {
            Intent intent = new Intent(context, MediaForegroundService.class);
            context.stopService(intent);
            state = ServiceState.IDLE;
        } else if (ServiceState.STARTING == state) {
            state = ServiceState.STOPPING;
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null) {
            Log.e((String)TAG, (String)("onStartCommand intent == null, state = " + (Object)((Object)state)));
            return 2;
        }
        Context appContext = ContextProvider.getApplicationContext();
        String title = intent.getStringExtra(TITLE);
        String description = intent.getStringExtra(DESCRIPTION);
        int icon = intent.getIntExtra(ICON, appContext.getApplicationInfo().icon);
        Notification notification = this.createForegroundNotification(title, description, icon);
        if (Build.VERSION.SDK_INT >= 30) {
            this.startForeground(1001, notification, 2);
        } else {
            this.startForeground(1001, notification);
        }
        Log.d((String)TAG, (String)("onStartCommand end, state = " + (Object)((Object)state)));
        if (state == ServiceState.STOPPING) {
            this.stopSelf();
            state = ServiceState.IDLE;
        } else {
            state = ServiceState.RUNNING;
        }
        return 2;
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        this.stopSelf();
        state = ServiceState.IDLE;
    }

    private Notification createForegroundNotification(String title, String description, int icon) {
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        String notificationChannelId = "rtc_uikit_foreground_service";
        if (TUIBuild.getVersionInt() >= 26) {
            String channelName = this.getApplicationContext().getString(R.string.common_rtc_channel_name);
            String channelDescription = this.getApplicationContext().getString(R.string.common_rtc_channel_description);
            int importance = 2;
            NotificationChannel notificationChannel = new NotificationChannel(notificationChannelId, (CharSequence)channelName, importance);
            notificationChannel.setDescription(channelDescription);
            if (notificationManager != null) {
                notificationManager.createNotificationChannel(notificationChannel);
            }
        }
        boolean enableNotification = true;
        if (TUIBuild.getVersionInt() >= 24) {
            enableNotification = notificationManager.areNotificationsEnabled();
        }
        Log.i((String)TAG, (String)("enableNotification: " + enableNotification));
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this, notificationChannelId);
        builder.setSmallIcon(icon);
        builder.setContentTitle((CharSequence)title);
        builder.setContentText((CharSequence)description);
        builder.setWhen(System.currentTimeMillis());
        return builder.build();
    }
}

