/*
 * Decompiled with CFR 0.152.
 */
package com.trtc.tuikit.common.event;

import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.trtc.tuikit.common.event.INotification;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventManager {
    private static final String TAG = EventManager.class.getSimpleName();
    private final Map<Pair<String, String>, List<INotification>> eventMap = new ConcurrentHashMap<Pair<String, String>, List<INotification>>();

    public static EventManager getInstance() {
        return EventManagerHolder.eventManager;
    }

    private EventManager() {
    }

    public void registerEvent(String key, String subKey, INotification notification) {
        Log.i((String)TAG, (String)("registerEvent : key : " + key + ", subKey : " + subKey + ", notification : " + notification));
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)subKey) || notification == null) {
            return;
        }
        Pair keyPair = new Pair((Object)key, (Object)subKey);
        List<INotification> list = this.eventMap.get(keyPair);
        if (list == null) {
            list = new CopyOnWriteArrayList<INotification>();
            this.eventMap.put((Pair<String, String>)keyPair, list);
        }
        if (!list.contains(notification)) {
            list.add(notification);
        }
    }

    public void unRegisterEvent(String key, String subKey, INotification notification) {
        Log.i((String)TAG, (String)("removeEvent : key : " + key + ", subKey : " + subKey + " notification : " + notification));
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)subKey) || notification == null) {
            return;
        }
        Pair keyPair = new Pair((Object)key, (Object)subKey);
        List<INotification> list = this.eventMap.get(keyPair);
        if (list == null) {
            return;
        }
        list.remove(notification);
    }

    public void unRegisterEvent(INotification notification) {
        Log.i((String)TAG, (String)("removeEvent : notification : " + notification));
        if (notification == null) {
            return;
        }
        block0: for (Pair<String, String> key : this.eventMap.keySet()) {
            List<INotification> value = this.eventMap.get(key);
            if (value == null) continue;
            for (INotification item : value) {
                if (item != notification) continue;
                value.remove(item);
                continue block0;
            }
        }
    }

    public void notifyEvent(String key, String subKey, Map<String, Object> param) {
        Log.d((String)TAG, (String)("notifyEvent : key : " + key + ", subKey : " + subKey));
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)subKey)) {
            return;
        }
        Pair keyPair = new Pair((Object)key, (Object)subKey);
        List<INotification> notificationList = this.eventMap.get(keyPair);
        if (notificationList != null) {
            for (INotification notification : notificationList) {
                notification.onNotifyEvent(key, subKey, param);
            }
        }
    }

    private static class EventManagerHolder {
        private static final EventManager eventManager = new EventManager();

        private EventManagerHolder() {
        }
    }
}

