/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.server;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;

public class ListBasedRecordSet
implements RecordSet {
    private final List<Type> types;
    private final List<List<String>> keys;
    private final int totalRecords;

    public ListBasedRecordSet(List<List<String>> keys, List<Type> types) {
        this.types = Objects.requireNonNull(types, "types is null");
        this.keys = Objects.requireNonNull(keys, "keys is null");
        Preconditions.checkArgument((keys.isEmpty() || keys.size() == types.size() ? 1 : 0) != 0, (Object)"number of types and key columns must match");
        this.totalRecords = keys.isEmpty() ? 0 : keys.get(0).size();
    }

    public List<Type> getColumnTypes() {
        return this.types;
    }

    public RecordCursor cursor() {
        return new ListBasedRecordCursor();
    }

    private class ListBasedRecordCursor
    implements RecordCursor {
        private int position = -1;

        private ListBasedRecordCursor() {
        }

        public boolean isNull(int field) {
            return ListBasedRecordSet.this.keys.get(field).get(this.position) == null;
        }

        public long getLong(int field) {
            return Long.parseLong(ListBasedRecordSet.this.keys.get(field).get(this.position));
        }

        public Slice getSlice(int field) {
            return Slices.utf8Slice((String)ListBasedRecordSet.this.keys.get(field).get(this.position));
        }

        public boolean advanceNextPosition() {
            if (this.position >= ListBasedRecordSet.this.totalRecords) {
                return false;
            }
            ++this.position;
            return this.position < ListBasedRecordSet.this.totalRecords;
        }

        public Type getType(int field) {
            return ListBasedRecordSet.this.types.get(field);
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public void close() {
        }

        public boolean getBoolean(int field) {
            throw new UnsupportedOperationException("invalid type");
        }

        public double getDouble(int field) {
            throw new UnsupportedOperationException("invalid type");
        }

        public Object getObject(int field) {
            throw new UnsupportedOperationException("invalid type");
        }
    }
}

