/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api.valuesets;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.trino.plugin.thrift.api.TrinoThriftBlock;
import io.trino.spi.predicate.EquatableValueSet;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@ThriftStruct
public final class TrinoThriftEquatableValueSet {
    private final boolean inclusive;
    private final List<TrinoThriftBlock> values;

    @ThriftConstructor
    public TrinoThriftEquatableValueSet(boolean inclusive, List<TrinoThriftBlock> values) {
        this.inclusive = inclusive;
        this.values = Objects.requireNonNull(values, "values are null");
    }

    @ThriftField(value=1)
    public boolean isInclusive() {
        return this.inclusive;
    }

    @ThriftField(value=2)
    public List<TrinoThriftBlock> getValues() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoThriftEquatableValueSet other = (TrinoThriftEquatableValueSet)obj;
        return this.inclusive == other.inclusive && Objects.equals(this.values, other.values);
    }

    public int hashCode() {
        return Objects.hash(this.inclusive, this.values);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("inclusive", this.inclusive).add("values", this.values).toString();
    }

    public static TrinoThriftEquatableValueSet fromEquatableValueSet(EquatableValueSet valueSet) {
        Type type = valueSet.getType();
        Set values = valueSet.getEntries();
        ArrayList<TrinoThriftBlock> thriftValues = new ArrayList<TrinoThriftBlock>(values.size());
        for (EquatableValueSet.ValueEntry value : values) {
            Preconditions.checkState((boolean)type.equals((Object)value.getType()), (String)"ValueEntrySet has elements of different types: %s vs %s", (Object)type, (Object)value.getType());
            thriftValues.add(TrinoThriftBlock.fromBlock(value.getBlock(), type));
        }
        return new TrinoThriftEquatableValueSet(valueSet.inclusive(), thriftValues);
    }
}

