/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.trino.plugin.thrift.api.TrinoThriftBlock;
import io.trino.plugin.thrift.api.TrinoThriftId;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ThriftStruct
public final class TrinoThriftPageResult {
    private final List<TrinoThriftBlock> columnBlocks;
    private final int rowCount;
    private final TrinoThriftId nextToken;

    @ThriftConstructor
    public TrinoThriftPageResult(List<TrinoThriftBlock> columnBlocks, int rowCount, @Nullable TrinoThriftId nextToken) {
        this.columnBlocks = Objects.requireNonNull(columnBlocks, "columnBlocks is null");
        Preconditions.checkArgument((rowCount >= 0 ? 1 : 0) != 0, (Object)"rowCount is negative");
        TrinoThriftPageResult.checkAllColumnsAreOfExpectedSize(columnBlocks, rowCount);
        this.rowCount = rowCount;
        this.nextToken = nextToken;
    }

    @ThriftField(value=1)
    public List<TrinoThriftBlock> getColumnBlocks() {
        return this.columnBlocks;
    }

    @ThriftField(value=2)
    public int getRowCount() {
        return this.rowCount;
    }

    @Nullable
    @ThriftField(value=3, requiredness=ThriftField.Requiredness.OPTIONAL)
    public TrinoThriftId getNextToken() {
        return this.nextToken;
    }

    @Nullable
    public Page toPage(List<Type> columnTypes) {
        if (this.rowCount == 0) {
            return null;
        }
        Preconditions.checkArgument((this.columnBlocks.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columns and types have different sizes");
        int numberOfColumns = this.columnBlocks.size();
        if (numberOfColumns == 0) {
            return new Page(this.rowCount);
        }
        Block[] blocks = new Block[numberOfColumns];
        for (int i = 0; i < numberOfColumns; ++i) {
            blocks[i] = this.columnBlocks.get(i).toBlock(columnTypes.get(i));
        }
        return new Page(blocks);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoThriftPageResult other = (TrinoThriftPageResult)obj;
        return Objects.equals(this.columnBlocks, other.columnBlocks) && this.rowCount == other.rowCount && Objects.equals(this.nextToken, other.nextToken);
    }

    public int hashCode() {
        return Objects.hash(this.columnBlocks, this.rowCount, this.nextToken);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnBlocks", this.columnBlocks).add("rowCount", this.rowCount).add("nextToken", (Object)this.nextToken).toString();
    }

    public static TrinoThriftPageResult fromRecordSet(RecordSet recordSet) {
        List types = recordSet.getColumnTypes();
        int numberOfColumns = types.size();
        int positions = TrinoThriftPageResult.totalRecords(recordSet);
        if (numberOfColumns == 0) {
            return new TrinoThriftPageResult((List<TrinoThriftBlock>)ImmutableList.of(), positions, null);
        }
        ArrayList<TrinoThriftBlock> thriftBlocks = new ArrayList<TrinoThriftBlock>(numberOfColumns);
        for (int columnIndex = 0; columnIndex < numberOfColumns; ++columnIndex) {
            thriftBlocks.add(TrinoThriftBlock.fromRecordSetColumn(recordSet, columnIndex, positions));
        }
        return new TrinoThriftPageResult(thriftBlocks, positions, null);
    }

    private static void checkAllColumnsAreOfExpectedSize(List<TrinoThriftBlock> columnBlocks, int expectedNumberOfRows) {
        for (int i = 0; i < columnBlocks.size(); ++i) {
            Preconditions.checkArgument((columnBlocks.get(i).numberOfRecords() == expectedNumberOfRows ? 1 : 0) != 0, (String)"Incorrect number of records for column with index %s: expected %s, got %s", (Object)i, (Object)expectedNumberOfRows, (Object)columnBlocks.get(i).numberOfRecords());
        }
    }

    private static int totalRecords(RecordSet recordSet) {
        RecordCursor cursor = recordSet.cursor();
        int result = 0;
        while (cursor.advanceNextPosition()) {
            ++result;
        }
        return result;
    }
}

