/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api.datatypes;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.trino.plugin.thrift.api.TrinoThriftBlock;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftColumnData;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftTypeUtils;
import io.trino.spi.block.Block;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.DateType;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@ThriftStruct
public final class TrinoThriftDate
implements TrinoThriftColumnData {
    private final boolean[] nulls;
    private final int[] dates;

    @ThriftConstructor
    public TrinoThriftDate(@ThriftField(name="nulls") @Nullable boolean[] nulls, @ThriftField(name="dates") @Nullable int[] dates) {
        Preconditions.checkArgument((boolean)TrinoThriftDate.sameSizeIfPresent(nulls, dates), (Object)"nulls and values must be of the same size");
        this.nulls = nulls;
        this.dates = dates;
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public boolean[] getNulls() {
        return this.nulls;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public int[] getDates() {
        return this.dates;
    }

    @Override
    public Block toBlock(Type desiredType) {
        Preconditions.checkArgument((boolean)DateType.DATE.equals((Object)desiredType), (String)"type doesn't match: %s", (Object)desiredType);
        int numberOfRecords = this.numberOfRecords();
        return new IntArrayBlock(numberOfRecords, Optional.ofNullable(this.nulls), this.dates == null ? new int[numberOfRecords] : this.dates);
    }

    @Override
    public int numberOfRecords() {
        if (this.nulls != null) {
            return this.nulls.length;
        }
        if (this.dates != null) {
            return this.dates.length;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoThriftDate other = (TrinoThriftDate)obj;
        return Arrays.equals(this.nulls, other.nulls) && Arrays.equals(this.dates, other.dates);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.nulls), Arrays.hashCode(this.dates));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRecords", this.numberOfRecords()).toString();
    }

    public static TrinoThriftBlock fromBlock(Block block) {
        return TrinoThriftTypeUtils.fromIntBasedBlock(block, (Type)DateType.DATE, (nulls, ints) -> TrinoThriftBlock.dateData(new TrinoThriftDate((boolean[])nulls, (int[])ints)));
    }

    public static TrinoThriftBlock fromRecordSetColumn(RecordSet recordSet, int columnIndex, int totalRecords) {
        return TrinoThriftTypeUtils.fromIntBasedColumn(recordSet, columnIndex, totalRecords, (nulls, ints) -> TrinoThriftBlock.dateData(new TrinoThriftDate((boolean[])nulls, (int[])ints)));
    }

    private static boolean sameSizeIfPresent(boolean[] nulls, int[] dates) {
        return nulls == null || dates == null || nulls.length == dates.length;
    }
}

