/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.airlift.slice.Slice;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftBigint;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftBigintArray;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftBoolean;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftColumnData;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftDate;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftDouble;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftHyperLogLog;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftInteger;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftJson;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftTimestamp;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftVarchar;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Objects;
import javax.annotation.Nullable;

@ThriftStruct
public final class TrinoThriftBlock {
    private final TrinoThriftInteger integerData;
    private final TrinoThriftBigint bigintData;
    private final TrinoThriftDouble doubleData;
    private final TrinoThriftVarchar varcharData;
    private final TrinoThriftBoolean booleanData;
    private final TrinoThriftDate dateData;
    private final TrinoThriftTimestamp timestampData;
    private final TrinoThriftJson jsonData;
    private final TrinoThriftHyperLogLog hyperLogLogData;
    private final TrinoThriftBigintArray bigintArrayData;
    private final TrinoThriftColumnData dataReference;

    @ThriftConstructor
    public TrinoThriftBlock(@Nullable TrinoThriftInteger integerData, @Nullable TrinoThriftBigint bigintData, @Nullable TrinoThriftDouble doubleData, @Nullable TrinoThriftVarchar varcharData, @Nullable TrinoThriftBoolean booleanData, @Nullable TrinoThriftDate dateData, @Nullable TrinoThriftTimestamp timestampData, @Nullable TrinoThriftJson jsonData, @Nullable TrinoThriftHyperLogLog hyperLogLogData, @Nullable TrinoThriftBigintArray bigintArrayData) {
        this.integerData = integerData;
        this.bigintData = bigintData;
        this.doubleData = doubleData;
        this.varcharData = varcharData;
        this.booleanData = booleanData;
        this.dateData = dateData;
        this.timestampData = timestampData;
        this.jsonData = jsonData;
        this.hyperLogLogData = hyperLogLogData;
        this.bigintArrayData = bigintArrayData;
        this.dataReference = TrinoThriftBlock.theOnlyNonNull(integerData, bigintData, doubleData, varcharData, booleanData, dateData, timestampData, jsonData, hyperLogLogData, bigintArrayData);
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public TrinoThriftInteger getIntegerData() {
        return this.integerData;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public TrinoThriftBigint getBigintData() {
        return this.bigintData;
    }

    @Nullable
    @ThriftField(value=3, requiredness=ThriftField.Requiredness.OPTIONAL)
    public TrinoThriftDouble getDoubleData() {
        return this.doubleData;
    }

    @Nullable
    @ThriftField(value=4, requiredness=ThriftField.Requiredness.OPTIONAL)
    public TrinoThriftVarchar getVarcharData() {
        return this.varcharData;
    }

    @Nullable
    @ThriftField(value=5, requiredness=ThriftField.Requiredness.OPTIONAL)
    public TrinoThriftBoolean getBooleanData() {
        return this.booleanData;
    }

    @Nullable
    @ThriftField(value=6, requiredness=ThriftField.Requiredness.OPTIONAL)
    public TrinoThriftDate getDateData() {
        return this.dateData;
    }

    @Nullable
    @ThriftField(value=7, requiredness=ThriftField.Requiredness.OPTIONAL)
    public TrinoThriftTimestamp getTimestampData() {
        return this.timestampData;
    }

    @Nullable
    @ThriftField(value=8, requiredness=ThriftField.Requiredness.OPTIONAL)
    public TrinoThriftJson getJsonData() {
        return this.jsonData;
    }

    @Nullable
    @ThriftField(value=9, requiredness=ThriftField.Requiredness.OPTIONAL)
    public TrinoThriftHyperLogLog getHyperLogLogData() {
        return this.hyperLogLogData;
    }

    @Nullable
    @ThriftField(value=10, requiredness=ThriftField.Requiredness.OPTIONAL)
    public TrinoThriftBigintArray getBigintArrayData() {
        return this.bigintArrayData;
    }

    public Block toBlock(Type desiredType) {
        return this.dataReference.toBlock(desiredType);
    }

    public int numberOfRecords() {
        return this.dataReference.numberOfRecords();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoThriftBlock other = (TrinoThriftBlock)obj;
        return Objects.equals(this.dataReference, other.dataReference);
    }

    public int hashCode() {
        return Objects.hash(this.integerData, this.bigintData, this.doubleData, this.varcharData, this.booleanData, this.dateData, this.timestampData, this.jsonData, this.hyperLogLogData, this.bigintArrayData);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("data", (Object)this.dataReference).toString();
    }

    public static TrinoThriftBlock integerData(TrinoThriftInteger integerData) {
        return new TrinoThriftBlock(integerData, null, null, null, null, null, null, null, null, null);
    }

    public static TrinoThriftBlock bigintData(TrinoThriftBigint bigintData) {
        return new TrinoThriftBlock(null, bigintData, null, null, null, null, null, null, null, null);
    }

    public static TrinoThriftBlock doubleData(TrinoThriftDouble doubleData) {
        return new TrinoThriftBlock(null, null, doubleData, null, null, null, null, null, null, null);
    }

    public static TrinoThriftBlock varcharData(TrinoThriftVarchar varcharData) {
        return new TrinoThriftBlock(null, null, null, varcharData, null, null, null, null, null, null);
    }

    public static TrinoThriftBlock booleanData(TrinoThriftBoolean booleanData) {
        return new TrinoThriftBlock(null, null, null, null, booleanData, null, null, null, null, null);
    }

    public static TrinoThriftBlock dateData(TrinoThriftDate dateData) {
        return new TrinoThriftBlock(null, null, null, null, null, dateData, null, null, null, null);
    }

    public static TrinoThriftBlock timestampData(TrinoThriftTimestamp timestampData) {
        return new TrinoThriftBlock(null, null, null, null, null, null, timestampData, null, null, null);
    }

    public static TrinoThriftBlock jsonData(TrinoThriftJson jsonData) {
        return new TrinoThriftBlock(null, null, null, null, null, null, null, jsonData, null, null);
    }

    public static TrinoThriftBlock hyperLogLogData(TrinoThriftHyperLogLog hyperLogLogData) {
        return new TrinoThriftBlock(null, null, null, null, null, null, null, null, hyperLogLogData, null);
    }

    public static TrinoThriftBlock bigintArrayData(TrinoThriftBigintArray bigintArrayData) {
        return new TrinoThriftBlock(null, null, null, null, null, null, null, null, null, bigintArrayData);
    }

    public static TrinoThriftBlock fromNativeValue(Object trinoNativeValue, Type type) {
        return TrinoThriftBlock.fromBlock(Utils.nativeValueToBlock((Type)type, (Object)trinoNativeValue), type);
    }

    public static TrinoThriftBlock fromBlock(Block block, Type type) {
        if (type instanceof IntegerType) {
            return TrinoThriftInteger.fromBlock(block);
        }
        if (type instanceof BigintType) {
            return TrinoThriftBigint.fromBlock(block);
        }
        if (type instanceof DoubleType) {
            return TrinoThriftDouble.fromBlock(block);
        }
        if (type instanceof VarcharType) {
            return TrinoThriftVarchar.fromBlock(block, type);
        }
        if (type instanceof BooleanType) {
            return TrinoThriftBoolean.fromBlock(block);
        }
        if (type instanceof DateType) {
            return TrinoThriftDate.fromBlock(block);
        }
        if (type instanceof TimestampType) {
            return TrinoThriftTimestamp.fromBlock(block);
        }
        if (type instanceof ArrayType) {
            Type elementType = (Type)Iterables.getOnlyElement((Iterable)type.getTypeParameters());
            if (BigintType.BIGINT.equals((Object)elementType)) {
                return TrinoThriftBigintArray.fromBlock(block);
            }
            throw new IllegalArgumentException("Unsupported array block type: " + type);
        }
        if (type.getBaseName().equals("json")) {
            return TrinoThriftJson.fromBlock(block, type);
        }
        if (type.getBaseName().equals("HyperLogLog")) {
            return TrinoThriftHyperLogLog.fromBlock(block);
        }
        throw new IllegalArgumentException("Unsupported block type: " + type);
    }

    public static TrinoThriftBlock fromRecordSetColumn(RecordSet recordSet, int columnIndex, int totalRecords) {
        Type type = (Type)recordSet.getColumnTypes().get(columnIndex);
        if (type instanceof IntegerType) {
            return TrinoThriftInteger.fromRecordSetColumn(recordSet, columnIndex, totalRecords);
        }
        if (type instanceof BigintType) {
            return TrinoThriftBigint.fromRecordSetColumn(recordSet, columnIndex, totalRecords);
        }
        if (type instanceof DateType) {
            return TrinoThriftDate.fromRecordSetColumn(recordSet, columnIndex, totalRecords);
        }
        if (type instanceof TimestampType) {
            return TrinoThriftTimestamp.fromRecordSetColumn(recordSet, columnIndex, totalRecords);
        }
        return TrinoThriftBlock.fromBlock(TrinoThriftBlock.convertColumnToBlock(recordSet, columnIndex, totalRecords), type);
    }

    private static Block convertColumnToBlock(RecordSet recordSet, int columnIndex, int positions) {
        Type type = (Type)recordSet.getColumnTypes().get(columnIndex);
        BlockBuilder output = type.createBlockBuilder(null, positions);
        Class javaType = type.getJavaType();
        RecordCursor cursor = recordSet.cursor();
        for (int position = 0; position < positions; ++position) {
            Preconditions.checkState((boolean)cursor.advanceNextPosition(), (Object)"cursor has less values than expected");
            if (cursor.isNull(columnIndex)) {
                output.appendNull();
                continue;
            }
            if (javaType == Boolean.TYPE) {
                type.writeBoolean(output, cursor.getBoolean(columnIndex));
                continue;
            }
            if (javaType == Long.TYPE) {
                type.writeLong(output, cursor.getLong(columnIndex));
                continue;
            }
            if (javaType == Double.TYPE) {
                type.writeDouble(output, cursor.getDouble(columnIndex));
                continue;
            }
            if (javaType == Slice.class) {
                Slice slice = cursor.getSlice(columnIndex);
                type.writeSlice(output, slice, 0, slice.length());
                continue;
            }
            type.writeObject(output, cursor.getObject(columnIndex));
        }
        Preconditions.checkState((!cursor.advanceNextPosition() ? 1 : 0) != 0, (Object)"cursor has more values than expected");
        return output.build();
    }

    private static TrinoThriftColumnData theOnlyNonNull(TrinoThriftColumnData ... columnsData) {
        TrinoThriftColumnData result = null;
        for (TrinoThriftColumnData data : columnsData) {
            if (data == null) continue;
            Preconditions.checkArgument((result == null ? 1 : 0) != 0, (Object)"more than one type is present");
            result = data;
        }
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (Object)"no types are present");
        return result;
    }
}

