/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api.valuesets;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftEnum;
import io.airlift.drift.annotations.ThriftEnumValue;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.trino.plugin.thrift.api.TrinoThriftBlock;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Marker;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.SortedRangeSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ThriftStruct
public final class TrinoThriftRangeValueSet {
    private final List<TrinoThriftRange> ranges;

    @ThriftConstructor
    public TrinoThriftRangeValueSet(@ThriftField(name="ranges") List<TrinoThriftRange> ranges) {
        this.ranges = Objects.requireNonNull(ranges, "ranges is null");
    }

    @ThriftField(value=1)
    public List<TrinoThriftRange> getRanges() {
        return this.ranges;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoThriftRangeValueSet other = (TrinoThriftRangeValueSet)obj;
        return Objects.equals(this.ranges, other.ranges);
    }

    public int hashCode() {
        return Objects.hashCode(this.ranges);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRanges", this.ranges.size()).toString();
    }

    public static TrinoThriftRangeValueSet fromSortedRangeSet(SortedRangeSet valueSet) {
        List ranges = (List)valueSet.getOrderedRanges().stream().map(TrinoThriftRange::fromRange).collect(ImmutableList.toImmutableList());
        return new TrinoThriftRangeValueSet(ranges);
    }

    @ThriftStruct
    public static final class TrinoThriftRange {
        private final TrinoThriftMarker low;
        private final TrinoThriftMarker high;

        @ThriftConstructor
        public TrinoThriftRange(TrinoThriftMarker low, TrinoThriftMarker high) {
            this.low = Objects.requireNonNull(low, "low is null");
            this.high = Objects.requireNonNull(high, "high is null");
        }

        @ThriftField(value=1)
        public TrinoThriftMarker getLow() {
            return this.low;
        }

        @ThriftField(value=2)
        public TrinoThriftMarker getHigh() {
            return this.high;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TrinoThriftRange other = (TrinoThriftRange)obj;
            return Objects.equals(this.low, other.low) && Objects.equals(this.high, other.high);
        }

        public int hashCode() {
            return Objects.hash(this.low, this.high);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("low", (Object)this.low).add("high", (Object)this.high).toString();
        }

        public static TrinoThriftRange fromRange(Range range) {
            return new TrinoThriftRange(TrinoThriftMarker.fromMarker(range.getLow()), TrinoThriftMarker.fromMarker(range.getHigh()));
        }
    }

    @ThriftStruct
    public static final class TrinoThriftMarker {
        private final TrinoThriftBlock value;
        private final TrinoThriftBound bound;

        @ThriftConstructor
        public TrinoThriftMarker(@Nullable TrinoThriftBlock value, TrinoThriftBound bound) {
            Preconditions.checkArgument((value == null || value.numberOfRecords() == 1 ? 1 : 0) != 0, (Object)"value must contain exactly one record when present");
            this.value = value;
            this.bound = Objects.requireNonNull(bound, "bound is null");
        }

        @Nullable
        @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
        public TrinoThriftBlock getValue() {
            return this.value;
        }

        @ThriftField(value=2)
        public TrinoThriftBound getBound() {
            return this.bound;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TrinoThriftMarker other = (TrinoThriftMarker)obj;
            return Objects.equals(this.value, other.value) && this.bound == other.bound;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.value, this.bound});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).add("bound", (Object)this.bound).toString();
        }

        public static TrinoThriftMarker fromMarker(Marker marker) {
            TrinoThriftBlock value = marker.getValueBlock().isPresent() ? TrinoThriftBlock.fromBlock((Block)marker.getValueBlock().get(), marker.getType()) : null;
            return new TrinoThriftMarker(value, TrinoThriftBound.fromBound(marker.getBound()));
        }
    }

    @ThriftEnum
    public static enum TrinoThriftBound {
        BELOW(1),
        EXACTLY(2),
        ABOVE(3);

        private final int value;

        private TrinoThriftBound(int value) {
            this.value = value;
        }

        @ThriftEnumValue
        public int getValue() {
            return this.value;
        }

        public static TrinoThriftBound fromBound(Marker.Bound bound) {
            switch (bound) {
                case BELOW: {
                    return BELOW;
                }
                case EXACTLY: {
                    return EXACTLY;
                }
                case ABOVE: {
                    return ABOVE;
                }
            }
            throw new IllegalArgumentException("Unknown bound: " + bound);
        }
    }
}

