/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api.datatypes;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.trino.plugin.thrift.api.TrinoThriftBlock;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftColumnData;
import io.trino.spi.block.Block;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@ThriftStruct
public final class TrinoThriftBoolean
implements TrinoThriftColumnData {
    private final boolean[] nulls;
    private final boolean[] booleans;

    @ThriftConstructor
    public TrinoThriftBoolean(@Nullable boolean[] nulls, @Nullable boolean[] booleans) {
        Preconditions.checkArgument((boolean)TrinoThriftBoolean.sameSizeIfPresent(nulls, booleans), (Object)"nulls and values must be of the same size");
        this.nulls = nulls;
        this.booleans = booleans;
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public boolean[] getNulls() {
        return this.nulls;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public boolean[] getBooleans() {
        return this.booleans;
    }

    @Override
    public Block toBlock(Type desiredType) {
        Preconditions.checkArgument((boolean)BooleanType.BOOLEAN.equals((Object)desiredType), (String)"type doesn't match: %s", (Object)desiredType);
        int numberOfRecords = this.numberOfRecords();
        return new ByteArrayBlock(numberOfRecords, Optional.ofNullable(this.nulls), this.booleans == null ? new byte[numberOfRecords] : TrinoThriftBoolean.toByteArray(this.booleans));
    }

    @Override
    public int numberOfRecords() {
        if (this.nulls != null) {
            return this.nulls.length;
        }
        if (this.booleans != null) {
            return this.booleans.length;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoThriftBoolean other = (TrinoThriftBoolean)obj;
        return Arrays.equals(this.nulls, other.nulls) && Arrays.equals(this.booleans, other.booleans);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.nulls), Arrays.hashCode(this.booleans));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRecords", this.numberOfRecords()).toString();
    }

    public static TrinoThriftBlock fromBlock(Block block) {
        int positions = block.getPositionCount();
        if (positions == 0) {
            return TrinoThriftBlock.booleanData(new TrinoThriftBoolean(null, null));
        }
        boolean[] nulls = null;
        boolean[] booleans = null;
        for (int position = 0; position < positions; ++position) {
            if (block.isNull(position)) {
                if (nulls == null) {
                    nulls = new boolean[positions];
                }
                nulls[position] = true;
                continue;
            }
            if (booleans == null) {
                booleans = new boolean[positions];
            }
            booleans[position] = BooleanType.BOOLEAN.getBoolean(block, position);
        }
        return TrinoThriftBlock.booleanData(new TrinoThriftBoolean(nulls, booleans));
    }

    private static boolean sameSizeIfPresent(boolean[] nulls, boolean[] booleans) {
        return nulls == null || booleans == null || nulls.length == booleans.length;
    }

    private static byte[] toByteArray(boolean[] booleans) {
        byte[] bytes = new byte[booleans.length];
        for (int i = 0; i < booleans.length; ++i) {
            bytes[i] = booleans[i] ? (byte)1 : 0;
        }
        return bytes;
    }
}

