/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api.datatypes;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.trino.plugin.thrift.api.TrinoThriftBlock;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftColumnData;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftTypeUtils;
import io.trino.spi.block.Block;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@ThriftStruct
public final class TrinoThriftBigint
implements TrinoThriftColumnData {
    private final boolean[] nulls;
    private final long[] longs;

    @ThriftConstructor
    public TrinoThriftBigint(@ThriftField(name="nulls") @Nullable boolean[] nulls, @ThriftField(name="longs") @Nullable long[] longs) {
        Preconditions.checkArgument((boolean)TrinoThriftBigint.sameSizeIfPresent(nulls, longs), (Object)"nulls and values must be of the same size");
        this.nulls = nulls;
        this.longs = longs;
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public boolean[] getNulls() {
        return this.nulls;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public long[] getLongs() {
        return this.longs;
    }

    @Override
    public Block toBlock(Type desiredType) {
        Preconditions.checkArgument((boolean)BigintType.BIGINT.equals((Object)desiredType), (String)"type doesn't match: %s", (Object)desiredType);
        int numberOfRecords = this.numberOfRecords();
        return new LongArrayBlock(numberOfRecords, Optional.ofNullable(this.nulls), this.longs == null ? new long[numberOfRecords] : this.longs);
    }

    @Override
    public int numberOfRecords() {
        if (this.nulls != null) {
            return this.nulls.length;
        }
        if (this.longs != null) {
            return this.longs.length;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoThriftBigint other = (TrinoThriftBigint)obj;
        return Arrays.equals(this.nulls, other.nulls) && Arrays.equals(this.longs, other.longs);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.nulls), Arrays.hashCode(this.longs));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRecords", this.numberOfRecords()).toString();
    }

    public static TrinoThriftBlock fromBlock(Block block) {
        return TrinoThriftTypeUtils.fromLongBasedBlock(block, (Type)BigintType.BIGINT, (nulls, longs) -> TrinoThriftBlock.bigintData(new TrinoThriftBigint((boolean[])nulls, (long[])longs)));
    }

    public static TrinoThriftBlock fromRecordSetColumn(RecordSet recordSet, int columnIndex, int totalRecords) {
        return TrinoThriftTypeUtils.fromLongBasedColumn(recordSet, columnIndex, totalRecords, (nulls, longs) -> TrinoThriftBlock.bigintData(new TrinoThriftBigint((boolean[])nulls, (long[])longs)));
    }

    private static boolean sameSizeIfPresent(boolean[] nulls, long[] longs) {
        return nulls == null || longs == null || nulls.length == longs.length;
    }
}

