/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.airlift.http.server.HttpServer;
import io.airlift.log.Level;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.testing.Closeables;
import io.airlift.units.Duration;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.trino.Session;
import io.trino.client.ClientSession;
import io.trino.client.StatementClient;
import io.trino.client.StatementClientFactory;
import io.trino.connector.ConnectorServicesProvider;
import io.trino.connector.CoordinatorDynamicCatalogManager;
import io.trino.cost.StatsCalculator;
import io.trino.execution.FailureInjector;
import io.trino.execution.QueryManager;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.SessionPropertyManager;
import io.trino.node.InternalNode;
import io.trino.plugin.exchange.filesystem.FileSystemExchangePlugin;
import io.trino.server.BasicQueryInfo;
import io.trino.server.PluginManager;
import io.trino.server.SessionPropertyDefaults;
import io.trino.server.testing.FactoryConfiguration;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.ErrorType;
import io.trino.spi.Plugin;
import io.trino.spi.QueryId;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.security.SystemAccessControl;
import io.trino.split.PageSourceManager;
import io.trino.split.SplitManager;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.Plan;
import io.trino.testing.CustomFunctionBundle;
import io.trino.testing.LocalSpoolingManager;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.ResultWithQueryId;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingGroupProviderManager;
import io.trino.testing.TestingStatementClientFactory;
import io.trino.testing.TestingTrinoClient;
import io.trino.testing.containers.OpenTracingCollector;
import io.trino.transaction.TransactionManager;
import io.trino.util.Ciphers;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import okhttp3.OkHttpClient;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.intellij.lang.annotations.Language;

public final class DistributedQueryRunner
implements QueryRunner {
    private static final Logger log = Logger.get(DistributedQueryRunner.class);
    private static final String ENVIRONMENT = "testing";
    private static final AtomicInteger unclosedInstances = new AtomicInteger();
    private TestingTrinoServer coordinator;
    private Optional<TestingTrinoServer> backupCoordinator = Optional.empty();
    private Consumer<Map<String, String>> registerNewWorker;
    private final InMemorySpanExporter spanExporter = InMemorySpanExporter.create();
    private final List<TestingTrinoServer> servers = new CopyOnWriteArrayList<TestingTrinoServer>();
    private final List<FunctionBundle> functionBundles = new CopyOnWriteArrayList<FunctionBundle>((Collection<FunctionBundle>)ImmutableList.of((Object)CustomFunctionBundle.CUSTOM_FUNCTIONS));
    private final List<Plugin> plugins = new CopyOnWriteArrayList<Plugin>();
    private final Closer closer = Closer.create();
    private TestingTrinoClient trinoClient;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicInteger concurrentQueries = new AtomicInteger();
    private volatile boolean spansValid = true;
    private boolean closed;

    public static Builder<?> builder(Session defaultSession) {
        return new Builder(defaultSession);
    }

    private DistributedQueryRunner(Session defaultSession, int workerCount, Map<String, String> extraProperties, Map<String, String> coordinatorProperties, Optional<Map<String, String>> backupCoordinatorProperties, String environment, Module additionalModule, Optional<Path> baseDataDir, Optional<FactoryConfiguration> systemAccessControlConfiguration, Optional<List<SystemAccessControl>> systemAccessControls, List<EventListener> eventListeners, List<AutoCloseable> extraCloseables, TestingTrinoClientFactory testingTrinoClientFactory) throws Exception {
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        long start = System.nanoTime();
        DistributedQueryRunner.setupLogging();
        try {
            HashMap<String, String> extraCoordinatorProperties = new HashMap<String, String>();
            extraCoordinatorProperties.putAll(extraProperties);
            extraCoordinatorProperties.putAll(coordinatorProperties);
            if (!extraCoordinatorProperties.containsKey("web-ui.authentication.type")) {
                extraCoordinatorProperties.put("web-ui.authentication.type", "fixed");
                extraCoordinatorProperties.put("web-ui.user", "admin");
            }
            this.coordinator = this.createServer(true, extraCoordinatorProperties, environment, additionalModule, baseDataDir, systemAccessControlConfiguration, systemAccessControls, eventListeners);
            this.backupCoordinator = backupCoordinatorProperties.map(properties -> this.createServer(true, (Map<String, String>)ImmutableMap.builder().putAll(extraProperties).putAll(properties).buildOrThrow(), environment, additionalModule, baseDataDir, systemAccessControlConfiguration, systemAccessControls, eventListeners));
            this.backupCoordinator.ifPresent(backup -> {
                this.coordinator.registerServer(backup.getCurrentNode());
                backup.registerServer(this.coordinator.getCurrentNode());
            });
            extraCloseables.forEach(closeable -> this.closer.register(() -> DistributedQueryRunner.closeUnchecked(closeable)));
            this.registerNewWorker = additionalWorkerProperties -> {
                TestingTrinoServer ignored = this.createServer(false, (Map<String, String>)ImmutableMap.builder().putAll(extraProperties).putAll(additionalWorkerProperties).buildOrThrow(), environment, additionalModule, baseDataDir, Optional.empty(), Optional.of(ImmutableList.of()), (List<EventListener>)ImmutableList.of());
            };
            for (int i = 0; i < workerCount; ++i) {
                this.registerNewWorker.accept(Map.of());
            }
        }
        catch (Exception e) {
            try {
                throw this.closer.rethrow((Throwable)e, Exception.class);
            }
            catch (Throwable throwable) {
                this.closer.close();
                throw throwable;
            }
        }
        defaultSession = defaultSession.toSessionRepresentation().toSession(this.coordinator.getSessionPropertyManager(), defaultSession.getIdentity().getExtraCredentials(), defaultSession.getExchangeEncryptionKey());
        this.trinoClient = (TestingTrinoClient)this.closer.register((Closeable)testingTrinoClientFactory.create(this.coordinator, defaultSession));
        log.info("Created DistributedQueryRunner in %s (unclosed instances = %s)", new Object[]{Duration.nanosSince((long)start), unclosedInstances.incrementAndGet()});
    }

    public void registerResource(AutoCloseable resource) {
        Objects.requireNonNull(resource, "resource is null");
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"already closed");
        this.closer.register(() -> {
            try {
                resource.close();
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                Throwables.throwIfInstanceOf((Throwable)e, IOException.class);
                throw new RuntimeException(e);
            }
        });
    }

    private TestingTrinoServer createServer(boolean coordinator, Map<String, String> extraProperties, String environment, Module additionalModule, Optional<Path> baseDataDir, Optional<FactoryConfiguration> systemAccessControlConfiguration, Optional<List<SystemAccessControl>> systemAccessControls, List<EventListener> eventListeners) {
        if (this.coordinator != null) {
            String discoveryUri = String.valueOf(this.coordinator.getCurrentNode().getInternalUri()) + this.backupCoordinator.map(backup -> "," + String.valueOf(backup.getCurrentNode().getInternalUri())).orElse("");
            extraProperties = ImmutableMap.builder().putAll(extraProperties).put((Object)"discovery.uri", (Object)discoveryUri).buildOrThrow();
        }
        TestingTrinoServer server = (TestingTrinoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingTrinoServer(coordinator, extraProperties, environment, additionalModule, baseDataDir, SimpleSpanProcessor.create((SpanExporter)this.spanExporter), systemAccessControlConfiguration, systemAccessControls, eventListeners, newServer -> {
            this.functionBundles.forEach(arg_0 -> ((TestingTrinoServer)newServer).addFunctions(arg_0));
            this.plugins.forEach(arg_0 -> ((TestingTrinoServer)newServer).installPlugin(arg_0));
        }));
        this.servers.add(server);
        if (this.coordinator != null) {
            InternalNode currentNode = server.getCurrentNode();
            this.coordinator.registerServer(currentNode);
            this.backupCoordinator.ifPresent(backup -> backup.registerServer(currentNode));
        }
        return server;
    }

    private static void setupLogging() {
        Logging logging = Logging.initialize();
        logging.setLevel("io.trino.bootstrap", Level.WARN);
        logging.setLevel("org.glassfish", Level.ERROR);
        logging.setLevel("org.eclipse.jetty.server", Level.WARN);
        logging.setLevel("org.hibernate.validator.internal.util.Version", Level.WARN);
        logging.setLevel(PluginManager.class.getName(), Level.WARN);
        logging.setLevel(CoordinatorDynamicCatalogManager.class.getName(), Level.WARN);
        logging.setLevel("io.trino.execution.scheduler.faulttolerant", Level.DEBUG);
    }

    private static TestingTrinoServer createTestingTrinoServer(boolean coordinator, Map<String, String> extraProperties, String environment, Module additionalModule, Optional<Path> baseDataDir, SpanProcessor spanProcessor, Optional<FactoryConfiguration> systemAccessControlConfiguration, Optional<List<SystemAccessControl>> systemAccessControls, List<EventListener> eventListeners, Consumer<TestingTrinoServer> additionalConfiguration) {
        long start = System.nanoTime();
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder().put((Object)"query.client.timeout", (Object)"10m").put((Object)"exchange.http-client.min-threads", (Object)"1").put((Object)"exchange.page-buffer-client.max-callback-threads", (Object)"5").put((Object)"exchange.http-client.idle-timeout", (Object)"1h").put((Object)"task.max-index-memory", (Object)"16kB");
        if (coordinator) {
            propertiesBuilder.put((Object)"node-scheduler.include-coordinator", (Object)"true");
            propertiesBuilder.put((Object)"join-distribution-type", (Object)"PARTITIONED");
            propertiesBuilder.put((Object)"catalog-prune.http-client.min-threads", (Object)"1");
            propertiesBuilder.put((Object)"memory-manager.http-client.min-threads", (Object)"1");
            propertiesBuilder.put((Object)"scheduler.http-client.min-threads", (Object)"1");
            propertiesBuilder.put((Object)"worker-info.http-client.min-threads", (Object)"1");
        }
        HashMap<String, String> properties = new HashMap<String, String>((Map<String, String>)propertiesBuilder.buildOrThrow());
        properties.putAll(extraProperties);
        TestingTrinoServer server = TestingTrinoServer.builder().setCoordinator(coordinator).setProperties(properties).setEnvironment(environment).setAdditionalModule(additionalModule).setBaseDataDir(baseDataDir).setSpanProcessor(spanProcessor).setSystemAccessControlConfiguration(systemAccessControlConfiguration).setSystemAccessControls(systemAccessControls).setEventListeners(eventListeners).setAdditionalConfiguration(additionalConfiguration).build();
        String nodeRole = coordinator ? "coordinator" : "worker";
        log.debug("Created TestingTrinoServer %s in %s: %s", new Object[]{nodeRole, Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit(), server.getBaseUrl()});
        return server;
    }

    public void addServers(int nodeCount) {
        for (int i = 0; i < nodeCount; ++i) {
            this.registerNewWorker.accept(Map.of());
        }
    }

    public void removeWorker() throws Exception {
        TestingTrinoServer worker = null;
        for (int i = 0; i < this.servers.size(); ++i) {
            if (this.servers.get(i).isCoordinator()) continue;
            worker = this.servers.get(i);
            this.servers.remove(i);
            break;
        }
        if (worker == null) {
            throw new IllegalStateException("No workers");
        }
        worker.close();
        this.coordinator.unregisterServer(worker.getCurrentNode());
    }

    public void restartWorker(TestingTrinoServer server) throws Exception {
        URI baseUrl = server.getBaseUrl();
        Preconditions.checkState((boolean)this.servers.remove(server), (String)"Server not found: %s", (Object)server);
        HttpServer workerHttpServer = (HttpServer)server.getInstance(Key.get(HttpServer.class));
        Field serverField = HttpServer.class.getDeclaredField("server");
        serverField.setAccessible(true);
        Connector httpConnector = (Connector)Iterables.getOnlyElement(Arrays.asList(((Server)serverField.get(workerHttpServer)).getConnectors()));
        httpConnector.stop();
        server.close();
        if (!server.isCoordinator()) {
            this.coordinator.unregisterServer(server.getCurrentNode());
            this.backupCoordinator.ifPresent(backup -> backup.unregisterServer(server.getCurrentNode()));
        }
        Map<String, String> reusePort = Map.of("http-server.http.port", Integer.toString(baseUrl.getPort()));
        this.registerNewWorker.accept(reusePort);
        Assertions.assertThat(this.servers.stream().map(TestingTrinoServer::getBaseUrl).filter(baseUrl::equals)).hasSize(1);
    }

    public TestingTrinoClient getClient() {
        return this.trinoClient;
    }

    public List<SpanData> getSpans() {
        Preconditions.checkState((boolean)this.spansValid, (Object)"No valid spans, queries were executing concurrently");
        return this.spanExporter.getFinishedSpanItems();
    }

    public int getNodeCount() {
        return this.servers.size();
    }

    public Session getDefaultSession() {
        return this.trinoClient.getDefaultSession();
    }

    public TransactionManager getTransactionManager() {
        return this.coordinator.getTransactionManager();
    }

    public PlannerContext getPlannerContext() {
        return this.coordinator.getPlannerContext();
    }

    public QueryExplainer getQueryExplainer() {
        return this.coordinator.getQueryExplainer();
    }

    public SessionPropertyManager getSessionPropertyManager() {
        return this.coordinator.getSessionPropertyManager();
    }

    public SplitManager getSplitManager() {
        return this.coordinator.getSplitManager();
    }

    public PageSourceManager getPageSourceManager() {
        return this.coordinator.getPageSourceManager();
    }

    public NodePartitioningManager getNodePartitioningManager() {
        return this.coordinator.getNodePartitioningManager();
    }

    public StatsCalculator getStatsCalculator() {
        return this.coordinator.getStatsCalculator();
    }

    public TestingAccessControlManager getAccessControl() {
        return this.coordinator.getAccessControl();
    }

    public TestingGroupProviderManager getGroupProvider() {
        return this.coordinator.getGroupProvider();
    }

    public SessionPropertyDefaults getSessionPropertyDefaults() {
        return this.coordinator.getSessionPropertyDefaults();
    }

    public TestingTrinoServer getCoordinator() {
        return this.coordinator;
    }

    public List<TestingTrinoServer> getServers() {
        return ImmutableList.copyOf(this.servers);
    }

    public void installPlugin(Plugin plugin) {
        this.plugins.add(plugin);
        this.servers.forEach(server -> server.installPlugin(plugin));
    }

    public void addFunctions(FunctionBundle functionBundle) {
        this.functionBundles.add(functionBundle);
        this.servers.forEach(server -> server.addFunctions(functionBundle));
    }

    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        long start = System.nanoTime();
        this.coordinator.createCatalog(catalogName, connectorName, properties);
        this.backupCoordinator.ifPresent(backup -> backup.createCatalog(catalogName, connectorName, properties));
        log.debug("Created catalog %s in %s", new Object[]{catalogName, Duration.nanosSince((long)start)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List<QualifiedObjectName> list = this.trinoClient.listTables(session, catalog, schema);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.trinoClient.tableExists(session, table);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        return this.executeInternal(session, sql).getResult();
    }

    public QueryRunner.MaterializedResultWithPlan executeWithPlan(Session session, String sql) {
        ResultWithQueryId<MaterializedResult> result = this.executeInternal(session, sql);
        return new QueryRunner.MaterializedResultWithPlan(result.getQueryId(), this.coordinator.getQueryPlan(result.getQueryId()), result.getResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultWithQueryId<MaterializedResult> executeInternal(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            ResultWithQueryId<MaterializedResult> resultWithQueryId;
            this.spansValid = this.concurrentQueries.incrementAndGet() == 1;
            try {
                this.spanExporter.reset();
                resultWithQueryId = this.trinoClient.execute(session, sql);
                this.concurrentQueries.decrementAndGet();
            }
            catch (Throwable throwable) {
                try {
                    this.concurrentQueries.decrementAndGet();
                    throw throwable;
                }
                catch (Throwable e) {
                    e.addSuppressed(new Exception("SQL: " + sql));
                    throw e;
                }
            }
            return resultWithQueryId;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plan createPlan(Session session, String sql) {
        this.getTransactionManager().getTransactionInfo(session.getRequiredTransactionId());
        this.lock.readLock().lock();
        try {
            Plan plan;
            this.spansValid = this.concurrentQueries.incrementAndGet() == 1;
            try {
                this.spanExporter.reset();
                plan = this.coordinator.getQueryExplainer().getLogicalPlan(session, ((SqlParser)this.coordinator.getInstance(Key.get(SqlParser.class))).createStatement(sql), (List)ImmutableList.of(), WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
                this.concurrentQueries.decrementAndGet();
            }
            catch (Throwable throwable) {
                this.concurrentQueries.decrementAndGet();
                throw throwable;
            }
            return plan;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Plan getQueryPlan(QueryId queryId) {
        return (Plan)this.coordinator.getQueryPlan(queryId).orElseThrow();
    }

    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    public void injectTaskFailure(String traceToken, int stageId, int partitionId, int attemptId, FailureInjector.InjectedFailureType injectionType, Optional<ErrorType> errorType) {
        for (TestingTrinoServer server : this.servers) {
            server.injectTaskFailure(traceToken, stageId, partitionId, attemptId, injectionType, errorType);
        }
    }

    public void loadExchangeManager(String name, Map<String, String> properties) {
        for (TestingTrinoServer server : this.servers) {
            server.loadExchangeManager(name, properties);
        }
    }

    public void loadSpoolingManager(String name, Map<String, String> properties) {
        for (TestingTrinoServer server : this.servers) {
            server.loadSpoolingManager(name, properties);
        }
    }

    public final void close() {
        if (this.closed) {
            return;
        }
        this.cancelAllQueries();
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.coordinator = null;
        this.backupCoordinator = Optional.empty();
        this.registerNewWorker = map -> {
            throw new IllegalStateException("Already closed");
        };
        this.servers.clear();
        this.functionBundles.clear();
        this.plugins.clear();
        unclosedInstances.decrementAndGet();
        this.trinoClient = null;
        this.closed = true;
    }

    private void cancelAllQueries() {
        QueryManager queryManager = this.coordinator.getQueryManager();
        for (BasicQueryInfo queryInfo : queryManager.getQueries()) {
            if (queryInfo.getState().isDone()) continue;
            try {
                queryManager.cancelQuery(queryInfo.getQueryId());
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Failed to cancel query");
            }
        }
    }

    private static void closeUnchecked(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static TestingTrinoClient createClient(TestingTrinoServer testingTrinoServer, Session session, final String encoding) {
        return new TestingTrinoClient(testingTrinoServer, new TestingStatementClientFactory(){

            @Override
            public StatementClient create(OkHttpClient httpClient, Session session, ClientSession clientSession, String query) {
                ClientSession clientSessionSpooled = ClientSession.builder((ClientSession)clientSession).encoding(Optional.ofNullable(encoding)).build();
                return StatementClientFactory.newStatementClient((OkHttpClient)httpClient, (ClientSession)clientSessionSpooled, (String)query, Optional.empty());
            }
        }, session, new OkHttpClient());
    }

    private static String randomAESKey() {
        return Base64.getEncoder().encodeToString(Ciphers.createRandomAesEncryptionKey().getEncoded());
    }

    public static class Builder<SELF extends Builder<?>> {
        private Session defaultSession;
        private boolean withTracing;
        private Optional<String> exchangeType = Optional.empty();
        private Optional<Map<String, String>> exchangeProperties = Optional.empty();
        private int workerCount = 2;
        private Map<String, String> extraProperties = ImmutableMap.of();
        private Map<String, String> coordinatorProperties = ImmutableMap.of();
        private Optional<Map<String, String>> backupCoordinatorProperties = Optional.empty();
        private Consumer<QueryRunner> additionalSetup = queryRunner -> {};
        private String environment = "testing";
        private Module additionalModule = Modules.EMPTY_MODULE;
        private Optional<Path> baseDataDir = Optional.empty();
        private Optional<FactoryConfiguration> systemAccessControlConfiguration = Optional.empty();
        private Optional<List<SystemAccessControl>> systemAccessControls = Optional.empty();
        private List<EventListener> eventListeners = ImmutableList.of();
        private ImmutableList.Builder<AutoCloseable> extraCloseables = ImmutableList.builder();
        private TestingTrinoClientFactory testingTrinoClientFactory = TestingTrinoClient::new;
        private Optional<String> encoding = Optional.empty();

        protected Builder(Session defaultSession) {
            this.defaultSession = Objects.requireNonNull(defaultSession, "defaultSession is null");
            String tracingEnabled = (String)MoreObjects.firstNonNull((Object)System.getenv("TESTS_TRACING_ENABLED"), (Object)"false");
            this.withTracing = Boolean.parseBoolean(tracingEnabled) || tracingEnabled.equals("1");
        }

        @CanIgnoreReturnValue
        public SELF amendSession(Function<Session.SessionBuilder, Session.SessionBuilder> amendSession) {
            Session.SessionBuilder builder = Session.builder((Session)this.defaultSession);
            this.defaultSession = amendSession.apply(builder).build();
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setWorkerCount(int workerCount) {
            this.workerCount = workerCount;
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setExtraProperties(Map<String, String> extraProperties) {
            this.extraProperties = ImmutableMap.copyOf(extraProperties);
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF addExtraProperties(Map<String, String> extraProperties) {
            this.extraProperties = Builder.addProperties(this.extraProperties, extraProperties);
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF addExtraProperty(String key, String value) {
            this.extraProperties = Builder.addProperty(this.extraProperties, key, value);
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setCoordinatorProperties(Map<String, String> coordinatorProperties) {
            this.coordinatorProperties = ImmutableMap.copyOf(coordinatorProperties);
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF addCoordinatorProperty(String key, String value) {
            this.coordinatorProperties = Builder.addProperty(this.coordinatorProperties, key, value);
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setBackupCoordinatorProperties(Map<String, String> backupCoordinatorProperties) {
            this.backupCoordinatorProperties = Optional.of(backupCoordinatorProperties);
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setAdditionalSetup(Consumer<QueryRunner> additionalSetup) {
            this.additionalSetup = Objects.requireNonNull(additionalSetup, "additionalSetup is null");
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setEnvironment(String environment) {
            this.environment = environment;
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setAdditionalModule(Module additionalModule) {
            this.additionalModule = Objects.requireNonNull(additionalModule, "additionalModules is null");
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setBaseDataDir(Optional<Path> baseDataDir) {
            this.baseDataDir = Objects.requireNonNull(baseDataDir, "baseDataDir is null");
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setSystemAccessControl(String name, Map<String, String> configuration) {
            this.systemAccessControlConfiguration = Optional.of(new FactoryConfiguration(name, configuration));
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setSystemAccessControl(SystemAccessControl systemAccessControl) {
            return this.setSystemAccessControls((List<SystemAccessControl>)ImmutableList.of((Object)Objects.requireNonNull(systemAccessControl, "systemAccessControl is null")));
        }

        @CanIgnoreReturnValue
        public SELF setSystemAccessControls(List<SystemAccessControl> systemAccessControls) {
            this.systemAccessControls = Optional.of(ImmutableList.copyOf((Collection)Objects.requireNonNull(systemAccessControls, "systemAccessControls is null")));
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setEventListener(EventListener eventListener) {
            return this.setEventListeners((List<EventListener>)ImmutableList.of((Object)Objects.requireNonNull(eventListener, "eventListener is null")));
        }

        @CanIgnoreReturnValue
        public SELF setEventListeners(List<EventListener> eventListeners) {
            this.eventListeners = ImmutableList.copyOf((Collection)Objects.requireNonNull(eventListeners, "eventListeners is null"));
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setTestingTrinoClientFactory(TestingTrinoClientFactory testingTrinoClientFactory) {
            this.testingTrinoClientFactory = Objects.requireNonNull(testingTrinoClientFactory, "testingTrinoClientFactory is null");
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF enableBackupCoordinator() {
            if (this.backupCoordinatorProperties.isEmpty()) {
                this.setBackupCoordinatorProperties((Map<String, String>)ImmutableMap.of());
            }
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF registerResource(AutoCloseable closeable) {
            Preconditions.checkState((this.extraCloseables != null ? 1 : 0) != 0, (Object)"query runner is already built");
            this.extraCloseables.add((Object)Objects.requireNonNull(closeable, "closeable is null"));
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF registerResources(Iterable<? extends AutoCloseable> closeables) {
            closeables.forEach(this::registerResource);
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF withTracing() {
            this.withTracing = true;
            return this.self();
        }

        public SELF withExchange(String exchangeType) {
            return this.withExchange(exchangeType, Optional.empty());
        }

        public SELF withExchange(String exchangeType, Map<String, String> properties) {
            return this.withExchange(exchangeType, Optional.of(ImmutableMap.copyOf(properties)));
        }

        private SELF withExchange(String exchangeType, Optional<Map<String, String>> properties) {
            if (!exchangeType.equals("filesystem")) {
                throw new IllegalArgumentException("Unknow exchange type: " + exchangeType);
            }
            this.exchangeType = Optional.of(exchangeType);
            this.exchangeProperties = properties;
            return this.self();
        }

        public SELF withProtocolSpooling(String encoding) {
            this.encoding = Optional.of(encoding);
            return this.self();
        }

        protected SELF self() {
            return (SELF)this;
        }

        public DistributedQueryRunner build() throws Exception {
            if (this.encoding.isPresent()) {
                this.setTestingTrinoClientFactory((server, session) -> DistributedQueryRunner.createClient(server, session, this.encoding.get()));
                this.addExtraProperty("protocol.spooling.enabled", "true");
                this.addExtraProperty("protocol.spooling.initial-segment-size", "16MB");
                this.addExtraProperty("protocol.spooling.max-segment-size", "32MB");
                this.addExtraProperty("protocol.spooling.inlining.enabled", "false");
                this.addExtraProperty("protocol.spooling.shared-secret-key", DistributedQueryRunner.randomAESKey());
                this.addExtraProperty("protocol.spooling.retrieval-mode", "coordinator_proxy");
            }
            if (this.withTracing) {
                final OpenTracingCollector collector = new OpenTracingCollector();
                collector.start();
                this.extraCloseables.add((Object)collector);
                this.addExtraProperties(Map.of("tracing.enabled", "true", "tracing.exporter.endpoint", collector.getExporterEndpoint().toString(), "tracing.exporter.protocol", "http/protobuf"));
                Preconditions.checkState((boolean)this.eventListeners.isEmpty(), (Object)"eventListeners already set");
                this.setEventListener(new EventListener(){
                    {
                        Objects.requireNonNull(this$0);
                    }

                    public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
                        String queryId = queryCompletedEvent.getMetadata().getQueryId();
                        log.info("TRACING: %s :: %s", new Object[]{queryId, collector.searchForQueryId(queryId)});
                    }
                });
            }
            Optional<FactoryConfiguration> systemAccessControlConfiguration = this.systemAccessControlConfiguration;
            Optional<List<SystemAccessControl>> systemAccessControls = this.systemAccessControls;
            if (systemAccessControlConfiguration.isEmpty() && systemAccessControls.isEmpty()) {
                systemAccessControls = Optional.of(ImmutableList.of());
            }
            DistributedQueryRunner queryRunner = new DistributedQueryRunner(this.defaultSession, this.workerCount, this.extraProperties, this.coordinatorProperties, this.backupCoordinatorProperties, this.environment, this.additionalModule, this.baseDataDir, systemAccessControlConfiguration, systemAccessControls, this.eventListeners, (List<AutoCloseable>)this.extraCloseables.build(), this.testingTrinoClientFactory);
            this.extraCloseables = null;
            try {
                if (this.encoding.isPresent()) {
                    queryRunner.installPlugin(new LocalSpoolingManager.LocalSpoolingPlugin());
                    queryRunner.loadSpoolingManager("test-local", Map.of());
                }
                if (this.exchangeType.isPresent()) {
                    switch (this.exchangeType.get()) {
                        case "filesystem": {
                            queryRunner.installPlugin((Plugin)new FileSystemExchangePlugin());
                            Map<String, String> properties = this.exchangeProperties.orElse((Map<String, String>)ImmutableMap.of((Object)"exchange.base-directories", (Object)(System.getProperty("java.io.tmpdir") + "/trino-local-file-system-exchange-manager")));
                            queryRunner.loadExchangeManager("filesystem", properties);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknow exchange type: " + String.valueOf(this.exchangeType));
                        }
                    }
                }
                this.additionalSetup.accept(queryRunner);
            }
            catch (Throwable e) {
                Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
                throw e;
            }
            ((ConnectorServicesProvider)queryRunner.getCoordinator().getInstance(Key.get(ConnectorServicesProvider.class))).loadInitialCatalogs();
            return queryRunner;
        }

        protected static Map<String, String> addProperties(Map<String, String> properties, Map<String, String> update) {
            return ImmutableMap.builder().putAll(Objects.requireNonNull(properties, "properties is null")).putAll(Objects.requireNonNull(update, "update is null")).buildOrThrow();
        }

        protected static Map<String, String> addProperty(Map<String, String> extraProperties, String key, String value) {
            return ImmutableMap.builder().putAll(Objects.requireNonNull(extraProperties, "properties is null")).put((Object)Objects.requireNonNull(key, "key is null"), (Object)Objects.requireNonNull(value, "value is null")).buildOrThrow();
        }
    }

    public static interface TestingTrinoClientFactory {
        public TestingTrinoClient create(TestingTrinoServer var1, Session var2);
    }
}

