/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.trino.connector.MockConnectorFactory;
import io.trino.plugin.base.util.AutoCloseableCloser;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.tracing.TracingConnectorMetadata;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class CountingMockConnector
implements AutoCloseable {
    private final Object lock = new Object();
    private final Set<String> tablesTestSchema1 = (Set)IntStream.range(0, 1000).mapToObj(i -> "test_table" + i).collect(ImmutableSet.toImmutableSet());
    private final Set<String> tablesTestSchema2 = (Set)IntStream.range(0, 2000).mapToObj(i -> "test_table" + i).collect(ImmutableSet.toImmutableSet());
    private final Set<RoleGrant> roleGrants = (Set)IntStream.range(0, 100).mapToObj(i -> new RoleGrant(new TrinoPrincipal(PrincipalType.USER, "user" + String.valueOf(i == 0 ? "" : Integer.valueOf(i))), "role" + i / 2, false)).collect(ImmutableSet.toImmutableSet());
    private final AutoCloseableCloser closer = AutoCloseableCloser.create();
    private final InMemorySpanExporter spanExporter = (InMemorySpanExporter)this.closer.register((AutoCloseable)InMemorySpanExporter.create());
    private final SdkTracerProvider tracerProvider = (SdkTracerProvider)this.closer.register((AutoCloseable)SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)this.spanExporter)).build());

    @Override
    public void close() throws Exception {
        this.closer.close();
    }

    public Plugin getPlugin() {
        return new Plugin(this){
            final /* synthetic */ CountingMockConnector this$0;
            {
                CountingMockConnector countingMockConnector = this$0;
                Objects.requireNonNull(countingMockConnector);
                this.this$0 = countingMockConnector;
            }

            public Iterable<ConnectorFactory> getConnectorFactories() {
                return ImmutableList.of((Object)this.this$0.getConnectorFactory());
            }
        };
    }

    public Stream<SchemaTableName> getAllTables() {
        return Stream.concat(this.tablesTestSchema1.stream().map(tableName -> new SchemaTableName("test_schema1", tableName)), this.tablesTestSchema2.stream().map(tableName -> new SchemaTableName("test_schema2", tableName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Multiset<String> runTracing(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            this.spanExporter.reset();
            runnable.run();
            return (Multiset)this.spanExporter.getFinishedSpanItems().stream().map(span -> {
                String attributes = span.getAttributes().asMap().entrySet().stream().map(entry -> Map.entry(((AttributeKey)entry.getKey()).getKey(), entry.getValue())).filter(entry -> !((String)entry.getKey()).equals("trino.catalog")).map(entry -> "%s=%s".formatted(((String)entry.getKey()).replaceFirst("^trino\\.", ""), entry.getValue())).sorted().collect(Collectors.joining(", "));
                if (attributes.isEmpty()) {
                    return span.getName();
                }
                return "%s(%s)".formatted(span.getName(), attributes);
            }).collect(ImmutableMultiset.toImmutableMultiset());
        }
    }

    private ConnectorFactory getConnectorFactory() {
        MockConnectorFactory mockConnectorFactory = MockConnectorFactory.builder().withMetadataWrapper(connectorMetadata -> new TracingConnectorMetadata(this.tracerProvider.get("test"), "mock", connectorMetadata)).withListSchemaNames(connectorSession -> ImmutableList.of((Object)"test_schema1", (Object)"test_schema2", (Object)"test_schema3_empty", (Object)"test_schema4_empty")).withListTables((connectorSession, schemaName) -> {
            if (schemaName.equals("test_schema1")) {
                return ImmutableList.copyOf(this.tablesTestSchema1);
            }
            if (schemaName.equals("test_schema2")) {
                return ImmutableList.copyOf(this.tablesTestSchema2);
            }
            return ImmutableList.of();
        }).withGetTableHandle((connectorSession, schemaTableName) -> {
            switch (schemaTableName.getSchemaName()) {
                case "test_schema1": {
                    if (this.tablesTestSchema1.contains(schemaTableName.getTableName())) break;
                    return null;
                }
                case "test_schema2": {
                    if (this.tablesTestSchema2.contains(schemaTableName.getTableName())) break;
                    return null;
                }
                default: {
                    return null;
                }
            }
            return (ConnectorTableHandle)MockConnectorFactory.Builder.defaultGetTableHandle().apply(connectorSession, schemaTableName);
        }).withGetColumns(schemaTableName -> (List)MockConnectorFactory.Builder.defaultGetColumns().apply(schemaTableName)).withGetComment(schemaTableName -> Optional.of("comment for " + String.valueOf(schemaTableName))).withListRoleGrants((connectorSession, roles, grantees, limit) -> this.roleGrants).build();
        return mockConnectorFactory;
    }
}

