/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.client.FailureException;
import io.trino.metadata.QualifiedObjectName;
import io.trino.spi.QueryId;
import io.trino.spi.TrinoException;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.planner.Plan;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.H2QueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryFailedException;
import io.trino.testing.QueryRunner;
import io.trino.testing.assertions.Assert;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.intellij.lang.annotations.Language;

public final class QueryAssertions {
    private static final Logger log = Logger.get(QueryAssertions.class);

    private QueryAssertions() {
    }

    public static void assertUpdate(QueryRunner queryRunner, Session session, @Language(value="SQL") String sql, OptionalLong count, Optional<Consumer<Plan>> planAssertion) {
        MaterializedResult results;
        Plan queryPlan;
        if (queryRunner instanceof DistributedQueryRunner) {
            DistributedQueryRunner distributedQueryRunner = (DistributedQueryRunner)queryRunner;
            QueryAssertions.assertDistributedUpdate(distributedQueryRunner, session, sql, count, planAssertion);
            return;
        }
        long start = System.nanoTime();
        if (planAssertion.isPresent()) {
            QueryRunner.MaterializedResultWithPlan resultWithPlan = queryRunner.executeWithPlan(session, sql);
            queryPlan = (Plan)resultWithPlan.queryPlan().orElseThrow();
            results = resultWithPlan.result().toTestTypes();
        } else {
            queryPlan = null;
            results = queryRunner.execute(session, sql);
        }
        Duration queryTime = Duration.nanosSince((long)start);
        if (queryTime.compareTo(Duration.succinctDuration((double)1.0, (TimeUnit)TimeUnit.SECONDS)) > 0) {
            log.debug("FINISHED in Trino: %s", new Object[]{queryTime});
        }
        if (planAssertion.isPresent()) {
            planAssertion.get().accept(queryPlan);
        }
        if (results.getUpdateType().isEmpty()) {
            Fail.fail((String)"update type is not set");
        }
        if (results.getUpdateCount().isPresent()) {
            if (count.isEmpty()) {
                Fail.fail((String)("expected no update count, but got " + results.getUpdateCount().getAsLong()));
            }
            ((AbstractLongAssert)Assertions.assertThat((long)results.getUpdateCount().getAsLong()).describedAs("update count", new Object[0])).isEqualTo(count.getAsLong());
        } else if (count.isPresent()) {
            Fail.fail((String)"update count is not present");
        }
    }

    private static void assertDistributedUpdate(DistributedQueryRunner distributedQueryRunner, Session session, @Language(value="SQL") String sql, OptionalLong count, Optional<Consumer<Plan>> planAssertion) {
        Duration queryTime;
        long start = System.nanoTime();
        Plan queryPlan = null;
        QueryRunner.MaterializedResultWithPlan resultWithPlan = distributedQueryRunner.executeWithPlan(session, sql);
        QueryId queryId = resultWithPlan.queryId();
        MaterializedResult results = resultWithPlan.result().toTestTypes();
        if (planAssertion.isPresent()) {
            try {
                queryPlan = distributedQueryRunner.getQueryPlan(queryId);
            }
            catch (RuntimeException e) {
                Fail.fail((String)("Failed to get query plan for query " + String.valueOf(queryId)), (Throwable)e);
            }
        }
        if ((queryTime = Duration.nanosSince((long)start)).compareTo(Duration.succinctDuration((double)1.0, (TimeUnit)TimeUnit.SECONDS)) > 0) {
            log.debug("FINISHED query %s in Trino: %s", new Object[]{queryId, queryTime});
        }
        if (planAssertion.isPresent()) {
            try {
                planAssertion.get().accept(queryPlan);
            }
            catch (Exception e) {
                Fail.fail((String)("Plan assertion failed for query " + String.valueOf(queryId)), (Throwable)e);
            }
        }
        if (results.getUpdateType().isEmpty()) {
            Fail.fail((String)("update type is not set for query " + String.valueOf(queryId)));
        }
        if (results.getUpdateCount().isPresent()) {
            if (count.isEmpty()) {
                Fail.fail((String)("expected no update count, but got " + results.getUpdateCount().getAsLong() + " for query " + String.valueOf(queryId)));
            }
            ((AbstractLongAssert)Assertions.assertThat((long)results.getUpdateCount().getAsLong()).describedAs("update count for query " + String.valueOf(queryId), new Object[0])).isEqualTo(count.getAsLong());
        } else if (count.isPresent()) {
            Fail.fail((String)("update count is not present for query " + String.valueOf(queryId)));
        }
    }

    public static void assertQuery(QueryRunner actualQueryRunner, Session session, @Language(value="SQL") String actual, H2QueryRunner h2QueryRunner, @Language(value="SQL") String expected, boolean ensureOrdering, boolean compareUpdate) {
        QueryAssertions.assertQuery(actualQueryRunner, session, actual, h2QueryRunner, expected, ensureOrdering, compareUpdate, Optional.empty());
    }

    public static void assertQuery(QueryRunner actualQueryRunner, Session session, @Language(value="SQL") String actual, H2QueryRunner h2QueryRunner, @Language(value="SQL") String expected, boolean ensureOrdering, boolean compareUpdate, Consumer<Plan> planAssertion) {
        QueryAssertions.assertQuery(actualQueryRunner, session, actual, h2QueryRunner, expected, ensureOrdering, compareUpdate, Optional.of(planAssertion));
    }

    private static void assertQuery(QueryRunner actualQueryRunner, Session session, @Language(value="SQL") String actual, H2QueryRunner h2QueryRunner, @Language(value="SQL") String expected, boolean ensureOrdering, boolean compareUpdate, Optional<Consumer<Plan>> planAssertion) {
        if (actualQueryRunner instanceof DistributedQueryRunner) {
            DistributedQueryRunner distributedQueryRunner = (DistributedQueryRunner)actualQueryRunner;
            QueryAssertions.assertDistributedQuery(distributedQueryRunner, session, actual, h2QueryRunner, expected, ensureOrdering, compareUpdate, planAssertion);
            return;
        }
        long start = System.nanoTime();
        MaterializedResult actualResults = null;
        Plan queryPlan = null;
        if (planAssertion.isPresent()) {
            try {
                QueryRunner.MaterializedResultWithPlan resultWithPlan = actualQueryRunner.executeWithPlan(session, actual);
                queryPlan = (Plan)resultWithPlan.queryPlan().orElseThrow();
                actualResults = resultWithPlan.result().toTestTypes();
            }
            catch (RuntimeException ex) {
                Fail.fail((String)("Execution of 'actual' query failed: " + actual), (Throwable)ex);
            }
        } else {
            try {
                actualResults = actualQueryRunner.execute(session, actual).toTestTypes();
            }
            catch (RuntimeException ex) {
                Fail.fail((String)("Execution of 'actual' query failed: " + actual), (Throwable)ex);
            }
        }
        if (planAssertion.isPresent()) {
            planAssertion.get().accept(queryPlan);
        }
        Duration actualTime = Duration.nanosSince((long)start);
        long expectedStart = System.nanoTime();
        MaterializedResult expectedResults = null;
        try {
            expectedResults = h2QueryRunner.execute(session, expected, actualResults.getTypes());
        }
        catch (RuntimeException ex) {
            Fail.fail((String)("Execution of 'expected' query failed: " + expected), (Throwable)ex);
        }
        Duration totalTime = Duration.nanosSince((long)start);
        if (totalTime.compareTo(Duration.succinctDuration((double)1.0, (TimeUnit)TimeUnit.SECONDS)) > 0) {
            log.debug("FINISHED in Trino: %s, H2: %s, total: %s", new Object[]{actualTime, Duration.nanosSince((long)expectedStart), totalTime});
        }
        if (actualResults.getUpdateType().isPresent() || actualResults.getUpdateCount().isPresent()) {
            if (actualResults.getUpdateType().isEmpty()) {
                Fail.fail((String)("update count present without update type for query: \n" + actual));
            }
            if (!compareUpdate) {
                Fail.fail((String)("update type should not be present (use assertUpdate) for query: \n" + actual));
            }
        }
        List actualRows = actualResults.getMaterializedRows();
        List expectedRows = expectedResults.getMaterializedRows();
        if (compareUpdate) {
            if (actualResults.getUpdateType().isEmpty()) {
                Fail.fail((String)("update type not present for query: \n" + actual));
            }
            if (actualResults.getUpdateCount().isEmpty()) {
                Fail.fail((String)("update count not present for query: \n" + actual));
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)actualRows.size()).describedAs("For query: \n " + actual + "\n:", new Object[0])).isEqualTo(1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)expectedRows.size()).describedAs("For query: \n " + actual + "\n:", new Object[0])).isEqualTo(1);
            MaterializedRow row = (MaterializedRow)expectedRows.get(0);
            ((AbstractIntegerAssert)Assertions.assertThat((int)row.getFieldCount()).describedAs("For query: \n " + actual + "\n:", new Object[0])).isEqualTo(1);
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(0)).describedAs("For query: \n " + actual + "\n:", new Object[0])).isEqualTo((Object)actualResults.getUpdateCount().getAsLong());
        }
        if (ensureOrdering) {
            if (!actualRows.equals(expectedRows)) {
                ((ListAssert)Assertions.assertThat((List)actualRows).describedAs("For query: \n " + actual + "\n:", new Object[0])).isEqualTo((Object)expectedRows);
            }
        } else {
            QueryAssertions.assertEqualsIgnoreOrder(actualRows, expectedRows, "For query: \n " + actual);
        }
    }

    private static void assertDistributedQuery(DistributedQueryRunner distributedQueryRunner, Session session, @Language(value="SQL") String actual, H2QueryRunner h2QueryRunner, @Language(value="SQL") String expected, boolean ensureOrdering, boolean compareUpdate, Optional<Consumer<Plan>> planAssertion) {
        long start = System.nanoTime();
        QueryId queryId = null;
        MaterializedResult actualResults = null;
        try {
            QueryRunner.MaterializedResultWithPlan resultWithPlan = distributedQueryRunner.executeWithPlan(session, actual);
            queryId = resultWithPlan.queryId();
            actualResults = resultWithPlan.result().toTestTypes();
        }
        catch (RuntimeException ex) {
            if (queryId == null && ex instanceof QueryFailedException) {
                QueryFailedException queryFailedException = (QueryFailedException)((Object)ex);
                queryId = queryFailedException.getQueryId();
            }
            if (queryId != null) {
                Fail.fail((String)("Execution of 'actual' query " + String.valueOf(queryId) + " failed: " + actual), (Throwable)ex);
            }
            Fail.fail((String)("Execution of 'actual' query failed: " + actual), (Throwable)ex);
        }
        if (planAssertion.isPresent()) {
            try {
                planAssertion.get().accept(distributedQueryRunner.getQueryPlan(queryId));
            }
            catch (Throwable t) {
                t.addSuppressed(new Exception(String.format("SQL: %s [QueryId: %s]", actual, queryId)));
                throw t;
            }
        }
        Duration actualTime = Duration.nanosSince((long)start);
        long expectedStart = System.nanoTime();
        MaterializedResult expectedResults = null;
        try {
            expectedResults = h2QueryRunner.execute(session, expected, actualResults.getTypes());
        }
        catch (RuntimeException ex) {
            Fail.fail((String)("Execution of 'expected' query failed: " + expected), (Throwable)ex);
        }
        Duration totalTime = Duration.nanosSince((long)start);
        if (totalTime.compareTo(Duration.succinctDuration((double)1.0, (TimeUnit)TimeUnit.SECONDS)) > 0) {
            log.debug("FINISHED in Trino: %s, H2: %s, total: %s", new Object[]{actualTime, Duration.nanosSince((long)expectedStart), totalTime});
        }
        if (actualResults.getUpdateType().isPresent() || actualResults.getUpdateCount().isPresent()) {
            if (actualResults.getUpdateType().isEmpty()) {
                Fail.fail((String)("update count present without update type for query " + String.valueOf(queryId) + ": \n" + actual));
            }
            if (!compareUpdate) {
                Fail.fail((String)("update type should not be present (use assertUpdate) for query " + String.valueOf(queryId) + ": \n" + actual));
            }
        }
        List actualRows = actualResults.getMaterializedRows();
        List expectedRows = expectedResults.getMaterializedRows();
        if (compareUpdate && !actualResults.getUpdateType().equals(Optional.of("ALTER TABLE EXECUTE"))) {
            if (actualResults.getUpdateType().isEmpty()) {
                Fail.fail((String)("update type not present for query " + String.valueOf(queryId) + ": \n" + actual));
            }
            if (actualResults.getUpdateCount().isEmpty()) {
                Fail.fail((String)("update count not present for query " + String.valueOf(queryId) + ": \n" + actual));
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)actualRows.size()).describedAs("For query " + String.valueOf(queryId) + ": \n " + actual + "\n:", new Object[0])).isEqualTo(1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)expectedRows.size()).describedAs("For query " + String.valueOf(queryId) + ": \n " + actual + "\n:", new Object[0])).isEqualTo(1);
            MaterializedRow row = (MaterializedRow)expectedRows.get(0);
            ((AbstractIntegerAssert)Assertions.assertThat((int)row.getFieldCount()).describedAs("For query " + String.valueOf(queryId) + ": \n " + actual + "\n:", new Object[0])).isEqualTo(1);
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(0)).describedAs("For query " + String.valueOf(queryId) + ": \n " + actual + "\n:", new Object[0])).isEqualTo((Object)actualResults.getUpdateCount().getAsLong());
        }
        if (ensureOrdering) {
            if (!actualRows.equals(expectedRows)) {
                ((ListAssert)Assertions.assertThat((List)actualRows).describedAs("For query " + String.valueOf(queryId) + ": \n " + actual + "\n:", new Object[0])).isEqualTo((Object)expectedRows);
            }
        } else {
            QueryAssertions.assertEqualsIgnoreOrder(actualRows, expectedRows, "For query " + String.valueOf(queryId) + ": \n " + actual);
        }
    }

    public static void assertQueryEventually(QueryRunner actualQueryRunner, Session session, @Language(value="SQL") String actual, H2QueryRunner h2QueryRunner, @Language(value="SQL") String expected, boolean ensureOrdering, boolean compareUpdate, Optional<Consumer<Plan>> planAssertion, Duration timeout) {
        Assert.assertEventually((Duration)timeout, () -> QueryAssertions.assertQuery(actualQueryRunner, session, actual, h2QueryRunner, expected, ensureOrdering, compareUpdate, planAssertion));
    }

    public static void assertEqualsIgnoreOrder(Iterable<?> actual, Iterable<?> expected) {
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected, null);
    }

    public static void assertEqualsIgnoreOrder(Iterable<?> actual, Iterable<?> expected, String message) {
        ((IterableAssert)Assertions.assertThat(actual).describedAs("actual is null", new Object[0])).isNotNull();
        ((IterableAssert)Assertions.assertThat(expected).describedAs("expected is null", new Object[0])).isNotNull();
        ImmutableMultiset actualSet = ImmutableMultiset.copyOf(actual);
        ImmutableMultiset expectedSet = ImmutableMultiset.copyOf(expected);
        if (!actualSet.equals((Object)expectedSet)) {
            Multiset unexpectedRows = Multisets.difference((Multiset)actualSet, (Multiset)expectedSet);
            Multiset missingRows = Multisets.difference((Multiset)expectedSet, (Multiset)actualSet);
            int limit = 100;
            Fail.fail((String)String.format("%snot equal\nActual rows (up to %s of %s extra rows shown, %s rows in total):\n    %s\nExpected rows (up to %s of %s missing rows shown, %s rows in total):\n    %s\n", message == null ? "" : message + "\n", limit, unexpectedRows.size(), actualSet.size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)unexpectedRows, (int)limit)), limit, missingRows.size(), expectedSet.size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)missingRows, (int)limit))));
        }
    }

    public static void assertContainsEventually(Supplier<MaterializedResult> all, MaterializedResult expectedSubset, Duration timeout) {
        Assert.assertEventually((Duration)timeout, () -> QueryAssertions.assertContains((MaterializedResult)all.get(), expectedSubset));
    }

    public static void assertContains(MaterializedResult all, MaterializedResult expectedSubset) {
        for (MaterializedRow row : expectedSubset.getMaterializedRows()) {
            if (all.getMaterializedRows().contains(row)) continue;
            Fail.fail((String)String.format("expected row missing: %s\nAll %s rows:\n    %s\nExpected subset %s rows:\n    %s\n", row, all.getMaterializedRows().size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)all, (int)100)), expectedSubset.getMaterializedRows().size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)expectedSubset, (int)100))));
        }
    }

    protected static void assertQuerySucceeds(QueryRunner queryRunner, Session session, @Language(value="SQL") String sql) {
        try {
            queryRunner.execute(session, sql);
        }
        catch (QueryFailedException e) {
            Fail.fail((String)String.format("Expected query %s to succeed: %s", e.getQueryId(), sql), (Throwable)e);
        }
        catch (RuntimeException e) {
            Fail.fail((String)String.format("Expected query to succeed: %s", sql), (Throwable)e);
        }
    }

    protected static void assertQueryFailsEventually(QueryRunner queryRunner, Session session, @Language(value="SQL") String sql, @Language(value="RegExp") String expectedMessageRegExp, Duration timeout) {
        Assert.assertEventually((Duration)timeout, () -> QueryAssertions.assertQueryFails(queryRunner, session, sql, expectedMessageRegExp));
    }

    public static void assertQueryFails(QueryRunner queryRunner, Session session, @Language(value="SQL") String sql, @Language(value="RegExp") String expectedMessageRegExp) {
        try {
            QueryRunner.MaterializedResultWithPlan resultWithPlan = queryRunner.executeWithPlan(session, sql);
            Fail.fail((String)String.format("Expected query to fail: %s [QueryId: %s]", sql, resultWithPlan.queryId()));
        }
        catch (RuntimeException exception) {
            exception.addSuppressed(new Exception("Query: " + sql));
            TrinoExceptionAssert.assertThatTrinoException((Throwable)exception).hasMessageMatching(expectedMessageRegExp);
        }
    }

    public static void assertQueryReturnsEmptyResult(QueryRunner queryRunner, Session session, @Language(value="SQL") String sql) {
        QueryId queryId = null;
        try {
            QueryRunner.MaterializedResultWithPlan resultWithPlan = queryRunner.executeWithPlan(session, sql);
            queryId = resultWithPlan.queryId();
            MaterializedResult results = resultWithPlan.result().toTestTypes();
            Assertions.assertThat((Iterable)results).isNotNull();
            Assertions.assertThat((int)results.getRowCount()).isEqualTo(0);
        }
        catch (RuntimeException ex) {
            if (queryId == null) {
                Fail.fail((String)("Execution of query failed: " + sql), (Throwable)ex);
            }
            Fail.fail((String)String.format("Execution of query failed: %s [QueryId: %s]", sql, queryId), (Throwable)ex);
        }
    }

    public static void copyTpchTables(QueryRunner queryRunner, String sourceCatalog, String sourceSchema, Iterable<TpchTable<?>> tables) {
        QueryAssertions.copyTpchTables(queryRunner, sourceCatalog, sourceSchema, queryRunner.getDefaultSession(), tables);
    }

    public static void copyTpchTables(QueryRunner queryRunner, String sourceCatalog, String sourceSchema, Session session, Iterable<TpchTable<?>> tables) {
        for (TpchTable<?> table : tables) {
            QueryAssertions.copyTable(queryRunner, sourceCatalog, sourceSchema, table.getTableName().toLowerCase(Locale.ENGLISH), session);
        }
    }

    public static void copyTable(QueryRunner queryRunner, String sourceCatalog, String sourceSchema, String sourceTable, Session session) {
        QualifiedObjectName table = new QualifiedObjectName(sourceCatalog, sourceSchema, sourceTable);
        QueryAssertions.copyTable(queryRunner, table, session);
    }

    public static void copyTable(QueryRunner queryRunner, QualifiedObjectName table, Session session) {
        long start = System.nanoTime();
        String sql = String.format("CREATE TABLE IF NOT EXISTS %s AS SELECT * FROM %s", table.objectName(), table);
        long rows = (Long)((MaterializedRow)queryRunner.execute(session, sql).getMaterializedRows().get(0)).getField(0);
        log.debug("Imported %s rows from %s in %s", new Object[]{rows, table, Duration.nanosSince((long)start)});
        ((ObjectAssert)Assertions.assertThat((Object)queryRunner.execute(session, "SELECT count(*) FROM " + table.objectName()).getOnlyValue()).as("Table is not loaded properly: %s", new Object[]{table.objectName()})).isEqualTo(queryRunner.execute(session, "SELECT count(*) FROM " + String.valueOf(table)).getOnlyValue());
    }

    public static RuntimeException getTrinoExceptionCause(Throwable e) {
        return Throwables.getCausalChain((Throwable)e).stream().filter(QueryAssertions::isTrinoException).findFirst().map(RuntimeException.class::cast).orElseThrow(() -> new IllegalArgumentException("Exception does not have TrinoException cause", e));
    }

    private static boolean isTrinoException(Throwable exception) {
        Objects.requireNonNull(exception, "exception is null");
        if (exception instanceof TrinoException || exception instanceof ParsingException) {
            return true;
        }
        if (exception instanceof FailureException) {
            FailureException failureException = (FailureException)exception;
            String type = failureException.getFailureInfo().getType();
            return type.equals(TrinoException.class.getName()) || type.equals(ParsingException.class.getName());
        }
        return false;
    }
}

