/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.errorprone.annotations.DoNotCall;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.Plugin;
import io.trino.spi.spool.SpooledLocation;
import io.trino.spi.spool.SpooledSegmentHandle;
import io.trino.spi.spool.SpoolingContext;
import io.trino.spi.spool.SpoolingManager;
import io.trino.spi.spool.SpoolingManagerContext;
import io.trino.spi.spool.SpoolingManagerFactory;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class LocalSpoolingManager
implements SpoolingManager {
    private static final JsonCodec<LocalSpooledSegmentHandle> HANDLE_CODEC = JsonCodec.jsonCodec(LocalSpooledSegmentHandle.class);
    private final Path rootPath;
    private final AtomicLong segmentId = new AtomicLong();

    public LocalSpoolingManager() {
        try {
            this.rootPath = Files.createTempDirectory("spooling", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public SpooledSegmentHandle create(SpoolingContext context) {
        return new LocalSpooledSegmentHandle(context.encoding(), this.rootPath.resolve(this.segmentId.incrementAndGet() + "-" + String.valueOf(UUID.randomUUID()) + "." + context.encoding()));
    }

    public OutputStream createOutputStream(SpooledSegmentHandle handle) throws IOException {
        LocalSpooledSegmentHandle localHandle = (LocalSpooledSegmentHandle)handle;
        return Files.newOutputStream(localHandle.getPath(), StandardOpenOption.CREATE_NEW);
    }

    public InputStream openInputStream(SpooledSegmentHandle handle) throws IOException {
        LocalSpooledSegmentHandle localHandle = (LocalSpooledSegmentHandle)handle;
        if (!Files.exists(localHandle.getPath(), new LinkOption[0])) {
            throw new IOException("Segment not found or expired");
        }
        return Files.newInputStream(localHandle.getPath(), new OpenOption[0]);
    }

    public SpooledSegmentHandle handle(Slice identifier, Map<String, List<String>> headers) {
        return (SpooledSegmentHandle)HANDLE_CODEC.fromJson(identifier.toStringUtf8());
    }

    public SpooledLocation location(SpooledSegmentHandle handle) {
        LocalSpooledSegmentHandle localHandle = (LocalSpooledSegmentHandle)handle;
        return SpooledLocation.coordinatorLocation((Slice)Slices.utf8Slice((String)HANDLE_CODEC.toJson((Object)localHandle)), Map.of());
    }

    public void acknowledge(SpooledSegmentHandle handle) throws IOException {
        LocalSpooledSegmentHandle localHandle = (LocalSpooledSegmentHandle)handle;
        if (!Files.exists(localHandle.getPath(), new LinkOption[0])) {
            throw new IOException("Segment not found or expired");
        }
        Files.delete(localHandle.getPath());
    }

    public Optional<SpooledLocation.DirectLocation> directLocation(SpooledSegmentHandle handle) {
        throw new UnsupportedOperationException();
    }

    @PreDestroy
    public void close() {
        try {
            MoreFiles.deleteRecursively((Path)this.rootPath, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class LocalSpooledSegmentHandle
    implements SpooledSegmentHandle {
        private final String encoding;
        private final Path path;

        public LocalSpooledSegmentHandle(String encoding, Path path) {
            this.encoding = Objects.requireNonNull(encoding, "encoding is null");
            this.path = Objects.requireNonNull(path, "path is null");
        }

        @JsonIgnore
        public Instant expirationTime() {
            return Instant.MAX;
        }

        @JsonIgnore
        public String identifier() {
            return this.path.getFileName().toString();
        }

        @JsonProperty
        public String encoding() {
            return this.encoding;
        }

        @JsonIgnore
        public Path getPath() {
            return this.path;
        }

        @JsonProperty(value="path")
        public String getFilePath() {
            return this.path.toAbsolutePath().toString();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("encoding", (Object)this.encoding).add("path", (Object)this.path).toString();
        }

        @JsonCreator
        @DoNotCall
        public static LocalSpooledSegmentHandle create(@JsonProperty(value="encoding") String encoding, @JsonProperty(value="path") String path) {
            return new LocalSpooledSegmentHandle(encoding, Paths.get(path, new String[0]));
        }
    }

    public static class LocalSpoolingFactory
    implements SpoolingManagerFactory {
        public String getName() {
            return "test-local";
        }

        public SpoolingManager create(Map<String, String> config, SpoolingManagerContext context) {
            return new LocalSpoolingManager();
        }
    }

    public static class LocalSpoolingPlugin
    implements Plugin {
        public Iterable<SpoolingManagerFactory> getSpoolingManagerFactories() {
            return List.of(new LocalSpoolingFactory());
        }
    }
}

