/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.tpch;

import io.trino.spi.connector.ConnectorIndex;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.RecordPageSource;
import io.trino.spi.connector.RecordSet;
import io.trino.testing.tpch.TpchIndexedData;
import java.util.Objects;
import java.util.function.Function;

class TpchConnectorIndex
implements ConnectorIndex {
    private final Function<RecordSet, RecordSet> keyFormatter;
    private final Function<RecordSet, RecordSet> outputFormatter;
    private final TpchIndexedData.IndexedTable indexedTable;

    public TpchConnectorIndex(Function<RecordSet, RecordSet> keyFormatter, Function<RecordSet, RecordSet> outputFormatter, TpchIndexedData.IndexedTable indexedTable) {
        this.keyFormatter = Objects.requireNonNull(keyFormatter, "keyFormatter is null");
        this.outputFormatter = Objects.requireNonNull(outputFormatter, "outputFormatter is null");
        this.indexedTable = Objects.requireNonNull(indexedTable, "indexedTable is null");
    }

    public ConnectorPageSource lookup(RecordSet rawInputRecordSet) {
        RecordSet inputRecordSet = this.keyFormatter.apply(rawInputRecordSet);
        RecordSet rawOutputRecordSet = this.indexedTable.lookupKeys(inputRecordSet);
        return new RecordPageSource(this.outputFormatter.apply(rawOutputRecordSet));
    }
}

