/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import io.trino.Session;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.testing.LocalQueryRunner;
import java.util.function.Function;
import org.testng.Assert;

public class PlanDeterminismChecker {
    private static final int MINIMUM_SUBSEQUENT_SAME_PLANS = 10;
    private final LocalQueryRunner localQueryRunner;
    private final Function<String, String> planEquivalenceFunction;

    public PlanDeterminismChecker(LocalQueryRunner localQueryRunner) {
        this(localQueryRunner, Function.identity());
    }

    public PlanDeterminismChecker(LocalQueryRunner localQueryRunner, Function<String, String> planEquivalenceFunction) {
        this.localQueryRunner = localQueryRunner;
        this.planEquivalenceFunction = planEquivalenceFunction;
    }

    public void checkPlanIsDeterministic(String sql) {
        this.checkPlanIsDeterministic(this.localQueryRunner.getDefaultSession(), sql);
    }

    public void checkPlanIsDeterministic(Session session, String sql) {
        String previous = this.planEquivalenceFunction.apply(this.getPlanText(session, sql));
        for (int attempt = 1; attempt < 10; ++attempt) {
            String current = this.planEquivalenceFunction.apply(this.getPlanText(session, sql));
            Assert.assertEquals((String)previous, (String)current);
        }
    }

    private String getPlanText(Session session, String sql) {
        return (String)this.localQueryRunner.inTransaction(session, transactionSession -> {
            Plan plan = this.localQueryRunner.createPlan(transactionSession, sql, this.localQueryRunner.getPlanOptimizers(true), LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
            return PlanPrinter.textLogicalPlan((PlanNode)plan.getRoot(), (TypeProvider)plan.getTypes(), (Metadata)this.localQueryRunner.getMetadata(), (FunctionManager)this.localQueryRunner.getFunctionManager(), (StatsAndCosts)plan.getStatsAndCosts(), (Session)transactionSession, (int)0, (boolean)false);
        });
    }
}

