/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.execution.FailureInjector;
import io.trino.operator.RetryPolicy;
import io.trino.server.DynamicFilterService;
import io.trino.spi.ErrorType;
import io.trino.spi.QueryId;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.testing.BaseFailureRecoveryTest;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;

public abstract class ExtendedFailureRecoveryTest
extends BaseFailureRecoveryTest {
    private static final String PARTITIONED_LINEITEM = "partitioned_lineitem";

    protected ExtendedFailureRecoveryTest(RetryPolicy retryPolicy) {
        super(retryPolicy);
    }

    @BeforeClass
    public void initTables() throws Exception {
        this.createPartitionedLineitemTable(PARTITIONED_LINEITEM, (List<String>)ImmutableList.of((Object)"orderkey", (Object)"partkey", (Object)"suppkey"), "suppkey");
    }

    protected abstract void createPartitionedLineitemTable(String var1, List<String> var2, String var3);

    @Override
    @DataProvider(name="parallelTests", parallel=true)
    public Object[][] parallelTests() {
        return this.moreParallelTests(super.parallelTests(), this.parallelTest("testSimpleSelect", this::testSimpleSelect), this.parallelTest("testAggregation", this::testAggregation), this.parallelTest("testJoinDynamicFilteringDisabled", this::testJoinDynamicFilteringDisabled), this.parallelTest("testJoinDynamicFilteringEnabled", this::testJoinDynamicFilteringEnabled), this.parallelTest("testUserFailure", this::testUserFailure));
    }

    protected void testSimpleSelect() {
        this.testSelect("SELECT * FROM nation");
    }

    protected void testAggregation() {
        this.testSelect("SELECT orderStatus, count(*) FROM orders GROUP BY orderStatus");
    }

    protected void testJoinDynamicFilteringDisabled() {
        String selectQuery = "SELECT * FROM partitioned_lineitem JOIN supplier ON partitioned_lineitem.suppkey = supplier.suppkey AND supplier.name = 'Supplier#000000001'";
        this.testSelect(selectQuery, Optional.of(this.enableDynamicFiltering(false)));
    }

    protected void testJoinDynamicFilteringEnabled() {
        String selectQuery = "SELECT * FROM partitioned_lineitem JOIN supplier ON partitioned_lineitem.suppkey = supplier.suppkey AND supplier.name = 'Supplier#000000001'";
        this.testSelect(selectQuery, Optional.of(this.enableDynamicFiltering(true)), queryId -> {
            DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats((QueryId)queryId);
            ((AbstractIntegerAssert)Assertions.assertThat((int)dynamicFiltersStats.getLazyDynamicFilters()).as("Dynamic filter is missing", new Object[0])).isEqualTo(1);
            DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
            Assertions.assertThat((String)domainStats.getSimplifiedDomain()).isEqualTo(Domain.singleValue((Type)BigintType.BIGINT, (Object)1L).toString(this.getSession().toConnectorSession()));
        });
    }

    protected void testUserFailure() {
        Session withoutPushdown = Session.builder((Session)this.getSession()).setSystemProperty("allow_pushdown_into_connectors", "false").build();
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(withoutPushdown, "SELECT * FROM nation WHERE regionKey / nationKey - 1 = 0")).hasMessageMatching("(?i).*Division by zero.*");
        this.assertThatQuery("SELECT * FROM nation").experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.USER_ERROR)).at(ExtendedFailureRecoveryTest.leafStage()).failsAlways(failure -> failure.hasMessageContaining("This error is injected by the failure injection service"));
    }

    @Override
    protected void testRequestTimeouts() {
        this.assertThatQuery("SELECT * FROM nation").experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_TIMEOUT).at(ExtendedFailureRecoveryTest.leafStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("Encountered too many errors talking to a worker node")).finishesSuccessfully();
        this.assertThatQuery("SELECT * FROM nation").experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_TIMEOUT).at(ExtendedFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("Encountered too many errors talking to a worker node")).finishesSuccessfully();
        super.testRequestTimeouts();
    }

    @Override
    protected void testNonSelect(Optional<Session> session, Optional<String> setupQuery, String query, Optional<String> cleanupQuery, boolean writesData) {
        super.testNonSelect(session, setupQuery, query, cleanupQuery, writesData);
        this.assertThatQuery(query).withSession(session).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(ExtendedFailureRecoveryTest.leafStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).finishesSuccessfully();
        this.assertThatQuery(query).withSession(session).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(ExtendedFailureRecoveryTest.intermediateDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).finishesSuccessfully();
        this.assertThatQuery(query).withSession(session).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_FAILURE).at(ExtendedFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Error 500 Internal Server Error|Error closing remote buffer, expected 204 got 500")).finishesSuccessfully();
    }

    private Session enableDynamicFiltering(boolean enabled) {
        Session defaultSession = this.getQueryRunner().getDefaultSession();
        return Session.builder((Session)defaultSession).setSystemProperty("enable_dynamic_filtering", Boolean.toString(enabled)).setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.PARTITIONED.name()).setCatalogSessionProperty((String)defaultSession.getCatalog().orElseThrow(), "dynamic_filtering_wait_timeout", "1h").build();
    }
}

