/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.airlift.discovery.server.testing.TestingDiscoveryServer;
import io.airlift.log.Level;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.testing.Assertions;
import io.airlift.testing.Closeables;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.cost.StatsCalculator;
import io.trino.execution.FailureInjector;
import io.trino.execution.QueryManager;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.AllNodes;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.LanguageFunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.SessionPropertyManager;
import io.trino.server.BasicQueryInfo;
import io.trino.server.SessionPropertyDefaults;
import io.trino.server.testing.FactoryConfiguration;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.ErrorType;
import io.trino.spi.Plugin;
import io.trino.spi.QueryId;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.exchange.ExchangeManager;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.type.TypeManager;
import io.trino.split.PageSourceManager;
import io.trino.split.SplitManager;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.Plan;
import io.trino.sql.tree.Statement;
import io.trino.testing.AbstractTestQueries;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedResultWithQueryId;
import io.trino.testing.QueryRunner;
import io.trino.testing.ResultWithQueryId;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingGroupProviderManager;
import io.trino.testing.TestingTrinoClient;
import io.trino.testing.containers.OpenTracingCollector;
import io.trino.transaction.TransactionManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.intellij.lang.annotations.Language;

public class DistributedQueryRunner
implements QueryRunner {
    private static final Logger log = Logger.get(DistributedQueryRunner.class);
    private static final String ENVIRONMENT = "testing";
    private TestingDiscoveryServer discoveryServer;
    private TestingTrinoServer coordinator;
    private Optional<TestingTrinoServer> backupCoordinator;
    private Runnable registerNewWorker;
    private final List<TestingTrinoServer> servers = new CopyOnWriteArrayList<TestingTrinoServer>();
    private final List<FunctionBundle> functionBundles = new CopyOnWriteArrayList<FunctionBundle>((Collection<FunctionBundle>)ImmutableList.of((Object)AbstractTestQueries.CUSTOM_FUNCTIONS));
    private final List<Plugin> plugins = new CopyOnWriteArrayList<Plugin>();
    private final Closer closer = Closer.create();
    private TestingTrinoClient trinoClient;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean closed;

    public static Builder<?> builder(Session defaultSession) {
        return new Builder(defaultSession);
    }

    private DistributedQueryRunner(Session defaultSession, int nodeCount, Map<String, String> extraProperties, Map<String, String> coordinatorProperties, Optional<Map<String, String>> backupCoordinatorProperties, String environment, Module additionalModule, Optional<Path> baseDataDir, Optional<FactoryConfiguration> systemAccessControlConfiguration, Optional<List<SystemAccessControl>> systemAccessControls, List<EventListener> eventListeners, List<AutoCloseable> extraCloseables, TestingTrinoClientFactory testingTrinoClientFactory) throws Exception {
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        DistributedQueryRunner.setupLogging();
        try {
            long start = System.nanoTime();
            this.discoveryServer = new TestingDiscoveryServer(environment);
            this.closer.register(() -> DistributedQueryRunner.closeUnchecked((AutoCloseable)this.discoveryServer));
            this.closer.register(() -> extraCloseables.forEach(DistributedQueryRunner::closeUnchecked));
            log.info("Created TestingDiscoveryServer in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
            this.registerNewWorker = () -> this.createServer(false, extraProperties, environment, additionalModule, baseDataDir, Optional.empty(), Optional.of(ImmutableList.of()), (List<EventListener>)ImmutableList.of());
            int coordinatorCount = backupCoordinatorProperties.isEmpty() ? 1 : 2;
            Preconditions.checkArgument((nodeCount >= coordinatorCount ? 1 : 0) != 0, (String)"nodeCount includes coordinator(s) count, so must be at least %s, got: %s", (int)coordinatorCount, (int)nodeCount);
            for (int i = coordinatorCount; i < nodeCount; ++i) {
                this.registerNewWorker.run();
            }
            HashMap<String, String> extraCoordinatorProperties = new HashMap<String, String>();
            extraCoordinatorProperties.putAll(extraProperties);
            extraCoordinatorProperties.putAll(coordinatorProperties);
            if (!extraCoordinatorProperties.containsKey("web-ui.authentication.type")) {
                extraCoordinatorProperties.put("web-ui.authentication.type", "fixed");
                extraCoordinatorProperties.put("web-ui.user", "admin");
            }
            this.coordinator = this.createServer(true, extraCoordinatorProperties, environment, additionalModule, baseDataDir, systemAccessControlConfiguration, systemAccessControls, eventListeners);
            if (backupCoordinatorProperties.isPresent()) {
                HashMap<String, String> extraBackupCoordinatorProperties = new HashMap<String, String>();
                extraBackupCoordinatorProperties.putAll(extraProperties);
                extraBackupCoordinatorProperties.putAll(backupCoordinatorProperties.get());
                this.backupCoordinator = Optional.of(this.createServer(true, extraBackupCoordinatorProperties, environment, additionalModule, baseDataDir, systemAccessControlConfiguration, systemAccessControls, eventListeners));
            } else {
                this.backupCoordinator = Optional.empty();
            }
        }
        catch (Exception e) {
            try {
                throw this.closer.rethrow((Throwable)e, Exception.class);
            }
            catch (Throwable throwable) {
                this.closer.close();
                throw throwable;
            }
        }
        defaultSession = defaultSession.toSessionRepresentation().toSession(this.coordinator.getSessionPropertyManager(), defaultSession.getIdentity().getExtraCredentials(), defaultSession.getExchangeEncryptionKey());
        this.trinoClient = (TestingTrinoClient)this.closer.register((Closeable)testingTrinoClientFactory.create(this.coordinator, defaultSession));
        this.waitForAllNodesGloballyVisible();
    }

    private TestingTrinoServer createServer(boolean coordinator, Map<String, String> extraCoordinatorProperties, String environment, Module additionalModule, Optional<Path> baseDataDir, Optional<FactoryConfiguration> systemAccessControlConfiguration, Optional<List<SystemAccessControl>> systemAccessControls, List<EventListener> eventListeners) {
        TestingTrinoServer server = (TestingTrinoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingTrinoServer(this.discoveryServer.getBaseUrl(), coordinator, extraCoordinatorProperties, environment, additionalModule, baseDataDir, systemAccessControlConfiguration, systemAccessControls, eventListeners));
        this.servers.add(server);
        this.functionBundles.forEach(arg_0 -> ((TestingTrinoServer)server).addFunctions(arg_0));
        this.plugins.forEach(arg_0 -> ((TestingTrinoServer)server).installPlugin(arg_0));
        return server;
    }

    private static void setupLogging() {
        Logging logging = Logging.initialize();
        logging.setLevel("Bootstrap", Level.WARN);
        logging.setLevel("org.glassfish", Level.ERROR);
        logging.setLevel("org.eclipse.jetty.server", Level.WARN);
        logging.setLevel("io.trino.plugin.hive.util.RetryDriver", Level.DEBUG);
    }

    private static TestingTrinoServer createTestingTrinoServer(URI discoveryUri, boolean coordinator, Map<String, String> extraProperties, String environment, Module additionalModule, Optional<Path> baseDataDir, Optional<FactoryConfiguration> systemAccessControlConfiguration, Optional<List<SystemAccessControl>> systemAccessControls, List<EventListener> eventListeners) {
        long start = System.nanoTime();
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder().put((Object)"query.client.timeout", (Object)"10m").put((Object)"discovery.http-client.min-threads", (Object)"1").put((Object)"exchange.http-client.min-threads", (Object)"1").put((Object)"node-manager.http-client.min-threads", (Object)"1").put((Object)"exchange.page-buffer-client.max-callback-threads", (Object)"5").put((Object)"exchange.http-client.idle-timeout", (Object)"1h").put((Object)"task.max-index-memory", (Object)"16kB");
        if (coordinator) {
            propertiesBuilder.put((Object)"node-scheduler.include-coordinator", (Object)"true");
            propertiesBuilder.put((Object)"join-distribution-type", (Object)"PARTITIONED");
            propertiesBuilder.put((Object)"failure-detector.http-client.min-threads", (Object)"1");
            propertiesBuilder.put((Object)"memoryManager.http-client.min-threads", (Object)"1");
            propertiesBuilder.put((Object)"scheduler.http-client.min-threads", (Object)"1");
            propertiesBuilder.put((Object)"workerInfo.http-client.min-threads", (Object)"1");
        }
        HashMap<String, String> properties = new HashMap<String, String>((Map<String, String>)propertiesBuilder.buildOrThrow());
        properties.putAll(extraProperties);
        TestingTrinoServer server = TestingTrinoServer.builder().setCoordinator(coordinator).setProperties(properties).setEnvironment(environment).setDiscoveryUri(discoveryUri).setAdditionalModule(additionalModule).setBaseDataDir(baseDataDir).setSystemAccessControlConfiguration(systemAccessControlConfiguration).setSystemAccessControls(systemAccessControls).setEventListeners(eventListeners).build();
        String nodeRole = coordinator ? "coordinator" : "worker";
        log.info("Created %s TestingTrinoServer in %s: %s", new Object[]{nodeRole, Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit(), server.getBaseUrl()});
        return server;
    }

    public void addServers(int nodeCount) throws Exception {
        for (int i = 0; i < nodeCount; ++i) {
            this.registerNewWorker.run();
        }
        this.waitForAllNodesGloballyVisible();
    }

    private void waitForAllNodesGloballyVisible() throws InterruptedException {
        long start = System.nanoTime();
        while (!this.allNodesGloballyVisible()) {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(30.0, TimeUnit.SECONDS));
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        log.info("Announced servers in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    private boolean allNodesGloballyVisible() {
        for (TestingTrinoServer server : this.servers) {
            AllNodes allNodes = server.refreshNodes();
            if (allNodes.getInactiveNodes().isEmpty() && allNodes.getActiveNodes().size() == this.servers.size()) continue;
            return false;
        }
        return true;
    }

    public TestingTrinoClient getClient() {
        return this.trinoClient;
    }

    public int getNodeCount() {
        return this.servers.size();
    }

    public Session getDefaultSession() {
        return this.trinoClient.getDefaultSession();
    }

    public TransactionManager getTransactionManager() {
        return this.coordinator.getTransactionManager();
    }

    public Metadata getMetadata() {
        return this.coordinator.getMetadata();
    }

    public TypeManager getTypeManager() {
        return this.coordinator.getTypeManager();
    }

    public QueryExplainer getQueryExplainer() {
        return this.coordinator.getQueryExplainer();
    }

    public SessionPropertyManager getSessionPropertyManager() {
        return this.coordinator.getSessionPropertyManager();
    }

    public FunctionManager getFunctionManager() {
        return this.coordinator.getFunctionManager();
    }

    public LanguageFunctionManager getLanguageFunctionManager() {
        return this.coordinator.getLanguageFunctionManager();
    }

    public SplitManager getSplitManager() {
        return this.coordinator.getSplitManager();
    }

    public ExchangeManager getExchangeManager() {
        return this.coordinator.getExchangeManager();
    }

    public PageSourceManager getPageSourceManager() {
        return this.coordinator.getPageSourceManager();
    }

    public NodePartitioningManager getNodePartitioningManager() {
        return this.coordinator.getNodePartitioningManager();
    }

    public StatsCalculator getStatsCalculator() {
        return this.coordinator.getStatsCalculator();
    }

    public TestingAccessControlManager getAccessControl() {
        return this.coordinator.getAccessControl();
    }

    public TestingGroupProviderManager getGroupProvider() {
        return this.coordinator.getGroupProvider();
    }

    public SessionPropertyDefaults getSessionPropertyDefaults() {
        return this.coordinator.getSessionPropertyDefaults();
    }

    public TestingTrinoServer getCoordinator() {
        return this.coordinator;
    }

    public Optional<TestingTrinoServer> getBackupCoordinator() {
        return this.backupCoordinator;
    }

    public List<TestingTrinoServer> getServers() {
        return ImmutableList.copyOf(this.servers);
    }

    public void installPlugin(Plugin plugin) {
        this.plugins.add(plugin);
        long start = System.nanoTime();
        this.servers.forEach(server -> server.installPlugin(plugin));
        log.info("Installed plugin %s in %s", new Object[]{plugin.getClass().getSimpleName(), Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    public void addFunctions(FunctionBundle functionBundle) {
        this.functionBundles.add(functionBundle);
        this.servers.forEach(server -> server.addFunctions(functionBundle));
    }

    public void createCatalog(String catalogName, String connectorName) {
        this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        long start = System.nanoTime();
        this.coordinator.createCatalog(catalogName, connectorName, properties);
        this.backupCoordinator.ifPresent(backup -> backup.createCatalog(catalogName, connectorName, properties));
        log.info("Created catalog %s in %s", new Object[]{catalogName, Duration.nanosSince((long)start)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List<QualifiedObjectName> list = this.trinoClient.listTables(session, catalog, schema);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.trinoClient.tableExists(session, table);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MaterializedResult execute(@Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.trinoClient.execute(sql).getResult();
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        return this.executeWithQueryId(session, sql).getResult();
    }

    public MaterializedResultWithQueryId executeWithQueryId(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            ResultWithQueryId result = this.trinoClient.execute(session, sql);
            MaterializedResultWithQueryId materializedResultWithQueryId = new MaterializedResultWithQueryId(result.getQueryId(), (MaterializedResult)result.getResult());
            return materializedResultWithQueryId;
        }
        catch (Throwable e) {
            e.addSuppressed(new Exception("SQL: " + sql));
            throw e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public QueryRunner.MaterializedResultWithPlan executeWithPlan(Session session, String sql, WarningCollector warningCollector) {
        MaterializedResultWithQueryId resultWithQueryId = this.executeWithQueryId(session, sql);
        return new QueryRunner.MaterializedResultWithPlan(resultWithQueryId.getResult().toTestTypes(), this.getQueryPlan(resultWithQueryId.getQueryId()));
    }

    public Plan createPlan(Session session, String sql) {
        this.getTransactionManager().getTransactionInfo(session.getRequiredTransactionId());
        SqlParser sqlParser = (SqlParser)this.coordinator.getInstance(Key.get(SqlParser.class));
        Statement statement = sqlParser.createStatement(sql);
        return this.coordinator.getQueryExplainer().getLogicalPlan(session, statement, (List)ImmutableList.of(), WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
    }

    public Plan getQueryPlan(QueryId queryId) {
        return this.coordinator.getQueryPlan(queryId);
    }

    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    public void injectTaskFailure(String traceToken, int stageId, int partitionId, int attemptId, FailureInjector.InjectedFailureType injectionType, Optional<ErrorType> errorType) {
        for (TestingTrinoServer server : this.servers) {
            server.injectTaskFailure(traceToken, stageId, partitionId, attemptId, injectionType, errorType);
        }
    }

    public void loadExchangeManager(String name, Map<String, String> properties) {
        for (TestingTrinoServer server : this.servers) {
            server.loadExchangeManager(name, properties);
        }
    }

    public final void close() {
        if (this.closed) {
            return;
        }
        this.cancelAllQueries();
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.discoveryServer = null;
        this.coordinator = null;
        this.backupCoordinator = Optional.empty();
        this.registerNewWorker = () -> {
            throw new IllegalStateException("Already closed");
        };
        this.servers.clear();
        this.functionBundles.clear();
        this.plugins.clear();
        this.trinoClient = null;
        this.closed = true;
    }

    private void cancelAllQueries() {
        QueryManager queryManager = this.coordinator.getQueryManager();
        for (BasicQueryInfo queryInfo : queryManager.getQueries()) {
            if (queryInfo.getState().isDone()) continue;
            try {
                queryManager.cancelQuery(queryInfo.getQueryId());
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Failed to cancel query");
            }
        }
    }

    private static void closeUnchecked(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static class Builder<SELF extends Builder<?>> {
        private Session defaultSession;
        private int nodeCount = 3;
        private Map<String, String> extraProperties = ImmutableMap.of();
        private Map<String, String> coordinatorProperties = ImmutableMap.of();
        private Optional<Map<String, String>> backupCoordinatorProperties = Optional.empty();
        private Consumer<QueryRunner> additionalSetup = queryRunner -> {};
        private String environment = "testing";
        private Module additionalModule = Modules.EMPTY_MODULE;
        private Optional<Path> baseDataDir = Optional.empty();
        private Optional<FactoryConfiguration> systemAccessControlConfiguration = Optional.empty();
        private Optional<List<SystemAccessControl>> systemAccessControls = Optional.empty();
        private List<EventListener> eventListeners = ImmutableList.of();
        private List<AutoCloseable> extraCloseables = ImmutableList.of();
        private TestingTrinoClientFactory testingTrinoClientFactory = TestingTrinoClient::new;

        protected Builder(Session defaultSession) {
            this.defaultSession = Objects.requireNonNull(defaultSession, "defaultSession is null");
        }

        @CanIgnoreReturnValue
        public SELF amendSession(Function<Session.SessionBuilder, Session.SessionBuilder> amendSession) {
            Session.SessionBuilder builder = Session.builder((Session)this.defaultSession);
            this.defaultSession = amendSession.apply(builder).build();
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setNodeCount(int nodeCount) {
            this.nodeCount = nodeCount;
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setExtraProperties(Map<String, String> extraProperties) {
            this.extraProperties = ImmutableMap.copyOf(extraProperties);
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF addExtraProperties(Map<String, String> extraProperties) {
            this.extraProperties = Builder.addProperties(this.extraProperties, extraProperties);
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF addExtraProperty(String key, String value) {
            this.extraProperties = Builder.addProperty(this.extraProperties, key, value);
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setCoordinatorProperties(Map<String, String> coordinatorProperties) {
            this.coordinatorProperties = ImmutableMap.copyOf(coordinatorProperties);
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF addCoordinatorProperties(Map<String, String> coordinatorProperties) {
            this.coordinatorProperties = Builder.addProperties(this.coordinatorProperties, coordinatorProperties);
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF addCoordinatorProperty(String key, String value) {
            this.coordinatorProperties = Builder.addProperty(this.coordinatorProperties, key, value);
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setBackupCoordinatorProperties(Map<String, String> backupCoordinatorProperties) {
            this.backupCoordinatorProperties = Optional.of(backupCoordinatorProperties);
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setAdditionalSetup(Consumer<QueryRunner> additionalSetup) {
            this.additionalSetup = Objects.requireNonNull(additionalSetup, "additionalSetup is null");
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setEnvironment(String environment) {
            this.environment = environment;
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setAdditionalModule(Module additionalModule) {
            this.additionalModule = Objects.requireNonNull(additionalModule, "additionalModules is null");
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setBaseDataDir(Optional<Path> baseDataDir) {
            this.baseDataDir = Objects.requireNonNull(baseDataDir, "baseDataDir is null");
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setSystemAccessControl(String name, Map<String, String> configuration) {
            this.systemAccessControlConfiguration = Optional.of(new FactoryConfiguration(name, configuration));
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setSystemAccessControl(SystemAccessControl systemAccessControl) {
            return this.setSystemAccessControls((List<SystemAccessControl>)ImmutableList.of((Object)Objects.requireNonNull(systemAccessControl, "systemAccessControl is null")));
        }

        @CanIgnoreReturnValue
        public SELF setSystemAccessControls(List<SystemAccessControl> systemAccessControls) {
            this.systemAccessControls = Optional.of(ImmutableList.copyOf((Collection)Objects.requireNonNull(systemAccessControls, "systemAccessControls is null")));
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setEventListener(EventListener eventListener) {
            return this.setEventListeners((List<EventListener>)ImmutableList.of((Object)Objects.requireNonNull(eventListener, "eventListener is null")));
        }

        @CanIgnoreReturnValue
        public SELF setEventListeners(List<EventListener> eventListeners) {
            this.eventListeners = ImmutableList.copyOf((Collection)Objects.requireNonNull(eventListeners, "eventListeners is null"));
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF setTestingTrinoClientFactory(TestingTrinoClientFactory testingTrinoClientFactory) {
            this.testingTrinoClientFactory = Objects.requireNonNull(testingTrinoClientFactory, "testingTrinoClientFactory is null");
            return this.self();
        }

        @CanIgnoreReturnValue
        public SELF enableBackupCoordinator() {
            if (this.backupCoordinatorProperties.isEmpty()) {
                this.setBackupCoordinatorProperties((Map<String, String>)ImmutableMap.of());
            }
            return this.self();
        }

        public SELF withTracing() {
            final OpenTracingCollector collector = new OpenTracingCollector();
            collector.start();
            this.extraCloseables = ImmutableList.of((Object)collector);
            this.addExtraProperties(Map.of("tracing.enabled", "true", "tracing.exporter.endpoint", collector.getExporterEndpoint().toString()));
            this.setEventListener(new EventListener(){

                public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
                    String queryId = queryCompletedEvent.getMetadata().getQueryId();
                    log.info("TRACING: %s :: %s", new Object[]{queryId, collector.searchForQueryId(queryId)});
                }
            });
            return this.self();
        }

        protected SELF self() {
            return (SELF)this;
        }

        public DistributedQueryRunner build() throws Exception {
            String tracingEnabled = (String)MoreObjects.firstNonNull((Object)System.getenv("TESTS_TRACING_ENABLED"), (Object)"false");
            if (Boolean.parseBoolean(tracingEnabled) || tracingEnabled.equals("1")) {
                this.withTracing();
            }
            Optional<FactoryConfiguration> systemAccessControlConfiguration = this.systemAccessControlConfiguration;
            Optional<List<SystemAccessControl>> systemAccessControls = this.systemAccessControls;
            if (systemAccessControlConfiguration.isEmpty() && systemAccessControls.isEmpty()) {
                systemAccessControls = Optional.of(ImmutableList.of());
            }
            DistributedQueryRunner queryRunner = new DistributedQueryRunner(this.defaultSession, this.nodeCount, this.extraProperties, this.coordinatorProperties, this.backupCoordinatorProperties, this.environment, this.additionalModule, this.baseDataDir, systemAccessControlConfiguration, systemAccessControls, this.eventListeners, this.extraCloseables, this.testingTrinoClientFactory);
            try {
                this.additionalSetup.accept(queryRunner);
            }
            catch (Throwable e) {
                Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
                throw e;
            }
            return queryRunner;
        }

        protected static Map<String, String> addProperties(Map<String, String> properties, Map<String, String> update) {
            return ImmutableMap.builder().putAll(Objects.requireNonNull(properties, "properties is null")).putAll(Objects.requireNonNull(update, "update is null")).buildOrThrow();
        }

        protected static ImmutableMap<String, String> addProperty(Map<String, String> extraProperties, String key, String value) {
            return ImmutableMap.builder().putAll(Objects.requireNonNull(extraProperties, "properties is null")).put((Object)Objects.requireNonNull(key, "key is null"), (Object)Objects.requireNonNull(value, "value is null")).buildOrThrow();
        }
    }

    public static interface TestingTrinoClientFactory {
        public TestingTrinoClient create(TestingTrinoServer var1, Session var2);
    }
}

