/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.testng.Assert;

public final class MultisetAssertions {
    private MultisetAssertions() {
    }

    public static void assertMultisetsEqual(Multiset<?> actual, Multiset<?> expected) {
        if (expected.equals(actual)) {
            return;
        }
        List mismatchReport = (List)Sets.union((Set)expected.elementSet(), (Set)actual.elementSet()).stream().filter(key -> expected.count(key) != actual.count(key)).flatMap(key -> {
            int expectedCount = expected.count(key);
            int actualCount = actual.count(key);
            if (actualCount < expectedCount) {
                return Stream.of(String.format("%s more occurrences of %s", expectedCount - actualCount, key));
            }
            if (actualCount > expectedCount) {
                return Stream.of(String.format("%s fewer occurrences of %s", actualCount - expectedCount, key));
            }
            return Stream.of(new String[0]);
        }).collect(ImmutableList.toImmutableList());
        Assert.fail((String)("Expected: \n\t\t" + String.join((CharSequence)",\n\t\t", mismatchReport)));
    }
}

