/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.TestingNames;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public abstract class BaseComplexTypesPredicatePushDownTest
extends AbstractTestQueryFramework {
    @Test
    public void testRowTypeOnlyNullsRowGroupPruning() {
        String tableName = "test_primitive_column_nulls_pruning_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (col BIGINT)");
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM unnest(repeat(NULL, 4096))", 4096L);
        this.assertNoDataRead("SELECT * FROM " + tableName + " WHERE col IS NOT NULL");
        tableName = "test_nested_column_nulls_pruning_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (col ROW(a BIGINT, b ARRAY(DOUBLE)))");
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM unnest(transform(repeat(1, 4096), x -> ROW(ROW(NULL, ARRAY [NULL, rand()]))))", 4096L);
        this.assertNoDataRead("SELECT * FROM " + tableName + " WHERE col.a IS NOT NULL");
        this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE col.a IS NULL", queryStats -> Assertions.assertThat((long)queryStats.getProcessedInputDataSize().toBytes()).isGreaterThan(0L), results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(4096));
        this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE col.b IS NOT NULL", queryStats -> Assertions.assertThat((long)queryStats.getProcessedInputDataSize().toBytes()).isGreaterThan(0L), results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(4096));
        this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE col.b IS NULL", queryStats -> Assertions.assertThat((long)queryStats.getProcessedInputDataSize().toBytes()).isGreaterThan(0L), results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
        this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE col IS NOT NULL", queryStats -> Assertions.assertThat((long)queryStats.getProcessedInputDataSize().toBytes()).isGreaterThan(0L), results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(4096));
        this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE col IS NULL", queryStats -> Assertions.assertThat((long)queryStats.getProcessedInputDataSize().toBytes()).isGreaterThan(0L), results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testRowTypeRowGroupPruning() {
        String tableName = "test_nested_column_pruning_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (col1Row ROW(a BIGINT, b BIGINT, c ROW(c1 BIGINT, c2 ROW(c21 BIGINT, c22 BIGINT))))");
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM unnest(transform(SEQUENCE(1, 10000), x -> ROW(ROW(x*2, 100, ROW(x, ROW(x*5, x*6))))))", 10000L);
        this.assertNoDataRead("SELECT * FROM " + tableName + " WHERE col1Row.a = -1");
        this.assertNoDataRead("SELECT * FROM " + tableName + " WHERE col1Row.a IS NULL");
        this.assertNoDataRead("SELECT * FROM " + tableName + " WHERE col1Row.c.c2.c22 = -1");
        this.assertNoDataRead("SELECT * FROM " + tableName + " WHERE col1Row.a = -1 AND col1ROW.b = -1 AND col1ROW.c.c1 = -1 AND col1Row.c.c2.c22 = -1");
        this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE col1Row.b = 100", queryStats -> Assertions.assertThat((long)queryStats.getProcessedInputDataSize().toBytes()).isGreaterThan(0L), results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(10000));
        this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE col1Row.c = ROW(-1, ROW(-1, -1))", queryStats -> Assertions.assertThat((long)queryStats.getProcessedInputDataSize().toBytes()).isGreaterThan(0L), results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
        this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE col1Row.c = ROW(-1, ROW(-1, -1)) OR col1Row.a = -1 ", queryStats -> Assertions.assertThat((long)queryStats.getProcessedInputDataSize().toBytes()).isGreaterThan(0L), results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
        this.assertNoDataRead("SELECT * FROM " + tableName + " WHERE col1Row.c = ROW(-1, ROW(-1, -1)) AND col1Row.a = -1 ");
        this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE col1Row = ROW(-1, -1, ROW(-1, ROW(-1, -1)))", queryStats -> Assertions.assertThat((long)queryStats.getProcessedInputDataSize().toBytes()).isGreaterThan(0L), results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testMapTypeRowGroupPruning() {
        String tableName = "test_nested_column_pruning_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (colMap Map(VARCHAR, BIGINT))");
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM unnest(transform(SEQUENCE(1, 10000), x -> ROW(MAP(ARRAY['FOO', 'BAR'], ARRAY[100, 200]))))", 10000L);
        this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE colMap['FOO'] = -1", queryStats -> Assertions.assertThat((long)queryStats.getProcessedInputDataSize().toBytes()).isGreaterThan(0L), results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
        this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE colMap = MAP(ARRAY['FOO', 'BAR'], ARRAY[-1, -1])", queryStats -> Assertions.assertThat((long)queryStats.getProcessedInputDataSize().toBytes()).isGreaterThan(0L), results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testArrayTypeRowGroupPruning() {
        String tableName = "test_nested_column_pruning_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (colArray ARRAY(BIGINT))");
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM unnest(transform(SEQUENCE(1, 10000), x -> ROW(ARRAY[100, 200])))", 10000L);
        this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE colArray[1] = -1", queryStats -> Assertions.assertThat((long)queryStats.getProcessedInputDataSize().toBytes()).isGreaterThan(0L), results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
        this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE colArray = ARRAY[-1, -1]", queryStats -> Assertions.assertThat((long)queryStats.getProcessedInputDataSize().toBytes()).isGreaterThan(0L), results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
        this.assertUpdate("DROP TABLE " + tableName);
    }
}

