/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public enum TestingConnectorBehavior {
    SUPPORTS_INSERT,
    SUPPORTS_DELETE,
    SUPPORTS_ROW_LEVEL_DELETE(SUPPORTS_DELETE),
    SUPPORTS_UPDATE,
    SUPPORTS_MERGE,
    SUPPORTS_TRUNCATE(SUPPORTS_DELETE),
    SUPPORTS_ARRAY,
    SUPPORTS_ROW_TYPE,
    SUPPORTS_PREDICATE_PUSHDOWN,
    SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_EQUALITY(SUPPORTS_PREDICATE_PUSHDOWN),
    SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY(SUPPORTS_PREDICATE_PUSHDOWN),
    SUPPORTS_PREDICATE_EXPRESSION_PUSHDOWN(SUPPORTS_PREDICATE_PUSHDOWN),
    SUPPORTS_PREDICATE_ARITHMETIC_EXPRESSION_PUSHDOWN(SUPPORTS_PREDICATE_EXPRESSION_PUSHDOWN),
    SUPPORTS_PREDICATE_EXPRESSION_PUSHDOWN_WITH_LIKE(SUPPORTS_PREDICATE_EXPRESSION_PUSHDOWN),
    SUPPORTS_DYNAMIC_FILTER_PUSHDOWN(false),
    SUPPORTS_LIMIT_PUSHDOWN,
    SUPPORTS_TOPN_PUSHDOWN,
    SUPPORTS_TOPN_PUSHDOWN_WITH_VARCHAR(TestingConnectorBehavior.and(SUPPORTS_TOPN_PUSHDOWN, SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY)),
    SUPPORTS_AGGREGATION_PUSHDOWN,
    SUPPORTS_AGGREGATION_PUSHDOWN_STDDEV(SUPPORTS_AGGREGATION_PUSHDOWN),
    SUPPORTS_AGGREGATION_PUSHDOWN_VARIANCE(SUPPORTS_AGGREGATION_PUSHDOWN),
    SUPPORTS_AGGREGATION_PUSHDOWN_COVARIANCE(SUPPORTS_AGGREGATION_PUSHDOWN),
    SUPPORTS_AGGREGATION_PUSHDOWN_CORRELATION(SUPPORTS_AGGREGATION_PUSHDOWN),
    SUPPORTS_AGGREGATION_PUSHDOWN_REGRESSION(SUPPORTS_AGGREGATION_PUSHDOWN),
    SUPPORTS_AGGREGATION_PUSHDOWN_COUNT_DISTINCT(SUPPORTS_AGGREGATION_PUSHDOWN),
    SUPPORTS_JOIN_PUSHDOWN(false),
    SUPPORTS_JOIN_PUSHDOWN_WITH_FULL_JOIN(SUPPORTS_JOIN_PUSHDOWN),
    SUPPORTS_JOIN_PUSHDOWN_WITH_DISTINCT_FROM(SUPPORTS_JOIN_PUSHDOWN),
    SUPPORTS_JOIN_PUSHDOWN_WITH_VARCHAR_EQUALITY(TestingConnectorBehavior.and(SUPPORTS_JOIN_PUSHDOWN, SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_EQUALITY)),
    SUPPORTS_JOIN_PUSHDOWN_WITH_VARCHAR_INEQUALITY(TestingConnectorBehavior.and(SUPPORTS_JOIN_PUSHDOWN, SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY)),
    SUPPORTS_DEREFERENCE_PUSHDOWN(SUPPORTS_ROW_TYPE),
    SUPPORTS_CREATE_SCHEMA,
    SUPPORTS_RENAME_SCHEMA(SUPPORTS_CREATE_SCHEMA),
    SUPPORTS_CREATE_TABLE,
    SUPPORTS_CREATE_TABLE_WITH_DATA(SUPPORTS_CREATE_TABLE),
    SUPPORTS_CREATE_TABLE_WITH_TABLE_COMMENT(SUPPORTS_CREATE_TABLE),
    SUPPORTS_CREATE_TABLE_WITH_COLUMN_COMMENT(SUPPORTS_CREATE_TABLE),
    SUPPORTS_RENAME_TABLE,
    SUPPORTS_RENAME_TABLE_ACROSS_SCHEMAS(SUPPORTS_RENAME_TABLE),
    SUPPORTS_ADD_COLUMN,
    SUPPORTS_ADD_COLUMN_WITH_COMMENT(SUPPORTS_ADD_COLUMN),
    SUPPORTS_DROP_COLUMN(SUPPORTS_ADD_COLUMN),
    SUPPORTS_DROP_FIELD(TestingConnectorBehavior.and(SUPPORTS_DROP_COLUMN, SUPPORTS_ROW_TYPE)),
    SUPPORTS_RENAME_COLUMN,
    SUPPORTS_SET_COLUMN_TYPE,
    SUPPORTS_COMMENT_ON_TABLE,
    SUPPORTS_COMMENT_ON_COLUMN(SUPPORTS_COMMENT_ON_TABLE),
    SUPPORTS_CREATE_VIEW,
    SUPPORTS_COMMENT_ON_VIEW(TestingConnectorBehavior.and(SUPPORTS_CREATE_VIEW, SUPPORTS_COMMENT_ON_TABLE)),
    SUPPORTS_COMMENT_ON_VIEW_COLUMN(SUPPORTS_COMMENT_ON_VIEW),
    SUPPORTS_CREATE_MATERIALIZED_VIEW,
    SUPPORTS_CREATE_MATERIALIZED_VIEW_GRACE_PERIOD(SUPPORTS_CREATE_MATERIALIZED_VIEW),
    SUPPORTS_CREATE_FEDERATED_MATERIALIZED_VIEW(SUPPORTS_CREATE_MATERIALIZED_VIEW),
    SUPPORTS_MATERIALIZED_VIEW_FRESHNESS_FROM_BASE_TABLES(SUPPORTS_CREATE_MATERIALIZED_VIEW),
    SUPPORTS_RENAME_MATERIALIZED_VIEW(SUPPORTS_CREATE_MATERIALIZED_VIEW),
    SUPPORTS_RENAME_MATERIALIZED_VIEW_ACROSS_SCHEMAS(SUPPORTS_RENAME_MATERIALIZED_VIEW),
    SUPPORTS_NOT_NULL_CONSTRAINT(SUPPORTS_CREATE_TABLE),
    SUPPORTS_ADD_COLUMN_NOT_NULL_CONSTRAINT(TestingConnectorBehavior.and(SUPPORTS_NOT_NULL_CONSTRAINT, SUPPORTS_ADD_COLUMN)),
    SUPPORTS_NEGATIVE_DATE,
    SUPPORTS_CANCELLATION(false),
    SUPPORTS_MULTI_STATEMENT_WRITES(false),
    SUPPORTS_NATIVE_QUERY(true);

    private final Predicate<Predicate<TestingConnectorBehavior>> hasBehaviorByDefault;

    private TestingConnectorBehavior() {
        this(true);
    }

    private TestingConnectorBehavior(boolean hasBehaviorByDefault) {
        this((Predicate<TestingConnectorBehavior> fallback) -> hasBehaviorByDefault);
        Preconditions.checkArgument((!hasBehaviorByDefault == (this.name().equals("SUPPORTS_CANCELLATION") || this.name().equals("SUPPORTS_DYNAMIC_FILTER_PUSHDOWN") || this.name().equals("SUPPORTS_JOIN_PUSHDOWN") || this.name().equals("SUPPORTS_MULTI_STATEMENT_WRITES")) ? 1 : 0) != 0, (String)"Every behavior should be expected to be true by default. Having mixed defaults makes reasoning about tests harder. False default provided for %s", (Object)this.name());
    }

    private TestingConnectorBehavior(TestingConnectorBehavior defaultBehaviorSource) {
        this((Predicate<TestingConnectorBehavior> fallback) -> fallback.test(defaultBehaviorSource));
    }

    private TestingConnectorBehavior(Predicate<Predicate<TestingConnectorBehavior>> hasBehaviorByDefault) {
        this.hasBehaviorByDefault = Objects.requireNonNull(hasBehaviorByDefault, "hasBehaviorByDefault is null");
    }

    boolean hasBehaviorByDefault(Predicate<TestingConnectorBehavior> fallback) {
        return this.hasBehaviorByDefault.test(fallback);
    }

    private static Predicate<Predicate<TestingConnectorBehavior>> and(TestingConnectorBehavior first, TestingConnectorBehavior ... rest) {
        ImmutableList conjuncts = ImmutableList.copyOf((Collection)Lists.asList((Object)((Object)first), (Object[])rest));
        return arg_0 -> TestingConnectorBehavior.lambda$and$2((List)conjuncts, arg_0);
    }

    private static /* synthetic */ boolean lambda$and$2(List conjuncts, Predicate fallback) {
        return conjuncts.stream().allMatch(fallback);
    }
}

