/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.BlockTypeOperators;
import io.trino.type.InternalTypeManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public final class StructuralTestUtil {
    private static final BlockTypeOperators TYPE_OPERATORS_CACHE = new BlockTypeOperators();

    private StructuralTestUtil() {
    }

    public static boolean arrayBlocksEqual(Type elementType, Block block1, Block block2) {
        if (block1.getPositionCount() != block2.getPositionCount()) {
            return false;
        }
        BlockTypeOperators.BlockPositionEqual elementEqualOperator = TYPE_OPERATORS_CACHE.getEqualOperator(elementType);
        for (int i = 0; i < block1.getPositionCount(); ++i) {
            if (block1.isNull(i) != block2.isNull(i)) {
                return false;
            }
            if (block1.isNull(i) || elementEqualOperator.equal(block1, i, block2, i).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static boolean mapBlocksEqual(Type keyType, Type valueType, Block block1, Block block2) {
        if (block1.getPositionCount() != block2.getPositionCount()) {
            return false;
        }
        BlockTypeOperators.BlockPositionEqual keyEqualOperator = TYPE_OPERATORS_CACHE.getEqualOperator(keyType);
        BlockTypeOperators.BlockPositionEqual valueEqualOperator = TYPE_OPERATORS_CACHE.getEqualOperator(valueType);
        for (int i = 0; i < block1.getPositionCount(); i += 2) {
            if (block1.isNull(i) != block2.isNull(i) || block1.isNull(i + 1) != block2.isNull(i + 1)) {
                return false;
            }
            if (!block1.isNull(i) && !keyEqualOperator.equal(block1, i, block2, i).booleanValue()) {
                return false;
            }
            if (block1.isNull(i + 1) || valueEqualOperator.equal(block1, i + 1, block2, i + 1).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static Block arrayBlockOf(Type elementType, Object ... values) {
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, 1024);
        for (Object value : values) {
            io.trino.util.StructuralTestUtil.appendToBlockBuilder((Type)elementType, (Object)value, (BlockBuilder)blockBuilder);
        }
        return blockBuilder.build();
    }

    public static Block mapBlockOf(Type keyType, Type valueType, Object key, Object value) {
        MapType mapType = StructuralTestUtil.mapType(keyType, valueType);
        BlockBuilder blockBuilder = mapType.createBlockBuilder(null, 10);
        BlockBuilder singleMapBlockWriter = blockBuilder.beginBlockEntry();
        io.trino.util.StructuralTestUtil.appendToBlockBuilder((Type)keyType, (Object)key, (BlockBuilder)singleMapBlockWriter);
        io.trino.util.StructuralTestUtil.appendToBlockBuilder((Type)valueType, (Object)value, (BlockBuilder)singleMapBlockWriter);
        blockBuilder.closeEntry();
        return mapType.getObject((Block)blockBuilder, 0);
    }

    public static Block mapBlockOf(Type keyType, Type valueType, Object[] keys, Object[] values) {
        Preconditions.checkArgument((keys.length == values.length ? 1 : 0) != 0, (Object)"keys/values must have the same length");
        MapType mapType = StructuralTestUtil.mapType(keyType, valueType);
        BlockBuilder blockBuilder = mapType.createBlockBuilder(null, 10);
        BlockBuilder singleMapBlockWriter = blockBuilder.beginBlockEntry();
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            Object value = values[i];
            io.trino.util.StructuralTestUtil.appendToBlockBuilder((Type)keyType, (Object)key, (BlockBuilder)singleMapBlockWriter);
            io.trino.util.StructuralTestUtil.appendToBlockBuilder((Type)valueType, (Object)value, (BlockBuilder)singleMapBlockWriter);
        }
        blockBuilder.closeEntry();
        return mapType.getObject((Block)blockBuilder, 0);
    }

    public static Block rowBlockOf(List<Type> parameterTypes, Object ... values) {
        RowType rowType = RowType.anonymous(parameterTypes);
        BlockBuilder blockBuilder = rowType.createBlockBuilder(null, 1);
        BlockBuilder singleRowBlockWriter = blockBuilder.beginBlockEntry();
        for (int i = 0; i < values.length; ++i) {
            io.trino.util.StructuralTestUtil.appendToBlockBuilder((Type)parameterTypes.get(i), (Object)values[i], (BlockBuilder)singleRowBlockWriter);
        }
        blockBuilder.closeEntry();
        return rowType.getObject((Block)blockBuilder, 0);
    }

    public static Block decimalArrayBlockOf(DecimalType type, BigDecimal decimal) {
        if (type.isShort()) {
            long longDecimal = decimal.unscaledValue().longValue();
            return StructuralTestUtil.arrayBlockOf((Type)type, longDecimal);
        }
        Int128 sliceDecimal = Int128.valueOf((BigInteger)decimal.unscaledValue());
        return StructuralTestUtil.arrayBlockOf((Type)type, sliceDecimal);
    }

    public static Block decimalMapBlockOf(DecimalType type, BigDecimal decimal) {
        if (type.isShort()) {
            long longDecimal = decimal.unscaledValue().longValue();
            return StructuralTestUtil.mapBlockOf((Type)type, (Type)type, longDecimal, longDecimal);
        }
        Int128 sliceDecimal = Int128.valueOf((BigInteger)decimal.unscaledValue());
        return StructuralTestUtil.mapBlockOf((Type)type, (Type)type, sliceDecimal, sliceDecimal);
    }

    public static MapType mapType(Type keyType, Type valueType) {
        return (MapType)InternalTypeManager.TESTING_TYPE_MANAGER.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.typeParameter((TypeSignature)valueType.getTypeSignature())));
    }

    public static ArrayType arrayType(Type elementType) {
        return (ArrayType)InternalTypeManager.TESTING_TYPE_MANAGER.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)elementType.getTypeSignature())));
    }
}

