/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryManager;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStats;
import io.trino.execution.SqlTaskManager;
import io.trino.execution.StageInfo;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskState;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.memory.LocalMemoryManager;
import io.trino.memory.MemoryPool;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableMetadata;
import io.trino.operator.OperatorStats;
import io.trino.security.AccessControl;
import io.trino.server.BasicQueryInfo;
import io.trino.server.DynamicFilterService;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.QueryId;
import io.trino.spi.type.Type;
import io.trino.sql.ParsingUtil;
import io.trino.sql.SqlFormatter;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.sql.tree.ExplainType;
import io.trino.sql.tree.Node;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.H2QueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedResultWithQueryId;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.assertions.Assert;
import io.trino.transaction.TransactionBuilder;
import io.trino.transaction.TransactionManager;
import io.trino.util.AutoCloseableCloser;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.intellij.lang.annotations.Language;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractTestQueryFramework {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private AutoCloseableCloser afterClassCloser;
    private QueryRunner queryRunner;
    private H2QueryRunner h2QueryRunner;
    private io.trino.sql.query.QueryAssertions queryAssertions;

    @BeforeClass
    public void init() throws Exception {
        this.afterClassCloser = AutoCloseableCloser.create();
        this.queryRunner = (QueryRunner)this.afterClassCloser.register((AutoCloseable)this.createQueryRunner());
        this.h2QueryRunner = (H2QueryRunner)this.afterClassCloser.register((AutoCloseable)new H2QueryRunner());
        this.queryAssertions = new io.trino.sql.query.QueryAssertions(this.queryRunner);
    }

    protected abstract QueryRunner createQueryRunner() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass(alwaysRun=true)
    public final void close() throws Exception {
        try (AutoCloseableCloser ignored = this.afterClassCloser;){
            this.checkQueryMemoryReleased();
            this.checkQueryInfosFinal();
            this.checkTasksDone();
        }
        finally {
            this.afterClassCloser = null;
            this.queryRunner = null;
            this.h2QueryRunner = null;
            this.queryAssertions = null;
        }
    }

    private void checkQueryMemoryReleased() {
        this.tryGetDistributedQueryRunner().ifPresent(runner -> Assert.assertEventually((Duration)new Duration(30.0, TimeUnit.SECONDS), (Duration)new Duration(1.0, TimeUnit.SECONDS), () -> {
            List<TestingTrinoServer> servers = runner.getServers();
            for (int serverId = 0; serverId < servers.size(); ++serverId) {
                TestingTrinoServer server = servers.get(serverId);
                this.assertMemoryPoolReleased(runner.getCoordinator(), server, serverId);
            }
            ((AbstractLongAssert)Assertions.assertThat((long)runner.getCoordinator().getClusterMemoryManager().getClusterTotalMemoryReservation()).describedAs("cluster memory reservation", new Object[0])).isZero();
        }));
    }

    private void assertMemoryPoolReleased(TestingTrinoServer coordinator, TestingTrinoServer server, long serverId) {
        String serverName = String.format("server_%d(%s)", serverId, server.isCoordinator() ? "coordinator" : "worker");
        long reservedBytes = server.getLocalMemoryManager().getMemoryPool().getReservedBytes();
        if (reservedBytes != 0L) {
            org.testng.Assert.fail((String)("Expected memory reservation on " + serverName + "to be 0 but was " + reservedBytes + "; detailed memory usage:\n" + this.describeMemoryPool(coordinator, server)));
        }
    }

    private String describeMemoryPool(TestingTrinoServer coordinator, TestingTrinoServer server) {
        LocalMemoryManager memoryManager = server.getLocalMemoryManager();
        MemoryPool memoryPool = memoryManager.getMemoryPool();
        Map queryReservations = memoryPool.getQueryMemoryReservations();
        Map queryTaggedReservations = memoryPool.getTaggedMemoryAllocations();
        List queriesWithMemory = (List)coordinator.getQueryManager().getQueries().stream().filter(query -> queryReservations.containsKey(query.getQueryId())).collect(ImmutableList.toImmutableList());
        StringBuilder result = new StringBuilder();
        queriesWithMemory.forEach(queryInfo -> {
            QueryId queryId = queryInfo.getQueryId();
            String querySql = queryInfo.getQuery();
            QueryState queryState = queryInfo.getState();
            Long memoryReservation = queryReservations.getOrDefault(queryId, 0L);
            Map taggedMemoryReservation = (Map)queryTaggedReservations.getOrDefault(queryId, ImmutableMap.of());
            result.append(" " + queryId + ":\n");
            result.append("   SQL: " + querySql + "\n");
            result.append("   state: " + queryState + "\n");
            result.append("   memoryReservation: " + memoryReservation + "\n");
            result.append("   taggedMemoryReservaton: " + taggedMemoryReservation + "\n");
        });
        return result.toString();
    }

    private void checkQueryInfosFinal() {
        this.tryGetDistributedQueryRunner().ifPresent(runner -> Assert.assertEventually((Duration)new Duration(30.0, TimeUnit.SECONDS), (Duration)new Duration(1.0, TimeUnit.SECONDS), () -> {
            TestingTrinoServer coordinator = runner.getCoordinator();
            QueryManager queryManager = coordinator.getQueryManager();
            for (BasicQueryInfo basicQueryInfo : queryManager.getQueries()) {
                QueryInfo queryInfo;
                QueryId queryId = basicQueryInfo.getQueryId();
                if (!basicQueryInfo.getState().isDone()) {
                    org.testng.Assert.fail((String)("query is expected to be in a done state\n\n" + AbstractTestQueryFramework.createQueryDebuggingSummary(basicQueryInfo, queryManager.getFullQueryInfo(queryId))));
                }
                if ((queryInfo = queryManager.getFullQueryInfo(queryId)).isFinalQueryInfo()) continue;
                org.testng.Assert.fail((String)("QueryInfo for is expected to be final\n\n" + AbstractTestQueryFramework.createQueryDebuggingSummary(basicQueryInfo, queryInfo)));
            }
        }));
    }

    private void checkTasksDone() {
        this.tryGetDistributedQueryRunner().ifPresent(runner -> Assert.assertEventually((Duration)new Duration(30.0, TimeUnit.SECONDS), (Duration)new Duration(1.0, TimeUnit.SECONDS), () -> {
            QueryManager queryManager = runner.getCoordinator().getQueryManager();
            List<TestingTrinoServer> servers = runner.getServers();
            for (TestingTrinoServer server : servers) {
                SqlTaskManager taskManager = server.getTaskManager();
                List taskInfos = taskManager.getAllTaskInfo();
                for (TaskInfo taskInfo : taskInfos) {
                    TaskId taskId = taskInfo.getTaskStatus().getTaskId();
                    QueryId queryId = taskId.getQueryId();
                    TaskState taskState = taskInfo.getTaskStatus().getState();
                    if (taskState.isDone()) continue;
                    try {
                        BasicQueryInfo basicQueryInfo = queryManager.getQueryInfo(queryId);
                        QueryInfo queryInfo = queryManager.getFullQueryInfo(queryId);
                        String querySummary = AbstractTestQueryFramework.createQueryDebuggingSummary(basicQueryInfo, queryInfo);
                        org.testng.Assert.fail((String)("Task is expected to be in done state, found: %s - TaskId: %s, QueryId: %s".formatted(taskState, taskId, queryId) + "\n\n" + querySummary));
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                    org.testng.Assert.fail((String)"Task is expected to be in done state, found: %s - TaskId: %s, QueryId: %s, Query: unknown".formatted(taskState, taskId, queryId));
                }
            }
        }));
    }

    private static String createQueryDebuggingSummary(BasicQueryInfo basicQueryInfo, QueryInfo queryInfo) {
        String queryDetails = String.format("Query %s [%s]: %s", basicQueryInfo.getQueryId(), basicQueryInfo.getState(), basicQueryInfo.getQuery());
        if (queryInfo.getOutputStage().isEmpty()) {
            return queryDetails + " -- <no output stage present>";
        }
        return queryDetails + StageInfo.getAllStages((Optional)queryInfo.getOutputStage()).stream().map(stageInfo -> {
            String stageDetail = String.format("Stage %s [%s]", stageInfo.getStageId(), stageInfo.getState());
            if (stageInfo.getTasks().isEmpty()) {
                return stageDetail;
            }
            return stageDetail + stageInfo.getTasks().stream().map(TaskInfo::getTaskStatus).map(task -> {
                String taskDetail = String.format("Task %s [%s]", task.getTaskId(), task.getState());
                if (task.getFailures().isEmpty()) {
                    return taskDetail;
                }
                return " -- Failures: " + task.getFailures().stream().map(failure -> String.format("%s %s: %s", failure.getErrorCode(), failure.getType(), failure.getMessage())).collect(Collectors.joining(", ", "[", "]"));
            }).collect(Collectors.joining("\n\t\t", ":\n\t\t", ""));
        }).collect(Collectors.joining("\n\n\t", "\nStages:\n\t", ""));
    }

    @Test
    public void ensureTestNamingConvention() {
        ((AbstractStringAssert)Assertions.assertThat((String)this.getClass().getName()).doesNotEndWith((CharSequence)"ConnectorTest")).doesNotEndWith((CharSequence)"ConnectorSmokeTest");
    }

    protected Session getSession() {
        return this.queryRunner.getDefaultSession();
    }

    protected final int getNodeCount() {
        return this.queryRunner.getNodeCount();
    }

    protected TransactionBuilder newTransaction() {
        return TransactionBuilder.transaction((TransactionManager)this.queryRunner.getTransactionManager(), (AccessControl)this.queryRunner.getAccessControl());
    }

    protected void inTransaction(Consumer<Session> callback) {
        this.newTransaction().execute(this.getSession(), callback);
    }

    protected MaterializedResult computeActual(@Language(value="SQL") String sql) {
        return this.computeActual(this.getSession(), sql);
    }

    protected MaterializedResult computeActual(Session session, @Language(value="SQL") String sql) {
        return this.queryRunner.execute(session, sql).toTestTypes();
    }

    protected Object computeScalar(@Language(value="SQL") String sql) {
        return this.computeScalar(this.getSession(), sql);
    }

    protected Object computeScalar(Session session, @Language(value="SQL") String sql) {
        return this.computeActual(session, sql).getOnlyValue();
    }

    protected AssertProvider<QueryAssertions.QueryAssert> query(@Language(value="SQL") String sql) {
        return this.query(this.getSession(), sql);
    }

    protected AssertProvider<QueryAssertions.QueryAssert> query(Session session, @Language(value="SQL") String sql) {
        return this.queryAssertions.query(session, sql);
    }

    protected void assertQuery(@Language(value="SQL") String sql) {
        this.assertQuery(this.getSession(), sql);
    }

    protected void assertQuery(Session session, @Language(value="SQL") String sql) {
        QueryAssertions.assertQuery(this.queryRunner, session, sql, this.h2QueryRunner, sql, false, false);
    }

    protected void assertQuery(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        QueryAssertions.assertQuery(this.queryRunner, this.getSession(), actual, this.h2QueryRunner, expected, false, false);
    }

    protected void assertQuery(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        QueryAssertions.assertQuery(this.queryRunner, session, actual, this.h2QueryRunner, expected, false, false);
    }

    protected void assertQuery(@Language(value="SQL") String actual, @Language(value="SQL") String expected, Consumer<Plan> planAssertion) {
        this.assertQuery(this.getSession(), actual, expected, planAssertion);
    }

    protected void assertQuery(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected, Consumer<Plan> planAssertion) {
        Preconditions.checkArgument((boolean)(this.queryRunner instanceof DistributedQueryRunner), (Object)"pattern assertion is only supported for DistributedQueryRunner");
        QueryAssertions.assertQuery(this.queryRunner, session, actual, this.h2QueryRunner, expected, false, false, planAssertion);
    }

    protected void assertQueryEventually(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected, Duration timeout) {
        QueryAssertions.assertQueryEventually(this.queryRunner, session, actual, this.h2QueryRunner, expected, false, false, Optional.empty(), timeout);
    }

    protected void assertQueryOrdered(@Language(value="SQL") String sql) {
        this.assertQueryOrdered(this.getSession(), sql);
    }

    protected void assertQueryOrdered(Session session, @Language(value="SQL") String sql) {
        this.assertQueryOrdered(session, sql, sql);
    }

    protected void assertQueryOrdered(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        this.assertQueryOrdered(this.getSession(), actual, expected);
    }

    protected void assertQueryOrdered(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        QueryAssertions.assertQuery(this.queryRunner, session, actual, this.h2QueryRunner, expected, true, false);
    }

    protected void assertUpdate(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        this.assertUpdate(this.getSession(), actual, expected);
    }

    protected void assertUpdate(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        QueryAssertions.assertQuery(this.queryRunner, session, actual, this.h2QueryRunner, expected, false, true);
    }

    protected void assertUpdate(@Language(value="SQL") String sql) {
        this.assertUpdate(this.getSession(), sql);
    }

    protected void assertUpdate(Session session, @Language(value="SQL") String sql) {
        QueryAssertions.assertUpdate(this.queryRunner, session, sql, OptionalLong.empty(), Optional.empty());
    }

    protected void assertUpdate(@Language(value="SQL") String sql, long count) {
        this.assertUpdate(this.getSession(), sql, count);
    }

    protected void assertUpdate(Session session, @Language(value="SQL") String sql, long count) {
        QueryAssertions.assertUpdate(this.queryRunner, session, sql, OptionalLong.of(count), Optional.empty());
    }

    protected void assertUpdate(Session session, @Language(value="SQL") String sql, long count, Consumer<Plan> planAssertion) {
        QueryAssertions.assertUpdate(this.queryRunner, session, sql, OptionalLong.of(count), Optional.of(planAssertion));
    }

    protected void assertQuerySucceeds(@Language(value="SQL") String sql) {
        this.assertQuerySucceeds(this.getSession(), sql);
    }

    protected void assertQuerySucceeds(Session session, @Language(value="SQL") String sql) {
        QueryAssertions.assertQuerySucceeds(this.queryRunner, session, sql);
    }

    protected void assertQueryFailsEventually(@Language(value="SQL") String sql, @Language(value="RegExp") String expectedMessageRegExp, Duration timeout) {
        QueryAssertions.assertQueryFailsEventually(this.queryRunner, this.getSession(), sql, expectedMessageRegExp, timeout);
    }

    protected void assertQueryFails(@Language(value="SQL") String sql, @Language(value="RegExp") String expectedMessageRegExp) {
        QueryAssertions.assertQueryFails(this.queryRunner, this.getSession(), sql, expectedMessageRegExp);
    }

    protected void assertQueryFails(Session session, @Language(value="SQL") String sql, @Language(value="RegExp") String expectedMessageRegExp) {
        QueryAssertions.assertQueryFails(this.queryRunner, session, sql, expectedMessageRegExp);
    }

    protected void assertQueryReturnsEmptyResult(@Language(value="SQL") String sql) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(sql))).returnsEmptyResult();
    }

    protected void assertQueryReturnsEmptyResult(Session session, @Language(value="SQL") String sql) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(session, sql))).returnsEmptyResult();
    }

    protected void assertAccessAllowed(@Language(value="SQL") String sql, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) {
        this.assertAccessAllowed(this.getSession(), sql, deniedPrivileges);
    }

    protected void assertAccessAllowed(Session session, @Language(value="SQL") String sql, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) {
        this.executeExclusively(session, sql, deniedPrivileges);
    }

    private void executeExclusively(Session session, @Language(value="SQL") String sql, TestingAccessControlManager.TestingPrivilege[] deniedPrivileges) {
        this.executeExclusively(() -> {
            try {
                this.queryRunner.getAccessControl().deny(deniedPrivileges);
                this.queryRunner.execute(session, sql);
            }
            finally {
                this.queryRunner.getAccessControl().reset();
            }
        });
    }

    protected void assertAccessDenied(@Language(value="SQL") String sql, @Language(value="RegExp") String exceptionsMessageRegExp, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) {
        this.assertAccessDenied(this.getSession(), sql, exceptionsMessageRegExp, deniedPrivileges);
    }

    protected void assertAccessDenied(Session session, @Language(value="SQL") String sql, @Language(value="RegExp") String exceptionsMessageRegExp, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) {
        this.assertException(session, sql, ".*Access Denied: " + exceptionsMessageRegExp, deniedPrivileges);
    }

    private void assertException(Session session, @Language(value="SQL") String sql, @Language(value="RegExp") String exceptionsMessageRegExp, TestingAccessControlManager.TestingPrivilege[] deniedPrivileges) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeExclusively(session, sql, deniedPrivileges)).as("Query: " + sql, new Object[0])).hasMessageMatching(exceptionsMessageRegExp);
    }

    protected void assertTableColumnNames(String tableName, String ... columnNames) {
        MaterializedResult result = this.computeActual("DESCRIBE " + tableName);
        List actual = (List)result.getMaterializedRows().stream().map(row -> (String)row.getField(0)).collect(ImmutableList.toImmutableList());
        ((ListAssert)Assertions.assertThat((List)actual).as("Columns of table %s", new Object[]{tableName})).isEqualTo(List.of(columnNames));
    }

    protected void assertExplain(@Language(value="SQL") String query, String ... expectedExplainRegExps) {
        this.assertExplain(this.getSession(), query, expectedExplainRegExps);
    }

    protected void assertExplain(Session session, @Language(value="SQL") String query, String ... expectedExplainRegExps) {
        this.assertExplainAnalyze(false, session, query, expectedExplainRegExps);
    }

    protected void assertExplainAnalyze(@Language(value="SQL") String query, String ... expectedExplainRegExps) {
        this.assertExplainAnalyze(this.getSession(), query, expectedExplainRegExps);
    }

    protected void assertExplainAnalyze(Session session, @Language(value="SQL") String query, String ... expectedExplainRegExps) {
        this.assertExplainAnalyze(true, session, query, expectedExplainRegExps);
    }

    private void assertExplainAnalyze(boolean analyze, Session session, @Language(value="SQL") String query, String ... expectedExplainRegExps) {
        String value = (String)this.computeActual(session, query).getOnlyValue();
        if (analyze) {
            Assertions.assertThat((String)value).containsPattern((CharSequence)"CPU:.*, Input:.*, Output");
        }
        for (String expectedExplainRegExp : expectedExplainRegExps) {
            Assertions.assertThat((String)value).containsPattern((CharSequence)expectedExplainRegExp);
        }
    }

    protected void assertQueryStats(Session session, @Language(value="SQL") String query, Consumer<QueryStats> queryStatsAssertion, Consumer<MaterializedResult> resultAssertion) {
        DistributedQueryRunner queryRunner = this.getDistributedQueryRunner();
        MaterializedResultWithQueryId resultWithQueryId = queryRunner.executeWithQueryId(session, query);
        QueryStats queryStats = queryRunner.getCoordinator().getQueryManager().getFullQueryInfo(resultWithQueryId.getQueryId()).getQueryStats();
        queryStatsAssertion.accept(queryStats);
        resultAssertion.accept(resultWithQueryId.getResult());
    }

    protected MaterializedResult computeExpected(@Language(value="SQL") String sql, List<? extends Type> resultTypes) {
        return this.h2QueryRunner.execute(this.getSession(), sql, resultTypes);
    }

    protected void executeExclusively(Runnable executionBlock) {
        this.queryRunner.getExclusiveLock().lock();
        try {
            executionBlock.run();
        }
        finally {
            this.queryRunner.getExclusiveLock().unlock();
        }
    }

    protected String formatSqlText(@Language(value="SQL") String sql) {
        return SqlFormatter.formatSql((Node)SQL_PARSER.createStatement(sql, ParsingUtil.createParsingOptions((Session)this.getSession())));
    }

    protected String getExplainPlan(@Language(value="SQL") String query, ExplainType.Type planType) {
        return this.getExplainPlan(this.getSession(), query, planType);
    }

    protected String getExplainPlan(Session session, @Language(value="SQL") String query, ExplainType.Type planType) {
        QueryExplainer explainer = this.queryRunner.getQueryExplainer();
        return (String)this.newTransaction().singleStatement().execute(session, transactionSession -> explainer.getPlan(transactionSession, SQL_PARSER.createStatement(query, ParsingUtil.createParsingOptions((Session)transactionSession)), planType, Collections.emptyList(), WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector()));
    }

    protected String getGraphvizExplainPlan(@Language(value="SQL") String query, ExplainType.Type planType) {
        QueryExplainer explainer = this.queryRunner.getQueryExplainer();
        return (String)this.newTransaction().singleStatement().execute(this.queryRunner.getDefaultSession(), session -> explainer.getGraphvizPlan(session, SQL_PARSER.createStatement(query, ParsingUtil.createParsingOptions((Session)session)), planType, Collections.emptyList(), WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector()));
    }

    protected static void skipTestUnless(boolean requirement) {
        if (!requirement) {
            throw new SkipException("requirement not met");
        }
    }

    protected final QueryRunner getQueryRunner() {
        Preconditions.checkState((this.queryRunner != null ? 1 : 0) != 0, (Object)"queryRunner not set");
        return this.queryRunner;
    }

    protected final DistributedQueryRunner getDistributedQueryRunner() {
        Preconditions.checkState((this.queryRunner != null ? 1 : 0) != 0, (Object)"queryRunner not set");
        Preconditions.checkState((boolean)(this.queryRunner instanceof DistributedQueryRunner), (String)"queryRunner is not a DistributedQueryRunner: %s [%s]", (Object)this.queryRunner, this.queryRunner.getClass());
        return (DistributedQueryRunner)this.queryRunner;
    }

    private Optional<DistributedQueryRunner> tryGetDistributedQueryRunner() {
        QueryRunner queryRunner;
        if (this.queryRunner != null && (queryRunner = this.queryRunner) instanceof DistributedQueryRunner) {
            DistributedQueryRunner runner = (DistributedQueryRunner)queryRunner;
            return Optional.of(runner);
        }
        return Optional.empty();
    }

    protected Session noJoinReordering() {
        return this.noJoinReordering(OptimizerConfig.JoinDistributionType.PARTITIONED);
    }

    protected Session noJoinReordering(OptimizerConfig.JoinDistributionType distributionType) {
        return Session.builder((Session)this.getSession()).setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", distributionType.name()).build();
    }

    protected OperatorStats searchScanFilterAndProjectOperatorStats(QueryId queryId, QualifiedObjectName catalogSchemaTableName) {
        DistributedQueryRunner runner = this.getDistributedQueryRunner();
        Plan plan = runner.getQueryPlan(queryId);
        PlanNodeId nodeId = PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> {
            if (!(node instanceof ProjectNode)) {
                return false;
            }
            ProjectNode projectNode = (ProjectNode)node;
            PlanNode patt28122$temp = projectNode.getSource();
            if (!(patt28122$temp instanceof FilterNode)) {
                return false;
            }
            FilterNode filterNode = (FilterNode)patt28122$temp;
            PlanNode patt28268$temp = filterNode.getSource();
            if (!(patt28268$temp instanceof TableScanNode)) {
                return false;
            }
            TableScanNode tableScanNode = (TableScanNode)patt28268$temp;
            TableMetadata tableMetadata = this.getTableMetadata(tableScanNode.getTable());
            return tableMetadata.getQualifiedName().equals((Object)catalogSchemaTableName);
        }).findOnlyElement().getId();
        return (OperatorStats)this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(queryId).getQueryStats().getOperatorSummaries().stream().filter(summary -> nodeId.equals((Object)summary.getPlanNodeId()) && summary.getOperatorType().equals("ScanFilterAndProjectOperator")).collect(MoreCollectors.onlyElement());
    }

    protected DynamicFilterService.DynamicFiltersStats getDynamicFilteringStats(QueryId queryId) {
        return this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(queryId).getQueryStats().getDynamicFiltersStats();
    }

    protected QualifiedObjectName getQualifiedTableName(String tableName) {
        Session session = this.getQueryRunner().getDefaultSession();
        return new QualifiedObjectName((String)session.getCatalog().orElseThrow(), (String)session.getSchema().orElseThrow(), tableName);
    }

    private TableMetadata getTableMetadata(TableHandle tableHandle) {
        return this.inTransaction(this.getSession(), transactionSession -> {
            this.getQueryRunner().getMetadata().getCatalogHandle(transactionSession, tableHandle.getCatalogHandle().getCatalogName());
            return this.getQueryRunner().getMetadata().getTableMetadata(transactionSession, tableHandle);
        });
    }

    private <T> T inTransaction(Session session, Function<Session, T> transactionSessionConsumer) {
        return (T)TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).singleStatement().execute(session, transactionSessionConsumer);
    }

    @CanIgnoreReturnValue
    protected final <T extends AutoCloseable> T closeAfterClass(T resource) {
        Preconditions.checkState((this.afterClassCloser != null ? 1 : 0) != 0, (Object)"closeAfterClass invoked before test is initialized or after it is torn down. In particular, make sure you do not allocate any resources in a test class constructor, as this can easily lead to OutOfMemoryErrors and other types of test flakiness.");
        return (T)this.afterClassCloser.register(resource);
    }
}

