/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.statistics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import java.util.Map;
import java.util.Objects;

public class StatsContext {
    private final Map<String, Symbol> columnSymbols;
    private final TypeProvider types;

    public StatsContext(Map<String, Symbol> columnSymbols, TypeProvider types) {
        this.columnSymbols = ImmutableMap.copyOf(columnSymbols);
        this.types = Objects.requireNonNull(types, "types is null");
    }

    public Symbol getSymbolForColumn(String columnName) {
        Preconditions.checkArgument((boolean)this.columnSymbols.containsKey(columnName), (Object)("no symbol found for column '" + columnName + "'"));
        return this.columnSymbols.get(columnName);
    }

    public Type getTypeForSymbol(Symbol symbol) {
        return this.types.get(symbol);
    }
}

