/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.cost.StatsCalculator;
import io.trino.execution.FailureInjector;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.SessionPropertyManager;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.ErrorType;
import io.trino.spi.Plugin;
import io.trino.spi.type.TypeManager;
import io.trino.split.PageSourceManager;
import io.trino.split.SplitManager;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.testing.AbstractTestQueries;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingGroupProvider;
import io.trino.testing.TestingTrinoClient;
import io.trino.transaction.TransactionManager;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.intellij.lang.annotations.Language;

public final class StandaloneQueryRunner
implements QueryRunner {
    private final TestingTrinoServer server;
    private final TestingTrinoClient trinoClient;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public StandaloneQueryRunner(Session defaultSession) {
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        this.server = StandaloneQueryRunner.createTestingTrinoServer();
        this.trinoClient = new TestingTrinoClient(this.server, defaultSession);
        this.server.addFunctions(AbstractTestQueries.CUSTOM_FUNCTIONS);
    }

    public MaterializedResult execute(@Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.trinoClient.execute(sql).getResult();
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.trinoClient.execute(session, sql).getResult();
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void close() {
        try {
            Closeables.closeAll((Closeable[])new Closeable[]{this.trinoClient, this.server});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getNodeCount() {
        return 1;
    }

    public Session getDefaultSession() {
        return this.trinoClient.getDefaultSession();
    }

    public TransactionManager getTransactionManager() {
        return this.server.getTransactionManager();
    }

    public Metadata getMetadata() {
        return this.server.getMetadata();
    }

    public TypeManager getTypeManager() {
        return this.server.getTypeManager();
    }

    public QueryExplainer getQueryExplainer() {
        return this.server.getQueryExplainer();
    }

    public SessionPropertyManager getSessionPropertyManager() {
        return this.server.getSessionPropertyManager();
    }

    public FunctionManager getFunctionManager() {
        return this.server.getFunctionManager();
    }

    public SplitManager getSplitManager() {
        return this.server.getSplitManager();
    }

    public PageSourceManager getPageSourceManager() {
        return this.server.getPageSourceManager();
    }

    public NodePartitioningManager getNodePartitioningManager() {
        return this.server.getNodePartitioningManager();
    }

    public StatsCalculator getStatsCalculator() {
        return this.server.getStatsCalculator();
    }

    public TestingGroupProvider getGroupProvider() {
        return this.server.getGroupProvider();
    }

    public TestingAccessControlManager getAccessControl() {
        return this.server.getAccessControl();
    }

    public TestingTrinoServer getServer() {
        return this.server;
    }

    public void installPlugin(Plugin plugin) {
        this.server.installPlugin(plugin);
    }

    public void addFunctions(FunctionBundle functionBundle) {
        this.server.addFunctions(functionBundle);
    }

    public void createCatalog(String catalogName, String connectorName) {
        this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        this.server.createCatalog(catalogName, connectorName, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List<QualifiedObjectName> list = this.trinoClient.listTables(session, catalog, schema);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.trinoClient.tableExists(session, table);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    public void injectTaskFailure(String traceToken, int stageId, int partitionId, int attemptId, FailureInjector.InjectedFailureType injectionType, Optional<ErrorType> errorType) {
        this.server.injectTaskFailure(traceToken, stageId, partitionId, attemptId, injectionType, errorType);
    }

    public void loadExchangeManager(String name, Map<String, String> properties) {
        this.server.loadExchangeManager(name, properties);
    }

    private static TestingTrinoServer createTestingTrinoServer() {
        return TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().put((Object)"query.client.timeout", (Object)"10m").put((Object)"exchange.http-client.idle-timeout", (Object)"1h").put((Object)"node-scheduler.min-candidates", (Object)"1").buildOrThrow()).build();
    }
}

