/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.datatype;

import com.google.common.base.Preconditions;
import io.airlift.testing.Closeables;
import io.trino.testing.datatype.ColumnSetup;
import io.trino.testing.datatype.DataSetup;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TrinoSqlExecutor;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CreateAndInsertDataSetup
implements DataSetup {
    private final SqlExecutor sqlExecutor;
    private final String tableNamePrefix;

    public CreateAndInsertDataSetup(SqlExecutor sqlExecutor, String tableNamePrefix) {
        this.sqlExecutor = sqlExecutor;
        this.tableNamePrefix = tableNamePrefix;
    }

    @Override
    public TestTable setupTestTable(List<ColumnSetup> inputs) {
        TestTable testTable = this.createTestTable(inputs);
        try {
            this.insertRows(testTable, inputs);
        }
        catch (Exception e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{testTable});
            throw e;
        }
        return testTable;
    }

    private void insertRows(TestTable testTable, List<ColumnSetup> inputs) {
        String valueLiterals = inputs.stream().map(ColumnSetup::getInputLiteral).collect(Collectors.joining(", "));
        this.sqlExecutor.execute(String.format("INSERT INTO %s VALUES(%s)", testTable.getName(), valueLiterals));
    }

    private TestTable createTestTable(List<ColumnSetup> inputs) {
        return new TestTable(this.sqlExecutor, this.tableNamePrefix, this.tableDefinition(inputs));
    }

    protected String tableDefinition(List<ColumnSetup> inputs) {
        if (inputs.stream().allMatch(input -> input.getDeclaredType().isPresent())) {
            return IntStream.range(0, inputs.size()).mapToObj(column -> String.format("col_%d %s", column, ((ColumnSetup)inputs.get(column)).getDeclaredType().orElseThrow())).collect(Collectors.joining(",\n", "(\n", ")"));
        }
        Preconditions.checkState((boolean)(this.sqlExecutor instanceof TrinoSqlExecutor), (Object)"Explicit declared input types are required when creating a table from any non-Trino system to prevent confusion between different systems' type literals.");
        return IntStream.range(0, inputs.size()).mapToObj(column -> {
            ColumnSetup input = (ColumnSetup)inputs.get(column);
            if (input.getDeclaredType().isEmpty()) {
                return String.format("%s AS col_%d", input.getInputLiteral(), column);
            }
            return String.format("CAST(%s AS %s) AS col_%d", input.getInputLiteral(), input.getDeclaredType().get(), column);
        }).collect(Collectors.joining(",\n", "AS\nSELECT\n", "\nWHERE 'with no' = 'data'"));
    }
}

