/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import io.trino.Session;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.sql.TestTable;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.Test;

public abstract class BaseOrcWithBloomFiltersTest
extends AbstractTestQueryFramework {
    protected abstract String getTableProperties(String var1, String var2);

    @Test
    public void testOrcBloomFilterIsWrittenDuringCreate() {
        String tableName = "create_orc_with_bloom_filters_" + TestTable.randomTableSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s WITH (%s) AS SELECT orderstatus, totalprice FROM tpch.tiny.orders", tableName, this.getTableProperties("totalprice", "orderstatus")), 15000L);
        this.assertBloomFilterBasedRowGroupPruning(String.format("SELECT * FROM %s WHERE totalprice = 51890", tableName));
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testOrcBloomFilterIsWrittenDuringInsert() {
        String tableName = "insert_orc_with_bloom_filters_" + TestTable.randomTableSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (totalprice DOUBLE, orderstatus VARCHAR) WITH (%s)", tableName, this.getTableProperties("totalprice", "orderstatus")));
        this.assertUpdate(String.format("INSERT INTO %s SELECT totalprice, orderstatus FROM tpch.tiny.orders", tableName), 15000L);
        this.assertBloomFilterBasedRowGroupPruning(String.format("SELECT * FROM %s WHERE totalprice = 51890", tableName));
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private void assertBloomFilterBasedRowGroupPruning(@Language(value="SQL") String sql) {
        this.assertQueryStats(this.disableBloomFilters(this.getSession()), sql, queryStats -> {
            Assertions.assertThat((long)queryStats.getPhysicalInputPositions()).isGreaterThan(0L);
            Assertions.assertThat((long)queryStats.getProcessedInputPositions()).isEqualTo(queryStats.getPhysicalInputPositions());
        }, results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
        this.assertQueryStats(this.getSession(), sql, queryStats -> {
            Assertions.assertThat((long)queryStats.getPhysicalInputPositions()).isEqualTo(0L);
            Assertions.assertThat((long)queryStats.getProcessedInputPositions()).isEqualTo(0L);
        }, results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
    }

    private Session disableBloomFilters(Session session) {
        return Session.builder((Session)session).setCatalogSessionProperty((String)session.getCatalog().orElseThrow(), "orc_bloom_filters_enabled", "false").build();
    }
}

