/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.concurrent.MoreFutures;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.cost.StatsAndCosts;
import io.trino.dispatcher.DispatchManager;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryManager;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.server.BasicQueryInfo;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueries;
import io.trino.testing.DataProviders;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.ResultWithQueryId;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.assertions.Assert;
import io.trino.testing.sql.TestTable;
import io.trino.transaction.TransactionBuilder;
import io.trino.transaction.TransactionManager;
import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class BaseConnectorTest
extends AbstractTestQueries {
    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return connectorBehavior.hasBehaviorByDefault(this::hasBehavior);
    }

    @Override
    @Test
    public void ensureTestNamingConvention() {
        Assertions.assertThat((String)this.getClass().getName()).endsWith((CharSequence)"ConnectorTest");
    }

    @Test
    public void ensureDistributedQueryRunner() {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.getQueryRunner().getNodeCount()).as("query runner node count", new Object[0])).isGreaterThanOrEqualTo(3);
    }

    @Test
    public void testShowCreateSchema() {
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE SCHEMA " + schemaName))).isEqualTo(String.format("CREATE SCHEMA %s.%s", this.getSession().getCatalog().orElseThrow(), schemaName));
    }

    @Test
    public void testCreateSchema() {
        String schemaName = "test_schema_create_" + TestTable.randomTableSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            this.assertQueryFails(this.createSchemaSql(schemaName), "This connector does not support creating schemas");
            return;
        }
        Assertions.assertThat((Iterable)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).doesNotContain(new Object[]{schemaName});
        this.assertUpdate(this.createSchemaSql(schemaName));
        Assertions.assertThat((Iterable)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).contains(new Object[]{schemaName});
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE SCHEMA " + schemaName))).startsWith((CharSequence)String.format("CREATE SCHEMA %s.%s", this.getSession().getCatalog().orElseThrow(), schemaName));
        this.assertQueryFails(this.createSchemaSql(schemaName), String.format("line 1:1: Schema '.*\\.%s' already exists", schemaName));
        this.assertUpdate("DROP SCHEMA " + schemaName);
        this.assertQueryFails("DROP SCHEMA " + schemaName, String.format("line 1:1: Schema '.*\\.%s' does not exist", schemaName));
    }

    @Test
    public void testDropNonEmptySchemaWithTable() {
        String schemaName = "test_drop_non_empty_schema_table_" + TestTable.randomTableSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            return;
        }
        try {
            this.assertUpdate("CREATE SCHEMA " + schemaName);
            this.assertUpdate("CREATE TABLE " + schemaName + ".t(x int)");
            this.assertQueryFails("DROP SCHEMA " + schemaName, ".*Cannot drop non-empty schema '\\Q" + schemaName + "\\E'");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + schemaName + ".t");
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName);
        }
    }

    @Test
    public void testDropNonEmptySchemaWithView() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            return;
        }
        String schemaName = "test_drop_non_empty_schema_view_" + TestTable.randomTableSuffix();
        try {
            this.assertUpdate("CREATE SCHEMA " + schemaName);
            this.assertUpdate("CREATE VIEW " + schemaName + ".v_t  AS SELECT 123 x");
            this.assertQueryFails("DROP SCHEMA " + schemaName, ".*Cannot drop non-empty schema '\\Q" + schemaName + "\\E'");
        }
        finally {
            this.assertUpdate("DROP VIEW IF EXISTS " + schemaName + ".v_t");
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName);
        }
    }

    @Test
    public void testDropNonEmptySchemaWithMaterializedView() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            return;
        }
        String schemaName = "test_drop_non_empty_schema_mv_" + TestTable.randomTableSuffix();
        try {
            this.assertUpdate("CREATE SCHEMA " + schemaName);
            this.assertUpdate("CREATE MATERIALIZED VIEW " + schemaName + ".mv_t  AS SELECT 123 x");
            this.assertQueryFails("DROP SCHEMA " + schemaName, ".*Cannot drop non-empty schema '\\Q" + schemaName + "\\E'");
        }
        finally {
            this.assertUpdate("DROP MATERIALIZED VIEW IF EXISTS " + schemaName + ".mv_t");
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName);
        }
    }

    @Test
    public void testColumnsInReverseOrder() {
        this.assertQuery("SELECT shippriority, clerk, totalprice FROM orders");
    }

    @Test
    public void testCharVarcharComparison() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_char_varchar", "(k, v) AS VALUES   (-1, CAST(NULL AS char(3))),    (3, CAST('   ' AS char(3))),   (6, CAST('x  ' AS char(3)))");){
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('  ' AS varchar(2))", "VALUES (3, '   ')");
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('  ' AS varchar(4))", "VALUES (3, '   ')");
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('x ' AS varchar(2))", "VALUES (6, 'x  ')");
        }
    }

    @Test
    public void testVarcharCharComparison() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_varchar_char", "(k, v) AS VALUES   (-1, CAST(NULL AS varchar(3))),    (0, CAST('' AS varchar(3))),   (1, CAST(' ' AS varchar(3))),    (2, CAST('  ' AS varchar(3))),    (3, CAST('   ' AS varchar(3))),   (4, CAST('x' AS varchar(3))),   (5, CAST('x ' AS varchar(3))),   (6, CAST('x  ' AS varchar(3)))");){
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('  ' AS char(2))", "VALUES (0, ''), (1, ' '), (2, '  '), (3, '   ')");
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('x ' AS char(2))", "VALUES (4, 'x'), (5, 'x '), (6, 'x  ')");
        }
    }

    @Test
    public void testAggregation() {
        this.assertQuery("SELECT sum(orderkey) FROM orders");
        this.assertQuery("SELECT sum(totalprice) FROM orders");
        this.assertQuery("SELECT max(comment) FROM nation");
        this.assertQuery("SELECT count(*) FROM orders");
        this.assertQuery("SELECT count(*) FROM orders WHERE orderkey > 10");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders LIMIT 10)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders WHERE orderkey > 10 LIMIT 10)");
        this.assertQuery("SELECT DISTINCT regionkey FROM nation");
        this.assertQuery("SELECT regionkey FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT regionkey, nationkey FROM nation GROUP BY GROUPING SETS ((regionkey), (nationkey))", "SELECT NULL, nationkey FROM nation UNION ALL SELECT DISTINCT regionkey, NULL FROM nation");
        this.assertQuery("SELECT regionkey, nationkey, count(*) FROM nation GROUP BY GROUPING SETS ((), (regionkey), (nationkey), (regionkey, nationkey))", "SELECT NULL, NULL, count(*) FROM nation UNION ALL SELECT NULL, nationkey, 1 FROM nation UNION ALL SELECT regionkey, NULL, count(*) FROM nation GROUP BY regionkey UNION ALL SELECT regionkey, nationkey, 1 FROM nation");
        this.assertQuery("SELECT count(regionkey) FROM nation");
        this.assertQuery("SELECT count(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, count(*) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT min(regionkey), max(regionkey) FROM nation");
        this.assertQuery("SELECT min(DISTINCT regionkey), max(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, min(regionkey), min(name), max(regionkey), max(name) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT sum(regionkey) FROM nation");
        this.assertQuery("SELECT sum(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, sum(regionkey) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT avg(nationkey) FROM nation", "SELECT avg(CAST(nationkey AS double)) FROM nation");
        this.assertQuery("SELECT avg(DISTINCT nationkey) FROM nation", "SELECT avg(DISTINCT CAST(nationkey AS double)) FROM nation");
        this.assertQuery("SELECT regionkey, avg(nationkey) FROM nation GROUP BY regionkey", "SELECT regionkey, avg(CAST(nationkey AS double)) FROM nation GROUP BY regionkey");
    }

    @Test
    public void testExactPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey = 10");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey = 32", "VALUES (1301, 32)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey = 32", "VALUES (1301)");
    }

    @Test
    public void testInListPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey IN (10, 11, 20, 21)");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey IN (7, 10, 32, 33)", "VALUES (392, 7), (1301, 32), (670, 33)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey IN (7, 10, 32, 33)", "VALUES (392), (1301), (670)");
    }

    @Test
    public void testIsNullPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey IS NULL");
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey = 10 OR orderkey IS NULL");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey = 32 OR orderkey IS NULL", "VALUES (1301, 32)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey = 32 OR orderkey IS NULL", "VALUES (1301)");
    }

    @Test
    public void testLikePredicate() {
        this.assertQuery("SELECT orderkey FROM orders WHERE orderpriority LIKE '5-L%'");
        this.assertQuery("SELECT orderkey, orderpriority FROM orders WHERE orderpriority LIKE '5-L%'");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderpriority LIKE '5-L__'");
        this.assertQuery("SELECT orderkey, orderpriority FROM orders WHERE orderpriority LIKE '5-L__'");
    }

    @Test
    public void testMultipleRangesPredicate() {
        this.assertQuery("SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders WHERE orderkey BETWEEN 10 AND 50");
    }

    @Test
    public void testRangePredicate() {
        this.assertQuery("SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders WHERE orderkey BETWEEN 10 AND 50");
    }

    @Test
    public void testDateYearOfEraPredicate() {
        this.assertQuery("SELECT orderdate FROM orders WHERE orderdate = DATE '1997-09-14'", "VALUES DATE '1997-09-14'");
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderdate = DATE '-1996-09-14'");
    }

    @Test
    public void testPredicateReflectedInExplain() {
        this.assertExplain("EXPLAIN SELECT name FROM nation WHERE nationkey = 42", "(predicate|filterPredicate|constraint).{0,10}(nationkey|NATIONKEY)");
    }

    @Test
    public void testSortItemsReflectedInExplain() {
        String expectedPattern = this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN) ? "sortOrder=\\[(?i:nationkey):.* DESC NULLS LAST] limit=5" : "\\[5 by \\((?i:nationkey) DESC NULLS LAST\\)]";
        this.assertExplain("EXPLAIN SELECT name FROM nation ORDER BY nationkey DESC NULLS LAST LIMIT 5", expectedPattern);
    }

    @Test
    public void testConcurrentScans() {
        String unionMultipleTimes = String.join((CharSequence)" UNION ALL ", Collections.nCopies(25, "SELECT * FROM orders"));
        this.assertQuery("SELECT sum(if(rand() >= 0, orderkey)) FROM (" + unionMultipleTimes + ")", "VALUES 11246812500");
    }

    @Test
    public void testSelectAll() {
        this.assertQuery("SELECT * FROM orders");
    }

    @Test
    public void testSelectInTransaction() {
        this.inTransaction(session -> {
            this.assertQuery((Session)session, "SELECT nationkey, name, regionkey FROM nation");
            this.assertQuery((Session)session, "SELECT regionkey, name FROM region");
            this.assertQuery((Session)session, "SELECT nationkey, name, regionkey FROM nation");
        });
    }

    @Test(timeOut=300000L, dataProvider="joinDistributionTypes")
    public void testJoinWithEmptySides(OptimizerConfig.JoinDistributionType joinDistributionType) {
        Session session = this.noJoinReordering(joinDistributionType);
        this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.name = ''", "VALUES 0");
        this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.regionkey < 0", "VALUES 0");
        this.assertQuery(session, "SELECT count(*) FROM region JOIN nation ON nation.regionkey = region.regionkey AND region.name = ''", "VALUES 0");
        this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.regionkey < 0", "VALUES 0");
    }

    @DataProvider
    public Object[][] joinDistributionTypes() {
        return (Object[][])Stream.of(OptimizerConfig.JoinDistributionType.values()).collect(DataProviders.toDataProvider());
    }

    @Test
    public void testJoin() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("ignore_stats_calculator_failures", "false").build();
        this.assertQuery(session, "SELECT c.name, n.name, r.name FROM nation n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey");
        this.assertQuery(session, "SELECT c.name, n.name, r.name FROM nation n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey WHERE n.name = 'ARGENTINA'");
        this.assertQuery(session, "SELECT c.name, n.name, n.count, r.name FROM (SELECT name, regionkey, nationkey, count(*) count FROM nation GROUP BY name, regionkey, nationkey) n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey");
    }

    @Test
    public void testDescribeTable() {
        MaterializedResult expectedColumns = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar(1)", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar(15)", "", ""}).row(new Object[]{"clerk", "varchar(15)", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar(79)", "", ""}).build();
        MaterializedResult actualColumns = this.computeActual("DESCRIBE orders");
        Assert.assertEquals((Iterable)actualColumns, (Iterable)expectedColumns);
    }

    @Test
    public void testView() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
            this.assertQueryFails("CREATE VIEW nation_v AS SELECT * FROM nation", "This connector does not support creating views");
            return;
        }
        String query = "SELECT orderkey, orderstatus, (totalprice / 2) half FROM orders";
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        String testView = "test_view_" + TestTable.randomTableSuffix();
        String testViewWithComment = "test_view_with_comment_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE VIEW " + testView + " AS SELECT 123 x");
        this.assertUpdate("CREATE OR REPLACE VIEW " + testView + " AS " + query);
        this.assertUpdate("CREATE VIEW " + testViewWithComment + " COMMENT 'orders' AS SELECT 123 x");
        this.assertUpdate("CREATE OR REPLACE VIEW " + testViewWithComment + " COMMENT 'orders' AS " + query);
        MaterializedResult materializedRows = this.computeActual("SHOW CREATE VIEW " + testViewWithComment);
        Assertions.assertThat((String)((String)materializedRows.getOnlyValue())).contains(new CharSequence[]{"COMMENT 'orders'"});
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, comment FROM system.metadata.table_comments WHERE catalog_name = '" + catalogName + "' AND schema_name = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES ('" + testView + "', null), ('" + testViewWithComment + "', 'orders')");
        this.assertQuery("SELECT * FROM " + testView, query);
        this.assertQuery("SELECT * FROM " + testViewWithComment, query);
        this.assertQuery("SELECT * FROM " + testView + " a JOIN " + testView + " b on a.orderkey = b.orderkey", String.format("SELECT * FROM (%s) a JOIN (%s) b ON a.orderkey = b.orderkey", query, query));
        this.assertQuery("WITH orders AS (SELECT * FROM orders LIMIT 0) SELECT * FROM " + testView, query);
        String name = String.format("%s.%s." + testView, catalogName, schemaName);
        this.assertQuery("SELECT * FROM " + name, query);
        this.assertUpdate("DROP VIEW " + testViewWithComment);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, regexp_replace(view_definition, '\\s', '') FROM information_schema.views WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES ('" + testView + "', '" + query.replaceAll("\\s", "") + "')");
        this.assertQuery("SELECT table_name, regexp_replace(view_definition, '\\s', '') FROM information_schema.views WHERE table_schema = '" + schemaName + "' and table_name = '" + testView + "'", "VALUES ('" + testView + "', '" + query.replaceAll("\\s", "") + "')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES"))).skippingTypesCheck().containsAll("VALUES '" + testView + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES ('" + testView + "', 'VIEW')");
        this.assertQuery("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '" + schemaName + "' and table_name = '" + testView + "'", "VALUES ('" + testView + "', 'VIEW')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, table_type FROM system.jdbc.tables"))).skippingTypesCheck().containsAll("VALUES ('" + schemaName + "', '" + testView + "', 'VIEW')");
        this.assertQuery("SELECT table_schem, table_name, table_type FROM system.jdbc.tables WHERE table_cat = '" + catalogName + "' AND table_schem = '" + schemaName + "' AND table_name = '" + testView + "'", "VALUES ('" + schemaName + "', '" + testView + "', 'VIEW')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW COLUMNS FROM " + testView))).projected(new int[]{0}).skippingTypesCheck().matches("VALUES 'orderkey', 'orderstatus', 'half'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("DESCRIBE " + testView))).projected(new int[]{0}).skippingTypesCheck().matches("VALUES 'orderkey', 'orderstatus', 'half'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES '" + testView + "') CROSS JOIN UNNEST(ARRAY['orderkey', 'orderstatus', 'half'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schemaName + "' and table_name = '" + testView + "'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES '" + testView + "') CROSS JOIN UNNEST(ARRAY['orderkey', 'orderstatus', 'half'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name FROM information_schema.views WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES '" + testView + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + schemaName + "', '" + testView + "')) CROSS JOIN UNNEST(ARRAY['orderkey', 'orderstatus', 'half'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_schem LIKE '%" + schemaName + "%'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + schemaName + "', '" + testView + "')) CROSS JOIN UNNEST(ARRAY['orderkey', 'orderstatus', 'half'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_name LIKE '%" + testView + "%'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + schemaName + "', '" + testView + "')) CROSS JOIN UNNEST(ARRAY['orderkey', 'orderstatus', 'half'])");
        this.assertUpdate("DROP VIEW " + testView);
    }

    @Test
    public void testViewCaseSensitivity() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        String upperCaseView = "test_view_uppercase_" + TestTable.randomTableSuffix();
        String mixedCaseView = "test_view_mixedcase_" + TestTable.randomTableSuffix();
        this.computeActual("CREATE VIEW " + upperCaseView + " AS SELECT X FROM (SELECT 123 X)");
        this.computeActual("CREATE VIEW " + mixedCaseView + " AS SELECT XyZ FROM (SELECT 456 XyZ)");
        this.assertQuery("SELECT * FROM " + upperCaseView, "SELECT X FROM (SELECT 123 X)");
        this.assertQuery("SELECT * FROM " + mixedCaseView, "SELECT XyZ FROM (SELECT 456 XyZ)");
        this.assertUpdate("DROP VIEW " + upperCaseView);
        this.assertUpdate("DROP VIEW " + mixedCaseView);
    }

    @Test
    public void testMaterializedView() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW)) {
            this.assertQueryFails("CREATE MATERIALIZED VIEW nation_mv AS SELECT * FROM nation", "This connector does not support creating materialized views");
            return;
        }
        QualifiedObjectName view = new QualifiedObjectName((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), "test_materialized_view_" + TestTable.randomTableSuffix());
        QualifiedObjectName otherView = new QualifiedObjectName((String)this.getSession().getCatalog().orElseThrow(), "other_schema", "test_materialized_view_" + TestTable.randomTableSuffix());
        QualifiedObjectName viewWithComment = new QualifiedObjectName((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), "test_materialized_view_with_comment_" + TestTable.randomTableSuffix());
        this.createTestingMaterializedView(view, Optional.empty());
        this.createTestingMaterializedView(otherView, Optional.of("sarcastic comment"));
        this.createTestingMaterializedView(viewWithComment, Optional.of("mv_comment"));
        MaterializedResult materializedRows = this.computeActual("SHOW CREATE MATERIALIZED VIEW " + viewWithComment);
        Assertions.assertThat((String)((String)materializedRows.getOnlyValue())).contains(new CharSequence[]{"COMMENT 'mv_comment'"});
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, comment FROM system.metadata.table_comments WHERE catalog_name = '" + view.getCatalogName() + "' AND schema_name = '" + view.getSchemaName() + "'"))).skippingTypesCheck().containsAll("VALUES ('" + view.getObjectName() + "', null), ('" + viewWithComment.getObjectName() + "', 'mv_comment')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + view))).skippingTypesCheck().matches("SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + viewWithComment))).skippingTypesCheck().matches("SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES"))).skippingTypesCheck().containsAll("VALUES '" + view.getObjectName() + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '" + view.getSchemaName() + "'"))).skippingTypesCheck().containsAll("VALUES ('" + view.getObjectName() + "', 'BASE TABLE')");
        this.assertQuery("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '" + view.getSchemaName() + "' and table_name = '" + view.getObjectName() + "'", "VALUES ('" + view.getObjectName() + "', 'BASE TABLE')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, table_type FROM system.jdbc.tables"))).skippingTypesCheck().containsAll("VALUES ('" + view.getSchemaName() + "', '" + view.getObjectName() + "', 'TABLE')");
        this.assertQuery("SELECT table_schem, table_name, table_type FROM system.jdbc.tables WHERE table_cat = '" + view.getCatalogName() + "' AND table_schem = '" + view.getSchemaName() + "' AND table_name = '" + view.getObjectName() + "'", "VALUES ('" + view.getSchemaName() + "', '" + view.getObjectName() + "', 'TABLE')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW COLUMNS FROM " + view.getObjectName()))).projected(new int[]{0}).skippingTypesCheck().matches("VALUES 'nationkey', 'name', 'regionkey', 'comment'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("DESCRIBE " + view.getObjectName()))).projected(new int[]{0}).skippingTypesCheck().matches("VALUES 'nationkey', 'name', 'regionkey', 'comment'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + view.getSchemaName() + "'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES '" + view.getObjectName() + "') CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + view.getSchemaName() + "' and table_name = '" + view.getObjectName() + "'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES '" + view.getObjectName() + "') CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        this.checkInformationSchemaViewsForMaterializedView(view.getSchemaName(), view.getObjectName());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + view.getSchemaName() + "', '" + view.getObjectName() + "')) CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_schem LIKE '%" + view.getSchemaName() + "%'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + view.getSchemaName() + "', '" + view.getObjectName() + "')) CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_name LIKE '%" + view.getObjectName() + "%'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + view.getSchemaName() + "', '" + view.getObjectName() + "')) CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE MATERIALIZED VIEW " + view.getObjectName()))).matches((CharSequence)("(?s)CREATE MATERIALIZED VIEW \\Q" + view + "\\E.* AS\nSELECT \\*\nFROM\n  nation"));
        this.assertUpdate("DROP MATERIALIZED VIEW " + viewWithComment);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("catalog_name = '" + view.getCatalogName() + "'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRows(view, otherView));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("catalog_name = '" + otherView.getCatalogName() + "'", "schema_name = '" + otherView.getSchemaName() + "'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRow(otherView, "sarcastic comment"));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("catalog_name = '" + view.getCatalogName() + "'", "schema_name = '" + view.getSchemaName() + "'", "name = '" + view.getObjectName() + "'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRow(view, ""));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("schema_name LIKE '%" + view.getSchemaName() + "%'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRow(view, ""));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("name LIKE '%" + view.getObjectName() + "%'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRow(view, ""));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES)) {
            Assertions.assertThatThrownBy(() -> this.inTransaction(session -> this.computeActual((Session)session, "REFRESH MATERIALIZED VIEW " + view))).hasMessageMatching("Catalog only supports writes using autocommit: \\w+");
        }
        this.assertUpdate("DROP MATERIALIZED VIEW " + view);
        this.assertUpdate("DROP MATERIALIZED VIEW " + otherView);
        this.assertQueryReturnsEmptyResult(this.listMaterializedViewsSql("name = '" + view.getObjectName() + "'"));
        this.assertQueryReturnsEmptyResult(this.listMaterializedViewsSql("name = '" + otherView.getObjectName() + "'"));
        this.assertQueryReturnsEmptyResult(this.listMaterializedViewsSql("name = '" + viewWithComment.getObjectName() + "'"));
    }

    @Test
    public void testCompatibleTypeChangeForView() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        String tableName = "test_table_" + TestTable.randomTableSuffix();
        String viewName = "test_view_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 'abcdefg' a", 1L);
        this.assertUpdate("CREATE VIEW " + viewName + " AS SELECT a FROM " + tableName);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES 'abcdefg'");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 'abc' a", 1L);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES 'abc'");
        this.assertUpdate("DROP VIEW " + viewName);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCompatibleTypeChangeForView2() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        String tableName = "test_table_" + TestTable.randomTableSuffix();
        String viewName = "test_view_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT BIGINT '1' v", 1L);
        this.assertUpdate("CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT INTEGER '1' v", 1L);
        this.assertQuery("SELECT * FROM " + viewName + " WHERE v = 1", "VALUES 1");
        this.assertUpdate("DROP VIEW " + viewName);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test(dataProvider="testViewMetadataDataProvider")
    public void testViewMetadata(String securityClauseInCreate, String securityClauseInShowCreate) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        String viewName = "meta_test_view_" + TestTable.randomTableSuffix();
        String query = "SELECT BIGINT '123' x, 'foo' y";
        this.assertUpdate("CREATE VIEW " + viewName + securityClauseInCreate + " AS " + query);
        MaterializedResult actual = this.computeActual(String.format("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '%s'", this.getSession().getSchema().get()));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"customer", "BASE TABLE"}).row(new Object[]{viewName, "VIEW"}).row(new Object[]{"nation", "BASE TABLE"}).row(new Object[]{"orders", "BASE TABLE"}).row(new Object[]{"region", "BASE TABLE"}).build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual("SHOW TABLES");
        MaterializedResult.Builder builder = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes());
        for (MaterializedRow row : expected.getMaterializedRows()) {
            builder.row(new Object[]{row.getField(0)});
        }
        expected = builder.build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual(String.format("SELECT table_name, view_definition FROM information_schema.views WHERE table_schema = '%s'", this.getSession().getSchema().get()));
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{viewName, this.formatSqlText(query)}).build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual("SHOW COLUMNS FROM " + viewName);
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"x", "bigint", "", ""}).row(new Object[]{"y", "varchar(3)", "", ""}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
        String expectedSql = this.formatSqlText(String.format("CREATE VIEW %s.%s.%s SECURITY %s AS %s", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), viewName, securityClauseInShowCreate, query)).trim();
        actual = this.computeActual("SHOW CREATE VIEW " + viewName);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actual.getOnlyColumnAsSet()), (Object)expectedSql);
        actual = this.computeActual(String.format("SHOW CREATE VIEW %s.%s.%s", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), viewName));
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actual.getOnlyColumnAsSet()), (Object)expectedSql);
        this.assertUpdate("DROP VIEW " + viewName);
    }

    @DataProvider
    public static Object[][] testViewMetadataDataProvider() {
        return new Object[][]{{"", "DEFINER"}, {" SECURITY DEFINER", "DEFINER"}, {" SECURITY INVOKER", "INVOKER"}};
    }

    @Test
    public void testShowCreateView() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        Preconditions.checkState((boolean)this.getSession().getCatalog().isPresent(), (Object)"catalog is not set");
        Preconditions.checkState((boolean)this.getSession().getSchema().isPresent(), (Object)"schema is not set");
        String viewName = "test_show_create_view" + TestTable.randomTableSuffix();
        this.assertUpdate("DROP VIEW IF EXISTS " + viewName);
        String ddl = String.format("CREATE VIEW %s.%s.%s SECURITY DEFINER AS\nSELECT *\nFROM\n  (\n VALUES \n     ROW (1, 'one')\n   , ROW (2, 't')\n)  t (col1, col2)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), viewName);
        this.assertUpdate(ddl);
        Assert.assertEquals((Object)this.computeActual("SHOW CREATE VIEW " + viewName).getOnlyValue(), (Object)ddl);
        this.assertUpdate("DROP VIEW " + viewName);
    }

    @Test
    public void testRenameMaterializedView() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        String schema = "rename_mv_test";
        Session session = Session.builder((Session)this.getSession()).setSchema(schema).build();
        QualifiedObjectName originalMaterializedView = new QualifiedObjectName((String)session.getCatalog().orElseThrow(), (String)session.getSchema().orElseThrow(), "test_materialized_view_rename_" + TestTable.randomTableSuffix());
        this.createTestingMaterializedView(originalMaterializedView, Optional.empty());
        String renamedMaterializedView = "test_materialized_view_rename_new_" + TestTable.randomTableSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_MATERIALIZED_VIEW)) {
            this.assertQueryFails(session, "ALTER MATERIALIZED VIEW " + originalMaterializedView + " RENAME TO " + renamedMaterializedView, "This connector does not support renaming materialized views");
            this.assertUpdate(session, "DROP MATERIALIZED VIEW " + originalMaterializedView);
            return;
        }
        this.assertUpdate(session, "ALTER MATERIALIZED VIEW " + originalMaterializedView + " RENAME TO " + renamedMaterializedView);
        this.assertTestingMaterializedViewQuery(schema, renamedMaterializedView);
        this.assertQuery(session, "SELECT catalog_name, schema_name FROM system.metadata.materialized_views WHERE name = '" + renamedMaterializedView + "'", String.format("VALUES ('%s', '%s')", originalMaterializedView.getCatalogName(), originalMaterializedView.getSchemaName()));
        this.assertQueryReturnsEmptyResult(session, this.listMaterializedViewsSql("name = '" + originalMaterializedView.getObjectName() + "'"));
        String testExistsMaterializedViewName = "test_materialized_view_rename_exists_" + TestTable.randomTableSuffix();
        this.assertUpdate(session, "ALTER MATERIALIZED VIEW IF EXISTS " + renamedMaterializedView + " RENAME TO " + testExistsMaterializedViewName);
        this.assertTestingMaterializedViewQuery(schema, testExistsMaterializedViewName);
        String uppercaseName = "TEST_MATERIALIZED_VIEW_RENAME_UPPERCASE_" + TestTable.randomTableSuffix();
        this.assertUpdate(session, "ALTER MATERIALIZED VIEW " + testExistsMaterializedViewName + " RENAME TO " + uppercaseName);
        this.assertTestingMaterializedViewQuery(schema, uppercaseName.toLowerCase(Locale.ENGLISH));
        String otherSchema = "rename_mv_other_schema";
        this.assertUpdate(String.format("CREATE SCHEMA IF NOT EXISTS %s", otherSchema));
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_MATERIALIZED_VIEW_ACROSS_SCHEMAS)) {
            this.assertUpdate(session, "ALTER MATERIALIZED VIEW " + uppercaseName + " RENAME TO " + otherSchema + "." + originalMaterializedView.getObjectName());
            this.assertTestingMaterializedViewQuery(otherSchema, originalMaterializedView.getObjectName());
            this.assertUpdate(session, "DROP MATERIALIZED VIEW " + otherSchema + "." + originalMaterializedView.getObjectName());
        } else {
            this.assertQueryFails(session, "ALTER MATERIALIZED VIEW " + uppercaseName + " RENAME TO " + otherSchema + "." + originalMaterializedView.getObjectName(), "Materialized View rename across schemas is not supported");
            this.assertUpdate(session, "DROP MATERIALIZED VIEW " + uppercaseName);
        }
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, originalMaterializedView.toString()));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, renamedMaterializedView));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, testExistsMaterializedViewName));
        this.assertUpdate(session, "ALTER TABLE IF EXISTS " + originalMaterializedView + " RENAME TO " + renamedMaterializedView);
        this.assertQueryReturnsEmptyResult(session, this.listMaterializedViewsSql("name = '" + originalMaterializedView.getObjectName() + "'"));
        this.assertQueryReturnsEmptyResult(session, this.listMaterializedViewsSql("name = '" + renamedMaterializedView + "'"));
    }

    private void assertTestingMaterializedViewQuery(String schema, String materializedViewName) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + schema + "." + materializedViewName))).skippingTypesCheck().matches("SELECT * FROM nation");
    }

    private void createTestingMaterializedView(QualifiedObjectName view, Optional<String> comment) {
        this.assertUpdate(String.format("CREATE SCHEMA IF NOT EXISTS %s", view.getSchemaName()));
        this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s %s AS SELECT * FROM nation", view, comment.map(c -> String.format("COMMENT '%s'", c)).orElse("")));
    }

    private String getTestingMaterializedViewsResultRow(QualifiedObjectName materializedView, String comment) {
        return String.format("VALUES ('%s', '%s', '%s', '%s', 'SELECT *\nFROM\n  nation\n')", materializedView.getCatalogName(), materializedView.getSchemaName(), materializedView.getObjectName(), comment);
    }

    private String getTestingMaterializedViewsResultRows(QualifiedObjectName materializedView, QualifiedObjectName otherMaterializedView) {
        String viewDefinitionSql = "SELECT *\nFROM\n  nation\n";
        return String.format("VALUES ('%s', '%s', '%s', '', '%s'),('%s', '%s', '%s', 'sarcastic comment', '%s')", materializedView.getCatalogName(), materializedView.getSchemaName(), materializedView.getObjectName(), viewDefinitionSql, otherMaterializedView.getCatalogName(), otherMaterializedView.getSchemaName(), otherMaterializedView.getObjectName(), viewDefinitionSql);
    }

    private String listMaterializedViewsSql(String ... filterClauses) {
        StringBuilder sql = new StringBuilder("SELECT   catalog_name,   schema_name,   name,   comment,   definition FROM system.metadata.materialized_views WHERE true");
        for (String filterClause : filterClauses) {
            sql.append(" AND ").append(filterClause);
        }
        return sql.toString();
    }

    @Test
    public void testViewAndMaterializedViewTogether() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW) || !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
            return;
        }
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        String regularViewName = "test_views_together_normal_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE VIEW " + regularViewName + " AS SELECT * FROM region");
        String materializedViewName = "test_views_together_materialized_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE MATERIALIZED VIEW " + materializedViewName + " AS SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name FROM information_schema.views WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES '" + regularViewName + "'");
        this.checkInformationSchemaViewsForMaterializedView(schemaName, materializedViewName);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + regularViewName))).containsAll("SELECT * FROM region");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + materializedViewName))).containsAll("SELECT * FROM nation");
        this.assertUpdate("DROP VIEW " + regularViewName);
        this.assertUpdate("DROP MATERIALIZED VIEW " + materializedViewName);
    }

    protected void checkInformationSchemaViewsForMaterializedView(String schemaName, String viewName) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name FROM information_schema.views WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES '" + viewName + "'");
    }

    @Test(timeOut=180000L)
    public void testReadMetadataWithRelationsConcurrentModifications() throws Exception {
        if (!(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) || this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW) || this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW))) {
            throw new SkipException("Cannot test");
        }
        int readIterations = 5;
        int testTimeoutSeconds = 150;
        this.testReadMetadataWithRelationsConcurrentModifications(readIterations, testTimeoutSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testReadMetadataWithRelationsConcurrentModifications(int readIterations, int testTimeoutSeconds) throws Exception {
        Stopwatch testWatch = Stopwatch.createStarted();
        int readerTasksCount = 6 + (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW) ? 1 : 0) + (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW) ? 1 : 0);
        AtomicInteger incompleteReadTasks = new AtomicInteger(readerTasksCount);
        ArrayList readerTasks = new ArrayList();
        readerTasks.add(this.queryRepeatedly(readIterations, incompleteReadTasks, "SHOW TABLES"));
        readerTasks.add(this.queryRepeatedly(readIterations, incompleteReadTasks, "SELECT * FROM information_schema.tables WHERE table_schema = CURRENT_SCHEMA"));
        readerTasks.add(this.queryRepeatedly(readIterations, incompleteReadTasks, "SELECT * FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA"));
        readerTasks.add(this.queryRepeatedly(readIterations, incompleteReadTasks, "SELECT * FROM system.jdbc.tables WHERE table_cat = CURRENT_CATALOG AND table_schem = CURRENT_SCHEMA"));
        readerTasks.add(this.queryRepeatedly(readIterations, incompleteReadTasks, "SELECT * FROM system.jdbc.columns WHERE table_cat = CURRENT_CATALOG AND table_schem = CURRENT_SCHEMA"));
        readerTasks.add(this.queryRepeatedly(readIterations, incompleteReadTasks, "SELECT * FROM system.metadata.table_comments WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA"));
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
            readerTasks.add(this.queryRepeatedly(readIterations, incompleteReadTasks, "SELECT * FROM information_schema.views WHERE table_schema = CURRENT_SCHEMA"));
        }
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW)) {
            readerTasks.add(this.queryRepeatedly(readIterations, incompleteReadTasks, "SELECT * FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA"));
        }
        Assert.assertEquals((int)readerTasks.size(), (int)readerTasksCount);
        int writeTasksCount = 1 + (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW) ? 1 : 0) + (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW) ? 1 : 0);
        writeTasksCount = 2 * writeTasksCount;
        CountDownLatch writeTasksInitialized = new CountDownLatch(writeTasksCount);
        Runnable writeInitialized = writeTasksInitialized::countDown;
        Supplier<Boolean> done = () -> incompleteReadTasks.get() == 0;
        ArrayList writeTasks = new ArrayList();
        writeTasks.add(this.createDropRepeatedly(writeInitialized, done, "concur_table", "CREATE TABLE %s(a integer)", "DROP TABLE %s"));
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
            writeTasks.add(this.createDropRepeatedly(writeInitialized, done, "concur_view", "CREATE VIEW %s AS SELECT 1 a", "DROP VIEW %s"));
        }
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW)) {
            writeTasks.add(this.createDropRepeatedly(writeInitialized, done, "concur_mview", "CREATE MATERIALIZED VIEW %s AS SELECT 1 a", "DROP MATERIALIZED VIEW %s"));
        }
        Assert.assertEquals((int)(writeTasks.size() * 2), (int)writeTasksCount);
        ExecutorService executor = Executors.newFixedThreadPool(readerTasksCount + writeTasksCount);
        try {
            ExecutorCompletionService completionService = new ExecutorCompletionService(executor);
            this.submitTasks(writeTasks, completionService);
            this.submitTasks(writeTasks, completionService);
            if (!writeTasksInitialized.await(testTimeoutSeconds, TimeUnit.SECONDS)) {
                Future someFailure = completionService.poll();
                if (someFailure != null) {
                    someFailure.get();
                }
                org.testng.Assert.fail((String)"Setup failed");
            }
            this.submitTasks(readerTasks, completionService);
            for (int i = 0; i < readerTasksCount + writeTasksCount; ++i) {
                long remainingTimeSeconds = (long)testTimeoutSeconds - testWatch.elapsed(TimeUnit.SECONDS);
                Future future = completionService.poll(remainingTimeSeconds, TimeUnit.SECONDS);
                Verify.verifyNotNull(future, (String)"Task did not completed before timeout; completed tasks: %s, current poll timeout: %s s", (Object[])new Object[]{i, remainingTimeSeconds});
                future.get();
            }
        }
        finally {
            executor.shutdownNow();
        }
        org.testng.Assert.assertTrue((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS));
    }

    protected Callable<Void> queryRepeatedly(final int minIterations, final AtomicInteger incompleteReadTasks, final @Language(value="SQL") String sql) {
        return new Callable<Void>(){

            @Override
            public Void call() {
                boolean alwaysEmpty = true;
                for (int i = 0; i < minIterations; ++i) {
                    MaterializedResult result = BaseConnectorTest.this.computeActual(sql);
                    alwaysEmpty &= result.getRowCount() == 0;
                }
                if (alwaysEmpty) {
                    org.testng.Assert.fail((String)String.format("The results of [%s] are always empty after %s iterations, this may indicate test misconfiguration or broken connector behavior", sql, minIterations));
                }
                ((AbstractIntegerAssert)Assertions.assertThat((int)incompleteReadTasks.decrementAndGet()).as("incompleteReadTasks", new Object[0])).isGreaterThanOrEqualTo(0);
                while (incompleteReadTasks.get() != 0) {
                    BaseConnectorTest.this.computeActual(sql);
                }
                return null;
            }

            public String toString() {
                return String.format("Query(%s)", sql);
            }
        };
    }

    protected Callable<Void> createDropRepeatedly(final Runnable initReady, final Supplier<Boolean> done, final String namePrefix, final String createTemplate, final String dropTemplate) {
        return new Callable<Void>(){

            @Override
            public Void call() {
                int objectsToKeep = 3;
                ArrayDeque<CallSite> liveObjects = new ArrayDeque<CallSite>(objectsToKeep);
                for (int i = 0; i < objectsToKeep; ++i) {
                    String name = namePrefix + "_" + TestTable.randomTableSuffix();
                    BaseConnectorTest.this.assertUpdate(String.format(createTemplate, name));
                    liveObjects.addLast((CallSite)((Object)name));
                }
                initReady.run();
                while (!((Boolean)done.get()).booleanValue()) {
                    BaseConnectorTest.this.assertUpdate(String.format(dropTemplate, liveObjects.removeFirst()));
                    String name = namePrefix + "_" + TestTable.randomTableSuffix();
                    BaseConnectorTest.this.assertUpdate(String.format(createTemplate, name));
                    liveObjects.addLast((CallSite)((Object)name));
                }
                while (!liveObjects.isEmpty()) {
                    BaseConnectorTest.this.assertUpdate(String.format(dropTemplate, liveObjects.removeFirst()));
                }
                return null;
            }

            public String toString() {
                return String.format("Repeat (%s) and (%s)", createTemplate, dropTemplate);
            }
        };
    }

    protected <T> void submitTasks(List<Callable<T>> callables, CompletionService<T> completionService) {
        for (final Callable<T> callable : callables) {
            final String taskDescription = callable.toString();
            completionService.submit(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    try {
                        return callable.call();
                    }
                    catch (Throwable e) {
                        e.addSuppressed(new Exception("Task: " + taskDescription));
                        throw e;
                    }
                }
            });
        }
    }

    @Test
    public void testExplainAnalyze() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT * FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT count(*), clerk FROM orders GROUP BY clerk", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT x + y FROM (   SELECT orderdate, COUNT(*) x FROM orders GROUP BY orderdate) a JOIN (   SELECT orderdate, COUNT(*) y FROM orders GROUP BY orderdate) b ON a.orderdate = b.orderdate", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT count(*), clerk FROM orders GROUP BY clerk UNION ALL SELECT sum(orderkey), clerk FROM orders GROUP BY clerk", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW COLUMNS FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE EXPLAIN SELECT count(*) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE EXPLAIN ANALYZE SELECT count(*) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW FUNCTIONS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW TABLES", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW SCHEMAS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW CATALOGS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW SESSION", new String[0]);
    }

    @Test
    public void testExplainAnalyzeVerbose() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT * FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT rank() OVER (PARTITION BY orderkey ORDER BY clerk DESC) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT rank() OVER (PARTITION BY orderkey ORDER BY clerk DESC) FROM orders WHERE orderkey < 0", new String[0]);
    }

    @Test
    public void testTableSampleSystem() {
        MaterializedResult fullSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (100)");
        MaterializedResult emptySample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (0)");
        MaterializedResult randomSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (50)");
        MaterializedResult all = this.computeActual("SELECT orderkey FROM orders");
        QueryAssertions.assertContains(all, fullSample);
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
        org.testng.Assert.assertTrue((all.getMaterializedRows().size() >= randomSample.getMaterializedRows().size() ? 1 : 0) != 0);
    }

    @Test
    public void testTableSampleWithFiltering() {
        MaterializedResult emptySample = this.computeActual("SELECT DISTINCT orderkey, orderdate FROM orders TABLESAMPLE SYSTEM (99) WHERE orderkey BETWEEN 0 AND 0");
        MaterializedResult halfSample = this.computeActual("SELECT DISTINCT orderkey, orderdate FROM orders TABLESAMPLE SYSTEM (50) WHERE orderkey BETWEEN 0 AND 9999999999");
        MaterializedResult all = this.computeActual("SELECT orderkey, orderdate FROM orders");
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
        org.testng.Assert.assertTrue((all.getMaterializedRows().size() >= halfSample.getMaterializedRows().size() ? 1 : 0) != 0);
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE orders").getOnlyValue())).matches((CharSequence)"CREATE TABLE \\w+\\.\\w+\\.orders \\Q(\n   orderkey bigint,\n   custkey bigint,\n   orderstatus varchar(1),\n   totalprice double,\n   orderdate date,\n   orderpriority varchar(15),\n   clerk varchar(15),\n   shippriority integer,\n   comment varchar(79)\n)");
    }

    @Test
    public void testSelectInformationSchemaTables() {
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        String schemaPattern = schema.replaceAll("^.", "_");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = '" + schema + "' AND table_name = 'orders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema LIKE '" + schema + "' AND table_name LIKE '%rders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema LIKE '" + schemaPattern + "' AND table_name LIKE '%rders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = '" + catalog + "' AND table_schema LIKE '" + schema + "' AND table_name LIKE '%orders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = 'something_else'", "SELECT '' WHERE false");
        this.assertQuery("SELECT DISTINCT table_name FROM information_schema.tables WHERE table_schema = 'information_schema' OR rand() = 42 ORDER BY 1", "VALUES ('applicable_roles'), ('columns'), ('enabled_roles'), ('role_authorization_descriptors'), ('roles'), ('schemata'), ('table_privileges'), ('tables'), ('views')");
    }

    @Test
    public void testSelectInformationSchemaColumns() {
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        String schemaPattern = schema.replaceAll(".$", "_");
        String ordersTableWithColumns = "VALUES ('orders', 'orderkey'), ('orders', 'custkey'), ('orders', 'orderstatus'), ('orders', 'totalprice'), ('orders', 'orderdate'), ('orders', 'orderpriority'), ('orders', 'clerk'), ('orders', 'shippriority'), ('orders', 'comment')";
        this.assertQuery("SELECT table_schema FROM information_schema.columns WHERE table_schema = '" + schema + "' GROUP BY table_schema", "VALUES '" + schema + "'");
        this.assertQuery("SELECT table_name FROM information_schema.columns WHERE table_name = 'orders' GROUP BY table_name", "VALUES 'orders'");
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schema + "' AND table_name = 'orders'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schema + "' AND table_name LIKE '%rders'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema LIKE '" + schemaPattern + "' AND table_name LIKE '_rder_'", ordersTableWithColumns);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "' AND table_name LIKE '%orders%'"))).skippingTypesCheck().containsAll(ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns");
        this.assertQuery("SELECT DISTINCT table_name, column_name FROM information_schema.columns WHERE table_name LIKE '_rders'", ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "'");
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "'");
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "' AND table_name LIKE '_rders'", ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_name LIKE '%'");
        this.assertQuery("SELECT column_name FROM information_schema.columns WHERE table_catalog = 'something_else'", "SELECT '' WHERE false");
        this.assertQuery("SELECT DISTINCT table_name FROM information_schema.columns WHERE table_schema = 'information_schema' OR rand() = 42 ORDER BY 1", "VALUES ('applicable_roles'), ('columns'), ('enabled_roles'), ('role_authorization_descriptors'), ('roles'), ('schemata'), ('table_privileges'), ('tables'), ('views')");
    }

    @Test
    public void testShowCreateInformationSchema() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW CREATE SCHEMA information_schema"))).skippingTypesCheck().matches(String.format("VALUES 'CREATE SCHEMA %s.information_schema'", this.getSession().getCatalog().orElseThrow()));
    }

    @Test
    public void testShowCreateInformationSchemaTable() {
        this.assertQueryFails("SHOW CREATE VIEW information_schema.schemata", "line 1:1: Relation '\\w+.information_schema.schemata' is a table, not a view");
        this.assertQueryFails("SHOW CREATE MATERIALIZED VIEW information_schema.schemata", "line 1:1: Relation '\\w+.information_schema.schemata' is a table, not a materialized view");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE information_schema.schemata"))).isEqualTo("CREATE TABLE " + (String)this.getSession().getCatalog().orElseThrow() + ".information_schema.schemata (\n   catalog_name varchar,\n   schema_name varchar\n)");
    }

    @Test
    public void testRollback() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES));
        String table = "test_rollback_" + TestTable.randomTableSuffix();
        this.computeActual(String.format("CREATE TABLE %s (x int)", table));
        Assertions.assertThatThrownBy(() -> this.inTransaction(session -> {
            this.assertUpdate((Session)session, String.format("INSERT INTO %s VALUES (42)", table), 1L);
            throw new RollbackException();
        })).isInstanceOf(RollbackException.class);
        this.assertQuery(String.format("SELECT count(*) FROM %s", table), "SELECT 0");
    }

    @Test
    public void testWriteNotAllowedInTransaction() {
        BaseConnectorTest.skipTestUnless(!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES));
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA, "CREATE SCHEMA write_not_allowed");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE, "CREATE TABLE write_not_allowed (x int)");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE, "DROP TABLE region");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA, "CREATE TABLE write_not_allowed AS SELECT * FROM region");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW, "CREATE VIEW write_not_allowed AS SELECT * FROM region");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, "CREATE MATERIALIZED VIEW write_not_allowed AS SELECT * FROM region");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE, "ALTER TABLE region RENAME TO region_name");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_INSERT, "INSERT INTO region (regionkey) VALUES (123)");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_DELETE, "DELETE FROM region WHERE regionkey = 123");
    }

    protected void assertWriteNotAllowedInTransaction(TestingConnectorBehavior behavior, @Language(value="SQL") String sql) {
        if (this.hasBehavior(behavior)) {
            Assertions.assertThatThrownBy(() -> this.inTransaction(session -> this.computeActual((Session)session, sql))).hasMessageMatching("Catalog only supports writes using autocommit: \\w+");
        }
    }

    @Test
    public void testRenameSchema() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA)) {
            String schemaName = (String)this.getSession().getSchema().orElseThrow();
            this.assertQueryFails(String.format("ALTER SCHEMA %s RENAME TO %s", schemaName, schemaName + TestTable.randomTableSuffix()), "This connector does not support renaming schemas");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            throw new SkipException("Skipping as connector does not support CREATE SCHEMA");
        }
        String schemaName = "test_rename_schema_" + TestTable.randomTableSuffix();
        try {
            this.assertUpdate("CREATE SCHEMA " + schemaName);
            this.assertUpdate("ALTER SCHEMA " + schemaName + " RENAME TO " + schemaName + "_renamed");
        }
        finally {
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName);
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName + "_renamed");
        }
    }

    @Test
    public void testAddColumn() {
        String tableName;
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN)) {
            this.assertQueryFails("ALTER TABLE nation ADD COLUMN test_add_column bigint", "This connector does not support adding columns");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_column_", this.tableDefinitionForAddColumn());){
            tableName = table.getName();
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'first'", 1L);
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN x bigint", ".* Column 'x' already exists");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN X bigint", ".* Column 'X' already exists");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN q bad_type", ".* Unknown type 'bad_type' for column 'q'");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN a varchar(50)");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'second', 'xxx'", 1L);
            this.assertQuery("SELECT x, a FROM " + table.getName(), "VALUES ('first', NULL), ('second', 'xxx')");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN b double");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'third', 'yyy', 33.3E0", 1L);
            this.assertQuery("SELECT x, a, b FROM " + table.getName(), "VALUES ('first', NULL, NULL), ('second', 'xxx', NULL), ('third', 'yyy', 33.3)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN IF NOT EXISTS c varchar(50)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN IF NOT EXISTS c varchar(50)");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'fourth', 'zzz', 55.3E0, 'newColumn'", 1L);
            this.assertQuery("SELECT x, a, b, c FROM " + table.getName(), "VALUES ('first', NULL, NULL, NULL), ('second', 'xxx', NULL, NULL), ('third', 'yyy', 33.3, NULL), ('fourth', 'zzz', 55.3, 'newColumn')");
        }
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " ADD COLUMN x bigint");
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " ADD COLUMN IF NOT EXISTS x bigint");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    protected String tableDefinitionForAddColumn() {
        return "(x VARCHAR)";
    }

    @Test
    public void testAddColumnWithComment() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN)) {
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN_WITH_COMMENT)) {
            this.assertQueryFails("ALTER TABLE nation ADD COLUMN test_add_col_desc bigint COMMENT 'test column comment'", "This connector does not support adding columns with comments");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_col_desc_", "(a_varchar varchar)");){
            String tableName = table.getName();
            this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN b_varchar varchar COMMENT 'test new column comment'");
            Assertions.assertThat((String)this.getColumnComment(tableName, "b_varchar")).isEqualTo("test new column comment");
            this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN empty_comment varchar COMMENT ''");
            Assert.assertEquals((String)this.getColumnComment(tableName, "empty_comment"), (String)"");
        }
    }

    @Test
    public void testDropColumn() {
        String tableName;
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_COLUMN)) {
            this.assertQueryFails("ALTER TABLE nation DROP COLUMN nationkey", "This connector does not support dropping columns");
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_column_", "AS SELECT 123 x, 456 y, 111 a");){
            tableName = table.getName();
            this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN x");
            this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN IF EXISTS y");
            this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN IF EXISTS notExistColumn");
            this.assertQueryFails("SELECT x FROM " + tableName, ".* Column 'x' cannot be resolved");
            this.assertQueryFails("SELECT y FROM " + tableName, ".* Column 'y' cannot be resolved");
            this.assertQueryFails("ALTER TABLE " + tableName + " DROP COLUMN a", ".* Cannot drop the only column in a table");
        }
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " DROP COLUMN notExistColumn");
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " DROP COLUMN IF EXISTS notExistColumn");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testRenameColumn() {
        String tableName;
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_COLUMN)) {
            this.assertQueryFails("ALTER TABLE nation RENAME COLUMN nationkey TO test_rename_column", "This connector does not support renaming columns");
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_rename_column_", "AS SELECT 'some value' x");){
            tableName = table.getName();
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN x TO before_y");
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN IF EXISTS before_y TO y");
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN IF EXISTS columnNotExists TO y");
            this.assertQuery("SELECT y FROM " + tableName, "VALUES 'some value'");
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN y TO Z");
            this.assertQuery("SELECT z FROM " + tableName, "VALUES 'some value'");
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN IF EXISTS z TO a");
            this.assertQuery("SELECT a FROM " + tableName, "VALUES 'some value'");
            this.assertQuery("SELECT * FROM " + tableName, "VALUES 'some value'");
        }
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " RENAME COLUMN columnNotExists TO y");
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " RENAME COLUMN IF EXISTS columnNotExists TO y");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testCreateTable() {
        String tableName = "test_create_" + TestTable.randomTableSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            this.assertQueryFails("CREATE TABLE " + tableName + " (a bigint, b double, c varchar(50))", "This connector does not support creating tables");
            return;
        }
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b double, c varchar(50))");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertTableColumnNames(tableName, "a", "b", "c");
        org.testng.Assert.assertNull((Object)this.getTableComment((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), tableName));
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertQueryFails("CREATE TABLE " + tableName + " (a bad_type)", ".* Unknown type 'bad_type' for column 'a'");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        tableName = "test_cr_not_exists_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b varchar(50), c double)");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertTableColumnNames(tableName, "a", "b", "c");
        this.assertUpdate("CREATE TABLE IF NOT EXISTS " + tableName + " (d bigint, e varchar(50))");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertTableColumnNames(tableName, "a", "b", "c");
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        tableName = "test_create_orig_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b double, c varchar(50))");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertTableColumnNames(tableName, "a", "b", "c");
        String tableNameLike = "test_create_like_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableNameLike + " (LIKE " + tableName + ", d bigint, e varchar(50))");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableNameLike));
        this.assertTableColumnNames(tableNameLike, "a", "b", "c", "d", "e");
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertUpdate("DROP TABLE " + tableNameLike);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableNameLike));
    }

    @Test
    public void testCreateTableSchemaNotFound() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String schemaName = "test_schema_" + TestTable.randomTableSuffix();
        String tableName = "test_create_no_schema_" + TestTable.randomTableSuffix();
        try {
            this.assertQueryFails(String.format("CREATE TABLE %s.%s (a bigint)", schemaName, tableName), String.format("Schema %s not found", schemaName));
        }
        catch (Throwable throwable) {
            this.assertUpdate(String.format("DROP TABLE IF EXISTS %s.%s", schemaName, tableName));
            throw throwable;
        }
        this.assertUpdate(String.format("DROP TABLE IF EXISTS %s.%s", schemaName, tableName));
    }

    @Test
    public void testCreateTableAsSelect() {
        String tableName = "test_ctas" + TestTable.randomTableSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            this.assertQueryFails("CREATE TABLE IF NOT EXISTS " + tableName + " AS SELECT name, regionkey FROM nation", "This connector does not support creating tables with data");
            return;
        }
        this.assertUpdate("CREATE TABLE IF NOT EXISTS " + tableName + " AS SELECT name, regionkey FROM nation", "SELECT count(*) FROM nation");
        this.assertTableColumnNames(tableName, "name", "regionkey");
        org.testng.Assert.assertNull((Object)this.getTableComment((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), tableName));
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE IF NOT EXISTS nation AS SELECT custkey, acctbal FROM customer", 0L);
        this.assertTableColumnNames("nation", "nationkey", "name", "regionkey", "comment");
        this.assertCreateTableAsSelect("SELECT custkey, address, acctbal FROM customer", "SELECT count(*) FROM customer");
        this.assertCreateTableAsSelect("SELECT mktsegment, sum(acctbal) x FROM customer GROUP BY mktsegment", "SELECT count(DISTINCT mktsegment) FROM customer");
        this.assertCreateTableAsSelect("SELECT count(*) x FROM customer JOIN nation ON customer.nationkey = nation.nationkey", "SELECT 1");
        this.assertCreateTableAsSelect("SELECT custkey FROM customer ORDER BY custkey LIMIT 10", "SELECT 10");
        this.assertCreateTableAsSelect("SELECT * FROM customer WITH DATA", "SELECT * FROM customer", "SELECT count(*) FROM customer");
        this.assertCreateTableAsSelect("SELECT * FROM customer WITH NO DATA", "SELECT * FROM customer LIMIT 0", "SELECT 0");
        this.assertCreateTableAsSelect("SELECT name, custkey, acctbal FROM customer WHERE custkey % 2 = 0 UNION ALL SELECT name, custkey, acctbal FROM customer WHERE custkey % 2 = 1", "SELECT name, custkey, acctbal FROM customer", "SELECT count(*) FROM customer");
        this.assertCreateTableAsSelect(Session.builder((Session)this.getSession()).setSystemProperty("redistribute_writes", "true").build(), "SELECT CAST(custkey AS BIGINT) custkey, acctbal FROM customer UNION ALL SELECT 1234567890, 1.23", "SELECT custkey, acctbal FROM customer UNION ALL SELECT 1234567890, 1.23", "SELECT count(*) + 1 FROM customer");
        this.assertCreateTableAsSelect(Session.builder((Session)this.getSession()).setSystemProperty("redistribute_writes", "false").build(), "SELECT CAST(custkey AS BIGINT) custkey, acctbal FROM customer UNION ALL SELECT 1234567890, 1.23", "SELECT custkey, acctbal FROM customer UNION ALL SELECT 1234567890, 1.23", "SELECT count(*) + 1 FROM customer");
        this.assertExplainAnalyze("EXPLAIN ANALYZE CREATE TABLE " + tableName + " AS SELECT mktsegment FROM customer", new String[0]);
        this.assertQuery("SELECT * from " + tableName, "SELECT mktsegment FROM customer");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTableAsSelectSchemaNotFound() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        String schemaName = "test_schema_" + TestTable.randomTableSuffix();
        String tableName = "test_ctas_no_schema_" + TestTable.randomTableSuffix();
        try {
            this.assertQueryFails(String.format("CREATE TABLE %s.%s AS SELECT name FROM nation", schemaName, tableName), String.format("Schema %s not found", schemaName));
        }
        catch (Throwable throwable) {
            this.assertUpdate(String.format("DROP TABLE IF EXISTS %s.%s", schemaName, tableName));
            throw throwable;
        }
        this.assertUpdate(String.format("DROP TABLE IF EXISTS %s.%s", schemaName, tableName));
    }

    @Test
    public void testCreateTableAsSelectWithUnicode() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        this.assertCreateTableAsSelect("SELECT '\u2603' unicode", "SELECT 1");
    }

    protected void assertCreateTableAsSelect(@Language(value="SQL") String query, @Language(value="SQL") String rowCountQuery) {
        this.assertCreateTableAsSelect(this.getSession(), query, query, rowCountQuery);
    }

    protected void assertCreateTableAsSelect(@Language(value="SQL") String query, @Language(value="SQL") String expectedQuery, @Language(value="SQL") String rowCountQuery) {
        this.assertCreateTableAsSelect(this.getSession(), query, expectedQuery, rowCountQuery);
    }

    protected void assertCreateTableAsSelect(Session session, @Language(value="SQL") String query, @Language(value="SQL") String expectedQuery, @Language(value="SQL") String rowCountQuery) {
        String table = "test_ctas_" + TestTable.randomTableSuffix();
        this.assertUpdate(session, "CREATE TABLE " + table + " AS " + query, rowCountQuery);
        this.assertQuery(session, "SELECT * FROM " + table, expectedQuery);
        this.assertUpdate(session, "DROP TABLE " + table);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, table));
    }

    @Test
    public void testCreateTableAsSelectNegativeDate() {
        String tableName = "negative_date_" + TestTable.randomTableSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA)) {
            this.assertQueryFails(String.format("CREATE TABLE %s AS SELECT DATE '-0001-01-01' AS dt", tableName), "This connector does not support creating tables with data");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NEGATIVE_DATE)) {
            this.assertQueryFails(String.format("CREATE TABLE %s AS SELECT DATE '-0001-01-01' AS dt", tableName), this.errorMessageForCreateTableAsSelectNegativeDate("-0001-01-01"));
            return;
        }
        try {
            this.assertUpdate(String.format("CREATE TABLE %s AS SELECT DATE '-0001-01-01' AS dt", tableName), 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES DATE '-0001-01-01'");
            this.assertQuery(String.format("SELECT * FROM %s WHERE dt = DATE '-0001-01-01'", tableName), "VALUES DATE '-0001-01-01'");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Language(value="RegExp")
    protected String errorMessageForCreateTableAsSelectNegativeDate(String date) {
        throw new UnsupportedOperationException("This method should be overridden");
    }

    @Test
    public void testRenameTable() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String tableName = "test_rename_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String renamedTable = "test_rename_new_" + TestTable.randomTableSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE)) {
            this.assertQueryFails("ALTER TABLE " + tableName + " RENAME TO " + renamedTable, "This connector does not support renaming tables");
            this.assertUpdate("DROP TABLE " + tableName);
            return;
        }
        this.assertUpdate("ALTER TABLE " + tableName + " RENAME TO " + renamedTable);
        this.assertQuery("SELECT x FROM " + renamedTable, "VALUES 123");
        String testExistsTableName = "test_rename_exists_" + TestTable.randomTableSuffix();
        this.assertUpdate("ALTER TABLE IF EXISTS " + renamedTable + " RENAME TO " + testExistsTableName);
        this.assertQuery("SELECT x FROM " + testExistsTableName, "VALUES 123");
        String uppercaseName = "TEST_RENAME_" + TestTable.randomTableSuffix();
        this.assertUpdate("ALTER TABLE " + testExistsTableName + " RENAME TO " + uppercaseName);
        this.assertQuery("SELECT x FROM " + uppercaseName.toLowerCase(Locale.ENGLISH), "VALUES 123");
        this.assertUpdate("DROP TABLE " + uppercaseName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), renamedTable));
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " RENAME TO " + renamedTable);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), renamedTable));
    }

    @Test
    public void testRenameTableAcrossSchema() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE_ACROSS_SCHEMAS)) {
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE)) {
                throw new SkipException("Skipping since rename table is not supported at all");
            }
            this.assertQueryFails("ALTER TABLE nation RENAME TO other_schema.yyyy", "This connector does not support renaming tables across schemas");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            throw new AssertionError((Object)"Cannot test ALTER TABLE RENAME across schemas without CREATE SCHEMA, the test needs to be implemented in a connector-specific way");
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test ALTER TABLE RENAME across schemas without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        String tableName = "test_rename_old_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String schemaName = "test_schema_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        String renamedTable = "test_rename_new_" + TestTable.randomTableSuffix();
        this.assertUpdate("ALTER TABLE " + tableName + " RENAME TO " + schemaName + "." + renamedTable);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertQuery("SELECT x FROM " + schemaName + "." + renamedTable, "VALUES 123");
        this.assertUpdate("DROP TABLE " + schemaName + "." + renamedTable);
        this.assertUpdate("DROP SCHEMA " + schemaName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(Session.builder((Session)this.getSession()).setSchema(schemaName).build(), renamedTable));
    }

    @Test
    public void testRenameTableToUnqualifiedPreservesSchema() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE));
        String sourceSchemaName = "test_source_schema_" + TestTable.randomTableSuffix();
        this.assertUpdate(this.createSchemaSql(sourceSchemaName));
        String tableName = "test_rename_unqualified_name_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + sourceSchemaName + "." + tableName + " AS SELECT 123 x", 1L);
        String renamedTable = "test_rename_unqualified_name_new_" + TestTable.randomTableSuffix();
        this.assertUpdate("ALTER TABLE " + sourceSchemaName + "." + tableName + " RENAME TO " + renamedTable);
        this.assertQuery("SELECT x FROM " + sourceSchemaName + "." + renamedTable, "VALUES 123");
        this.assertUpdate("DROP TABLE " + sourceSchemaName + "." + renamedTable);
        this.assertUpdate("DROP SCHEMA " + sourceSchemaName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommentTable() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_TABLE)) {
            this.assertQueryFails("COMMENT ON TABLE nation IS 'new comment'", "This connector does not support setting table comments");
            return;
        }
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_", "(a integer)");){
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS 'new comment'");
            Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE " + table.getName()).getOnlyValue())).contains(new CharSequence[]{"COMMENT 'new comment'"});
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, table.getName())).isEqualTo("new comment");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, comment FROM system.metadata.table_comments WHERE catalog_name = '" + catalogName + "' AND schema_name = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES ('" + table.getName() + "', 'new comment')");
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS 'updated comment'");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, table.getName())).isEqualTo("updated comment");
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS ''");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, table.getName())).isIn(new Object[]{"", null});
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS 'a comment'");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, table.getName())).isEqualTo("a comment");
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS NULL");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, table.getName())).isEqualTo(null);
        }
        String tableName = "test_comment_" + TestTable.randomTableSuffix();
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(key integer) COMMENT 'new table comment'");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, tableName)).isEqualTo("new table comment");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    private String getTableComment(String catalogName, String schemaName, String tableName) {
        String sql = String.format("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = '%s' AND schema_name = '%s' AND table_name = '%s'", catalogName, schemaName, tableName);
        return (String)this.computeActual(sql).getOnlyValue();
    }

    @Test
    public void testCommentColumn() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_COLUMN)) {
            this.assertQueryFails("COMMENT ON COLUMN nation.nationkey IS 'new comment'", "This connector does not support setting column comments");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_column_", "(a integer)");){
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS 'new comment'");
            Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE " + table.getName()).getOnlyValue())).contains(new CharSequence[]{"COMMENT 'new comment'"});
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo("new comment");
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS 'updated comment'");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo("updated comment");
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS ''");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isIn(new Object[]{"", null});
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS 'a comment'");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo("a comment");
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS NULL");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo(null);
        }
    }

    protected String getColumnComment(String tableName, String columnName) {
        MaterializedResult materializedResult = this.computeActual(String.format("SELECT comment FROM information_schema.columns WHERE table_schema = '%s' AND table_name = '%s' AND column_name = '%s'", this.getSession().getSchema().orElseThrow(), tableName, columnName));
        return (String)materializedResult.getOnlyValue();
    }

    @Test
    public void testInsert() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            this.assertQueryFails("INSERT INTO nation(nationkey) VALUES (42)", "This connector does not support inserts");
            return;
        }
        String query = "SELECT phone, custkey, acctbal FROM customer";
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_", "AS " + query + " WITH NO DATA");){
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "SELECT 0");
            this.assertUpdate("INSERT INTO " + table.getName() + " " + query, "SELECT count(*) FROM customer");
            this.assertQuery("SELECT * FROM " + table.getName(), query);
            this.assertUpdate("INSERT INTO " + table.getName() + " (custkey) VALUES (-1)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (custkey) VALUES (null)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (phone) VALUES ('3283-2001-01-01')", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (custkey, phone) VALUES (-2, '3283-2001-01-02')", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (phone, custkey) VALUES ('3283-2001-01-03', -3)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (acctbal) VALUES (1234)", 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), query + " UNION ALL SELECT null, -1, null UNION ALL SELECT null, null, null UNION ALL SELECT '3283-2001-01-01', null, null UNION ALL SELECT '3283-2001-01-02', -2, null UNION ALL SELECT '3283-2001-01-03', -3, null UNION ALL SELECT null, null, 1234");
            this.assertUpdate("INSERT INTO " + table.getName() + " (custkey, phone, acctbal) SELECT custkey, phone, acctbal FROM customer UNION ALL SELECT custkey, phone, acctbal FROM customer", "SELECT 2 * count(*) FROM customer");
        }
    }

    @Test
    public void testInsertForDefaultColumn() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        try (TestTable testTable = this.createTableWithDefaultColumns();){
            this.assertUpdate(String.format("INSERT INTO %s (col_required, col_required2) VALUES (1, 10)", testTable.getName()), 1L);
            this.assertUpdate(String.format("INSERT INTO %s VALUES (2, 3, 4, 5, 6)", testTable.getName()), 1L);
            this.assertUpdate(String.format("INSERT INTO %s VALUES (7, null, null, 8, 9)", testTable.getName()), 1L);
            this.assertUpdate(String.format("INSERT INTO %s (col_required2, col_required) VALUES (12, 13)", testTable.getName()), 1L);
            this.assertQuery("SELECT * FROM " + testTable.getName(), "VALUES (1, null, 43, 42, 10), (2, 3, 4, 5, 6), (7, null, null, 8, 9), (13, null, 43, 42, 12)");
        }
    }

    protected TestTable createTableWithDefaultColumns() {
        throw new UnsupportedOperationException();
    }

    @Test
    public void testInsertUnicode() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_unicode_", "(test varchar(50))");){
            this.assertUpdate("INSERT INTO " + table.getName() + "(test) VALUES 'Hello', U&'hello\\6d4B\\8Bd5world\\7F16\\7801' ", 2L);
            Assertions.assertThat((Iterable)this.computeActual("SELECT test FROM " + table.getName()).getOnlyColumnAsSet()).containsExactlyInAnyOrder(new Object[]{"Hello", "hello\u6d4b\u8bd5world\u7f16\u7801"});
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_unicode_", "(test varchar(50))");
        try {
            this.assertUpdate("INSERT INTO " + table.getName() + "(test) VALUES 'aa', 'b\u00e9'", 2L);
            this.assertQuery("SELECT test FROM " + table.getName(), "VALUES 'aa', 'b\u00e9'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test = 'aa'", "VALUES 'aa'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test > 'ba'", "VALUES 'b\u00e9'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test < 'ba'", "VALUES 'aa'");
            this.assertQueryReturnsEmptyResult("SELECT test FROM " + table.getName() + " WHERE test = 'ba'");
        }
        finally {
            table.close();
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_unicode_", "(test varchar(50))");
        try {
            this.assertUpdate("INSERT INTO " + table.getName() + "(test) VALUES 'a', '\u00e9'", 2L);
            this.assertQuery("SELECT test FROM " + table.getName(), "VALUES 'a', '\u00e9'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test = 'a'", "VALUES 'a'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test > 'b'", "VALUES '\u00e9'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test < 'b'", "VALUES 'a'");
            this.assertQueryReturnsEmptyResult("SELECT test FROM " + table.getName() + " WHERE test = 'b'");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testInsertHighestUnicodeCharacter() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_unicode_", "(test varchar(50))");){
            this.assertUpdate("INSERT INTO " + table.getName() + "(test) VALUES 'Hello', U&'hello\\6d4B\\8Bd5\\+10FFFFworld\\7F16\\7801' ", 2L);
            Assertions.assertThat((Iterable)this.computeActual("SELECT test FROM " + table.getName()).getOnlyColumnAsSet()).containsExactlyInAnyOrder(new Object[]{"Hello", "hello\u6d4b\u8bd5\udbff\udfffworld\u7f16\u7801"});
        }
    }

    @Test
    public void testInsertArray() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        String tableName = "test_insert_array_" + TestTable.randomTableSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ARRAY)) {
            Assertions.assertThatThrownBy(() -> this.query("CREATE TABLE " + tableName + " (a array(bigint))")).hasMessageMatching("[Uu]nsupported (column )?type: \\Qarray(bigint)");
            throw new SkipException("not supported");
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_array_", "(a ARRAY<DOUBLE>, b ARRAY<BIGINT>)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " (a) VALUES (ARRAY[null])", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (a, b) VALUES (ARRAY[1.23E1], ARRAY[1.23E1])", 1L);
            this.assertQuery("SELECT a[1], b[1] FROM " + table.getName(), "VALUES (null, null), (12.3, 12)");
        }
    }

    @Test
    public void testInsertNegativeDate() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            this.assertQueryFails("INSERT INTO orders (orderdate) VALUES (DATE '-0001-01-01')", "This connector does not support inserts");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test INSERT negative dates without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NEGATIVE_DATE)) {
            try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "insert_date", "(dt DATE)");){
                this.assertQueryFails(String.format("INSERT INTO %s VALUES (DATE '-0001-01-01')", table.getName()), this.errorMessageForInsertNegativeDate("-0001-01-01"));
            }
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "insert_date", "(dt DATE)");){
            this.assertUpdate(String.format("INSERT INTO %s VALUES (DATE '-0001-01-01')", table.getName()), 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES DATE '-0001-01-01'");
            this.assertQuery(String.format("SELECT * FROM %s WHERE dt = DATE '-0001-01-01'", table.getName()), "VALUES DATE '-0001-01-01'");
        }
    }

    @Language(value="RegExp")
    protected String errorMessageForInsertNegativeDate(String date) {
        throw new UnsupportedOperationException("This method should be overridden");
    }

    protected boolean isReportingWrittenBytesSupported(Session session) {
        CatalogName catalogName = session.getCatalog().map(CatalogName::new).orElseThrow();
        Metadata metadata = this.getQueryRunner().getMetadata();
        metadata.getCatalogHandle(session, catalogName.getCatalogName());
        QualifiedObjectName fullTableName = new QualifiedObjectName(catalogName.getCatalogName(), "any", "any");
        return this.getQueryRunner().getMetadata().supportsReportingWrittenBytes(session, fullTableName, (Map)ImmutableMap.of());
    }

    @Test
    public void isReportingWrittenBytesSupported() {
        TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).singleStatement().execute(this.getSession(), session -> BaseConnectorTest.skipTestUnless(this.isReportingWrittenBytesSupported((Session)session)));
        String query = "CREATE TABLE temp AS SELECT * FROM tpch.tiny.nation";
        this.assertQueryStats(this.getSession(), query, queryStats -> Assertions.assertThat((long)queryStats.getPhysicalWrittenDataSize().toBytes()).isGreaterThan(0L), results -> {});
    }

    @Test
    public void testInsertIntoNotNullColumn() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT)) {
            this.assertQueryFails("CREATE TABLE not_null_constraint (not_null_col INTEGER NOT NULL)", String.format("line 1:35: Catalog '%s' does not support non-null column for column name 'not_null_col'", this.getSession().getCatalog().orElseThrow()));
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "insert_not_null", "(nullable_col INTEGER, not_null_col INTEGER NOT NULL)");){
            this.assertUpdate(String.format("INSERT INTO %s (not_null_col) VALUES (2)", table.getName()), 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (NULL, 2)");
            this.assertQueryFails(String.format("INSERT INTO %s (nullable_col) VALUES (1)", table.getName()), this.errorMessageForInsertIntoNotNullColumn("not_null_col"));
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "commuted_not_null", "(nullable_col BIGINT, not_null_col BIGINT NOT NULL)");
        try {
            this.assertUpdate(String.format("INSERT INTO %s (not_null_col) VALUES (2)", table.getName()), 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (NULL, 2)");
            this.assertQueryFails(String.format("INSERT INTO %s (not_null_col, nullable_col) VALUES (NULL, 3)", table.getName()), "NULL value not allowed for NOT NULL column: not_null_col");
        }
        finally {
            table.close();
        }
    }

    @Language(value="RegExp")
    protected String errorMessageForInsertIntoNotNullColumn(String columnName) {
        throw new UnsupportedOperationException("This method should be overridden");
    }

    @Test
    public void testInsertInTransaction() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_tx_insert", "(a bigint)");){
            String tableName = table.getName();
            this.inTransaction(session -> this.assertUpdate((Session)session, "INSERT INTO " + tableName + " VALUES 42", 1L));
            this.assertQuery("TABLE " + tableName, "VALUES 42");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_", "AS SELECT * FROM orders");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE custkey <= 100", "SELECT count(*) FROM orders WHERE custkey <= 100");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE custkey > 100");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE custkey <= 300", "SELECT count(*) FROM orders WHERE custkey > 100 AND custkey <= 300");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE custkey > 300");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE custkey <= 500", "SELECT count(*) FROM orders WHERE custkey > 300 AND custkey <= 500");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE custkey > 500");
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_", "AS SELECT * FROM orders");
        try {
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey < 0", 0L);
        }
        finally {
            table.close();
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_", "AS SELECT * FROM orders");
        try {
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey > 5 AND orderkey < 4", 0L);
        }
        finally {
            table.close();
        }
        String tableName = "test_delete_" + TestTable.randomTableSuffix();
        try {
            this.assertExplainAnalyze("EXPLAIN ANALYZE CREATE TABLE " + tableName + " AS SELECT CAST(orderstatus AS VARCHAR(15)) orderstatus FROM orders", new String[0]);
            this.assertQuery("SELECT * from " + tableName, "SELECT orderstatus FROM orders");
            this.assertExplainAnalyze("EXPLAIN ANALYZE INSERT INTO " + tableName + " SELECT clerk FROM orders", new String[0]);
            this.assertQuery("SELECT * from " + tableName, "SELECT orderstatus FROM orders UNION ALL SELECT clerk FROM orders");
            this.assertExplainAnalyze("EXPLAIN ANALYZE DELETE FROM " + tableName + " WHERE TRUE", new String[0]);
            this.assertQuery("SELECT COUNT(*) from " + tableName, "SELECT 0");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testDeleteWithLike() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_with_like_", "AS SELECT * FROM nation");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE name LIKE '%a%'", "VALUES 0");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE name LIKE '%A%'", "SELECT count(*) FROM nation WHERE name LIKE '%A%'");
        }
    }

    @Test
    public void testDeleteWithComplexPredicate() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_complex_", "AS SELECT * FROM orders");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey % 2 = 0", "SELECT count(*) FROM orders WHERE orderkey % 2 = 0");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE orderkey % 2 <> 0");
            this.assertUpdate("DELETE FROM " + table.getName(), "SELECT count(*) FROM orders WHERE orderkey % 2 <> 0");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders LIMIT 0");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE rand() < 0", 0L);
        }
    }

    @Test
    public void testDeleteWithSubquery() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_subquery", "AS SELECT * FROM nation");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE regionkey IN (SELECT regionkey FROM region WHERE name LIKE 'A%')", 15L);
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM nation WHERE regionkey IN (SELECT regionkey FROM region WHERE name NOT LIKE 'A%')");
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_subquery", "AS SELECT * FROM orders");
        try {
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey = (SELECT orderkey FROM orders ORDER BY orderkey LIMIT 1)", 1L);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey = (SELECT orderkey FROM orders WHERE false)", 0L);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE EXISTS(SELECT 1 WHERE false)", 0L);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE EXISTS(SELECT 1)", "SELECT count(*) - 1 FROM orders");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testExplainAnalyzeWithDeleteWithSubquery() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        String tableName = "test_delete_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM nation", 25L);
        this.assertExplainAnalyze("EXPLAIN ANALYZE DELETE FROM " + tableName + " WHERE regionkey IN (SELECT regionkey FROM region WHERE name LIKE 'A%' LIMIT 1)", "SemiJoin.*");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDeleteWithSemiJoin() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_semijoin", "AS SELECT * FROM nation");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE regionkey IN (SELECT regionkey FROM region WHERE name LIKE 'A%')   AND regionkey IN (SELECT regionkey FROM region WHERE length(comment) < 50)", 10L);
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM nation WHERE regionkey IN (SELECT regionkey FROM region WHERE name NOT LIKE 'A%')   OR regionkey IN (SELECT regionkey FROM region WHERE length(comment) >= 50)");
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_semijoin", "AS SELECT * FROM orders");
        try {
            this.assertUpdate("DELETE FROM " + table.getName() + "\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM tpch.tiny.lineitem)) IS NULL\n", "SELECT count(*) FROM orders\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NULL\n");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NOT NULL\n");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testDeleteWithVarcharPredicate() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_with_varchar_predicate_", "AS SELECT * FROM orders");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderstatus = 'O'", "SELECT count(*) FROM orders WHERE orderstatus = 'O'");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE orderstatus <> 'O'");
        }
    }

    @Test
    public void verifySupportsDeleteDeclaration() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE)) {
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_supports_delete", "(regionkey int)");){
            this.assertQueryFails("DELETE FROM " + table.getName(), "This connector does not support deletes");
        }
    }

    @Test
    public void verifySupportsRowLevelDeleteDeclaration() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE)) {
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_supports_row_level_delete", "(regionkey int)");){
            this.assertQueryFails("DELETE FROM " + table.getName() + " WHERE regionkey = 2", "This connector does not support deletes");
        }
    }

    @Test
    public void testDeleteAllDataFromTable() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_all_data", "AS SELECT * FROM region");){
            this.getQueryRunner().execute("DELETE FROM " + table.getName());
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "VALUES 0");
        }
    }

    @Test
    public void testRowLevelDelete() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_row_delete", "AS SELECT * FROM region");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE regionkey = 2", 1L);
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "VALUES 4");
        }
    }

    @Test
    public void testUpdate() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            this.assertQueryFails("UPDATE nation SET nationkey = nationkey + regionkey WHERE regionkey < 1", "This connector does not support updates");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_update", "AS TABLE tpch.tiny.nation");){
            String tableName = table.getName();
            this.assertUpdate("UPDATE " + tableName + " SET nationkey = 100 + nationkey WHERE regionkey = 2", 5L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + tableName))).skippingTypesCheck().matches("SELECT IF(regionkey=2, nationkey + 100, nationkey) nationkey, name, regionkey, comment FROM tpch.tiny.nation");
            this.assertUpdate("UPDATE " + tableName + " SET nationkey = nationkey * 2 WHERE regionkey IN (2,3)", 10L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + tableName))).skippingTypesCheck().matches("SELECT CASE regionkey WHEN 2 THEN 2*(nationkey+100) WHEN 3 THEN 2*nationkey ELSE nationkey END nationkey, name, regionkey, comment FROM tpch.tiny.nation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=60000L, invocationCount=4)
    public void testUpdateRowConcurrently() throws Exception {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            return;
        }
        int threads = 4;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_concurrent_update", IntStream.range(0, threads).mapToObj(i -> String.format("col%s integer", i)).collect(Collectors.joining(", ", "(", ")")));){
            String tableName = table.getName();
            this.assertUpdate(String.format("INSERT INTO %s VALUES (%s)", tableName, String.join((CharSequence)",", Collections.nCopies(threads, "0"))), 1L);
            List futures = (List)IntStream.range(0, threads).mapToObj(threadNumber -> executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                try {
                    String columnName = "col" + threadNumber;
                    this.getQueryRunner().execute(String.format("UPDATE %s SET %s = %s + 1", tableName, columnName, columnName));
                    return true;
                }
                catch (Exception e) {
                    RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause(e);
                    try {
                        this.verifyConcurrentUpdateFailurePermissible(trinoException);
                    }
                    catch (Throwable verifyFailure) {
                        if (trinoException != e && verifyFailure != e) {
                            verifyFailure.addSuppressed(e);
                        }
                        throw verifyFailure;
                    }
                    return false;
                }
            })).collect(ImmutableList.toImmutableList());
            String expected = futures.stream().map(future -> (Boolean)MoreFutures.tryGetFutureValue((Future)future, (int)10, (TimeUnit)TimeUnit.SECONDS).orElseThrow(() -> new RuntimeException("Wait timed out"))).map(success -> success != false ? "1" : "0").collect(Collectors.joining(",", "VALUES (", ")"));
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("TABLE " + tableName))).matches(expected);
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    protected void verifyConcurrentUpdateFailurePermissible(Exception e) {
        throw new AssertionError("Unexpected concurrent update failure", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=60000L, invocationCount=4)
    public void testInsertRowConcurrently() throws Exception {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            return;
        }
        int threads = 4;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert", "(col integer)");){
            String tableName = table.getName();
            List futures = (List)IntStream.range(0, threads).mapToObj(threadNumber -> executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                try {
                    this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (" + threadNumber + ")");
                    return OptionalInt.of(threadNumber);
                }
                catch (Exception e) {
                    RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause(e);
                    try {
                        this.verifyConcurrentInsertFailurePermissible(trinoException);
                    }
                    catch (Throwable verifyFailure) {
                        if (trinoException != e && verifyFailure != e) {
                            verifyFailure.addSuppressed(e);
                        }
                        throw verifyFailure;
                    }
                    return OptionalInt.empty();
                }
            })).collect(ImmutableList.toImmutableList());
            List values = (List)futures.stream().map(future -> (OptionalInt)MoreFutures.tryGetFutureValue((Future)future, (int)10, (TimeUnit)TimeUnit.SECONDS).orElseThrow(() -> new RuntimeException("Wait timed out"))).filter(OptionalInt::isPresent).map(OptionalInt::getAsInt).collect(ImmutableList.toImmutableList());
            if (values.isEmpty()) {
                this.assertQueryReturnsEmptyResult("TABLE " + tableName);
            } else {
                ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT CAST(col AS INTEGER) FROM " + tableName))).matches(values.stream().map(value -> String.format("(%s)", value)).collect(Collectors.joining(",", "VALUES ", "")));
            }
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    protected void verifyConcurrentInsertFailurePermissible(Exception e) {
        throw new AssertionError("Unexpected concurrent insert failure", e);
    }

    @Test
    public void testUpdateWithPredicates() {
        String tableName;
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            this.assertQueryFails("UPDATE nation SET nationkey = nationkey + regionkey WHERE regionkey < 1", "This connector does not support updates");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_update_with_predicates", "(a INT, b INT, c INT)");){
            tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 2, 3), (11, 12, 13), (21, 22, 23)", 3L);
            this.assertUpdate("UPDATE " + tableName + " SET a = a - 1 WHERE c = 3", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 13), (21, 22, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET c = c + 1 WHERE a = 11", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 14), (21, 22, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET b = b * 2 WHERE b = 22", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 14), (21, 44, 23)");
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_update_with_predicates_on_row_types", "(int_t INT, row_t ROW(f1 INT, f2 INT))");
        try {
            tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW(2, 3)), (11, ROW(12, 13)), (21, ROW(22, 23))", 3L);
            this.assertUpdate("UPDATE " + tableName + " SET int_t = int_t - 1 WHERE row_t.f2 = 3", 1L);
            this.assertQuery("SELECT int_t, row_t.f1, row_t.f2 FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 13), (21, 22, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET row_t = ROW(row_t.f1, row_t.f2 + 1) WHERE int_t = 11", 1L);
            this.assertQuery("SELECT int_t, row_t.f1, row_t.f2 FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 14), (21, 22, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET row_t = ROW(row_t.f1 * 2, row_t.f2) WHERE row_t.f1 = 22", 1L);
            this.assertQuery("SELECT int_t, row_t.f1, row_t.f2 FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 14), (21, 44, 23)");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testUpdateAllValues() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            this.assertQueryFails("UPDATE nation SET nationkey = nationkey + regionkey WHERE regionkey < 1", "This connector does not support updates");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_update_all_columns", "(a INT, b INT, c INT)");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 2, 3), (11, 12, 13), (21, 22, 23)", 3L);
            this.assertUpdate("UPDATE " + tableName + " SET a = a + 1, b = b - 1, c = c * 2", 3L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (2, 1, 6), (12, 11, 26), (22, 21, 46)");
        }
    }

    @Test
    public void testDropTable() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String tableName = "test_drop_table_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(col bigint)");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testDropTableIfExists() {
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_drop_if_exists"));
        this.assertUpdate("DROP TABLE IF EXISTS test_drop_if_exists");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_drop_if_exists"));
    }

    @Test
    public void testTruncateTable() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TRUNCATE)) {
            this.assertQueryFails("TRUNCATE TABLE nation", "This connector does not support truncating tables");
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_truncate", "AS SELECT * FROM region");){
            this.assertUpdate("TRUNCATE TABLE " + table.getName());
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "VALUES 0");
        }
    }

    @Test
    public void testQueryLoggingCount() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        QueryManager queryManager = this.getDistributedQueryRunner().getCoordinator().getQueryManager();
        this.executeExclusively(() -> {
            Assert.assertEventually((Duration)new Duration(1.0, TimeUnit.MINUTES), () -> Assert.assertEquals((Collection)queryManager.getQueries().stream().map(BasicQueryInfo::getQueryId).map(arg_0 -> ((QueryManager)queryManager).getFullQueryInfo(arg_0)).filter(info -> !info.isFinalQueryInfo()).collect(Collectors.toList()), (Collection)ImmutableList.of()));
            DispatchManager dispatchManager = ((DistributedQueryRunner)this.getQueryRunner()).getCoordinator().getDispatchManager();
            long beforeCompletedQueriesCount = this.waitUntilStable(() -> dispatchManager.getStats().getCompletedQueries().getTotalCount(), new Duration(5.0, TimeUnit.SECONDS));
            long beforeSubmittedQueriesCount = dispatchManager.getStats().getSubmittedQueries().getTotalCount();
            String tableName = "test_logging_count" + TestTable.randomTableSuffix();
            this.assertUpdate("CREATE TABLE " + tableName + this.tableDefinitionForQueryLoggingCount());
            this.assertQueryReturnsEmptyResult("SELECT foo_1, foo_2_4 FROM " + tableName);
            this.assertUpdate("DROP TABLE " + tableName);
            this.assertQueryFails("SELECT * FROM " + tableName, ".*Table .* does not exist");
            Assert.assertEventually((Duration)new Duration(1.0, TimeUnit.MINUTES), () -> Assert.assertEquals((long)(dispatchManager.getStats().getCompletedQueries().getTotalCount() - beforeCompletedQueriesCount), (long)4L));
            Assert.assertEquals((long)(dispatchManager.getStats().getSubmittedQueries().getTotalCount() - beforeSubmittedQueriesCount), (long)4L);
        });
    }

    @Language(value="SQL")
    protected String tableDefinitionForQueryLoggingCount() {
        return "(foo_1 int, foo_2_4 int)";
    }

    private <T> T waitUntilStable(Supplier<T> computation, Duration timeout) {
        T lastValue = computation.get();
        long start = System.nanoTime();
        while (!Thread.currentThread().isInterrupted() && Duration.nanosSince((long)start).compareTo(timeout) < 0) {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            T currentValue = computation.get();
            if (currentValue.equals(lastValue)) {
                return currentValue;
            }
            lastValue = currentValue;
        }
        throw new UncheckedTimeoutException();
    }

    @Test
    public void testShowSchemasFromOther() {
        MaterializedResult result = this.computeActual("SHOW SCHEMAS FROM tpch");
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)ImmutableSet.of((Object)"information_schema", (Object)"tiny", (Object)"sf1")));
    }

    @Test
    public void testSymbolAliasing() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String tableName = "test_symbol_aliasing" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 foo_1, 2 foo_2_4", 1L);
        this.assertQuery("SELECT foo_1, foo_2_4 FROM " + tableName, "SELECT 1, 2");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrittenStats() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        String tableName = "test_written_stats_" + TestTable.randomTableSuffix();
        try {
            String sql = "CREATE TABLE " + tableName + " AS SELECT * FROM nation";
            ResultWithQueryId<MaterializedResult> resultResultWithQueryId = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), sql);
            QueryInfo queryInfo = this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(resultResultWithQueryId.getQueryId());
            Assert.assertEquals((long)queryInfo.getQueryStats().getOutputPositions(), (long)1L);
            Assert.assertEquals((long)queryInfo.getQueryStats().getWrittenPositions(), (long)25L);
            org.testng.Assert.assertTrue((queryInfo.getQueryStats().getLogicalWrittenDataSize().toBytes() > 0L ? 1 : 0) != 0);
            sql = "INSERT INTO " + tableName + " SELECT * FROM nation LIMIT 10";
            resultResultWithQueryId = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), sql);
            queryInfo = this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(resultResultWithQueryId.getQueryId());
            Assert.assertEquals((long)queryInfo.getQueryStats().getOutputPositions(), (long)1L);
            Assert.assertEquals((long)queryInfo.getQueryStats().getWrittenPositions(), (long)10L);
            org.testng.Assert.assertTrue((queryInfo.getQueryStats().getLogicalWrittenDataSize().toBytes() > 0L ? 1 : 0) != 0);
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test(dataProvider="testColumnNameDataProvider")
    public void testColumnName(String columnName) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        if (!BaseConnectorTest.requiresDelimiting(columnName)) {
            this.testColumnName(columnName, false);
        }
        this.testColumnName(columnName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testColumnName(String columnName, boolean delimited) {
        Object nameInSql = columnName;
        if (delimited) {
            nameInSql = "\"" + columnName.replace("\"", "\"\"") + "\"";
        }
        String tableName = "tcn_" + ((String)nameInSql).toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "") + TestTable.randomTableSuffix();
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(key varchar(50), " + (String)nameInSql + " varchar(50))");
        }
        catch (RuntimeException e) {
            if (this.isColumnNameRejected(e, columnName, delimited)) {
                return;
            }
            throw e;
        }
        try {
            this.assertUpdate("INSERT INTO " + tableName + " VALUES ('null value', NULL), ('sample value', 'abc'), ('other value', 'xyz')", 3L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('null value', NULL), ('sample value', 'abc'), ('other value', 'xyz')");
            this.assertQuery("SELECT " + (String)nameInSql + " FROM " + tableName, "VALUES (NULL), ('abc'), ('xyz')");
            this.assertQuery("SELECT key FROM " + tableName + " WHERE " + (String)nameInSql + " IS NULL", "VALUES ('null value')");
            this.assertQuery("SELECT key FROM " + tableName + " WHERE " + (String)nameInSql + " = 'abc'", "VALUES ('sample value')");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    protected boolean isColumnNameRejected(Exception exception, String columnName, boolean delimited) {
        return false;
    }

    protected static boolean requiresDelimiting(String identifierName) {
        return !identifierName.matches("[a-zA-Z][a-zA-Z0-9_]*");
    }

    @DataProvider
    public Object[][] testColumnNameDataProvider() {
        return (Object[][])this.testColumnNameTestData().stream().map(this::filterColumnNameTestData).filter(Optional::isPresent).map(Optional::get).collect(DataProviders.toDataProvider());
    }

    private List<String> testColumnNameTestData() {
        return ImmutableList.builder().add((Object)"lowercase").add((Object)"UPPERCASE").add((Object)"MixedCase").add((Object)"an_underscore").add((Object)"a-hyphen-minus").add((Object)"a space").add((Object)"atrailingspace ").add((Object)" aleadingspace").add((Object)"a.dot").add((Object)"a,comma").add((Object)"a:colon").add((Object)"a;semicolon").add((Object)"an@at").add((Object)"a\"quote").add((Object)"an'apostrophe").add((Object)"a`backtick`").add((Object)"a/slash`").add((Object)"a\\backslash`").add((Object)"adigit0").add((Object)"0startwithdigit").build();
    }

    protected Optional<String> filterColumnNameTestData(String columnName) {
        return Optional.of(columnName);
    }

    protected String dataMappingTableName(String trinoTypeName) {
        return "test_data_mapping_smoke_" + trinoTypeName.replaceAll("[^a-zA-Z0-9]", "_") + "_" + TestTable.randomTableSuffix();
    }

    @Test(dataProvider="testDataMappingSmokeTestDataProvider")
    public void testDataMappingSmokeTest(DataMappingTestSetup dataMappingTestSetup) {
        this.testDataMapping(dataMappingTestSetup);
    }

    private void testDataMapping(DataMappingTestSetup dataMappingTestSetup) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String trinoTypeName = dataMappingTestSetup.getTrinoTypeName();
        String sampleValueLiteral = dataMappingTestSetup.getSampleValueLiteral();
        String highValueLiteral = dataMappingTestSetup.getHighValueLiteral();
        String tableName = this.dataMappingTableName(trinoTypeName);
        Runnable setup = () -> {
            String createTable = "CREATE TABLE " + tableName + " AS SELECT CAST(row_id AS varchar(50)) row_id, CAST(value AS " + trinoTypeName + ") value FROM (VALUES   ('null value', NULL),   ('sample value', " + sampleValueLiteral + "),   ('high value', " + highValueLiteral + "))  t(row_id, value)";
            this.assertUpdate(createTable, 3L);
        };
        if (dataMappingTestSetup.isUnsupportedType()) {
            Assertions.assertThatThrownBy(setup::run).satisfies(exception -> this.verifyUnsupportedTypeException((Throwable)exception, trinoTypeName));
            return;
        }
        setup.run();
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE rand() = 42 OR value IS NULL", "VALUES 'null value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE rand() = 42 OR value IS NOT NULL", "VALUES 'sample value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE rand() = 42 OR value = " + sampleValueLiteral, "VALUES 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE rand() = 42 OR value = " + highValueLiteral, "VALUES 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL", "VALUES 'null value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NOT NULL", "VALUES 'sample value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value = " + sampleValueLiteral, "VALUES 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value != " + sampleValueLiteral, "VALUES 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value <= " + sampleValueLiteral, "VALUES 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value > " + sampleValueLiteral, "VALUES 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value <= " + highValueLiteral, "VALUES 'sample value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value = " + sampleValueLiteral, "VALUES 'null value', 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value != " + sampleValueLiteral, "VALUES 'null value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value <= " + sampleValueLiteral, "VALUES 'null value', 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value > " + sampleValueLiteral, "VALUES 'null value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value <= " + highValueLiteral, "VALUES 'null value', 'sample value', 'high value'");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @DataProvider
    public final Object[][] testDataMappingSmokeTestDataProvider() {
        return (Object[][])this.testDataMappingSmokeTestData().stream().map(this::filterDataMappingSmokeTestData).flatMap(Optional::stream).collect(DataProviders.toDataProvider());
    }

    private List<DataMappingTestSetup> testDataMappingSmokeTestData() {
        return ImmutableList.builder().add((Object)new DataMappingTestSetup("boolean", "false", "true")).add((Object)new DataMappingTestSetup("tinyint", "37", "127")).add((Object)new DataMappingTestSetup("smallint", "32123", "32767")).add((Object)new DataMappingTestSetup("integer", "1274942432", "2147483647")).add((Object)new DataMappingTestSetup("bigint", "312739231274942432", "9223372036854775807")).add((Object)new DataMappingTestSetup("real", "REAL '567.123'", "REAL '999999.999'")).add((Object)new DataMappingTestSetup("double", "DOUBLE '1234567890123.123'", "DOUBLE '9999999999999.999'")).add((Object)new DataMappingTestSetup("decimal(5,3)", "12.345", "99.999")).add((Object)new DataMappingTestSetup("decimal(15,3)", "123456789012.345", "999999999999.99")).add((Object)new DataMappingTestSetup("date", "DATE '0001-01-01'", "DATE '1582-10-04'")).add((Object)new DataMappingTestSetup("date", "DATE '1582-10-05'", "DATE '1582-10-14'")).add((Object)new DataMappingTestSetup("date", "DATE '2020-02-12'", "DATE '9999-12-31'")).add((Object)new DataMappingTestSetup("time", "TIME '15:03:00'", "TIME '23:59:59.999'")).add((Object)new DataMappingTestSetup("timestamp", "TIMESTAMP '2020-02-12 15:03:00'", "TIMESTAMP '2199-12-31 23:59:59.999'")).add((Object)new DataMappingTestSetup("timestamp(3) with time zone", "TIMESTAMP '2020-02-12 15:03:00 +01:00'", "TIMESTAMP '9999-12-31 23:59:59.999 +12:00'")).add((Object)new DataMappingTestSetup("char(3)", "'ab'", "'zzz'")).add((Object)new DataMappingTestSetup("varchar(3)", "'de'", "'zzz'")).add((Object)new DataMappingTestSetup("varchar", "'\u0142\u0105ka for the win'", "'\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b'")).add((Object)new DataMappingTestSetup("varbinary", "X'12ab3f'", "X'ffffffffffffffffffff'")).build();
    }

    protected Optional<DataMappingTestSetup> filterDataMappingSmokeTestData(DataMappingTestSetup dataMappingTestSetup) {
        return Optional.of(dataMappingTestSetup);
    }

    @Test(dataProvider="testCaseSensitiveDataMappingProvider")
    public void testCaseSensitiveDataMapping(DataMappingTestSetup dataMappingTestSetup) {
        this.testDataMapping(dataMappingTestSetup);
    }

    @DataProvider
    public final Object[][] testCaseSensitiveDataMappingProvider() {
        return (Object[][])this.testCaseSensitiveDataMappingData().stream().map(this::filterCaseSensitiveDataMappingTestData).flatMap(Optional::stream).collect(DataProviders.toDataProvider());
    }

    protected Optional<DataMappingTestSetup> filterCaseSensitiveDataMappingTestData(DataMappingTestSetup dataMappingTestSetup) {
        return Optional.of(dataMappingTestSetup);
    }

    private List<DataMappingTestSetup> testCaseSensitiveDataMappingData() {
        return ImmutableList.builder().add((Object)new DataMappingTestSetup("char(1)", "'A'", "'a'")).add((Object)new DataMappingTestSetup("varchar(1)", "'A'", "'a'")).add((Object)new DataMappingTestSetup("char(1)", "'A'", "'b'")).add((Object)new DataMappingTestSetup("varchar(1)", "'A'", "'b'")).add((Object)new DataMappingTestSetup("char(1)", "'B'", "'a'")).add((Object)new DataMappingTestSetup("varchar(1)", "'B'", "'a'")).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPotentialDuplicateDereferencePushdown() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        String tableName = "test_dup_deref_" + TestTable.randomTableSuffix();
        String createTable = "CREATE TABLE " + tableName + " AS SELECT CAST(ROW('abc', 1) AS row(a varchar, b bigint)) r";
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE)) {
            try {
                this.assertUpdate(createTable);
            }
            catch (Exception expected) {
                this.verifyUnsupportedTypeException(expected, "row(a varchar, b bigint)");
                return;
            }
            this.assertUpdate("DROP TABLE " + tableName);
            org.testng.Assert.fail((String)"Expected create table failure");
        }
        this.assertUpdate(createTable, 1L);
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r, r.b + 2 FROM " + tableName))).matches("SELECT CAST(ROW('abc', 1) AS ROW(a varchar, b bigint)), BIGINT '3'");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r[1], r[2], r.b + 2 FROM " + tableName))).matches("VALUES (VARCHAR 'abc', BIGINT '1', BIGINT '3')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r[2], r.b + 2 FROM " + tableName))).matches("VALUES (BIGINT '1', BIGINT '3')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r.b, r.b + 2 FROM " + tableName))).matches("VALUES (BIGINT '1', BIGINT '3')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r, r.a LIKE '%c' FROM " + tableName))).matches("SELECT CAST(ROW('abc', 1) AS ROW(a varchar, b bigint)), true");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r[1], r[2], r.a LIKE '%c' FROM " + tableName))).matches("VALUES (VARCHAR 'abc', BIGINT '1', true)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r[1], r.a LIKE '%c' FROM " + tableName))).matches("VALUES (VARCHAR 'abc', true)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r.a, r.a LIKE '%c' FROM " + tableName))).matches("VALUES (VARCHAR 'abc', true)");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    private void verifyUnsupportedTypeException(Throwable exception, String trinoTypeName) {
        String typeNameBase = trinoTypeName.replaceFirst("\\(.*", "");
        String expectedMessagePart = String.format("(%1$s.*not (yet )?supported)|((?i)unsupported.*%1$s)|((?i)not supported.*%1$s)", Pattern.quote(typeNameBase));
        Assertions.assertThat((Throwable)exception).hasMessageFindingMatch(expectedMessagePart).satisfies(e -> Assertions.assertThat((Throwable)QueryAssertions.getTrinoExceptionCause(e)).hasMessageFindingMatch(expectedMessagePart));
    }

    @Test(dataProvider="testColumnNameDataProvider")
    public void testMaterializedViewColumnName(String columnName) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        if (!BaseConnectorTest.requiresDelimiting(columnName)) {
            this.testMaterializedViewColumnName(columnName, false);
        }
        this.testMaterializedViewColumnName(columnName, true);
    }

    private void testMaterializedViewColumnName(String columnName, boolean delimited) {
        Object nameInSql = columnName;
        if (delimited) {
            nameInSql = "\"" + columnName.replace("\"", "\"\"") + "\"";
        }
        String viewName = "tcn_" + ((String)nameInSql).toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "_") + "_" + TestTable.randomTableSuffix();
        try {
            this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " AS SELECT 'sample value' key, 'abc' " + (String)nameInSql);
        }
        catch (RuntimeException e) {
            if (this.isColumnNameRejected(e, columnName, delimited)) {
                return;
            }
            throw e;
        }
        this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 1L);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES ('sample value', 'abc')");
        this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
    }

    protected Consumer<Plan> assertPartialLimitWithPreSortedInputsCount(Session session, int expectedCount) {
        return plan -> {
            int actualCount = PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof LimitNode && ((LimitNode)node).isPartial() && ((LimitNode)node).requiresPreSortedInputs()).findAll().size();
            if (actualCount != expectedCount) {
                Metadata metadata = this.getDistributedQueryRunner().getMetadata();
                FunctionManager functionManager = this.getDistributedQueryRunner().getFunctionManager();
                String formattedPlan = PlanPrinter.textLogicalPlan((PlanNode)plan.getRoot(), (TypeProvider)plan.getTypes(), (Metadata)metadata, (FunctionManager)functionManager, (StatsAndCosts)StatsAndCosts.empty(), (Session)session, (int)0, (boolean)false);
                throw new AssertionError((Object)String.format("Expected [\n%s\n] partial limit but found [\n%s\n] partial limit. Actual plan is [\n\n%s\n]", expectedCount, actualCount, formattedPlan));
            }
        };
    }

    protected String createSchemaSql(String schemaName) {
        return "CREATE SCHEMA " + schemaName;
    }

    protected static final class DataMappingTestSetup {
        private final String trinoTypeName;
        private final String sampleValueLiteral;
        private final String highValueLiteral;
        private final boolean unsupportedType;

        public DataMappingTestSetup(String trinoTypeName, String sampleValueLiteral, String highValueLiteral) {
            this(trinoTypeName, sampleValueLiteral, highValueLiteral, false);
        }

        private DataMappingTestSetup(String trinoTypeName, String sampleValueLiteral, String highValueLiteral, boolean unsupportedType) {
            this.trinoTypeName = Objects.requireNonNull(trinoTypeName, "trinoTypeName is null");
            this.sampleValueLiteral = Objects.requireNonNull(sampleValueLiteral, "sampleValueLiteral is null");
            this.highValueLiteral = Objects.requireNonNull(highValueLiteral, "highValueLiteral is null");
            this.unsupportedType = unsupportedType;
        }

        public String getTrinoTypeName() {
            return this.trinoTypeName;
        }

        public String getSampleValueLiteral() {
            return this.sampleValueLiteral;
        }

        public String getHighValueLiteral() {
            return this.highValueLiteral;
        }

        public boolean isUnsupportedType() {
            return this.unsupportedType;
        }

        public DataMappingTestSetup asUnsupported() {
            return new DataMappingTestSetup(this.trinoTypeName, this.sampleValueLiteral, this.highValueLiteral, true);
        }

        public String toString() {
            return this.trinoTypeName + (this.unsupportedType ? "!" : "");
        }
    }

    private static class RollbackException
    extends RuntimeException {
        private RollbackException() {
        }
    }
}

