/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.client.ClientSelectedRole;
import io.trino.client.ClientSession;
import io.trino.client.Column;
import io.trino.client.QueryError;
import io.trino.client.QueryStatusInfo;
import io.trino.client.StatementClient;
import io.trino.client.StatementClientFactory;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.security.AccessControl;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.QueryId;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.session.ResourceEstimates;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.testing.ResultWithQueryId;
import io.trino.testing.ResultsSession;
import io.trino.transaction.TransactionBuilder;
import io.trino.transaction.TransactionManager;
import java.io.Closeable;
import java.net.URI;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import okhttp3.OkHttpClient;
import org.intellij.lang.annotations.Language;

public abstract class AbstractTestingTrinoClient<T>
implements Closeable {
    private final TestingTrinoServer trinoServer;
    private final Session defaultSession;
    private final OkHttpClient httpClient;

    protected AbstractTestingTrinoClient(TestingTrinoServer trinoServer, Session defaultSession) {
        this(trinoServer, defaultSession, new OkHttpClient());
    }

    protected AbstractTestingTrinoClient(TestingTrinoServer trinoServer, Session defaultSession, OkHttpClient httpClient) {
        this.trinoServer = Objects.requireNonNull(trinoServer, "trinoServer is null");
        this.defaultSession = Objects.requireNonNull(defaultSession, "defaultSession is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
    }

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }

    protected abstract ResultsSession<T> getResultSession(Session var1);

    public ResultWithQueryId<T> execute(@Language(value="SQL") String sql) {
        return this.execute(this.defaultSession, sql);
    }

    public ResultWithQueryId<T> execute(Session session, @Language(value="SQL") String sql) {
        ResultsSession<T> resultsSession = this.getResultSession(session);
        ClientSession clientSession = AbstractTestingTrinoClient.toClientSession(session, this.trinoServer.getBaseUrl(), new Duration(2.0, TimeUnit.MINUTES));
        try (StatementClient client = StatementClientFactory.newStatementClient((OkHttpClient)this.httpClient, (ClientSession)clientSession, (String)sql);){
            while (client.isRunning()) {
                resultsSession.addResults(client.currentStatusInfo(), client.currentData());
                client.advance();
            }
            Preconditions.checkState((boolean)client.isFinished());
            QueryError error = client.finalStatusInfo().getError();
            if (error == null) {
                QueryStatusInfo results = client.finalStatusInfo();
                if (results.getUpdateType() != null) {
                    resultsSession.setUpdateType(results.getUpdateType());
                }
                if (results.getUpdateCount() != null) {
                    resultsSession.setUpdateCount(results.getUpdateCount());
                }
                resultsSession.setWarnings(results.getWarnings());
                resultsSession.setStatementStats(results.getStats());
                T result = resultsSession.build(client.getSetSessionProperties(), client.getResetSessionProperties());
                ResultWithQueryId<T> resultWithQueryId = new ResultWithQueryId<T>(new QueryId(results.getId()), result);
                return resultWithQueryId;
            }
            if (error.getFailureInfo() != null) {
                RuntimeException remoteException = error.getFailureInfo().toException();
                throw new RuntimeException(Optional.ofNullable(remoteException.getMessage()).orElseGet(remoteException::toString), remoteException);
            }
            throw new RuntimeException("Query failed: " + error.getMessage());
        }
    }

    private static ClientSession toClientSession(Session session, URI server, Duration clientRequestTimeout) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.putAll(session.getSystemProperties());
        for (Map.Entry catalogAndConnectorProperties : session.getCatalogProperties().entrySet()) {
            for (Map.Entry connectorProperties : ((Map)catalogAndConnectorProperties.getValue()).entrySet()) {
                String catalogName = (String)catalogAndConnectorProperties.getKey();
                properties.put((Object)(catalogName + "." + (String)connectorProperties.getKey()), (Object)((String)connectorProperties.getValue()));
            }
        }
        ImmutableMap.Builder resourceEstimates = ImmutableMap.builder();
        ResourceEstimates estimates = session.getResourceEstimates();
        estimates.getExecutionTime().ifPresent(e -> resourceEstimates.put((Object)"EXECUTION_TIME", (Object)e.toString()));
        estimates.getCpuTime().ifPresent(e -> resourceEstimates.put((Object)"CPU_TIME", (Object)e.toString()));
        estimates.getPeakMemoryBytes().ifPresent(e -> resourceEstimates.put((Object)"PEAK_MEMORY", (Object)e.toString()));
        return new ClientSession(server, session.getIdentity().getUser(), Optional.empty(), (String)session.getSource().orElse(null), session.getTraceToken(), session.getClientTags(), (String)session.getClientInfo().orElse(null), (String)session.getCatalog().orElse(null), (String)session.getSchema().orElse(null), session.getPath().toString(), ZoneId.of(session.getTimeZoneKey().getId()), session.getLocale(), (Map)resourceEstimates.buildOrThrow(), (Map)properties.buildOrThrow(), session.getPreparedStatements(), AbstractTestingTrinoClient.getRoles(session), session.getIdentity().getExtraCredentials(), (String)session.getTransactionId().map(Object::toString).orElse(null), clientRequestTimeout, true);
    }

    private static Map<String, ClientSelectedRole> getRoles(Session session) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        session.getIdentity().getEnabledRoles().forEach(role -> builder.put((Object)"system", (Object)AbstractTestingTrinoClient.toClientSelectedRole(new SelectedRole(SelectedRole.Type.ROLE, Optional.of(role)))));
        session.getIdentity().getCatalogRoles().forEach((key, value) -> builder.put(key, (Object)AbstractTestingTrinoClient.toClientSelectedRole(value)));
        return builder.buildOrThrow();
    }

    private static ClientSelectedRole toClientSelectedRole(SelectedRole value) {
        return new ClientSelectedRole(ClientSelectedRole.Type.valueOf((String)value.getType().toString()), value.getRole());
    }

    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        return this.inTransaction(session, transactionSession -> this.trinoServer.getMetadata().listTables(transactionSession, new QualifiedTablePrefix(catalog, schema)));
    }

    public boolean tableExists(Session session, String table) {
        return this.inTransaction(session, transactionSession -> MetadataUtil.tableExists((Metadata)this.trinoServer.getMetadata(), (Session)transactionSession, (String)table));
    }

    private <V> V inTransaction(Session session, Function<Session, V> callback) {
        return (V)TransactionBuilder.transaction((TransactionManager)this.trinoServer.getTransactionManager(), (AccessControl)this.trinoServer.getAccessControl()).readOnly().singleStatement().execute(session, callback);
    }

    public Session getDefaultSession() {
        return this.defaultSession;
    }

    public TestingTrinoServer getServer() {
        return this.trinoServer;
    }

    protected List<Type> getTypes(List<Column> columns) {
        return (List)columns.stream().map(Column::getType).map(arg_0 -> ((TypeManager)this.trinoServer.getTypeManager()).fromSqlType(arg_0)).collect(ImmutableList.toImmutableList());
    }
}

