/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.dispatcher.DispatchManager;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryManager;
import io.trino.server.BasicQueryInfo;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueries;
import io.trino.testing.DataProviders;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.ResultWithQueryId;
import io.trino.testing.assertions.Assert;
import io.trino.testing.sql.TestTable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Deprecated
public abstract class AbstractTestDistributedQueries
extends AbstractTestQueries {
    protected boolean supportsCreateSchema() {
        return true;
    }

    private boolean supportsDropSchema() {
        return this.supportsCreateSchema();
    }

    protected boolean supportsCreateTable() {
        return true;
    }

    protected boolean supportsInsert() {
        return true;
    }

    protected boolean supportsDelete() {
        return true;
    }

    protected boolean supportsViews() {
        return true;
    }

    protected boolean supportsArrays() {
        return true;
    }

    protected boolean supportsCommentOnTable() {
        return true;
    }

    protected boolean supportsCommentOnColumn() {
        return true;
    }

    protected boolean supportsRenameTable() {
        return true;
    }

    @Test
    public void ensureDistributedQueryRunner() {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.getQueryRunner().getNodeCount()).as("query runner node count", new Object[0])).isGreaterThanOrEqualTo(3);
    }

    @Test
    public void testCreateTable() {
        String tableName = "test_create_" + TestTable.randomTableSuffix();
        if (!this.supportsCreateTable()) {
            this.assertQueryFails("CREATE TABLE " + tableName + " (a bigint, b double, c varchar(50))", "This connector does not support creating tables");
            return;
        }
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b double, c varchar(50))");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertTableColumnNames(tableName, "a", "b", "c");
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertQueryFails("CREATE TABLE " + tableName + " (a bad_type)", ".* Unknown type 'bad_type' for column 'a'");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        tableName = "test_cr_not_exists_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b varchar(50), c double)");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertTableColumnNames(tableName, "a", "b", "c");
        this.assertUpdate("CREATE TABLE IF NOT EXISTS " + tableName + " (d bigint, e varchar(50))");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertTableColumnNames(tableName, "a", "b", "c");
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        tableName = "test_create_orig_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b double, c varchar(50))");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertTableColumnNames(tableName, "a", "b", "c");
        String tableNameLike = "test_create_like_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableNameLike + " (LIKE " + tableName + ", d bigint, e varchar(50))");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableNameLike));
        this.assertTableColumnNames(tableNameLike, "a", "b", "c", "d", "e");
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertUpdate("DROP TABLE " + tableNameLike);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableNameLike));
    }

    @Test
    public void testCreateTableAsSelect() {
        String tableName = "test_ctas" + TestTable.randomTableSuffix();
        if (!this.supportsCreateTable()) {
            this.assertQueryFails("CREATE TABLE IF NOT EXISTS " + tableName + " AS SELECT name, regionkey FROM nation", "This connector does not support creating tables with data");
            return;
        }
        this.assertUpdate("CREATE TABLE IF NOT EXISTS " + tableName + " AS SELECT name, regionkey FROM nation", "SELECT count(*) FROM nation");
        this.assertTableColumnNames(tableName, "name", "regionkey");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE IF NOT EXISTS nation AS SELECT custkey, acctbal FROM customer", 0L);
        this.assertTableColumnNames("nation", "nationkey", "name", "regionkey", "comment");
        this.assertCreateTableAsSelect("SELECT custkey, address, acctbal FROM customer", "SELECT count(*) FROM customer");
        this.assertCreateTableAsSelect("SELECT mktsegment, sum(acctbal) x FROM customer GROUP BY mktsegment", "SELECT count(DISTINCT mktsegment) FROM customer");
        this.assertCreateTableAsSelect("SELECT count(*) x FROM customer JOIN nation ON customer.nationkey = nation.nationkey", "SELECT 1");
        this.assertCreateTableAsSelect("SELECT custkey FROM customer ORDER BY custkey LIMIT 10", "SELECT 10");
        this.assertCreateTableAsSelect("SELECT * FROM customer WITH DATA", "SELECT * FROM customer", "SELECT count(*) FROM customer");
        this.assertCreateTableAsSelect("SELECT * FROM customer WITH NO DATA", "SELECT * FROM customer LIMIT 0", "SELECT 0");
        this.assertCreateTableAsSelect("SELECT name, custkey, acctbal FROM customer WHERE custkey % 2 = 0 UNION ALL SELECT name, custkey, acctbal FROM customer WHERE custkey % 2 = 1", "SELECT name, custkey, acctbal FROM customer", "SELECT count(*) FROM customer");
        this.assertCreateTableAsSelect(Session.builder((Session)this.getSession()).setSystemProperty("redistribute_writes", "true").build(), "SELECT CAST(custkey AS BIGINT) custkey, acctbal FROM customer UNION ALL SELECT 1234567890, 1.23", "SELECT custkey, acctbal FROM customer UNION ALL SELECT 1234567890, 1.23", "SELECT count(*) + 1 FROM customer");
        this.assertCreateTableAsSelect(Session.builder((Session)this.getSession()).setSystemProperty("redistribute_writes", "false").build(), "SELECT CAST(custkey AS BIGINT) custkey, acctbal FROM customer UNION ALL SELECT 1234567890, 1.23", "SELECT custkey, acctbal FROM customer UNION ALL SELECT 1234567890, 1.23", "SELECT count(*) + 1 FROM customer");
        this.assertExplainAnalyze("EXPLAIN ANALYZE CREATE TABLE " + tableName + " AS SELECT mktsegment FROM customer", new String[0]);
        this.assertQuery("SELECT * from " + tableName, "SELECT mktsegment FROM customer");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTableAsSelectWithUnicode() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsCreateTable());
        this.assertCreateTableAsSelect("SELECT '\u2603' unicode", "SELECT 1");
    }

    protected void assertCreateTableAsSelect(@Language(value="SQL") String query, @Language(value="SQL") String rowCountQuery) {
        this.assertCreateTableAsSelect(this.getSession(), query, query, rowCountQuery);
    }

    protected void assertCreateTableAsSelect(@Language(value="SQL") String query, @Language(value="SQL") String expectedQuery, @Language(value="SQL") String rowCountQuery) {
        this.assertCreateTableAsSelect(this.getSession(), query, expectedQuery, rowCountQuery);
    }

    protected void assertCreateTableAsSelect(Session session, @Language(value="SQL") String query, @Language(value="SQL") String expectedQuery, @Language(value="SQL") String rowCountQuery) {
        String table = "test_ctas_" + TestTable.randomTableSuffix();
        this.assertUpdate(session, "CREATE TABLE " + table + " AS " + query, rowCountQuery);
        this.assertQuery(session, "SELECT * FROM " + table, expectedQuery);
        this.assertUpdate(session, "DROP TABLE " + table);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, table));
    }

    @Test
    public void testRenameTable() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsCreateTable());
        String tableName = "test_rename_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String renamedTable = "test_rename_new_" + TestTable.randomTableSuffix();
        if (!this.supportsRenameTable()) {
            this.assertQueryFails("ALTER TABLE " + tableName + " RENAME TO " + renamedTable, "This connector does not support renaming tables");
            return;
        }
        this.assertUpdate("ALTER TABLE " + tableName + " RENAME TO " + renamedTable);
        this.assertQuery("SELECT x FROM " + renamedTable, "VALUES 123");
        String testExistsTableName = "test_rename_exists_" + TestTable.randomTableSuffix();
        this.assertUpdate("ALTER TABLE IF EXISTS " + renamedTable + " RENAME TO " + testExistsTableName);
        this.assertQuery("SELECT x FROM " + testExistsTableName, "VALUES 123");
        String uppercaseName = "TEST_RENAME_" + TestTable.randomTableSuffix();
        this.assertUpdate("ALTER TABLE " + testExistsTableName + " RENAME TO " + uppercaseName);
        this.assertQuery("SELECT x FROM " + uppercaseName.toLowerCase(Locale.ENGLISH), "VALUES 123");
        this.assertUpdate("DROP TABLE " + uppercaseName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), renamedTable));
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " RENAME TO " + renamedTable);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), renamedTable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommentTable() {
        if (!this.supportsCommentOnTable()) {
            this.assertQueryFails("COMMENT ON TABLE nation IS 'new comment'", "This connector does not support setting table comments");
            return;
        }
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_", "(a integer)");){
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS 'new comment'");
            Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE " + table.getName()).getOnlyValue())).contains(new CharSequence[]{"COMMENT 'new comment'"});
            Assertions.assertThat((String)this.getTableComment(table.getName())).isEqualTo("new comment");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, comment FROM system.metadata.table_comments WHERE catalog_name = '" + catalogName + "' AND schema_name = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES ('" + table.getName() + "', 'new comment')");
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS 'updated comment'");
            Assertions.assertThat((String)this.getTableComment(table.getName())).isEqualTo("updated comment");
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS ''");
            Assertions.assertThat((String)this.getTableComment(table.getName())).isIn(new Object[]{"", null});
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS 'a comment'");
            Assertions.assertThat((String)this.getTableComment(table.getName())).isEqualTo("a comment");
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS NULL");
            Assertions.assertThat((String)this.getTableComment(table.getName())).isEqualTo(null);
        }
        String tableName = "test_comment_" + TestTable.randomTableSuffix();
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(key integer) COMMENT 'new table comment'");
            Assertions.assertThat((String)this.getTableComment(tableName)).isEqualTo("new table comment");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    private String getTableComment(String tableName) {
        String result = (String)this.computeActual("SHOW CREATE TABLE " + tableName).getOnlyValue();
        Matcher matcher = Pattern.compile("COMMENT '([^']*)'").matcher(result);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Test
    public void testCommentColumn() {
        if (!this.supportsCommentOnColumn()) {
            this.assertQueryFails("COMMENT ON COLUMN nation.nationkey IS 'new comment'", "This connector does not support setting column comments");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_column_", "(a integer)");){
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS 'new comment'");
            Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE " + table.getName()).getOnlyValue())).contains(new CharSequence[]{"COMMENT 'new comment'"});
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo("new comment");
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS 'updated comment'");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo("updated comment");
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS ''");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isIn(new Object[]{"", null});
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS 'a comment'");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo("a comment");
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS NULL");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo(null);
        }
    }

    private String getColumnComment(String tableName, String columnName) {
        MaterializedResult materializedResult = this.computeActual(String.format("SELECT comment FROM information_schema.columns WHERE table_schema = '%s' AND table_name = '%s' AND column_name = '%s'", this.getSession().getSchema().orElseThrow(), tableName, columnName));
        return (String)materializedResult.getOnlyValue();
    }

    @Test
    public void testRenameColumn() {
        String tableName;
        AbstractTestDistributedQueries.skipTestUnless(this.supportsCreateTable());
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_rename_column_", "AS SELECT 'some value' x");){
            tableName = table.getName();
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN x TO before_y");
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN IF EXISTS before_y TO y");
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN IF EXISTS columnNotExists TO y");
            this.assertQuery("SELECT y FROM " + tableName, "VALUES 'some value'");
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN y TO Z");
            this.assertQuery("SELECT z FROM " + tableName, "VALUES 'some value'");
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN IF EXISTS z TO a");
            this.assertQuery("SELECT a FROM " + tableName, "VALUES 'some value'");
            this.assertQuery("SELECT * FROM " + tableName, "VALUES 'some value'");
        }
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " RENAME COLUMN columnNotExists TO y");
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " RENAME COLUMN IF EXISTS columnNotExists TO y");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testDropColumn() {
        String tableName;
        AbstractTestDistributedQueries.skipTestUnless(this.supportsCreateTable());
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_column_", "AS SELECT 123 x, 456 y, 111 a");){
            tableName = table.getName();
            this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN x");
            this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN IF EXISTS y");
            this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN IF EXISTS notExistColumn");
            this.assertQueryFails("SELECT x FROM " + tableName, ".* Column 'x' cannot be resolved");
            this.assertQueryFails("SELECT y FROM " + tableName, ".* Column 'y' cannot be resolved");
            this.assertQueryFails("ALTER TABLE " + tableName + " DROP COLUMN a", ".* Cannot drop the only column in a table");
        }
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " DROP COLUMN notExistColumn");
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " DROP COLUMN IF EXISTS notExistColumn");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testAddColumn() {
        String tableName;
        AbstractTestDistributedQueries.skipTestUnless(this.supportsCreateTable());
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_column_", "AS SELECT VARCHAR 'first' x");){
            tableName = table.getName();
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN x bigint", ".* Column 'x' already exists");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN X bigint", ".* Column 'X' already exists");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN q bad_type", ".* Unknown type 'bad_type' for column 'q'");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN a varchar(50)");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'second', 'xxx'", 1L);
            this.assertQuery("SELECT x, a FROM " + table.getName(), "VALUES ('first', NULL), ('second', 'xxx')");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN b double");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'third', 'yyy', 33.3E0", 1L);
            this.assertQuery("SELECT x, a, b FROM " + table.getName(), "VALUES ('first', NULL, NULL), ('second', 'xxx', NULL), ('third', 'yyy', 33.3)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN IF NOT EXISTS c varchar(50)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN IF NOT EXISTS c varchar(50)");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'fourth', 'zzz', 55.3E0, 'newColumn'", 1L);
            this.assertQuery("SELECT x, a, b, c FROM " + table.getName(), "VALUES ('first', NULL, NULL, NULL), ('second', 'xxx', NULL, NULL), ('third', 'yyy', 33.3, NULL), ('fourth', 'zzz', 55.3, 'newColumn')");
        }
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " ADD COLUMN x bigint");
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " ADD COLUMN IF NOT EXISTS x bigint");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testInsert() {
        if (!this.supportsInsert()) {
            this.assertQueryFails("INSERT INTO nation(nationkey) VALUES (42)", "This connector does not support inserts");
            return;
        }
        String query = "SELECT phone, custkey, acctbal FROM customer";
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_", "AS " + query + " WITH NO DATA");){
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "SELECT 0");
            this.assertUpdate("INSERT INTO " + table.getName() + " " + query, "SELECT count(*) FROM customer");
            this.assertQuery("SELECT * FROM " + table.getName(), query);
            this.assertUpdate("INSERT INTO " + table.getName() + " (custkey) VALUES (-1)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (custkey) VALUES (null)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (phone) VALUES ('3283-2001-01-01')", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (custkey, phone) VALUES (-2, '3283-2001-01-02')", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (phone, custkey) VALUES ('3283-2001-01-03', -3)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (acctbal) VALUES (1234)", 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), query + " UNION ALL SELECT null, -1, null UNION ALL SELECT null, null, null UNION ALL SELECT '3283-2001-01-01', null, null UNION ALL SELECT '3283-2001-01-02', -2, null UNION ALL SELECT '3283-2001-01-03', -3, null UNION ALL SELECT null, null, 1234");
            this.assertUpdate("INSERT INTO " + table.getName() + " (custkey, phone, acctbal) SELECT custkey, phone, acctbal FROM customer UNION ALL SELECT custkey, phone, acctbal FROM customer", "SELECT 2 * count(*) FROM customer");
        }
    }

    @Test
    public void testInsertUnicode() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsInsert());
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_unicode_", "(test varchar(50))");){
            this.assertUpdate("INSERT INTO " + table.getName() + "(test) VALUES 'Hello', U&'hello\\6d4B\\8Bd5world\\7F16\\7801' ", 2L);
            Assertions.assertThat((Iterable)this.computeActual("SELECT test FROM " + table.getName()).getOnlyColumnAsSet()).containsExactlyInAnyOrder(new Object[]{"Hello", "hello\u6d4b\u8bd5world\u7f16\u7801"});
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_unicode_", "(test varchar(50))");
        try {
            this.assertUpdate("INSERT INTO " + table.getName() + "(test) VALUES 'aa', 'b\u00e9'", 2L);
            this.assertQuery("SELECT test FROM " + table.getName(), "VALUES 'aa', 'b\u00e9'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test = 'aa'", "VALUES 'aa'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test > 'ba'", "VALUES 'b\u00e9'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test < 'ba'", "VALUES 'aa'");
            this.assertQueryReturnsEmptyResult("SELECT test FROM " + table.getName() + " WHERE test = 'ba'");
        }
        finally {
            table.close();
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_unicode_", "(test varchar(50))");
        try {
            this.assertUpdate("INSERT INTO " + table.getName() + "(test) VALUES 'a', '\u00e9'", 2L);
            this.assertQuery("SELECT test FROM " + table.getName(), "VALUES 'a', '\u00e9'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test = 'a'", "VALUES 'a'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test > 'b'", "VALUES '\u00e9'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test < 'b'", "VALUES 'a'");
            this.assertQueryReturnsEmptyResult("SELECT test FROM " + table.getName() + " WHERE test = 'b'");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testInsertHighestUnicodeCharacter() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsInsert());
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_unicode_", "(test varchar(50))");){
            this.assertUpdate("INSERT INTO " + table.getName() + "(test) VALUES 'Hello', U&'hello\\6d4B\\8Bd5\\+10FFFFworld\\7F16\\7801' ", 2L);
            Assertions.assertThat((Iterable)this.computeActual("SELECT test FROM " + table.getName()).getOnlyColumnAsSet()).containsExactlyInAnyOrder(new Object[]{"Hello", "hello\u6d4b\u8bd5\udbff\udfffworld\u7f16\u7801"});
        }
    }

    @Test
    public void testInsertArray() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsInsert());
        String tableName = "test_insert_array_" + TestTable.randomTableSuffix();
        if (!this.supportsArrays()) {
            Assertions.assertThatThrownBy(() -> this.query("CREATE TABLE " + tableName + " (a array(bigint))")).hasMessageMatching("[Uu]nsupported (column )?type: \\Qarray(bigint)");
            throw new SkipException("not supported");
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_array_", "(a ARRAY<DOUBLE>, b ARRAY<BIGINT>)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " (a) VALUES (ARRAY[null])", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (a, b) VALUES (ARRAY[1.23E1], ARRAY[1.23E1])", 1L);
            this.assertQuery("SELECT a[1], b[1] FROM " + table.getName(), "VALUES (null, null), (12.3, 12)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete() {
        this.skipTestUnlessSupportsDeletes();
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_", "AS SELECT * FROM orders");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE custkey <= 100", "SELECT count(*) FROM orders WHERE custkey <= 100");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE custkey > 100");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE custkey <= 300", "SELECT count(*) FROM orders WHERE custkey > 100 AND custkey <= 300");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE custkey > 300");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE custkey <= 500", "SELECT count(*) FROM orders WHERE custkey > 300 AND custkey <= 500");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE custkey > 500");
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_", "AS SELECT * FROM orders");
        try {
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey < 0", 0L);
        }
        finally {
            table.close();
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_", "AS SELECT * FROM orders");
        try {
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey > 5 AND orderkey < 4", 0L);
        }
        finally {
            table.close();
        }
        String tableName = "test_delete_" + TestTable.randomTableSuffix();
        try {
            this.assertExplainAnalyze("EXPLAIN ANALYZE CREATE TABLE " + tableName + " AS SELECT CAST(orderstatus AS VARCHAR(15)) orderstatus FROM orders", new String[0]);
            this.assertQuery("SELECT * from " + tableName, "SELECT orderstatus FROM orders");
            this.assertExplainAnalyze("EXPLAIN ANALYZE INSERT INTO " + tableName + " SELECT clerk FROM orders", new String[0]);
            this.assertQuery("SELECT * from " + tableName, "SELECT orderstatus FROM orders UNION ALL SELECT clerk FROM orders");
            this.assertExplainAnalyze("EXPLAIN ANALYZE DELETE FROM " + tableName + " WHERE TRUE", new String[0]);
            this.assertQuery("SELECT COUNT(*) from " + tableName, "SELECT 0");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testDeleteWithComplexPredicate() {
        this.skipTestUnlessSupportsDeletes();
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_complex_", "AS SELECT * FROM orders");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey % 2 = 0", "SELECT count(*) FROM orders WHERE orderkey % 2 = 0");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE orderkey % 2 <> 0");
            this.assertUpdate("DELETE FROM " + table.getName(), "SELECT count(*) FROM orders WHERE orderkey % 2 <> 0");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders LIMIT 0");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE rand() < 0", 0L);
        }
    }

    @Test
    public void testDeleteWithSubquery() {
        this.skipTestUnlessSupportsDeletes();
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_subquery", "AS SELECT * FROM nation");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE regionkey IN (SELECT regionkey FROM region WHERE name LIKE 'A%')", 15L);
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM nation WHERE regionkey IN (SELECT regionkey FROM region WHERE name NOT LIKE 'A%')");
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_subquery", "AS SELECT * FROM orders");
        try {
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey = (SELECT orderkey FROM orders ORDER BY orderkey LIMIT 1)", 1L);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey = (SELECT orderkey FROM orders WHERE false)", 0L);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE EXISTS(SELECT 1 WHERE false)", 0L);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE EXISTS(SELECT 1)", "SELECT count(*) - 1 FROM orders");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testExplainAnalyzeWithDeleteWithSubquery() {
        this.skipTestUnlessSupportsDeletes();
        String tableName = "test_delete_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM nation", 25L);
        this.assertExplainAnalyze("EXPLAIN ANALYZE DELETE FROM " + tableName + " WHERE regionkey IN (SELECT regionkey FROM region WHERE name LIKE 'A%' LIMIT 1)", "SemiJoin.*");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDeleteWithSemiJoin() {
        this.skipTestUnlessSupportsDeletes();
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_semijoin", "AS SELECT * FROM nation");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE regionkey IN (SELECT regionkey FROM region WHERE name LIKE 'A%')   AND regionkey IN (SELECT regionkey FROM region WHERE length(comment) < 50)", 10L);
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM nation WHERE regionkey IN (SELECT regionkey FROM region WHERE name NOT LIKE 'A%')   OR regionkey IN (SELECT regionkey FROM region WHERE length(comment) >= 50)");
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_semijoin", "AS SELECT * FROM orders");
        try {
            this.assertUpdate("DELETE FROM " + table.getName() + "\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM tpch.tiny.lineitem)) IS NULL\n", "SELECT count(*) FROM orders\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NULL\n");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NOT NULL\n");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testDeleteWithVarcharPredicate() {
        this.skipTestUnlessSupportsDeletes();
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_with_varchar_predicate_", "AS SELECT * FROM orders");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderstatus = 'O'", "SELECT count(*) FROM orders WHERE orderstatus = 'O'");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE orderstatus <> 'O'");
        }
    }

    protected void skipTestUnlessSupportsDeletes() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsCreateTable());
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_supports_delete", "(col varchar(1))", (List<String>)ImmutableList.of((Object)"'a'", (Object)"'A'"));){
            if (!this.supportsDelete()) {
                this.assertQueryFails("DELETE FROM " + table.getName(), "This connector does not support deletes");
                throw new SkipException("This connector does not support deletes");
            }
        }
    }

    @Test
    public void testDropTableIfExists() {
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_drop_if_exists"));
        this.assertUpdate("DROP TABLE IF EXISTS test_drop_if_exists");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_drop_if_exists"));
    }

    @Test
    public void testView() {
        if (!this.supportsViews()) {
            this.assertQueryFails("CREATE VIEW nation_v AS SELECT * FROM nation", "This connector does not support creating views");
            return;
        }
        String query = "SELECT orderkey, orderstatus, totalprice / 2 half FROM orders";
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        String testView = "test_view_" + TestTable.randomTableSuffix();
        String testViewWithComment = "test_view_with_comment_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE VIEW " + testView + " AS SELECT 123 x");
        this.assertUpdate("CREATE OR REPLACE VIEW " + testView + " AS " + query);
        this.assertUpdate("CREATE VIEW " + testViewWithComment + " COMMENT 'orders' AS SELECT 123 x");
        this.assertUpdate("CREATE OR REPLACE VIEW " + testViewWithComment + " COMMENT 'orders' AS " + query);
        MaterializedResult materializedRows = this.computeActual("SHOW CREATE VIEW " + testViewWithComment);
        Assertions.assertThat((String)((String)materializedRows.getOnlyValue())).contains(new CharSequence[]{"COMMENT 'orders'"});
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, comment FROM system.metadata.table_comments WHERE catalog_name = '" + catalogName + "' AND schema_name = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES ('" + testView + "', null), ('" + testViewWithComment + "', 'orders')");
        this.assertQuery("SELECT * FROM " + testView, query);
        this.assertQuery("SELECT * FROM " + testViewWithComment, query);
        this.assertQuery("SELECT * FROM " + testView + " a JOIN " + testView + " b on a.orderkey = b.orderkey", String.format("SELECT * FROM (%s) a JOIN (%s) b ON a.orderkey = b.orderkey", query, query));
        this.assertQuery("WITH orders AS (SELECT * FROM orders LIMIT 0) SELECT * FROM " + testView, query);
        String name = String.format("%s.%s." + testView, catalogName, schemaName);
        this.assertQuery("SELECT * FROM " + name, query);
        this.assertUpdate("DROP VIEW " + testView);
        this.assertUpdate("DROP VIEW " + testViewWithComment);
    }

    @Test
    public void testViewCaseSensitivity() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        String upperCaseView = "test_view_uppercase_" + TestTable.randomTableSuffix();
        String mixedCaseView = "test_view_mixedcase_" + TestTable.randomTableSuffix();
        this.computeActual("CREATE VIEW " + upperCaseView + " AS SELECT X FROM (SELECT 123 X)");
        this.computeActual("CREATE VIEW " + mixedCaseView + " AS SELECT XyZ FROM (SELECT 456 XyZ)");
        this.assertQuery("SELECT * FROM " + upperCaseView, "SELECT X FROM (SELECT 123 X)");
        this.assertQuery("SELECT * FROM " + mixedCaseView, "SELECT XyZ FROM (SELECT 456 XyZ)");
        this.assertUpdate("DROP VIEW " + upperCaseView);
        this.assertUpdate("DROP VIEW " + mixedCaseView);
    }

    @Test
    public void testCompatibleTypeChangeForView() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        String tableName = "test_table_" + TestTable.randomTableSuffix();
        String viewName = "test_view_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 'abcdefg' a", 1L);
        this.assertUpdate("CREATE VIEW " + viewName + " AS SELECT a FROM " + tableName);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES 'abcdefg'");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 'abc' a", 1L);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES 'abc'");
        this.assertUpdate("DROP VIEW " + viewName);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCompatibleTypeChangeForView2() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        String tableName = "test_table_" + TestTable.randomTableSuffix();
        String viewName = "test_view_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT BIGINT '1' v", 1L);
        this.assertUpdate("CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT INTEGER '1' v", 1L);
        this.assertQuery("SELECT * FROM " + viewName + " WHERE v = 1", "VALUES 1");
        this.assertUpdate("DROP VIEW " + viewName);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test(dataProvider="testViewMetadataDataProvider")
    public void testViewMetadata(String securityClauseInCreate, String securityClauseInShowCreate) {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        String viewName = "meta_test_view_" + TestTable.randomTableSuffix();
        String query = "SELECT BIGINT '123' x, 'foo' y";
        this.assertUpdate("CREATE VIEW " + viewName + securityClauseInCreate + " AS " + query);
        MaterializedResult actual = this.computeActual(String.format("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '%s'", this.getSession().getSchema().get()));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"customer", "BASE TABLE"}).row(new Object[]{viewName, "VIEW"}).row(new Object[]{"nation", "BASE TABLE"}).row(new Object[]{"orders", "BASE TABLE"}).row(new Object[]{"region", "BASE TABLE"}).build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual("SHOW TABLES");
        MaterializedResult.Builder builder = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes());
        for (MaterializedRow row : expected.getMaterializedRows()) {
            builder.row(new Object[]{row.getField(0)});
        }
        expected = builder.build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual(String.format("SELECT table_name, view_definition FROM information_schema.views WHERE table_schema = '%s'", this.getSession().getSchema().get()));
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{viewName, this.formatSqlText(query)}).build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual("SHOW COLUMNS FROM " + viewName);
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"x", "bigint", "", ""}).row(new Object[]{"y", "varchar(3)", "", ""}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
        String expectedSql = this.formatSqlText(String.format("CREATE VIEW %s.%s.%s SECURITY %s AS %s", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), viewName, securityClauseInShowCreate, query)).trim();
        actual = this.computeActual("SHOW CREATE VIEW " + viewName);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actual.getOnlyColumnAsSet()), (Object)expectedSql);
        actual = this.computeActual(String.format("SHOW CREATE VIEW %s.%s.%s", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), viewName));
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actual.getOnlyColumnAsSet()), (Object)expectedSql);
        this.assertUpdate("DROP VIEW " + viewName);
    }

    @DataProvider
    public static Object[][] testViewMetadataDataProvider() {
        return new Object[][]{{"", "DEFINER"}, {" SECURITY DEFINER", "DEFINER"}, {" SECURITY INVOKER", "INVOKER"}};
    }

    @Test
    public void testShowCreateView() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        Preconditions.checkState((boolean)this.getSession().getCatalog().isPresent(), (Object)"catalog is not set");
        Preconditions.checkState((boolean)this.getSession().getSchema().isPresent(), (Object)"schema is not set");
        String viewName = "test_show_create_view" + TestTable.randomTableSuffix();
        this.assertUpdate("DROP VIEW IF EXISTS " + viewName);
        String ddl = String.format("CREATE VIEW %s.%s.%s SECURITY DEFINER AS\nSELECT *\nFROM\n  (\n VALUES \n     ROW (1, 'one')\n   , ROW (2, 't')\n)  t (col1, col2)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), viewName);
        this.assertUpdate(ddl);
        Assert.assertEquals((Object)this.computeActual("SHOW CREATE VIEW " + viewName).getOnlyValue(), (Object)ddl);
        this.assertUpdate("DROP VIEW " + viewName);
    }

    @Test
    public void testQueryLoggingCount() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsCreateTable());
        QueryManager queryManager = this.getDistributedQueryRunner().getCoordinator().getQueryManager();
        this.executeExclusively(() -> {
            Assert.assertEventually((Duration)new Duration(1.0, TimeUnit.MINUTES), () -> Assert.assertEquals((Collection)queryManager.getQueries().stream().map(BasicQueryInfo::getQueryId).map(arg_0 -> ((QueryManager)queryManager).getFullQueryInfo(arg_0)).filter(info -> !info.isFinalQueryInfo()).collect(Collectors.toList()), (Collection)ImmutableList.of()));
            DispatchManager dispatchManager = ((DistributedQueryRunner)this.getQueryRunner()).getCoordinator().getDispatchManager();
            long beforeCompletedQueriesCount = this.waitUntilStable(() -> dispatchManager.getStats().getCompletedQueries().getTotalCount(), new Duration(5.0, TimeUnit.SECONDS));
            long beforeSubmittedQueriesCount = dispatchManager.getStats().getSubmittedQueries().getTotalCount();
            String tableName = "test_logging_count" + TestTable.randomTableSuffix();
            this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 foo_1, 2 foo_2_4", 1L);
            this.assertQuery("SELECT foo_1, foo_2_4 FROM " + tableName, "SELECT 1, 2");
            this.assertUpdate("DROP TABLE " + tableName);
            this.assertQueryFails("SELECT * FROM " + tableName, ".*Table .* does not exist");
            Assert.assertEventually((Duration)new Duration(1.0, TimeUnit.MINUTES), () -> Assert.assertEquals((long)(dispatchManager.getStats().getCompletedQueries().getTotalCount() - beforeCompletedQueriesCount), (long)4L));
            Assert.assertEquals((long)(dispatchManager.getStats().getSubmittedQueries().getTotalCount() - beforeSubmittedQueriesCount), (long)4L);
        });
    }

    private <T> T waitUntilStable(Supplier<T> computation, Duration timeout) {
        T lastValue = computation.get();
        long start = System.nanoTime();
        while (!Thread.currentThread().isInterrupted() && Duration.nanosSince((long)start).compareTo(timeout) < 0) {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            T currentValue = computation.get();
            if (currentValue.equals(lastValue)) {
                return currentValue;
            }
            lastValue = currentValue;
        }
        throw new UncheckedTimeoutException();
    }

    @Test
    public void testShowSchemasFromOther() {
        MaterializedResult result = this.computeActual("SHOW SCHEMAS FROM tpch");
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)ImmutableSet.of((Object)"information_schema", (Object)"tiny", (Object)"sf1")));
    }

    @Test
    public void testSymbolAliasing() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsCreateTable());
        String tableName = "test_symbol_aliasing" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 foo_1, 2 foo_2_4", 1L);
        this.assertQuery("SELECT foo_1, foo_2_4 FROM " + tableName, "SELECT 1, 2");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrittenStats() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsCreateTable());
        AbstractTestDistributedQueries.skipTestUnless(this.supportsInsert());
        String tableName = "test_written_stats_" + TestTable.randomTableSuffix();
        try {
            String sql = "CREATE TABLE " + tableName + " AS SELECT * FROM nation";
            ResultWithQueryId<MaterializedResult> resultResultWithQueryId = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), sql);
            QueryInfo queryInfo = this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(resultResultWithQueryId.getQueryId());
            Assert.assertEquals((long)queryInfo.getQueryStats().getOutputPositions(), (long)1L);
            Assert.assertEquals((long)queryInfo.getQueryStats().getWrittenPositions(), (long)25L);
            org.testng.Assert.assertTrue((queryInfo.getQueryStats().getLogicalWrittenDataSize().toBytes() > 0L ? 1 : 0) != 0);
            sql = "INSERT INTO " + tableName + " SELECT * FROM nation LIMIT 10";
            resultResultWithQueryId = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), sql);
            queryInfo = this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(resultResultWithQueryId.getQueryId());
            Assert.assertEquals((long)queryInfo.getQueryStats().getOutputPositions(), (long)1L);
            Assert.assertEquals((long)queryInfo.getQueryStats().getWrittenPositions(), (long)10L);
            org.testng.Assert.assertTrue((queryInfo.getQueryStats().getLogicalWrittenDataSize().toBytes() > 0L ? 1 : 0) != 0);
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testShowCreateSchema() {
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE SCHEMA " + schemaName))).isEqualTo(String.format("CREATE SCHEMA %s.%s", this.getSession().getCatalog().orElseThrow(), schemaName));
    }

    @Test
    public void testCreateSchema() {
        String schemaName = "test_schema_create_" + TestTable.randomTableSuffix();
        if (!this.supportsCreateSchema()) {
            this.assertQueryFails("CREATE SCHEMA " + schemaName, "This connector does not support creating schemas");
            return;
        }
        Assertions.assertThat((Iterable)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).doesNotContain(new Object[]{schemaName});
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        Assertions.assertThat((Iterable)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).contains(new Object[]{schemaName});
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE SCHEMA " + schemaName))).startsWith((CharSequence)String.format("CREATE SCHEMA %s.%s", this.getSession().getCatalog().orElseThrow(), schemaName));
        this.assertQueryFails("CREATE SCHEMA " + schemaName, String.format("line 1:1: Schema '.*\\.%s' already exists", schemaName));
        this.assertUpdate("DROP SCHEMA " + schemaName);
        this.assertQueryFails("DROP SCHEMA " + schemaName, String.format("line 1:1: Schema '.*\\.%s' does not exist", schemaName));
    }

    @Test
    public void testDropNonEmptySchema() {
        String schemaName = "test_drop_non_empty_schema_" + TestTable.randomTableSuffix();
        if (!this.supportsDropSchema()) {
            return;
        }
        try {
            this.assertUpdate("CREATE SCHEMA " + schemaName);
            this.assertUpdate("CREATE TABLE " + schemaName + ".t(x int)");
            this.assertQueryFails("DROP SCHEMA " + schemaName, ".*Cannot drop non-empty schema '\\Q" + schemaName + "\\E'");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + schemaName + ".t");
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName);
        }
    }

    @Test
    public void testInsertForDefaultColumn() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsInsert());
        try (TestTable testTable = this.createTableWithDefaultColumns();){
            this.assertUpdate(String.format("INSERT INTO %s (col_required, col_required2) VALUES (1, 10)", testTable.getName()), 1L);
            this.assertUpdate(String.format("INSERT INTO %s VALUES (2, 3, 4, 5, 6)", testTable.getName()), 1L);
            this.assertUpdate(String.format("INSERT INTO %s VALUES (7, null, null, 8, 9)", testTable.getName()), 1L);
            this.assertUpdate(String.format("INSERT INTO %s (col_required2, col_required) VALUES (12, 13)", testTable.getName()), 1L);
            this.assertQuery("SELECT * FROM " + testTable.getName(), "VALUES (1, null, 43, 42, 10), (2, 3, 4, 5, 6), (7, null, null, 8, 9), (13, null, 43, 42, 12)");
        }
    }

    protected TestTable createTableWithDefaultColumns() {
        throw new UnsupportedOperationException();
    }

    @Test(dataProvider="testColumnNameDataProvider")
    public void testColumnName(String columnName) {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsCreateTable());
        if (!AbstractTestDistributedQueries.requiresDelimiting(columnName)) {
            this.testColumnName(columnName, false);
        }
        this.testColumnName(columnName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testColumnName(String columnName, boolean delimited) {
        Object nameInSql = columnName;
        if (delimited) {
            nameInSql = "\"" + columnName.replace("\"", "\"\"") + "\"";
        }
        String tableName = "tcn_" + ((String)nameInSql).toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "") + TestTable.randomTableSuffix();
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(key varchar(50), " + (String)nameInSql + " varchar(50))");
        }
        catch (RuntimeException e) {
            if (this.isColumnNameRejected(e, columnName, delimited)) {
                return;
            }
            throw e;
        }
        try {
            this.assertUpdate("INSERT INTO " + tableName + " VALUES ('null value', NULL), ('sample value', 'abc'), ('other value', 'xyz')", 3L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('null value', NULL), ('sample value', 'abc'), ('other value', 'xyz')");
            this.assertQuery("SELECT " + (String)nameInSql + " FROM " + tableName, "VALUES (NULL), ('abc'), ('xyz')");
            this.assertQuery("SELECT key FROM " + tableName + " WHERE " + (String)nameInSql + " IS NULL", "VALUES ('null value')");
            this.assertQuery("SELECT key FROM " + tableName + " WHERE " + (String)nameInSql + " = 'abc'", "VALUES ('sample value')");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    protected boolean isColumnNameRejected(Exception exception, String columnName, boolean delimited) {
        return false;
    }

    protected static boolean requiresDelimiting(String identifierName) {
        return !identifierName.matches("[a-zA-Z][a-zA-Z0-9_]*");
    }

    @DataProvider
    public Object[][] testColumnNameDataProvider() {
        return (Object[][])this.testColumnNameTestData().stream().map(this::filterColumnNameTestData).filter(Optional::isPresent).map(Optional::get).collect(DataProviders.toDataProvider());
    }

    private List<String> testColumnNameTestData() {
        return ImmutableList.builder().add((Object)"lowercase").add((Object)"UPPERCASE").add((Object)"MixedCase").add((Object)"an_underscore").add((Object)"a-hyphen-minus").add((Object)"a space").add((Object)"atrailingspace ").add((Object)" aleadingspace").add((Object)"a.dot").add((Object)"a,comma").add((Object)"a:colon").add((Object)"a;semicolon").add((Object)"an@at").add((Object)"a\"quote").add((Object)"an'apostrophe").add((Object)"a`backtick`").add((Object)"a/slash`").add((Object)"a\\backslash`").add((Object)"adigit0").add((Object)"0startwithdigit").build();
    }

    protected Optional<String> filterColumnNameTestData(String columnName) {
        return Optional.of(columnName);
    }

    protected String dataMappingTableName(String trinoTypeName) {
        return "test_data_mapping_smoke_" + trinoTypeName.replaceAll("[^a-zA-Z0-9]", "_") + "_" + TestTable.randomTableSuffix();
    }

    @Test(dataProvider="testDataMappingSmokeTestDataProvider")
    public void testDataMappingSmokeTest(DataMappingTestSetup dataMappingTestSetup) {
        this.testDataMapping(dataMappingTestSetup);
    }

    private void testDataMapping(DataMappingTestSetup dataMappingTestSetup) {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsCreateTable());
        String trinoTypeName = dataMappingTestSetup.getTrinoTypeName();
        String sampleValueLiteral = dataMappingTestSetup.getSampleValueLiteral();
        String highValueLiteral = dataMappingTestSetup.getHighValueLiteral();
        String tableName = this.dataMappingTableName(trinoTypeName);
        Runnable setup = () -> {
            String createTable = "CREATE TABLE " + tableName + " AS SELECT CAST(row_id AS varchar(50)) row_id, CAST(value AS " + trinoTypeName + ") value FROM (VALUES   ('null value', NULL),   ('sample value', " + sampleValueLiteral + "),   ('high value', " + highValueLiteral + "))  t(row_id, value)";
            this.assertUpdate(createTable, 3L);
        };
        if (dataMappingTestSetup.isUnsupportedType()) {
            String typeNameBase = trinoTypeName.replaceFirst("\\(.*", "");
            String expectedMessagePart = String.format("(%1$s.*not (yet )?supported)|((?i)unsupported.*%1$s)|((?i)not supported.*%1$s)", Pattern.quote(typeNameBase));
            Assertions.assertThatThrownBy(setup::run).hasMessageFindingMatch(expectedMessagePart).satisfies(e -> Assertions.assertThat((Throwable)QueryAssertions.getTrinoExceptionCause(e)).hasMessageFindingMatch(expectedMessagePart));
            return;
        }
        setup.run();
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE rand() = 42 OR value IS NULL", "VALUES 'null value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE rand() = 42 OR value IS NOT NULL", "VALUES 'sample value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE rand() = 42 OR value = " + sampleValueLiteral, "VALUES 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE rand() = 42 OR value = " + highValueLiteral, "VALUES 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL", "VALUES 'null value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NOT NULL", "VALUES 'sample value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value = " + sampleValueLiteral, "VALUES 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value != " + sampleValueLiteral, "VALUES 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value <= " + sampleValueLiteral, "VALUES 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value > " + sampleValueLiteral, "VALUES 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value <= " + highValueLiteral, "VALUES 'sample value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value = " + sampleValueLiteral, "VALUES 'null value', 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value != " + sampleValueLiteral, "VALUES 'null value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value <= " + sampleValueLiteral, "VALUES 'null value', 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value > " + sampleValueLiteral, "VALUES 'null value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value <= " + highValueLiteral, "VALUES 'null value', 'sample value', 'high value'");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @DataProvider
    public final Object[][] testDataMappingSmokeTestDataProvider() {
        return (Object[][])this.testDataMappingSmokeTestData().stream().map(this::filterDataMappingSmokeTestData).flatMap(Optional::stream).collect(DataProviders.toDataProvider());
    }

    private List<DataMappingTestSetup> testDataMappingSmokeTestData() {
        return ImmutableList.builder().add((Object)new DataMappingTestSetup("boolean", "false", "true")).add((Object)new DataMappingTestSetup("tinyint", "37", "127")).add((Object)new DataMappingTestSetup("smallint", "32123", "32767")).add((Object)new DataMappingTestSetup("integer", "1274942432", "2147483647")).add((Object)new DataMappingTestSetup("bigint", "312739231274942432", "9223372036854775807")).add((Object)new DataMappingTestSetup("real", "REAL '567.123'", "REAL '999999.999'")).add((Object)new DataMappingTestSetup("double", "DOUBLE '1234567890123.123'", "DOUBLE '9999999999999.999'")).add((Object)new DataMappingTestSetup("decimal(5,3)", "12.345", "99.999")).add((Object)new DataMappingTestSetup("decimal(15,3)", "123456789012.345", "999999999999.99")).add((Object)new DataMappingTestSetup("date", "DATE '0001-01-01'", "DATE '1582-10-04'")).add((Object)new DataMappingTestSetup("date", "DATE '1582-10-05'", "DATE '1582-10-14'")).add((Object)new DataMappingTestSetup("date", "DATE '2020-02-12'", "DATE '9999-12-31'")).add((Object)new DataMappingTestSetup("time", "TIME '15:03:00'", "TIME '23:59:59.999'")).add((Object)new DataMappingTestSetup("timestamp", "TIMESTAMP '2020-02-12 15:03:00'", "TIMESTAMP '2199-12-31 23:59:59.999'")).add((Object)new DataMappingTestSetup("timestamp(3) with time zone", "TIMESTAMP '2020-02-12 15:03:00 +01:00'", "TIMESTAMP '9999-12-31 23:59:59.999 +12:00'")).add((Object)new DataMappingTestSetup("char(3)", "'ab'", "'zzz'")).add((Object)new DataMappingTestSetup("varchar(3)", "'de'", "'zzz'")).add((Object)new DataMappingTestSetup("varchar", "'\u0142\u0105ka for the win'", "'\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b'")).add((Object)new DataMappingTestSetup("varbinary", "X'12ab3f'", "X'ffffffffffffffffffff'")).build();
    }

    protected Optional<DataMappingTestSetup> filterDataMappingSmokeTestData(DataMappingTestSetup dataMappingTestSetup) {
        return Optional.of(dataMappingTestSetup);
    }

    @Test(dataProvider="testCaseSensitiveDataMappingProvider")
    public void testCaseSensitiveDataMapping(DataMappingTestSetup dataMappingTestSetup) {
        this.testDataMapping(dataMappingTestSetup);
    }

    @DataProvider
    public final Object[][] testCaseSensitiveDataMappingProvider() {
        return (Object[][])this.testCaseSensitiveDataMappingData().stream().map(this::filterCaseSensitiveDataMappingTestData).flatMap(Optional::stream).collect(DataProviders.toDataProvider());
    }

    protected Optional<DataMappingTestSetup> filterCaseSensitiveDataMappingTestData(DataMappingTestSetup dataMappingTestSetup) {
        return Optional.of(dataMappingTestSetup);
    }

    private List<DataMappingTestSetup> testCaseSensitiveDataMappingData() {
        return ImmutableList.builder().add((Object)new DataMappingTestSetup("char(1)", "'A'", "'a'")).add((Object)new DataMappingTestSetup("varchar(1)", "'A'", "'a'")).add((Object)new DataMappingTestSetup("char(1)", "'A'", "'b'")).add((Object)new DataMappingTestSetup("varchar(1)", "'A'", "'b'")).add((Object)new DataMappingTestSetup("char(1)", "'B'", "'a'")).add((Object)new DataMappingTestSetup("varchar(1)", "'B'", "'a'")).build();
    }

    protected static final class DataMappingTestSetup {
        private final String trinoTypeName;
        private final String sampleValueLiteral;
        private final String highValueLiteral;
        private final boolean unsupportedType;

        public DataMappingTestSetup(String trinoTypeName, String sampleValueLiteral, String highValueLiteral) {
            this(trinoTypeName, sampleValueLiteral, highValueLiteral, false);
        }

        private DataMappingTestSetup(String trinoTypeName, String sampleValueLiteral, String highValueLiteral, boolean unsupportedType) {
            this.trinoTypeName = Objects.requireNonNull(trinoTypeName, "trinoTypeName is null");
            this.sampleValueLiteral = Objects.requireNonNull(sampleValueLiteral, "sampleValueLiteral is null");
            this.highValueLiteral = Objects.requireNonNull(highValueLiteral, "highValueLiteral is null");
            this.unsupportedType = unsupportedType;
        }

        public String getTrinoTypeName() {
            return this.trinoTypeName;
        }

        public String getSampleValueLiteral() {
            return this.sampleValueLiteral;
        }

        public String getHighValueLiteral() {
            return this.highValueLiteral;
        }

        public boolean isUnsupportedType() {
            return this.unsupportedType;
        }

        public DataMappingTestSetup asUnsupported() {
            return new DataMappingTestSetup(this.trinoTypeName, this.sampleValueLiteral, this.highValueLiteral, true);
        }

        public String toString() {
            return this.trinoTypeName + (this.unsupportedType ? "!" : "");
        }
    }
}

