/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.tpch;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.tpch.DecimalTypeMapping;
import io.trino.plugin.tpch.TpchNodePartitioningProvider;
import io.trino.plugin.tpch.TpchRecordSetProvider;
import io.trino.plugin.tpch.TpchSplitManager;
import io.trino.plugin.tpch.TpchTransactionHandle;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorIndexProvider;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.testing.tpch.ExampleSystemTable;
import io.trino.testing.tpch.TpchIndexMetadata;
import io.trino.testing.tpch.TpchIndexProvider;
import io.trino.testing.tpch.TpchIndexSpec;
import io.trino.testing.tpch.TpchIndexedData;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class IndexedTpchConnectorFactory
implements ConnectorFactory {
    private final TpchIndexSpec indexSpec;
    private final int defaultSplitsPerNode;

    public IndexedTpchConnectorFactory(TpchIndexSpec indexSpec, int defaultSplitsPerNode) {
        this.indexSpec = Objects.requireNonNull(indexSpec, "indexSpec is null");
        this.defaultSplitsPerNode = defaultSplitsPerNode;
    }

    public String getName() {
        return "tpch_indexed";
    }

    public Connector create(String catalogName, Map<String, String> properties, ConnectorContext context) {
        final int splitsPerNode = this.getSplitsPerNode(properties);
        final TpchIndexedData indexedData = new TpchIndexedData(this.indexSpec);
        final NodeManager nodeManager = context.getNodeManager();
        return new Connector(){

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
                return TpchTransactionHandle.INSTANCE;
            }

            public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
                return new TpchIndexMetadata(indexedData);
            }

            public ConnectorSplitManager getSplitManager() {
                return new TpchSplitManager(nodeManager, splitsPerNode);
            }

            public ConnectorRecordSetProvider getRecordSetProvider() {
                return new TpchRecordSetProvider(DecimalTypeMapping.DOUBLE);
            }

            public ConnectorIndexProvider getIndexProvider() {
                return new TpchIndexProvider(indexedData);
            }

            public Set<SystemTable> getSystemTables() {
                return ImmutableSet.of((Object)new ExampleSystemTable());
            }

            public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
                return new TpchNodePartitioningProvider(nodeManager, splitsPerNode);
            }
        };
    }

    private int getSplitsPerNode(Map<String, String> properties) {
        try {
            return Integer.parseInt((String)MoreObjects.firstNonNull((Object)properties.get("tpch.splits-per-node"), (Object)String.valueOf(this.defaultSplitsPerNode)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid property tpch.splits-per-node");
        }
    }
}

