/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DataProviders;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.assertions.Assert;
import java.util.Collections;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Deprecated
public abstract class AbstractTestIntegrationSmokeTest
extends AbstractTestQueryFramework {
    @Test
    public void ensureDistributedQueryRunner() {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.getQueryRunner().getNodeCount()).as("query runner node count", new Object[0])).isGreaterThanOrEqualTo(3);
    }

    @Test
    public void testColumnsInReverseOrder() {
        this.assertQuery("SELECT shippriority, clerk, totalprice FROM orders");
    }

    @Test
    public void testAggregation() {
        this.assertQuery("SELECT sum(orderkey) FROM orders");
        this.assertQuery("SELECT sum(totalprice) FROM orders");
        this.assertQuery("SELECT max(comment) FROM nation");
        this.assertQuery("SELECT count(*) FROM orders");
        this.assertQuery("SELECT count(*) FROM orders WHERE orderkey > 10");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders LIMIT 10)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders WHERE orderkey > 10 LIMIT 10)");
        this.assertQuery("SELECT DISTINCT regionkey FROM nation");
        this.assertQuery("SELECT regionkey FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT regionkey, nationkey FROM nation GROUP BY GROUPING SETS ((regionkey), (nationkey))", "SELECT NULL, nationkey FROM nation UNION ALL SELECT DISTINCT regionkey, NULL FROM nation");
        this.assertQuery("SELECT regionkey, nationkey, count(*) FROM nation GROUP BY GROUPING SETS ((), (regionkey), (nationkey), (regionkey, nationkey))", "SELECT NULL, NULL, count(*) FROM nation UNION ALL SELECT NULL, nationkey, 1 FROM nation UNION ALL SELECT regionkey, NULL, count(*) FROM nation GROUP BY regionkey UNION ALL SELECT regionkey, nationkey, 1 FROM nation");
        this.assertQuery("SELECT count(regionkey) FROM nation");
        this.assertQuery("SELECT count(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, count(*) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT min(regionkey), max(regionkey) FROM nation");
        this.assertQuery("SELECT min(DISTINCT regionkey), max(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, min(regionkey), min(name), max(regionkey), max(name) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT sum(regionkey) FROM nation");
        this.assertQuery("SELECT sum(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, sum(regionkey) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT avg(nationkey) FROM nation", "SELECT avg(CAST(nationkey AS double)) FROM nation");
        this.assertQuery("SELECT avg(DISTINCT nationkey) FROM nation", "SELECT avg(DISTINCT CAST(nationkey AS double)) FROM nation");
        this.assertQuery("SELECT regionkey, avg(nationkey) FROM nation GROUP BY regionkey", "SELECT regionkey, avg(CAST(nationkey AS double)) FROM nation GROUP BY regionkey");
    }

    @Test
    public void testExactPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey = 10");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey = 32", "VALUES (1301, 32)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey = 32", "VALUES (1301)");
    }

    @Test
    public void testInListPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey IN (10, 11, 20, 21)");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey IN (7, 10, 32, 33)", "VALUES (392, 7), (1301, 32), (670, 33)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey IN (7, 10, 32, 33)", "VALUES (392), (1301), (670)");
    }

    @Test
    public void testIsNullPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey IS NULL");
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey = 10 OR orderkey IS NULL");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey = 32 OR orderkey IS NULL", "VALUES (1301, 32)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey = 32 OR orderkey IS NULL", "VALUES (1301)");
    }

    @Test
    public void testLikePredicate() {
        this.assertQuery("SELECT orderkey FROM orders WHERE orderpriority LIKE '5-L%'");
        this.assertQuery("SELECT orderkey, orderpriority FROM orders WHERE orderpriority LIKE '5-L%'");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderpriority LIKE '5-L__'");
        this.assertQuery("SELECT orderkey, orderpriority FROM orders WHERE orderpriority LIKE '5-L__'");
    }

    @Test
    public void testLimit() {
        Assert.assertEquals((int)this.computeActual("SELECT * FROM orders LIMIT 10").getRowCount(), (int)10);
    }

    @Test
    public void testMultipleRangesPredicate() {
        this.assertQuery("SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders WHERE orderkey BETWEEN 10 AND 50");
    }

    @Test
    public void testRangePredicate() {
        this.assertQuery("SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders WHERE orderkey BETWEEN 10 AND 50");
    }

    @Test
    public void testConcurrentScans() {
        String unionMultipleTimes = String.join((CharSequence)" UNION ALL ", Collections.nCopies(25, "SELECT * FROM orders"));
        this.assertQuery("SELECT sum(if(rand() >= 0, orderkey)) FROM (" + unionMultipleTimes + ")", "VALUES 11246812500");
    }

    @Test
    public void testSelectAll() {
        this.assertQuery("SELECT * FROM orders");
    }

    @Test(timeOut=300000L, dataProvider="joinDistributionTypes")
    public void testJoinWithEmptySides(FeaturesConfig.JoinDistributionType joinDistributionType) {
        Session session = this.noJoinReordering(joinDistributionType);
        this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.name = ''", "VALUES 0");
        this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.regionkey < 0", "VALUES 0");
        this.assertQuery(session, "SELECT count(*) FROM region JOIN nation ON nation.regionkey = region.regionkey AND region.name = ''", "VALUES 0");
        this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.regionkey < 0", "VALUES 0");
    }

    @DataProvider
    public Object[][] joinDistributionTypes() {
        return (Object[][])Stream.of(FeaturesConfig.JoinDistributionType.values()).collect(DataProviders.toDataProvider());
    }

    @Test
    public void testJoin() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("ignore_stats_calculator_failures", "false").build();
        this.assertQuery(session, "SELECT c.name, n.name, r.name FROM nation n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey");
        this.assertQuery(session, "SELECT c.name, n.name, r.name FROM nation n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey WHERE n.name = 'ARGENTINA'");
        this.assertQuery(session, "SELECT c.name, n.name, n.count, r.name FROM (SELECT name, regionkey, nationkey, count(*) count FROM nation GROUP BY name, regionkey, nationkey) n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey");
    }

    @Test
    public void testShowSchemas() {
        MaterializedResult actualSchemas = this.computeActual("SHOW SCHEMAS").toTestTypes();
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR}).row(new Object[]{this.getSession().getSchema().orElse("tpch")});
        QueryAssertions.assertContains(actualSchemas, resultBuilder.build());
    }

    @Test
    public void testShowTables() {
        MaterializedResult actualTables = this.computeActual("SHOW TABLES").toTestTypes();
        MaterializedResult expectedTables = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR}).row(new Object[]{"orders"}).build();
        QueryAssertions.assertContains(actualTables, expectedTables);
    }

    @Test
    public void testDescribeTable() {
        MaterializedResult expectedColumns = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar(1)", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar(15)", "", ""}).row(new Object[]{"clerk", "varchar(15)", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar(79)", "", ""}).build();
        MaterializedResult actualColumns = this.computeActual("DESCRIBE orders");
        Assert.assertEquals((Iterable)actualColumns, (Iterable)expectedColumns);
    }

    @Test
    public void testExplainAnalyze() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT * FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT count(*), clerk FROM orders GROUP BY clerk", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT x + y FROM (   SELECT orderdate, COUNT(*) x FROM orders GROUP BY orderdate) a JOIN (   SELECT orderdate, COUNT(*) y FROM orders GROUP BY orderdate) b ON a.orderdate = b.orderdate", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT count(*), clerk FROM orders GROUP BY clerk UNION ALL SELECT sum(orderkey), clerk FROM orders GROUP BY clerk", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW COLUMNS FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE EXPLAIN SELECT count(*) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE EXPLAIN ANALYZE SELECT count(*) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW FUNCTIONS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW TABLES", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW SCHEMAS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW CATALOGS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW SESSION", new String[0]);
    }

    @Test
    public void testExplainAnalyzeVerbose() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT * FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT rank() OVER (PARTITION BY orderkey ORDER BY clerk DESC) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT rank() OVER (PARTITION BY orderkey ORDER BY clerk DESC) FROM orders WHERE orderkey < 0", new String[0]);
    }

    @Test
    public void testTableSampleSystem() {
        MaterializedResult fullSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (100)");
        MaterializedResult emptySample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (0)");
        MaterializedResult randomSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (50)");
        MaterializedResult all = this.computeActual("SELECT orderkey FROM orders");
        QueryAssertions.assertContains(all, fullSample);
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
        org.testng.Assert.assertTrue((all.getMaterializedRows().size() >= randomSample.getMaterializedRows().size() ? 1 : 0) != 0);
    }

    @Test
    public void testTableSampleWithFiltering() {
        MaterializedResult emptySample = this.computeActual("SELECT DISTINCT orderkey, orderdate FROM orders TABLESAMPLE SYSTEM (99) WHERE orderkey BETWEEN 0 AND 0");
        MaterializedResult halfSample = this.computeActual("SELECT DISTINCT orderkey, orderdate FROM orders TABLESAMPLE SYSTEM (50) WHERE orderkey BETWEEN 0 AND 9999999999");
        MaterializedResult all = this.computeActual("SELECT orderkey, orderdate FROM orders");
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
        org.testng.Assert.assertTrue((all.getMaterializedRows().size() >= halfSample.getMaterializedRows().size() ? 1 : 0) != 0);
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE orders"))).matches((CharSequence)"CREATE TABLE \\w+\\.\\w+\\.orders \\Q(\n   orderkey bigint,\n   custkey bigint,\n   orderstatus varchar(1),\n   totalprice double,\n   orderdate date,\n   orderpriority varchar(15),\n   clerk varchar(15),\n   shippriority integer,\n   comment varchar(79)\n)");
    }

    @Test
    public void testSelectInformationSchemaTables() {
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        String schemaPattern = schema.replaceAll("^.", "_");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = '" + schema + "' AND table_name = 'orders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema LIKE '" + schema + "' AND table_name LIKE '%rders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema LIKE '" + schemaPattern + "' AND table_name LIKE '%rders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = '" + catalog + "' AND table_schema LIKE '" + schema + "' AND table_name LIKE '%orders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = 'something_else'", "SELECT '' WHERE false");
        this.assertQuery("SELECT DISTINCT table_name FROM information_schema.tables WHERE table_schema = 'information_schema' OR rand() = 42 ORDER BY 1", "VALUES ('applicable_roles'), ('columns'), ('enabled_roles'), ('role_authorization_descriptors'), ('roles'), ('schemata'), ('table_privileges'), ('tables'), ('views')");
    }

    @Test
    public void testSelectInformationSchemaColumns() {
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        String schemaPattern = schema.replaceAll(".$", "_");
        String ordersTableWithColumns = "VALUES ('orders', 'orderkey'), ('orders', 'custkey'), ('orders', 'orderstatus'), ('orders', 'totalprice'), ('orders', 'orderdate'), ('orders', 'orderpriority'), ('orders', 'clerk'), ('orders', 'shippriority'), ('orders', 'comment')";
        this.assertQuery("SELECT table_schema FROM information_schema.columns WHERE table_schema = '" + schema + "' GROUP BY table_schema", "VALUES '" + schema + "'");
        this.assertQuery("SELECT table_name FROM information_schema.columns WHERE table_name = 'orders' GROUP BY table_name", "VALUES 'orders'");
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schema + "' AND table_name = 'orders'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schema + "' AND table_name LIKE '%rders'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema LIKE '" + schemaPattern + "' AND table_name LIKE '_rder_'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "' AND table_name LIKE '%orders%'", ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns");
        this.assertQuery("SELECT DISTINCT table_name, column_name FROM information_schema.columns WHERE table_name LIKE '_rders'", ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "'");
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "'");
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "' AND table_name LIKE '_rders'", ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_name LIKE '%'");
        this.assertQuery("SELECT column_name FROM information_schema.columns WHERE table_catalog = 'something_else'", "SELECT '' WHERE false");
        this.assertQuery("SELECT DISTINCT table_name FROM information_schema.columns WHERE table_schema = 'information_schema' OR rand() = 42 ORDER BY 1", "VALUES ('applicable_roles'), ('columns'), ('enabled_roles'), ('role_authorization_descriptors'), ('roles'), ('schemata'), ('table_privileges'), ('tables'), ('views')");
    }
}

