/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import io.trino.Session;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.FeaturesConfig;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestDistributedQueries;
import io.trino.testing.DataProviders;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.assertions.Assert;
import io.trino.testing.sql.TestTable;
import java.util.Collections;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class BaseConnectorTest
extends AbstractTestDistributedQueries {
    @Override
    @Deprecated
    protected final boolean supportsCreateSchema() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA);
    }

    @Override
    @Deprecated
    protected final boolean supportsCreateTable() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE);
    }

    @Override
    @Deprecated
    protected final boolean supportsInsert() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT);
    }

    @Override
    @Deprecated
    protected final boolean supportsDelete() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE);
    }

    @Override
    @Deprecated
    protected final boolean supportsViews() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW);
    }

    @Override
    @Deprecated
    protected final boolean supportsArrays() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ARRAY);
    }

    @Override
    @Deprecated
    protected final boolean supportsCommentOnTable() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_TABLE);
    }

    @Override
    @Deprecated
    protected final boolean supportsCommentOnColumn() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_COLUMN);
    }

    @Override
    @Deprecated
    protected boolean supportsRenameTable() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE);
    }

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return connectorBehavior.hasBehaviorByDefault(this::hasBehavior);
    }

    @Override
    @Test
    public void ensureTestNamingConvention() {
        Assertions.assertThat((String)this.getClass().getName()).endsWith((CharSequence)"ConnectorTest");
    }

    @Test
    public void testColumnsInReverseOrder() {
        this.assertQuery("SELECT shippriority, clerk, totalprice FROM orders");
    }

    @Test
    public void testAggregation() {
        this.assertQuery("SELECT sum(orderkey) FROM orders");
        this.assertQuery("SELECT sum(totalprice) FROM orders");
        this.assertQuery("SELECT max(comment) FROM nation");
        this.assertQuery("SELECT count(*) FROM orders");
        this.assertQuery("SELECT count(*) FROM orders WHERE orderkey > 10");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders LIMIT 10)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders WHERE orderkey > 10 LIMIT 10)");
        this.assertQuery("SELECT DISTINCT regionkey FROM nation");
        this.assertQuery("SELECT regionkey FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT regionkey, nationkey FROM nation GROUP BY GROUPING SETS ((regionkey), (nationkey))", "SELECT NULL, nationkey FROM nation UNION ALL SELECT DISTINCT regionkey, NULL FROM nation");
        this.assertQuery("SELECT regionkey, nationkey, count(*) FROM nation GROUP BY GROUPING SETS ((), (regionkey), (nationkey), (regionkey, nationkey))", "SELECT NULL, NULL, count(*) FROM nation UNION ALL SELECT NULL, nationkey, 1 FROM nation UNION ALL SELECT regionkey, NULL, count(*) FROM nation GROUP BY regionkey UNION ALL SELECT regionkey, nationkey, 1 FROM nation");
        this.assertQuery("SELECT count(regionkey) FROM nation");
        this.assertQuery("SELECT count(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, count(*) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT min(regionkey), max(regionkey) FROM nation");
        this.assertQuery("SELECT min(DISTINCT regionkey), max(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, min(regionkey), min(name), max(regionkey), max(name) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT sum(regionkey) FROM nation");
        this.assertQuery("SELECT sum(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, sum(regionkey) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT avg(nationkey) FROM nation", "SELECT avg(CAST(nationkey AS double)) FROM nation");
        this.assertQuery("SELECT avg(DISTINCT nationkey) FROM nation", "SELECT avg(DISTINCT CAST(nationkey AS double)) FROM nation");
        this.assertQuery("SELECT regionkey, avg(nationkey) FROM nation GROUP BY regionkey", "SELECT regionkey, avg(CAST(nationkey AS double)) FROM nation GROUP BY regionkey");
    }

    @Test
    public void testExactPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey = 10");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey = 32", "VALUES (1301, 32)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey = 32", "VALUES (1301)");
    }

    @Test
    public void testInListPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey IN (10, 11, 20, 21)");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey IN (7, 10, 32, 33)", "VALUES (392, 7), (1301, 32), (670, 33)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey IN (7, 10, 32, 33)", "VALUES (392), (1301), (670)");
    }

    @Test
    public void testIsNullPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey IS NULL");
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey = 10 OR orderkey IS NULL");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey = 32 OR orderkey IS NULL", "VALUES (1301, 32)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey = 32 OR orderkey IS NULL", "VALUES (1301)");
    }

    @Test
    public void testLikePredicate() {
        this.assertQuery("SELECT orderkey FROM orders WHERE orderpriority LIKE '5-L%'");
        this.assertQuery("SELECT orderkey, orderpriority FROM orders WHERE orderpriority LIKE '5-L%'");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderpriority LIKE '5-L__'");
        this.assertQuery("SELECT orderkey, orderpriority FROM orders WHERE orderpriority LIKE '5-L__'");
    }

    @Test
    public void testMultipleRangesPredicate() {
        this.assertQuery("SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders WHERE orderkey BETWEEN 10 AND 50");
    }

    @Test
    public void testRangePredicate() {
        this.assertQuery("SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders WHERE orderkey BETWEEN 10 AND 50");
    }

    @Test
    public void testPredicateReflectedInExplain() {
        this.assertExplain("EXPLAIN SELECT name FROM nation WHERE nationkey = 42", "(predicate|filterPredicate|constraint).{0,10}(nationkey|NATIONKEY)");
    }

    @Test
    public void testSortItemsReflectedInExplain() {
        String expectedPattern = this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN) ? "sortOrder=\\[(?i:nationkey):.* DESC NULLS LAST] limit=5" : "\\[5 by \\((?i:nationkey) DESC NULLS LAST\\)]";
        this.assertExplain("EXPLAIN SELECT name FROM nation ORDER BY nationkey DESC NULLS LAST LIMIT 5", expectedPattern);
    }

    @Test
    public void testConcurrentScans() {
        String unionMultipleTimes = String.join((CharSequence)" UNION ALL ", Collections.nCopies(25, "SELECT * FROM orders"));
        this.assertQuery("SELECT sum(if(rand() >= 0, orderkey)) FROM (" + unionMultipleTimes + ")", "VALUES 11246812500");
    }

    @Test
    public void testSelectAll() {
        this.assertQuery("SELECT * FROM orders");
    }

    @Test(timeOut=300000L, dataProvider="joinDistributionTypes")
    public void testJoinWithEmptySides(FeaturesConfig.JoinDistributionType joinDistributionType) {
        Session session = this.noJoinReordering(joinDistributionType);
        this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.name = ''", "VALUES 0");
        this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.regionkey < 0", "VALUES 0");
        this.assertQuery(session, "SELECT count(*) FROM region JOIN nation ON nation.regionkey = region.regionkey AND region.name = ''", "VALUES 0");
        this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.regionkey < 0", "VALUES 0");
    }

    @DataProvider
    public Object[][] joinDistributionTypes() {
        return (Object[][])Stream.of(FeaturesConfig.JoinDistributionType.values()).collect(DataProviders.toDataProvider());
    }

    @Test
    public void testJoin() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("ignore_stats_calculator_failures", "false").build();
        this.assertQuery(session, "SELECT c.name, n.name, r.name FROM nation n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey");
        this.assertQuery(session, "SELECT c.name, n.name, r.name FROM nation n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey WHERE n.name = 'ARGENTINA'");
        this.assertQuery(session, "SELECT c.name, n.name, n.count, r.name FROM (SELECT name, regionkey, nationkey, count(*) count FROM nation GROUP BY name, regionkey, nationkey) n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey");
    }

    @Test
    public void testDescribeTable() {
        MaterializedResult expectedColumns = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar(1)", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar(15)", "", ""}).row(new Object[]{"clerk", "varchar(15)", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar(79)", "", ""}).build();
        MaterializedResult actualColumns = this.computeActual("DESCRIBE orders");
        Assert.assertEquals((Iterable)actualColumns, (Iterable)expectedColumns);
    }

    @Override
    public void testView() {
        super.testView();
    }

    @Test
    public void testMaterializedView() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW)) {
            this.assertQueryFails("CREATE MATERIALIZED VIEW nation_mv AS SELECT * FROM nation", "This connector does not support creating materialized views");
            return;
        }
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        String viewName = "test_materialized_view_" + TestTable.randomTableSuffix();
        String viewNameWithComment = "test_materialized_view_with_comment_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " AS SELECT * FROM nation");
        this.assertUpdate("CREATE MATERIALIZED VIEW " + viewNameWithComment + " COMMENT 'mv_comment' AS SELECT * FROM nation");
        MaterializedResult materializedRows = this.computeActual("SHOW CREATE MATERIALIZED VIEW " + viewNameWithComment);
        Assertions.assertThat((String)((String)materializedRows.getOnlyValue())).contains(new CharSequence[]{"COMMENT 'mv_comment'"});
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, comment FROM system.metadata.table_comments WHERE catalog_name = '" + catalogName + "' AND schema_name = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES ('" + viewName + "', null), ('" + viewNameWithComment + "', 'mv_comment')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + viewName))).skippingTypesCheck().matches("SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + viewNameWithComment))).skippingTypesCheck().matches("SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES"))).skippingTypesCheck().containsAll("VALUES '" + viewName + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES ('" + viewName + "', 'BASE TABLE')");
        this.assertQuery("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '" + schemaName + "' and table_name = '" + viewName + "'", "VALUES ('" + viewName + "', 'BASE TABLE')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, table_type FROM system.jdbc.tables"))).skippingTypesCheck().containsAll("VALUES ('" + schemaName + "', '" + viewName + "', 'TABLE')");
        this.assertQuery("SELECT table_schem, table_name, table_type FROM system.jdbc.tables WHERE table_cat = '" + catalogName + "' AND table_schem = '" + schemaName + "' AND table_name = '" + viewName + "'", "VALUES ('" + schemaName + "', '" + viewName + "', 'TABLE')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW COLUMNS FROM " + viewName))).projected(new int[]{0}).skippingTypesCheck().matches("VALUES 'nationkey', 'name', 'regionkey', 'comment'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("DESCRIBE " + viewName))).projected(new int[]{0}).skippingTypesCheck().matches("VALUES 'nationkey', 'name', 'regionkey', 'comment'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES '" + viewName + "') CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schemaName + "' and table_name = '" + viewName + "'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES '" + viewName + "') CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        this.checkInformationSchemaViewsForMaterializedView(schemaName, viewName);
        String expectedValues = "VALUES ('" + schemaName + "', '" + viewName + "', 'nationkey'), ('" + schemaName + "', '" + viewName + "', 'name'), ('" + schemaName + "', '" + viewName + "', 'regionkey'), ('" + schemaName + "', '" + viewName + "', 'comment')";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns"))).skippingTypesCheck().containsAll(expectedValues);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_schem LIKE '%" + schemaName + "%'"))).skippingTypesCheck().containsAll(expectedValues);
        this.assertQuery("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_name LIKE '%" + viewName + "%'", expectedValues);
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE MATERIALIZED VIEW " + viewName))).matches((CharSequence)("(?s)CREATE MATERIALIZED VIEW \\Q" + catalogName + "." + schemaName + "." + viewName + "\\E.* AS\nSELECT \\*\nFROM\n  nation"));
        this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
        this.assertUpdate("DROP MATERIALIZED VIEW " + viewNameWithComment);
    }

    protected void checkInformationSchemaViewsForMaterializedView(String schemaName, String viewName) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name FROM information_schema.views WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES '" + viewName + "'");
    }

    @Test
    public void testExplainAnalyze() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT * FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT count(*), clerk FROM orders GROUP BY clerk", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT x + y FROM (   SELECT orderdate, COUNT(*) x FROM orders GROUP BY orderdate) a JOIN (   SELECT orderdate, COUNT(*) y FROM orders GROUP BY orderdate) b ON a.orderdate = b.orderdate", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT count(*), clerk FROM orders GROUP BY clerk UNION ALL SELECT sum(orderkey), clerk FROM orders GROUP BY clerk", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW COLUMNS FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE EXPLAIN SELECT count(*) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE EXPLAIN ANALYZE SELECT count(*) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW FUNCTIONS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW TABLES", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW SCHEMAS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW CATALOGS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW SESSION", new String[0]);
    }

    @Test
    public void testExplainAnalyzeVerbose() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT * FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT rank() OVER (PARTITION BY orderkey ORDER BY clerk DESC) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT rank() OVER (PARTITION BY orderkey ORDER BY clerk DESC) FROM orders WHERE orderkey < 0", new String[0]);
    }

    @Test
    public void testTableSampleSystem() {
        MaterializedResult fullSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (100)");
        MaterializedResult emptySample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (0)");
        MaterializedResult randomSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (50)");
        MaterializedResult all = this.computeActual("SELECT orderkey FROM orders");
        QueryAssertions.assertContains(all, fullSample);
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
        org.testng.Assert.assertTrue((all.getMaterializedRows().size() >= randomSample.getMaterializedRows().size() ? 1 : 0) != 0);
    }

    @Test
    public void testTableSampleWithFiltering() {
        MaterializedResult emptySample = this.computeActual("SELECT DISTINCT orderkey, orderdate FROM orders TABLESAMPLE SYSTEM (99) WHERE orderkey BETWEEN 0 AND 0");
        MaterializedResult halfSample = this.computeActual("SELECT DISTINCT orderkey, orderdate FROM orders TABLESAMPLE SYSTEM (50) WHERE orderkey BETWEEN 0 AND 9999999999");
        MaterializedResult all = this.computeActual("SELECT orderkey, orderdate FROM orders");
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
        org.testng.Assert.assertTrue((all.getMaterializedRows().size() >= halfSample.getMaterializedRows().size() ? 1 : 0) != 0);
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE orders").getOnlyValue())).matches((CharSequence)"CREATE TABLE \\w+\\.\\w+\\.orders \\Q(\n   orderkey bigint,\n   custkey bigint,\n   orderstatus varchar(1),\n   totalprice double,\n   orderdate date,\n   orderpriority varchar(15),\n   clerk varchar(15),\n   shippriority integer,\n   comment varchar(79)\n)");
    }

    @Test
    public void testSelectInformationSchemaTables() {
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        String schemaPattern = schema.replaceAll("^.", "_");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = '" + schema + "' AND table_name = 'orders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema LIKE '" + schema + "' AND table_name LIKE '%rders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema LIKE '" + schemaPattern + "' AND table_name LIKE '%rders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = '" + catalog + "' AND table_schema LIKE '" + schema + "' AND table_name LIKE '%orders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = 'something_else'", "SELECT '' WHERE false");
        this.assertQuery("SELECT DISTINCT table_name FROM information_schema.tables WHERE table_schema = 'information_schema' OR rand() = 42 ORDER BY 1", "VALUES ('applicable_roles'), ('columns'), ('enabled_roles'), ('role_authorization_descriptors'), ('roles'), ('schemata'), ('table_privileges'), ('tables'), ('views')");
    }

    @Test
    public void testSelectInformationSchemaColumns() {
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        String schemaPattern = schema.replaceAll(".$", "_");
        String ordersTableWithColumns = "VALUES ('orders', 'orderkey'), ('orders', 'custkey'), ('orders', 'orderstatus'), ('orders', 'totalprice'), ('orders', 'orderdate'), ('orders', 'orderpriority'), ('orders', 'clerk'), ('orders', 'shippriority'), ('orders', 'comment')";
        this.assertQuery("SELECT table_schema FROM information_schema.columns WHERE table_schema = '" + schema + "' GROUP BY table_schema", "VALUES '" + schema + "'");
        this.assertQuery("SELECT table_name FROM information_schema.columns WHERE table_name = 'orders' GROUP BY table_name", "VALUES 'orders'");
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schema + "' AND table_name = 'orders'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schema + "' AND table_name LIKE '%rders'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema LIKE '" + schemaPattern + "' AND table_name LIKE '_rder_'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "' AND table_name LIKE '%orders%'", ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns");
        this.assertQuery("SELECT DISTINCT table_name, column_name FROM information_schema.columns WHERE table_name LIKE '_rders'", ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "'");
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "'");
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "' AND table_name LIKE '_rders'", ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_name LIKE '%'");
        this.assertQuery("SELECT column_name FROM information_schema.columns WHERE table_catalog = 'something_else'", "SELECT '' WHERE false");
        this.assertQuery("SELECT DISTINCT table_name FROM information_schema.columns WHERE table_schema = 'information_schema' OR rand() = 42 ORDER BY 1", "VALUES ('applicable_roles'), ('columns'), ('enabled_roles'), ('role_authorization_descriptors'), ('roles'), ('schemata'), ('table_privileges'), ('tables'), ('views')");
    }

    @Test
    public void testRenameTableAcrossSchema() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE_ACROSS_SCHEMAS)) {
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE)) {
                throw new SkipException("Skipping since rename table is not supported at all");
            }
            this.assertQueryFails("ALTER TABLE nation RENAME TO other_schema.yyyy", "This connector does not support renaming tables across schemas");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            throw new AssertionError((Object)"Cannot test ALTER TABLE RENAME across schemas without CREATE SCHEMA, the test needs to be implemented in a connector-specific way");
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test ALTER TABLE RENAME across schemas without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        String tableName = "test_rename_old_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String schemaName = "test_schema_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        String renamedTable = schemaName + ".test_rename_new_" + TestTable.randomTableSuffix();
        this.assertUpdate("ALTER TABLE " + tableName + " RENAME TO " + renamedTable);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertQuery("SELECT x FROM " + renamedTable, "VALUES 123");
        this.assertUpdate("DROP TABLE " + renamedTable);
        this.assertUpdate("DROP SCHEMA " + schemaName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), renamedTable));
    }
}

