/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import java.util.Objects;
import java.util.function.Predicate;

public enum TestingConnectorBehavior {
    SUPPORTS_PREDICATE_PUSHDOWN,
    SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_EQUALITY(SUPPORTS_PREDICATE_PUSHDOWN),
    SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY(SUPPORTS_PREDICATE_PUSHDOWN),
    SUPPORTS_LIMIT_PUSHDOWN,
    SUPPORTS_TOPN_PUSHDOWN,
    SUPPORTS_AGGREGATION_PUSHDOWN,
    SUPPORTS_JOIN_PUSHDOWN(false),
    SUPPORTS_JOIN_PUSHDOWN_WITH_FULL_JOIN(SUPPORTS_JOIN_PUSHDOWN),
    SUPPORTS_JOIN_PUSHDOWN_WITH_DISTINCT_FROM(SUPPORTS_JOIN_PUSHDOWN),
    SUPPORTS_CREATE_TABLE,
    SUPPORTS_CREATE_TABLE_WITH_DATA(SUPPORTS_CREATE_TABLE),
    SUPPORTS_INSERT,
    SUPPORTS_DELETE(false),
    SUPPORTS_ROW_LEVEL_DELETE(SUPPORTS_DELETE),
    SUPPORTS_CREATE_SCHEMA;

    private final Predicate<Predicate<TestingConnectorBehavior>> hasBehaviorByDefault;

    private TestingConnectorBehavior() {
        this(true);
    }

    private TestingConnectorBehavior(boolean hasBehaviorByDefault) {
        this((Predicate<TestingConnectorBehavior> fallback) -> hasBehaviorByDefault);
    }

    private TestingConnectorBehavior(TestingConnectorBehavior defaultBehaviorSource) {
        this((Predicate<TestingConnectorBehavior> fallback) -> fallback.test(defaultBehaviorSource));
    }

    private TestingConnectorBehavior(Predicate<Predicate<TestingConnectorBehavior>> hasBehaviorByDefault) {
        this.hasBehaviorByDefault = Objects.requireNonNull(hasBehaviorByDefault, "hasBehaviorByDefault is null");
    }

    boolean hasBehaviorByDefault(Predicate<TestingConnectorBehavior> fallback) {
        return this.hasBehaviorByDefault.test(fallback);
    }
}

