/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableList;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.sql.TestTable;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public abstract class BaseConnectorSmokeTest
extends AbstractTestQueryFramework {
    protected static final List<TpchTable<?>> REQUIRED_TPCH_TABLES = ImmutableList.of((Object)TpchTable.NATION, (Object)TpchTable.REGION);

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return connectorBehavior.hasBehaviorByDefault(this::hasBehavior);
    }

    @Test
    public void ensureDistributedQueryRunner() {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.getQueryRunner().getNodeCount()).as("query runner node count", new Object[0])).isGreaterThanOrEqualTo(3);
    }

    @Test
    public void testSelect() {
        this.assertQuery("SELECT name FROM region");
    }

    @Test
    public void testPredicate() {
        this.assertQuery("SELECT name, regionkey FROM nation WHERE nationkey = 10");
        this.assertQuery("SELECT name, regionkey FROM nation WHERE nationkey BETWEEN 5 AND 15");
        this.assertQuery("SELECT name, regionkey FROM nation WHERE name = 'EGYPT'");
    }

    @Test
    public void testLimit() {
        this.assertQuery("SELECT name FROM region LIMIT 5");
    }

    @Test
    public void testTopN() {
        this.assertQuery("SELECT regionkey FROM nation ORDER BY name LIMIT 3");
    }

    @Test
    public void testAggregation() {
        this.assertQuery("SELECT sum(regionkey) FROM nation");
        this.assertQuery("SELECT sum(nationkey) FROM nation GROUP BY regionkey");
    }

    @Test
    public void testHaving() {
        this.assertQuery("SELECT regionkey, sum(nationkey) FROM nation GROUP BY regionkey HAVING sum(nationkey) = 58", "VALUES (4, 58)");
    }

    @Test
    public void testJoin() {
        this.assertQuery("SELECT n.name, r.name FROM nation n JOIN region r on n.regionkey = r.regionkey");
    }

    @Test
    public void testCreateTable() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            this.assertQueryFails("CREATE TABLE xxxx (a bigint, b double)", "This connector does not support create");
            return;
        }
        String tableName = "test_create_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b double)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a, b FROM " + tableName))).returnsEmptyResult();
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTableAsSelect() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA)) {
            this.assertQueryFails("CREATE TABLE xxxx (a bigint, b double) AS VALUES (42, -38.5)", "This connector does not support create");
            return;
        }
        String tableName = "test_create_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT BIGINT '42' a, DOUBLE '-38.5' b", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT CAST(a AS bigint), b FROM " + tableName))).matches("VALUES (BIGINT '42', -385e-1)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testInsert() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            this.assertQueryFails("INSERT INTO region (regionkey) VALUES (42)", "This connector does not support insert");
            return;
        }
        String tableName = "test_create_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b double)");
        this.assertUpdate("INSERT INTO " + tableName + " (a, b) VALUES (42, -38.5)", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT CAST(a AS bigint), b FROM " + tableName))).matches("VALUES (BIGINT '42', -385e-1)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDelete() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE)) {
            this.assertQueryFails("DELETE FROM region", "This connector does not support deletes");
            return;
        }
        String tableName = "test_delete_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM region", 5L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE regionkey = 2", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT regionkey FROM " + tableName))).skippingTypesCheck().matches("VALUES 1, 3, 4, 5");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateSchema() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            this.assertQueryFails("CREATE SCHEMA xxxxxx", "This connector does not support creating schemas");
            return;
        }
        String schemaName = "test_schema_create_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW SCHEMAS"))).skippingTypesCheck().containsAll(String.format("VALUES '%s', '%s'", this.getSession().getSchema().orElseThrow(), schemaName));
        this.assertUpdate("DROP SCHEMA " + schemaName);
    }

    @Test
    public void testSelectInformationSchemaTables() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s'", this.getSession().getSchema().orElseThrow())))).skippingTypesCheck().containsAll("VALUES 'nation', 'region'");
    }

    @Test
    public void testSelectInformationSchemaColumns() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(String.format("SELECT column_name FROM information_schema.columns WHERE table_schema = '%s' AND table_name = 'region'", this.getSession().getSchema().orElseThrow())))).skippingTypesCheck().matches("VALUES 'regionkey', 'name', 'comment'");
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE region").getOnlyValue())).matches((CharSequence)String.format("CREATE TABLE %s.%s.region \\(\n   regionkey (bigint|decimal\\(19, 0\\)),\n   name varchar(\\(\\d+\\))?,\n   comment varchar(\\(\\d+\\))?\n\\)", Pattern.quote((String)this.getSession().getCatalog().orElseThrow()), Pattern.quote((String)this.getSession().getSchema().orElseThrow())));
    }
}

