/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import io.trino.Session;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.testing.LocalQueryRunner;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.testng.Assert;

public class PlanDeterminismChecker {
    private static final int MINIMUM_SUBSEQUENT_SAME_PLANS = 10;
    private final LocalQueryRunner localQueryRunner;
    private final Function<String, String> planEquivalenceFunction;

    public PlanDeterminismChecker(LocalQueryRunner localQueryRunner) {
        this(localQueryRunner, Function.identity());
    }

    public PlanDeterminismChecker(LocalQueryRunner localQueryRunner, Function<String, String> planEquivalenceFunction) {
        this.localQueryRunner = localQueryRunner;
        this.planEquivalenceFunction = planEquivalenceFunction;
    }

    public void checkPlanIsDeterministic(String sql) {
        this.checkPlanIsDeterministic(this.localQueryRunner.getDefaultSession(), sql);
    }

    public void checkPlanIsDeterministic(Session session, String sql) {
        IntStream.range(1, 10).mapToObj(attempt -> this.getPlanText(session, sql)).map(this.planEquivalenceFunction).reduce((previous, current) -> {
            Assert.assertEquals((String)previous, (String)current);
            return current;
        });
    }

    private String getPlanText(Session session, String sql) {
        return (String)this.localQueryRunner.inTransaction(session, transactionSession -> {
            Plan plan = this.localQueryRunner.createPlan(transactionSession, sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, WarningCollector.NOOP);
            return PlanPrinter.textLogicalPlan((PlanNode)plan.getRoot(), (TypeProvider)plan.getTypes(), (Metadata)this.localQueryRunner.getMetadata(), (StatsAndCosts)plan.getStatsAndCosts(), (Session)transactionSession, (int)0, (boolean)false);
        });
    }
}

