/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Properties;

public final class TestingProperties {
    private static final Supplier<Properties> properties = Suppliers.memoize(() -> {
        Properties properties = new Properties();
        try {
            try (InputStream stream = Resources.getResource((String)"trino-testing.properties").openStream();){
                properties.load(stream);
            }
            return properties;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    });

    private TestingProperties() {
    }

    public static String getProjectVersion() {
        return TestingProperties.getProjectProperty("project.version");
    }

    public static String getDockerImagesVersion() {
        return TestingProperties.getProjectProperty("docker.images.version");
    }

    private static String getProjectProperty(String name) {
        return Objects.requireNonNull(((Properties)properties.get()).getProperty(name), name + " is null");
    }

    public static String requiredNonEmptySystemProperty(String propertyName) {
        String value = System.getProperty(propertyName);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (String)"System property %s must be non-empty", (Object)propertyName);
        return value;
    }
}

