/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testng.services;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import io.trino.testng.services.Listeners;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestNGMethod;

public class ReportOrphanedExecutors
implements ISuiteListener {
    public void onStart(ISuite suite) {
    }

    public void onFinish(ISuite suite) {
        try {
            this.reportOrphanedExecutors(suite);
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(ReportOrphanedExecutors.class, "Failed to process %s [%s]: \n%s", suite, suite.getName(), Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void reportOrphanedExecutors(ISuite suite) {
        Set instances = (Set)suite.getAllMethods().stream().map(ITestNGMethod::getInstance).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        for (Object instance : instances) {
            this.reportOrphanedExecutorsOnInstance(instance);
        }
    }

    private void reportOrphanedExecutorsOnInstance(Object instance) {
        Objects.requireNonNull(instance, "instance is null");
        try {
            for (Class<?> currentClass = instance.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = currentClass.getDeclaredFields()) {
                    ExecutorService executorService;
                    if (field.isAnnotationPresent(Suppress.class)) continue;
                    field.setAccessible(true);
                    Object value = field.get(instance);
                    if (!(value instanceof ExecutorService) || (executorService = (ExecutorService)value).isShutdown()) continue;
                    throw new RuntimeException(String.format("Executor [%s] in [%s] has not been shut down", field, instance));
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Suppress {
        public String because();
    }
}

