/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.assertions;

import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;

public final class Assert {
    private Assert() {
    }

    public static <E extends Exception> void assertEventually(CheckedRunnable<E> assertion) throws E {
        Assert.assertEventually(new Duration(30.0, TimeUnit.SECONDS), assertion);
    }

    public static <E extends Exception> void assertEventually(Duration timeout, CheckedRunnable<E> assertion) throws E {
        Assert.assertEventually(timeout, new Duration(50.0, TimeUnit.MILLISECONDS), assertion);
    }

    public static <E extends Exception> void assertEventually(Duration timeout, Duration retryFrequency, CheckedRunnable<E> assertion) throws E {
        long start = System.nanoTime();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                assertion.run();
                return;
            }
            catch (AssertionError | Exception e) {
                if (Duration.nanosSince((long)start).compareTo(timeout) > 0) {
                    throw e;
                }
                try {
                    Thread.sleep(retryFrequency.toMillis());
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e2);
                }
            }
        }
    }

    public static <E extends Exception> void assertConsistently(Duration timeout, Duration retryFrequency, CheckedRunnable<E> assertion) throws E {
        long start = System.nanoTime();
        while (!Thread.currentThread().isInterrupted()) {
            assertion.run();
            if (Duration.nanosSince((long)start).compareTo(timeout) > 0) {
                return;
            }
            try {
                Thread.sleep(retryFrequency.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    public static interface CheckedRunnable<E extends Exception> {
        public void run() throws E;
    }
}

