/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testng.services;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.testng.services.Listeners;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.testng.IClassListener;
import org.testng.ITestClass;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;

public class ReportAfterMethodNotAlwaysRun
implements IClassListener {
    private static final Set<AnnotationPredicate<?>> VIOLATIONS = ImmutableSet.of(new AnnotationPredicate<AfterMethod>(AfterMethod.class, Predicate.not(AfterMethod::alwaysRun)), new AnnotationPredicate<AfterClass>(AfterClass.class, Predicate.not(AfterClass::alwaysRun)), new AnnotationPredicate<AfterSuite>(AfterSuite.class, Predicate.not(AfterSuite::alwaysRun)), new AnnotationPredicate<AfterGroups>(AfterGroups.class, Predicate.not(AfterGroups::alwaysRun)));

    public void onBeforeClass(ITestClass testClass) {
        try {
            ReportAfterMethodNotAlwaysRun.checkHasAfterMethodsNotAlwaysRun(testClass.getRealClass());
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(ReportAfterMethodNotAlwaysRun.class, "Failed to process %s:%n%s", testClass.getName(), Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    @VisibleForTesting
    static void checkHasAfterMethodsNotAlwaysRun(Class<?> testClass) {
        List notAlwaysRunMethods = (List)Arrays.stream(testClass.getMethods()).filter(ReportAfterMethodNotAlwaysRun::isAfterMethodNotAlwaysRun).collect(ImmutableList.toImmutableList());
        if (!notAlwaysRunMethods.isEmpty()) {
            throw new RuntimeException(notAlwaysRunMethods.stream().map(Method::toString).sorted().collect(Collectors.joining("\n", "The @AfterX methods should have the alwaysRun = true attribute to make sure that they'll run even if tests were skipped:\n", "")));
        }
    }

    private static boolean isAfterMethodNotAlwaysRun(Method method) {
        return VIOLATIONS.stream().anyMatch(p -> p.test(method));
    }

    public void onAfterClass(ITestClass testClass) {
    }

    private record AnnotationPredicate<T extends Annotation>(Class<T> annotationType, Predicate<T> predicate) implements Predicate<Method>
    {
        AnnotationPredicate {
            Objects.requireNonNull(annotationType);
            Objects.requireNonNull(predicate);
        }

        @Override
        public boolean test(Method method) {
            return Optional.ofNullable(method.getAnnotation(this.annotationType)).filter(this.predicate).isPresent();
        }
    }
}

