/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.services.junit;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.testing.services.junit.Listeners;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class LogTestDurationListener
implements TestExecutionListener {
    private static final Logger log = Logger.get(LogTestDurationListener.class);
    private static final Duration TEST_LOGGING_THRESHOLD = new Duration(20.0, TimeUnit.SECONDS);
    private static final Duration GLOBAL_IDLE_LOGGING_THRESHOLD = new Duration(8.0, TimeUnit.MINUTES);
    private final boolean enabled;
    private final ScheduledExecutorService scheduledExecutorService;
    private TestPlan currentTestPlan;
    private final Map<TestIdentifier, Long> started = new ConcurrentHashMap<TestIdentifier, Long>();
    private final AtomicLong lastChange = new AtomicLong(System.nanoTime());
    private final AtomicBoolean hangLogged = new AtomicBoolean();
    private final AtomicBoolean finished = new AtomicBoolean();
    @GuardedBy(value="this")
    private ScheduledFuture<?> monitorHangTask;

    public LogTestDurationListener() {
        this.enabled = LogTestDurationListener.isEnabled();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"TestHangMonitor"));
        log.info("LogTestDurationListener enabled: %s", new Object[]{this.enabled});
    }

    private static boolean isEnabled() {
        if (System.getProperty("LogTestDurationListener.enabled") != null) {
            return Boolean.getBoolean("LogTestDurationListener.enabled");
        }
        return System.getenv("CONTINUOUS_INTEGRATION") != null;
    }

    public synchronized void testPlanExecutionStarted(TestPlan testPlan) {
        if (!this.enabled) {
            return;
        }
        try {
            Preconditions.checkState((this.currentTestPlan == null ? 1 : 0) != 0, (String)"currentTestPlan already set to %s when starting %s", (Object)this.currentTestPlan, (Object)testPlan);
            this.currentTestPlan = testPlan;
            this.resetHangMonitor();
            this.finished.set(false);
            if (this.monitorHangTask == null) {
                this.monitorHangTask = this.scheduledExecutorService.scheduleWithFixedDelay(this::checkForTestHang, 5L, 5L, TimeUnit.SECONDS);
            }
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(this.getClass(), "testPlanExecutionStarted: \n%s", Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        if (!this.enabled) {
            return;
        }
        try {
            Preconditions.checkState((this.currentTestPlan == testPlan ? 1 : 0) != 0, (String)"currentTestPlan set to %s when finishing %s", (Object)this.currentTestPlan, (Object)testPlan);
            this.currentTestPlan = null;
            this.resetHangMonitor();
            this.finished.set(true);
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(this.getClass(), "testPlanExecutionFinished: \n%s", Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void checkForTestHang() {
        if (this.hangLogged.get()) {
            return;
        }
        Duration duration = Duration.nanosSince((long)this.lastChange.get());
        if (duration.compareTo(GLOBAL_IDLE_LOGGING_THRESHOLD) < 0) {
            return;
        }
        if (!this.hangLogged.compareAndSet(false, true)) {
            return;
        }
        ImmutableMap runningTests = ImmutableMap.copyOf(this.started);
        if (!runningTests.isEmpty()) {
            String testDetails = runningTests.entrySet().stream().map(entry -> String.format("%s running for %s", this.testName((TestIdentifier)entry.getKey()), Duration.nanosSince((long)((Long)entry.getValue())))).collect(Collectors.joining("\n\t", "\n\t", ""));
            LogTestDurationListener.dumpAllThreads(String.format("No test started or completed in %s. Running tests:%s.", GLOBAL_IDLE_LOGGING_THRESHOLD, testDetails));
        } else if (this.finished.get()) {
            LogTestDurationListener.dumpAllThreads(String.format("Tests finished, but JVM did not shutdown in %s.", GLOBAL_IDLE_LOGGING_THRESHOLD));
        } else {
            LogTestDurationListener.dumpAllThreads(String.format("No test started in %s", GLOBAL_IDLE_LOGGING_THRESHOLD));
        }
    }

    private static void dumpAllThreads(String message) {
        log.warn("%s\n\nFull Thread Dump:\n%s", new Object[]{message, Arrays.stream(ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)).map(io.trino.jvm.Threads::fullToString).collect(Collectors.joining("\n"))});
    }

    private void resetHangMonitor() {
        this.lastChange.set(System.nanoTime());
        this.hangLogged.set(false);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (!this.enabled) {
            return;
        }
        try {
            this.beginTest(testIdentifier);
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(LogTestDurationListener.class, "executionStarted: \n%s", Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (!this.enabled) {
            return;
        }
        try {
            Duration duration = this.endTest(testIdentifier);
            if (duration.compareTo(TEST_LOGGING_THRESHOLD) > 0) {
                log.info("Test %s took %s", new Object[]{this.testName(testIdentifier), duration});
            }
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(LogTestDurationListener.class, "executionFinished: \n%s", Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void beginTest(TestIdentifier testIdentifier) {
        this.resetHangMonitor();
        Long existingEntry = this.started.putIfAbsent(testIdentifier, System.nanoTime());
        Preconditions.checkState((existingEntry == null ? 1 : 0) != 0, (String)"There already is a start record for test: %s", (Object)testIdentifier);
    }

    private Duration endTest(TestIdentifier testIdentifier) {
        this.resetHangMonitor();
        Long startTime = this.started.remove(testIdentifier);
        Preconditions.checkState((startTime != null ? 1 : 0) != 0, (String)"There is no start record for test: %s", (Object)testIdentifier);
        return Duration.nanosSince((long)startTime);
    }

    private String testName(TestIdentifier testIdentifier) {
        Optional parent = this.currentTestPlan.getParent(testIdentifier);
        Object parentName = "";
        if (parent.isPresent()) {
            parentName = this.testName((TestIdentifier)parent.get());
            parentName = ((String)parentName).equals("JUnit Jupiter") ? "" : (String)parentName + ".";
        }
        return (String)parentName + testIdentifier.getDisplayName();
    }
}

