/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testng.services;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import io.airlift.log.Logger;
import io.trino.testng.services.Flaky;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;
import org.testng.IRetryAnalyzer;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;

public class FlakyTestRetryAnalyzer
implements IRetryAnalyzer {
    private static final Logger log = Logger.get(FlakyTestRetryAnalyzer.class);
    private static final String ENABLED_SYSTEM_PROPERTY = "io.trino.testng.services.FlakyTestRetryAnalyzer.enabled";
    @VisibleForTesting
    static final int ALLOWED_RETRIES_COUNT = 2;
    @GuardedBy(value="this")
    private final Map<String, Long> retryCounter = new HashMap<String, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retry(ITestResult result) {
        long retryCount;
        if (result.isSuccess()) {
            return false;
        }
        Optional<String> enabledSystemPropertyValue = Optional.ofNullable(System.getProperty(ENABLED_SYSTEM_PROPERTY));
        if (!enabledSystemPropertyValue.map(Boolean::parseBoolean).orElse(System.getenv("CONTINUOUS_INTEGRATION") != null).booleanValue()) {
            log.info("FlakyTestRetryAnalyzer not enabled: CONTINUOUS_INTEGRATION environment is not detected or system property '%s' is not set to 'true' (actual: %s)", new Object[]{ENABLED_SYSTEM_PROPERTY, enabledSystemPropertyValue.orElse("<not set>")});
            return false;
        }
        Method javaMethod = result.getMethod().getConstructorOrMethod().getMethod();
        if (javaMethod == null) {
            log.info("not retrying; cannot get java method");
            return false;
        }
        Flaky annotation = javaMethod.getAnnotation(Flaky.class);
        if (annotation == null) {
            log.info("not retrying; @Flaky annotation not present");
            return false;
        }
        if (result.getThrowable() == null) {
            log.info("not retrying; throwable not present in result");
            return false;
        }
        String stackTrace = Throwables.getStackTraceAsString((Throwable)result.getThrowable());
        if (!Pattern.compile(annotation.match()).matcher(stackTrace).find()) {
            log.warn("not retrying; stacktrace '%s' does not match pattern '%s'", new Object[]{stackTrace, annotation.match()});
            return false;
        }
        ITestNGMethod method = result.getMethod();
        FlakyTestRetryAnalyzer flakyTestRetryAnalyzer = this;
        synchronized (flakyTestRetryAnalyzer) {
            String name = FlakyTestRetryAnalyzer.getName(method, result.getParameters());
            retryCount = this.retryCounter.getOrDefault(name, 0L);
            if (++retryCount > 2L) {
                return false;
            }
            this.retryCounter.put(name, retryCount);
        }
        log.warn(result.getThrowable(), "Test %s::%s attempt %s failed, retrying...,", new Object[]{result.getTestClass().getName(), method.getMethodName(), retryCount});
        return true;
    }

    private static String getName(ITestNGMethod method, Object[] parameters) {
        String actualTestClass = method.getTestClass().getName();
        if (parameters.length != 0) {
            return String.format("%s::%s(%s)", actualTestClass, method.getMethodName(), Joiner.on((String)",").useForNull("null").join(parameters));
        }
        return String.format("%s::%s", actualTestClass, method.getMethodName());
    }
}

