/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jvm;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;

public final class Threads {
    private Threads() {
    }

    public static String fullToString(ThreadInfo thread) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\"%s\"%s prio=%s Id=%s %s%s%s%s%s\n", new Object[]{thread.getThreadName(), thread.isDaemon() ? " daemon" : "", thread.getPriority(), thread.getThreadId(), thread.getThreadState(), thread.getLockName() != null ? " on " + thread.getLockName() : "", thread.getLockOwnerName() != null ? " owned by " + thread.getLockOwnerName() : "", thread.isSuspended() ? " (suspended)" : "", thread.isInNative() ? " (in native)" : ""}));
        Iterator<StackTraceElement> stackTrace = Arrays.asList(thread.getStackTrace()).iterator();
        Multimap lockedMonitors = (Multimap)Arrays.stream(thread.getLockedMonitors()).collect(Multimaps.toMultimap(MonitorInfo::getLockedStackDepth, Function.identity(), ArrayListMultimap::create));
        int depth = 0;
        if (stackTrace.hasNext()) {
            StackTraceElement first = stackTrace.next();
            sb.append(String.format("\tat %s\n", first));
            LockInfo lockInfo = thread.getLockInfo();
            if (lockInfo != null) {
                String lockVerb;
                switch (thread.getThreadState()) {
                    case BLOCKED: {
                        lockVerb = "blocked";
                        break;
                    }
                    case WAITING: 
                    case TIMED_WAITING: {
                        lockVerb = "waiting";
                        break;
                    }
                    default: {
                        lockVerb = "(unexpected lock info)";
                    }
                }
                sb.append(String.format("\t-  %s on %s\n", lockVerb, lockInfo));
            }
            lockedMonitors.get((Object)depth).forEach(monitor -> sb.append(String.format("\t-  locked %s\n", monitor)));
        }
        stackTrace.forEachRemaining(element -> sb.append(String.format("\tat %s\n", element)));
        while (stackTrace.hasNext()) {
            StackTraceElement element2 = stackTrace.next();
            sb.append(String.format("\tat %s\n", element2));
            lockedMonitors.get((Object)(++depth)).forEach(monitor -> sb.append(String.format("\t-  locked %s\n", monitor)));
        }
        LockInfo[] lockedSynchronizers = thread.getLockedSynchronizers();
        if (lockedSynchronizers.length != 0) {
            sb.append("\n");
            sb.append("\tlocked synchronizers:\n");
            for (LockInfo locked : lockedSynchronizers) {
                sb.append(String.format("\t- %s\n", locked));
            }
        }
        sb.append("\n");
        return sb.toString();
    }
}

