/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testng.services;

import com.google.common.base.Joiner;
import io.airlift.log.Logger;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class ProgressLoggingListener
implements ITestListener {
    private static final Logger LOGGER = Logger.get(ProgressLoggingListener.class);
    private final boolean enabled = ProgressLoggingListener.isEnabled();

    public ProgressLoggingListener() {
        if (!this.enabled) {
            LOGGER.info("ProgressLoggingListener is disabled!");
        }
    }

    private static boolean isEnabled() {
        if (System.getProperty("ProgressLoggingListener.enabled") != null) {
            return Boolean.getBoolean("ProgressLoggingListener.enabled");
        }
        return System.getenv("CONTINUOUS_INTEGRATION") != null;
    }

    public void onStart(ITestContext context) {
    }

    public void onTestStart(ITestResult testCase) {
        if (!this.enabled) {
            return;
        }
        LOGGER.info("[TEST START] %s", new Object[]{this.formatTestName(testCase)});
    }

    public void onTestSuccess(ITestResult testCase) {
        if (!this.enabled) {
            return;
        }
        LOGGER.info("[TEST SUCCESS] %s; (took: %s)", new Object[]{this.formatTestName(testCase), ProgressLoggingListener.formatDuration(testCase)});
    }

    public void onTestFailure(ITestResult testCase) {
        if (!this.enabled) {
            return;
        }
        if (testCase.getThrowable() != null) {
            LOGGER.error(testCase.getThrowable(), "[TEST FAILURE] %s; (took: %s)", new Object[]{this.formatTestName(testCase), ProgressLoggingListener.formatDuration(testCase)});
        } else {
            LOGGER.error("[TEST FAILURE] %s; (took: %s)", new Object[]{this.formatTestName(testCase), ProgressLoggingListener.formatDuration(testCase)});
        }
    }

    public void onTestSkipped(ITestResult testCase) {
        if (!this.enabled) {
            return;
        }
        LOGGER.info("[TEST SKIPPED] %s", new Object[]{this.formatTestName(testCase)});
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult testCase) {
    }

    public void onFinish(ITestContext context) {
    }

    private String formatTestName(ITestResult testCase) {
        return String.format("%s.%s%s", testCase.getTestClass().getName(), testCase.getName(), this.formatTestParameters(testCase));
    }

    private String formatTestParameters(ITestResult testCase) {
        Object[] parameters = testCase.getParameters();
        if (parameters == null || parameters.length == 0) {
            return "";
        }
        return String.format(" [%s]", Joiner.on((String)", ").join(parameters));
    }

    private static String formatDuration(ITestResult testCase) {
        return ProgressLoggingListener.formatDuration(testCase.getEndMillis() - testCase.getStartMillis());
    }

    private static String formatDuration(long durationInMillis) {
        BigDecimal durationSeconds = ProgressLoggingListener.durationInSeconds(durationInMillis);
        if (durationSeconds.longValue() < 60L) {
            return String.format("%s seconds", durationSeconds);
        }
        long minutes = durationSeconds.longValue() / 60L;
        long restSeconds = durationSeconds.longValue() % 60L;
        return String.format("%d minutes and %d seconds", minutes, restSeconds);
    }

    private static BigDecimal durationInSeconds(long millis) {
        return new BigDecimal(millis).divide(new BigDecimal(1000), 1, RoundingMode.HALF_UP);
    }
}

