/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Properties;

public class TestingProperties {
    private static Supplier<Properties> properties = Suppliers.memoize(() -> {
        Properties properties = new Properties();
        try {
            try (InputStream stream = Resources.getResource((String)"trino-testing.properties").openStream();){
                properties.load(stream);
            }
            return properties;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    });

    private TestingProperties() {
    }

    public static String getProjectVersion() {
        return Objects.requireNonNull(((Properties)properties.get()).getProperty("project.version"), "project.version is null");
    }

    public static String getDockerImagesVersion() {
        return Objects.requireNonNull(((Properties)properties.get()).getProperty("docker.images.version"), "docker.images.version is null");
    }
}

