/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Properties;

public class TestingProperties {
    public static final TestingProperties INSTANCE = new TestingProperties("trino-testing.properties");
    private Properties properties = new Properties();

    public TestingProperties(String resourceName) {
        try (InputStream stream = Resources.getResource((String)resourceName).openStream();){
            this.properties.load(stream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getProjectVersion() {
        return Objects.requireNonNull(this.properties.getProperty("project.version"), "project.version is null");
    }

    public String getDockerImagesVersion() {
        return Objects.requireNonNull(this.properties.getProperty("docker.images.version"), "docker.images.version is null");
    }
}

