/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jmh;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;

public final class Benchmarks {
    private Benchmarks() {
    }

    public static BenchmarkBuilder benchmark(Class<?> benchmarkClass) {
        ChainedOptionsBuilder optionsBuilder = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include("^\\Q" + benchmarkClass.getName() + ".\\E").resultFormat(ResultFormatType.JSON).result(String.format("%s/%s-result-%s.json", System.getProperty("java.io.tmpdir"), benchmarkClass.getSimpleName(), DateTimeFormatter.ISO_DATE_TIME.format(LocalDateTime.now())));
        return new BenchmarkBuilder(optionsBuilder);
    }

    public static BenchmarkBuilder benchmark(Class<?> benchmarkClass, WarmupMode warmupMode) {
        return Benchmarks.benchmark(benchmarkClass).withOptions(optionsBuilder -> optionsBuilder.warmupMode(warmupMode));
    }

    public static class BenchmarkBuilder {
        private final ChainedOptionsBuilder optionsBuilder;

        private BenchmarkBuilder(ChainedOptionsBuilder optionsBuilder) {
            this.optionsBuilder = Objects.requireNonNull(optionsBuilder, "optionsBuilder is null");
        }

        public BenchmarkBuilder withOptions(Consumer<ChainedOptionsBuilder> optionsConsumer) {
            optionsConsumer.accept(this.optionsBuilder);
            return this;
        }

        public Collection<RunResult> run() throws RunnerException {
            return new Runner(this.optionsBuilder.build()).run();
        }
    }
}

