/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.Version;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.trino.testing.SystemEnvironmentUtils;
import io.trino.testing.containers.ConditionalPullPolicy;
import java.io.Closeable;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;
import org.testcontainers.utility.TestcontainersConfiguration;

public final class TestContainers {
    private static final boolean TESTCONTAINERS_REUSE_ENABLE = Boolean.parseBoolean(System.getenv("TESTCONTAINERS_REUSE_ENABLE"));

    private TestContainers() {
    }

    public static Closeable startOrReuse(GenericContainer<?> container) {
        boolean reuse = TestcontainersConfiguration.getInstance().environmentSupportsReuse();
        Preconditions.checkState((reuse == TESTCONTAINERS_REUSE_ENABLE ? 1 : 0) != 0, (Object)"Unable to enable or disable container reuse");
        container.withReuse(TESTCONTAINERS_REUSE_ENABLE);
        container.start();
        if (reuse) {
            return () -> {};
        }
        return () -> container.stop();
    }

    public static String getPathFromClassPathResource(String resourcePath) {
        return MountableFile.forClasspathResource((String)resourcePath).getResolvedPath();
    }

    public static void exposeFixedPorts(GenericContainer<?> container) {
        Preconditions.checkState((!SystemEnvironmentUtils.isEnvSet((String)"CONTINUOUS_INTEGRATION") ? 1 : 0) != 0, (Object)"Exposing fixed ports should not be used in regular test code. This could break parallel test execution. This method is supposed to be invoked from local development helpers only e.g. QueryRunner.main(), hence it should never run on CI");
        container.withCreateContainerCmdModifier(cmd -> cmd.withHostConfig(Objects.requireNonNull(cmd.getHostConfig(), "hostConfig is null").withPortBindings((List)container.getExposedPorts().stream().map(exposedPort -> new PortBinding(Ports.Binding.bindPort((int)exposedPort), new ExposedPort(exposedPort.intValue()))).collect(ImmutableList.toImmutableList()))));
    }

    public static DockerArchitectureInfo getDockerArchitectureInfo(DockerImageName imageName) {
        Preconditions.checkState((!ConditionalPullPolicy.TESTCONTAINERS_NEVER_PULL ? 1 : 0) != 0, (String)"Cannot get arch for image %s without pulling it, and pulling is forbidden", (Object)imageName);
        DockerClient client = DockerClientFactory.lazyClient();
        if (!TestContainers.imageExists(client, imageName)) {
            TestContainers.pullImage(client, imageName);
        }
        return new DockerArchitectureInfo(DockerArchitecture.fromString(((Version)client.versionCmd().exec()).getArch()), DockerArchitecture.fromString(TestContainers.getImageArch(client, imageName)));
    }

    private static String getImageArch(DockerClient client, DockerImageName imageName) {
        return client.inspectImageCmd(imageName.asCanonicalNameString()).exec().getArch().toLowerCase(Locale.ENGLISH);
    }

    private static boolean imageExists(DockerClient client, DockerImageName imageName) {
        try {
            TestContainers.getImageArch(client, imageName);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    private static void pullImage(DockerClient client, final DockerImageName imageName) {
        try {
            (client.pullImageCmd(imageName.asCanonicalNameString()).exec((ResultCallback)new PullImageResultCallback(){

                public void onNext(PullResponseItem item) {
                    String progress = item.getProgress();
                    if (progress != null) {
                        System.err.println(Strings.padEnd((String)(imageName.asCanonicalNameString() + ":" + item.getId()), (int)50, (char)' ') + " " + progress);
                    }
                }
            })).awaitCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public record DockerArchitectureInfo(DockerArchitecture hostArch, DockerArchitecture imageArch) {
    }

    public static enum DockerArchitecture {
        ARM64,
        AMD64,
        PPC64;


        public static DockerArchitecture fromString(String value) {
            return switch (value.toLowerCase(Locale.ENGLISH)) {
                case "linux/arm64", "arm64" -> ARM64;
                case "linux/amd64", "amd64" -> AMD64;
                case "ppc64", "ppc64le" -> PPC64;
                default -> throw new IllegalArgumentException("Unrecognized docker image architecture: " + value);
            };
        }
    }
}

